/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.javalanglevels;

import edu.rice.cs.javalanglevels.BodyBodyIntermediateVisitor;
import edu.rice.cs.javalanglevels.IntermediateVisitor;
import edu.rice.cs.javalanglevels.LanguageLevelVisitor;
import edu.rice.cs.javalanglevels.MethodData;
import edu.rice.cs.javalanglevels.Pair;
import edu.rice.cs.javalanglevels.SourceInfo;
import edu.rice.cs.javalanglevels.SymbolData;
import edu.rice.cs.javalanglevels.VariableData;
import edu.rice.cs.javalanglevels.tree.AbstractMethodDef;
import edu.rice.cs.javalanglevels.tree.ComplexAnonymousClassInstantiation;
import edu.rice.cs.javalanglevels.tree.ConcreteMethodDef;
import edu.rice.cs.javalanglevels.tree.ConstructorDef;
import edu.rice.cs.javalanglevels.tree.InitializedVariableDeclarator;
import edu.rice.cs.javalanglevels.tree.InstanceInitializer;
import edu.rice.cs.javalanglevels.tree.ModifiersAndVisibility;
import edu.rice.cs.javalanglevels.tree.SimpleAnonymousClassInstantiation;
import edu.rice.cs.javalanglevels.tree.Statement;
import edu.rice.cs.javalanglevels.tree.TypeParameter;
import edu.rice.cs.javalanglevels.tree.UninitializedVariableDeclarator;
import edu.rice.cs.javalanglevels.tree.VariableDeclaration;
import java.io.File;
import java.util.Hashtable;
import java.util.LinkedList;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassBodyIntermediateVisitor
extends IntermediateVisitor {
    private SymbolData _symbolData;

    public ClassBodyIntermediateVisitor(SymbolData sd, File file, String packageName, LinkedList<String> importedFiles, LinkedList<String> importedPackages, LinkedList<String> classDefsInThisFile, Hashtable<String, Pair<SourceInfo, LanguageLevelVisitor>> continuations) {
        super(file, packageName, importedFiles, importedPackages, classDefsInThisFile, continuations);
        this._symbolData = sd;
    }

    @Override
    public void forStatementDoFirst(Statement that) {
        ClassBodyIntermediateVisitor._addError("Statements cannot appear outside of method bodies", that);
    }

    @Override
    public void forConcreteMethodDefDoFirst(ConcreteMethodDef that) {
        ModifiersAndVisibility mav = that.getMav();
        String[] modifiers = mav.getModifiers();
        for (int i = 0; i < modifiers.length; ++i) {
            if (modifiers[i].equals("abstract")) {
                ClassBodyIntermediateVisitor._addError("Methods that have a braced body cannot be declared \"abstract\"", that);
                break;
            }
            if (!modifiers[i].equals("static")) continue;
            ClassBodyIntermediateVisitor._addError("Static methods cannot be used at the Intermediate level", that);
            break;
        }
        super.forConcreteMethodDefDoFirst(that);
    }

    @Override
    public void forAbstractMethodDefDoFirst(AbstractMethodDef that) {
        if (!this._symbolData.hasModifier("abstract")) {
            ClassBodyIntermediateVisitor._addError("Abstract methods can only be declared in abstract classes", that);
        }
        ModifiersAndVisibility mav = that.getMav();
        String[] modifiers = mav.getModifiers();
        for (int i = 0; i < modifiers.length; ++i) {
            if (!modifiers[i].equals("static")) continue;
            ClassBodyIntermediateVisitor._addError("Static methods cannot be used at the Intermediate level", that);
            break;
        }
        super.forAbstractMethodDefDoFirst(that);
    }

    @Override
    public void forInstanceInitializerDoFirst(InstanceInitializer that) {
        ClassBodyIntermediateVisitor._addError("This open brace must mark the beginning of a method or class body", that);
    }

    @Override
    public void forVariableDeclarationOnly(VariableDeclaration that) {
        VariableData[] vds = this._variableDeclaration2VariableData(that, this._symbolData);
        LinkedList<VariableData> vdsList = new LinkedList<VariableData>();
        for (int i = 0; i < vds.length; ++i) {
            if (vds[i].hasModifier("static") && that.getDeclarators()[i] instanceof UninitializedVariableDeclarator) {
                ClassBodyIntermediateVisitor._addAndIgnoreError("All static fields must be initialized", that);
                continue;
            }
            if (!vds[i].hasModifier("static") && that.getDeclarators()[i] instanceof InitializedVariableDeclarator) {
                ClassBodyIntermediateVisitor._addAndIgnoreError("Only static fields may be initialized outside of a constructor at the Intermediate level", that);
                continue;
            }
            vdsList.addLast(vds[i]);
        }
        if (!this._symbolData.addFinalVars(vdsList.toArray(new VariableData[vdsList.size()]))) {
            ClassBodyIntermediateVisitor._addAndIgnoreError("You cannot have two fields with the same name.  Either you already have a field by that name in this class, or one of your superclasses or interfaces has a field by that name", that);
        }
    }

    @Override
    public void forConcreteMethodDef(ConcreteMethodDef that) {
        String className;
        this.forConcreteMethodDefDoFirst(that);
        if (this.prune(that)) {
            return;
        }
        MethodData md = this.createMethodData(that, this._symbolData);
        if (!(md.hasModifier("public") || md.hasModifier("private") || md.hasModifier("protected"))) {
            md.addModifier("public");
        }
        if ((className = ClassBodyIntermediateVisitor.getUnqualifiedClassName(this._symbolData.getName())).equals(md.getName())) {
            ClassBodyIntermediateVisitor._addAndIgnoreError("Only constructors can have the same name as the class they appear in, and constructors do not have an explicit return type", that);
        } else {
            this._symbolData.addMethod(md);
        }
        that.getBody().visit(new BodyBodyIntermediateVisitor(md, this._file, this._package, (LinkedList<String>)this._importedFiles, (LinkedList<String>)this._importedPackages, this._classNamesInThisFile, (Hashtable<String, Pair<SourceInfo, LanguageLevelVisitor>>)continuations));
        this.forConcreteMethodDefOnly(that);
    }

    @Override
    public void forAbstractMethodDef(AbstractMethodDef that) {
        String className;
        this.forAbstractMethodDefDoFirst(that);
        if (this.prune(that)) {
            return;
        }
        MethodData md = this.createMethodData(that, this._symbolData);
        if (!(md.hasModifier("public") || md.hasModifier("private") || md.hasModifier("protected"))) {
            md.addModifier("public");
        }
        if ((className = ClassBodyIntermediateVisitor.getUnqualifiedClassName(this._symbolData.getName())).equals(md.getName())) {
            ClassBodyIntermediateVisitor._addAndIgnoreError("Only constructors can have the same name as the class they appear in, and constructors do not have an explicit return type", that);
        } else {
            this._symbolData.addMethod(md);
        }
    }

    @Override
    public void forConstructorDef(ConstructorDef that) {
        this.forConstructorDefDoFirst(that);
        if (this.prune(that)) {
            return;
        }
        that.getMav().visit(this);
        String name = ClassBodyIntermediateVisitor.getUnqualifiedClassName(that.getName().getText());
        if (!name.equals(ClassBodyIntermediateVisitor.getUnqualifiedClassName(this._symbolData.getName()))) {
            ClassBodyIntermediateVisitor._addAndIgnoreError("The constructor return type and class name must match", that);
        }
        String[] throwStrings = this.referenceType2String(that.getThrows());
        SymbolData returnType = this._symbolData;
        MethodData md = new MethodData(name, that.getMav(), new TypeParameter[0], returnType, new VariableData[0], throwStrings, this._symbolData, that);
        if (!(md.hasModifier("public") || md.hasModifier("private") || md.hasModifier("protected"))) {
            md.addModifier("public");
        }
        ClassBodyIntermediateVisitor._checkError();
        VariableData[] vds = this.formalParameters2VariableData(that.getParameters(), md);
        if (!ClassBodyIntermediateVisitor._checkError()) {
            md.setParams(vds);
            if (!md.addFinalVars(vds)) {
                ClassBodyIntermediateVisitor._addAndIgnoreError("You cannot have two method parameters with the same name", that);
            }
        }
        this._symbolData.addMethod(md);
        that.getStatements().visit(new BodyBodyIntermediateVisitor(md, this._file, this._package, (LinkedList<String>)this._importedFiles, (LinkedList<String>)this._importedPackages, this._classNamesInThisFile, (Hashtable<String, Pair<SourceInfo, LanguageLevelVisitor>>)continuations));
        this._symbolData.incrementConstructorCount();
        this.forConstructorDefOnly(that);
    }

    @Override
    public void forComplexAnonymousClassInstantiation(ComplexAnonymousClassInstantiation that) {
        this.complexAnonymousClassInstantiationHelper(that, this._symbolData);
    }

    @Override
    public void forSimpleAnonymousClassInstantiation(SimpleAnonymousClassInstantiation that) {
        this.simpleAnonymousClassInstantiationHelper(that, this._symbolData);
    }

    static SymbolData access$000(ClassBodyIntermediateVisitor x0) {
        return x0._symbolData;
    }

    static SymbolData access$002(ClassBodyIntermediateVisitor x0, SymbolData x1) {
        x0._symbolData = x1;
        return x0._symbolData;
    }
}

