/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.model.definitions.indent;

import edu.rice.cs.drjava.model.AbstractDJDocument;
import edu.rice.cs.drjava.model.definitions.indent.IndentRuleAction;
import edu.rice.cs.drjava.model.definitions.indent.Indenter;
import edu.rice.cs.util.UnexpectedException;
import javax.swing.text.BadLocationException;

class ActionStartPrevLinePlusBackup
extends IndentRuleAction {
    private String _suffix;
    private int _position = 0;

    public ActionStartPrevLinePlusBackup(String suffix, int position) {
        this._suffix = suffix;
        if (position < 0 || position > suffix.length()) {
            throw new IllegalArgumentException("The specified position was not within the bounds of the suffix.");
        }
        this._position = position;
    }

    public boolean indentLine(AbstractDJDocument doc, Indenter.IndentReason reason) {
        super.indentLine(doc, reason);
        try {
            int here = doc.getCurrentLocation();
            int startLine = doc.getLineStartPos(here);
            if (startLine > 0) {
                int startPrevLine = doc.getLineStartPos(startLine - 1);
                int firstChar = doc.getLineFirstCharPos(startPrevLine);
                String prefix = doc.getText(startPrevLine, firstChar - startPrevLine);
                doc.setTab(prefix + this._suffix, here);
                doc.setCurrentLocation(startLine + prefix.length() + this._position);
            } else {
                doc.setTab(this._suffix, here);
                doc.setCurrentLocation(here + this._position);
            }
            return false;
        }
        catch (BadLocationException e) {
            throw new UnexpectedException(e);
        }
    }
}

