/*
 * Decompiled with CFR 0.152.
 */
package koala.dynamicjava.interpreter;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import koala.dynamicjava.classinfo.ClassFinder;
import koala.dynamicjava.classinfo.ClassInfo;
import koala.dynamicjava.classinfo.TreeClassInfo;
import koala.dynamicjava.interpreter.ClassInfoCompiler;
import koala.dynamicjava.interpreter.ClassPool;
import koala.dynamicjava.interpreter.Interpreter;
import koala.dynamicjava.interpreter.TreeClassFinder;
import koala.dynamicjava.interpreter.TreeClassLoader;
import koala.dynamicjava.interpreter.context.Context;
import koala.dynamicjava.interpreter.context.GlobalContext;
import koala.dynamicjava.interpreter.error.CatchedExceptionError;
import koala.dynamicjava.interpreter.error.ExecutionError;
import koala.dynamicjava.parser.wrapper.ParserFactory;
import koala.dynamicjava.parser.wrapper.SourceCodeParser;
import koala.dynamicjava.tree.AddAssignExpression;
import koala.dynamicjava.tree.AddExpression;
import koala.dynamicjava.tree.AndExpression;
import koala.dynamicjava.tree.ArrayAccess;
import koala.dynamicjava.tree.ArrayAllocation;
import koala.dynamicjava.tree.ArrayInitializer;
import koala.dynamicjava.tree.ArrayType;
import koala.dynamicjava.tree.AssertStatement;
import koala.dynamicjava.tree.BitAndAssignExpression;
import koala.dynamicjava.tree.BitAndExpression;
import koala.dynamicjava.tree.BitOrAssignExpression;
import koala.dynamicjava.tree.BitOrExpression;
import koala.dynamicjava.tree.BlockStatement;
import koala.dynamicjava.tree.BreakStatement;
import koala.dynamicjava.tree.CastExpression;
import koala.dynamicjava.tree.CatchStatement;
import koala.dynamicjava.tree.ClassAllocation;
import koala.dynamicjava.tree.ClassDeclaration;
import koala.dynamicjava.tree.ClassInitializer;
import koala.dynamicjava.tree.ComplementExpression;
import koala.dynamicjava.tree.ConditionalExpression;
import koala.dynamicjava.tree.ConstructorDeclaration;
import koala.dynamicjava.tree.ConstructorInvocation;
import koala.dynamicjava.tree.ContinueStatement;
import koala.dynamicjava.tree.DivideAssignExpression;
import koala.dynamicjava.tree.DivideExpression;
import koala.dynamicjava.tree.DoStatement;
import koala.dynamicjava.tree.EmptyStatement;
import koala.dynamicjava.tree.EqualExpression;
import koala.dynamicjava.tree.ExclusiveOrAssignExpression;
import koala.dynamicjava.tree.ExclusiveOrExpression;
import koala.dynamicjava.tree.FieldDeclaration;
import koala.dynamicjava.tree.ForEachStatement;
import koala.dynamicjava.tree.ForStatement;
import koala.dynamicjava.tree.FormalParameter;
import koala.dynamicjava.tree.FunctionCall;
import koala.dynamicjava.tree.GreaterExpression;
import koala.dynamicjava.tree.GreaterOrEqualExpression;
import koala.dynamicjava.tree.IfThenElseStatement;
import koala.dynamicjava.tree.IfThenStatement;
import koala.dynamicjava.tree.ImportDeclaration;
import koala.dynamicjava.tree.InnerAllocation;
import koala.dynamicjava.tree.InnerClassAllocation;
import koala.dynamicjava.tree.InstanceInitializer;
import koala.dynamicjava.tree.InstanceOfExpression;
import koala.dynamicjava.tree.InterfaceDeclaration;
import koala.dynamicjava.tree.LabeledStatement;
import koala.dynamicjava.tree.LessExpression;
import koala.dynamicjava.tree.LessOrEqualExpression;
import koala.dynamicjava.tree.Literal;
import koala.dynamicjava.tree.MethodDeclaration;
import koala.dynamicjava.tree.MinusExpression;
import koala.dynamicjava.tree.MultiplyAssignExpression;
import koala.dynamicjava.tree.MultiplyExpression;
import koala.dynamicjava.tree.Node;
import koala.dynamicjava.tree.NotEqualExpression;
import koala.dynamicjava.tree.NotExpression;
import koala.dynamicjava.tree.ObjectFieldAccess;
import koala.dynamicjava.tree.ObjectMethodCall;
import koala.dynamicjava.tree.OrExpression;
import koala.dynamicjava.tree.PackageDeclaration;
import koala.dynamicjava.tree.PlusExpression;
import koala.dynamicjava.tree.PostDecrement;
import koala.dynamicjava.tree.PostIncrement;
import koala.dynamicjava.tree.PreDecrement;
import koala.dynamicjava.tree.PreIncrement;
import koala.dynamicjava.tree.PrimitiveType;
import koala.dynamicjava.tree.QualifiedName;
import koala.dynamicjava.tree.ReferenceType;
import koala.dynamicjava.tree.RemainderAssignExpression;
import koala.dynamicjava.tree.RemainderExpression;
import koala.dynamicjava.tree.ReturnStatement;
import koala.dynamicjava.tree.ShiftLeftAssignExpression;
import koala.dynamicjava.tree.ShiftLeftExpression;
import koala.dynamicjava.tree.ShiftRightAssignExpression;
import koala.dynamicjava.tree.ShiftRightExpression;
import koala.dynamicjava.tree.SimpleAllocation;
import koala.dynamicjava.tree.SimpleAssignExpression;
import koala.dynamicjava.tree.StaticFieldAccess;
import koala.dynamicjava.tree.StaticMethodCall;
import koala.dynamicjava.tree.SubtractAssignExpression;
import koala.dynamicjava.tree.SubtractExpression;
import koala.dynamicjava.tree.SuperFieldAccess;
import koala.dynamicjava.tree.SuperMethodCall;
import koala.dynamicjava.tree.SwitchBlock;
import koala.dynamicjava.tree.SwitchStatement;
import koala.dynamicjava.tree.SynchronizedStatement;
import koala.dynamicjava.tree.ThisExpression;
import koala.dynamicjava.tree.ThrowStatement;
import koala.dynamicjava.tree.TryStatement;
import koala.dynamicjava.tree.TypeDeclaration;
import koala.dynamicjava.tree.TypeExpression;
import koala.dynamicjava.tree.UnsignedShiftRightAssignExpression;
import koala.dynamicjava.tree.UnsignedShiftRightExpression;
import koala.dynamicjava.tree.VariableDeclaration;
import koala.dynamicjava.tree.WhileStatement;
import koala.dynamicjava.tree.visitor.VisitorObject;
import koala.dynamicjava.util.ImportationManager;
import koala.dynamicjava.util.LibraryFinder;
import koala.dynamicjava.util.TigerUtilities;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeCompiler {
    protected Interpreter interpreter;
    protected TreeClassLoader classLoader;
    protected ClassInfoLoader classInfoLoader;
    protected ClassPool classPool = new ClassPool();

    public TreeCompiler(Interpreter i) {
        this.interpreter = i;
        this.classLoader = (TreeClassLoader)this.interpreter.getClassLoader();
        this.classInfoLoader = new ClassInfoLoader();
    }

    public Class<?> compile(String name) throws ClassNotFoundException {
        this.loadClass(name);
        return this.compileClasses(name);
    }

    public Class<?> compileClasses(String name) throws ClassNotFoundException {
        Class<?> result = null;
        if (this.classPool.contains(name)) {
            ClassInfo ci;
            while ((ci = this.classPool.getFirstCompilable()) != null) {
                if (!this.classExists(ci.getName())) {
                    Class<?> c = this.compileClass(ci, name);
                    if (c == null) continue;
                    result = c;
                    continue;
                }
                ci.setCompilable(false);
            }
        }
        if (result == null) {
            throw new ClassNotFoundException(name);
        }
        return result;
    }

    public Class<?> compileTree(Context ctx, TypeDeclaration td) {
        TreeClassFinder cf = new TreeClassFinder(ctx, this.interpreter, this.classPool);
        TreeClassInfo ci = new TreeClassInfo(td, cf);
        this.classPool.add(ci.getName(), ci);
        try {
            return this.compileClasses(ci.getName());
        }
        catch (ClassNotFoundException e) {
            td.setProperty("errorStrings", new String[]{td.getName()});
            throw new ExecutionError("undefined.or.defined.class", td);
        }
    }

    protected Class<?> compileClass(ClassInfo ci, String name) {
        Class<?> c;
        Class<?> result = null;
        ClassInfo t = ci.getSuperclass();
        if (t.isCompilable() && !this.classExists(t.getName()) && (c = this.compileClass(t, name)) != null) {
            result = c;
        }
        ClassInfo[] ti = ci.getInterfaces();
        for (int i = 0; i < ti.length; ++i) {
            Class<?> c2;
            t = ti[i];
            if (!t.isCompilable() || this.classExists(t.getName()) || (c2 = this.compileClass(t, name)) == null) continue;
            result = c2;
        }
        Class<?> c3 = new ClassInfoCompiler(ci).compile();
        ci.setCompilable(false);
        if (name.equals(c3.getName())) {
            result = c3;
        }
        return result;
    }

    protected boolean classExists(String name) {
        return this.classLoader.hasDefined(name);
    }

    protected void loadClass(String name) throws ClassNotFoundException {
        if (this.classPool.contains(name)) {
            return;
        }
        TypeDeclaration td = this.classLoader.getTree(name);
        if (td != null) {
            ImportationManager im = (ImportationManager)td.getProperty("importationManager");
            GlobalContext ctx = new GlobalContext(this.interpreter, this.classInfoLoader);
            im.setClassLoader(this.classInfoLoader);
            ctx.setImportationManager(im);
            TreeClassFinder cfinder = new TreeClassFinder(ctx, this.interpreter, this.classPool);
            this.classPool.add(name, new TreeClassInfo(td, cfinder));
            return;
        }
        LibraryFinder lf = this.interpreter.getLibraryFinder();
        try {
            String cun = lf.findCompilationUnitName(name);
            td = this.classLoader.getTree(cun);
            if (td != null) {
                ImportationManager im = (ImportationManager)td.getProperty("importationManager");
                GlobalContext ctx = new GlobalContext(this.interpreter, this.classInfoLoader);
                im.setClassLoader(this.classInfoLoader);
                ctx.setImportationManager(im);
                TreeClassFinder cfinder = new TreeClassFinder(ctx, this.interpreter, this.classPool);
                this.classPool.add(cun, new TreeClassInfo(td, cfinder));
                return;
            }
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        try {
            File f = lf.findCompilationUnit(name);
            FileInputStream fis = new FileInputStream(f);
            ParserFactory pf = this.interpreter.getParserFactory();
            SourceCodeParser p = pf.createParser(fis, f.getCanonicalPath());
            List<Node> stmts = p.parseCompilationUnit();
            Iterator<Node> it = stmts.iterator();
            CompilationUnitVisitor v = new CompilationUnitVisitor();
            while (it.hasNext()) {
                it.next().acceptVisitor(v);
            }
        }
        catch (IOException e) {
            throw new ClassNotFoundException(name);
        }
    }

    public class PseudoError
    extends Error {
        protected ClassInfo classInfo;

        PseudoError(ClassInfo ci) {
            this.classInfo = ci;
        }

        public ClassInfo getClassInfo() {
            return this.classInfo;
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ClassInfoLoader
    extends ClassLoader {
        protected ClassInfoLoader() {
        }

        @Override
        protected Class<?> findClass(String name) throws ClassNotFoundException {
            TreeCompiler.this.loadClass(name);
            if (TreeCompiler.this.classPool.contains(name)) {
                throw new PseudoError(TreeCompiler.this.classPool.get(name));
            }
            throw new ClassNotFoundException(name);
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class CompilationUnitVisitor
    extends VisitorObject<Void> {
        protected Context context;
        protected ClassFinder classFinder;

        protected CompilationUnitVisitor() {
            this.context = new GlobalContext(TreeCompiler.this.interpreter, TreeCompiler.this.classInfoLoader);
            this.classFinder = new TreeClassFinder(this.context, TreeCompiler.this.interpreter, TreeCompiler.this.classPool);
        }

        @Override
        public Void visit(PackageDeclaration node) {
            this.context.setCurrentPackage(node.getName());
            return null;
        }

        @Override
        public Void visit(ImportDeclaration node) {
            if (node.isStatic()) {
                TigerUtilities.assertTigerEnabled("Static Import is not supported before Java 1.5");
                try {
                    if (node.isStaticImportClass()) {
                        this.context.declareClassStaticImport(node.getName());
                    }
                    this.context.declareMemberStaticImport(node.getName());
                }
                catch (ClassNotFoundException e) {
                    throw new CatchedExceptionError(e, (Node)node);
                }
            } else if (node.isPackage()) {
                this.context.declarePackageImport(node.getName());
            } else {
                try {
                    this.context.declareClassImport(node.getName());
                }
                catch (ClassNotFoundException e) {
                    throw new CatchedExceptionError(e, (Node)node);
                }
                catch (PseudoError pseudoError) {
                    // empty catch block
                }
            }
            return null;
        }

        @Override
        public Void visit(ClassDeclaration node) {
            return this.visitType(node);
        }

        @Override
        public Void visit(InterfaceDeclaration node) {
            return this.visitType(node);
        }

        protected Void visitType(TypeDeclaration node) {
            String cname = this.classFinder.getCurrentPackage();
            cname = new StringBuffer().append(cname.equals("") ? "" : new StringBuffer().append(cname).append(".").toString()).append(node.getName()).toString();
            TreeCompiler.this.classPool.add(cname, new TreeClassInfo(node, this.classFinder));
            return null;
        }

        @Override
        public /* synthetic */ Object visit(InstanceInitializer x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(ClassInitializer x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(VariableDeclaration x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(FieldDeclaration x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(FormalParameter x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(MethodDeclaration x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(ConstructorDeclaration x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(InterfaceDeclaration x0) {
            return this.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(ClassDeclaration x0) {
            return this.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(BlockStatement x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(BitOrAssignExpression x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(ExclusiveOrAssignExpression x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(BitAndAssignExpression x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(UnsignedShiftRightAssignExpression x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(ShiftRightAssignExpression x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(ShiftLeftAssignExpression x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(SubtractAssignExpression x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(AddAssignExpression x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(RemainderAssignExpression x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(DivideAssignExpression x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(MultiplyAssignExpression x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(SimpleAssignExpression x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(ConditionalExpression x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(OrExpression x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(AndExpression x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(BitOrExpression x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(ExclusiveOrExpression x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(BitAndExpression x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(NotEqualExpression x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(EqualExpression x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(InstanceOfExpression x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(GreaterOrEqualExpression x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(LessOrEqualExpression x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(GreaterExpression x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(LessExpression x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(UnsignedShiftRightExpression x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(ShiftRightExpression x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(ShiftLeftExpression x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(SubtractExpression x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(AddExpression x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(RemainderExpression x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(DivideExpression x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(MultiplyExpression x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(MinusExpression x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(PlusExpression x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(ComplementExpression x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(NotExpression x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(CastExpression x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(InnerClassAllocation x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(InnerAllocation x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(ClassAllocation x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(SimpleAllocation x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(ArrayAllocation x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(ArrayInitializer x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(PreDecrement x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(PreIncrement x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(PostDecrement x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(PostIncrement x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(TypeExpression x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(ArrayType x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(ReferenceType x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(PrimitiveType x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(SuperMethodCall x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(ConstructorInvocation x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(StaticMethodCall x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(FunctionCall x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(ObjectMethodCall x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(SuperFieldAccess x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(ArrayAccess x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(StaticFieldAccess x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(ObjectFieldAccess x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(QualifiedName x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(ThisExpression x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(Literal x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(AssertStatement x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(IfThenElseStatement x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(IfThenStatement x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(ContinueStatement x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(SynchronizedStatement x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(ReturnStatement x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(ThrowStatement x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(CatchStatement x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(TryStatement x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(BreakStatement x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(LabeledStatement x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(SwitchBlock x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(SwitchStatement x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(DoStatement x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(ForEachStatement x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(ForStatement x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(WhileStatement x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(EmptyStatement x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(ImportDeclaration x0) {
            return this.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(PackageDeclaration x0) {
            return this.visit(x0);
        }
    }
}

