/*
 * Decompiled with CFR 0.152.
 */
package koala.dynamicjava.interpreter;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import koala.dynamicjava.interpreter.AbstractTypeChecker;
import koala.dynamicjava.interpreter.context.Context;
import koala.dynamicjava.interpreter.error.CatchedExceptionError;
import koala.dynamicjava.interpreter.error.ExecutionError;
import koala.dynamicjava.tree.AddAssignExpression;
import koala.dynamicjava.tree.AddExpression;
import koala.dynamicjava.tree.AndExpression;
import koala.dynamicjava.tree.ArrayAccess;
import koala.dynamicjava.tree.ArrayAllocation;
import koala.dynamicjava.tree.ArrayInitializer;
import koala.dynamicjava.tree.ArrayType;
import koala.dynamicjava.tree.AssertStatement;
import koala.dynamicjava.tree.BinaryExpression;
import koala.dynamicjava.tree.BitAndAssignExpression;
import koala.dynamicjava.tree.BitAndExpression;
import koala.dynamicjava.tree.BitOrAssignExpression;
import koala.dynamicjava.tree.BitOrExpression;
import koala.dynamicjava.tree.BlockStatement;
import koala.dynamicjava.tree.BreakStatement;
import koala.dynamicjava.tree.CastExpression;
import koala.dynamicjava.tree.CatchStatement;
import koala.dynamicjava.tree.ClassAllocation;
import koala.dynamicjava.tree.ClassDeclaration;
import koala.dynamicjava.tree.ClassInitializer;
import koala.dynamicjava.tree.ComplementExpression;
import koala.dynamicjava.tree.ConditionalExpression;
import koala.dynamicjava.tree.ConstructorDeclaration;
import koala.dynamicjava.tree.ConstructorInvocation;
import koala.dynamicjava.tree.ContinueStatement;
import koala.dynamicjava.tree.DivideAssignExpression;
import koala.dynamicjava.tree.DivideExpression;
import koala.dynamicjava.tree.DoStatement;
import koala.dynamicjava.tree.EmptyStatement;
import koala.dynamicjava.tree.EqualExpression;
import koala.dynamicjava.tree.ExclusiveOrAssignExpression;
import koala.dynamicjava.tree.ExclusiveOrExpression;
import koala.dynamicjava.tree.Expression;
import koala.dynamicjava.tree.ExpressionContainer;
import koala.dynamicjava.tree.FieldAccess;
import koala.dynamicjava.tree.FieldDeclaration;
import koala.dynamicjava.tree.ForEachStatement;
import koala.dynamicjava.tree.ForStatement;
import koala.dynamicjava.tree.FormalParameter;
import koala.dynamicjava.tree.FunctionCall;
import koala.dynamicjava.tree.GreaterExpression;
import koala.dynamicjava.tree.GreaterOrEqualExpression;
import koala.dynamicjava.tree.IdentifierToken;
import koala.dynamicjava.tree.IfThenElseStatement;
import koala.dynamicjava.tree.IfThenStatement;
import koala.dynamicjava.tree.ImportDeclaration;
import koala.dynamicjava.tree.InnerAllocation;
import koala.dynamicjava.tree.InnerClassAllocation;
import koala.dynamicjava.tree.InstanceInitializer;
import koala.dynamicjava.tree.InstanceOfExpression;
import koala.dynamicjava.tree.InterfaceDeclaration;
import koala.dynamicjava.tree.LabeledStatement;
import koala.dynamicjava.tree.LessExpression;
import koala.dynamicjava.tree.LessOrEqualExpression;
import koala.dynamicjava.tree.Literal;
import koala.dynamicjava.tree.MethodDeclaration;
import koala.dynamicjava.tree.MinusExpression;
import koala.dynamicjava.tree.MultiplyAssignExpression;
import koala.dynamicjava.tree.MultiplyExpression;
import koala.dynamicjava.tree.Node;
import koala.dynamicjava.tree.NotEqualExpression;
import koala.dynamicjava.tree.NotExpression;
import koala.dynamicjava.tree.ObjectFieldAccess;
import koala.dynamicjava.tree.ObjectMethodCall;
import koala.dynamicjava.tree.OrExpression;
import koala.dynamicjava.tree.PackageDeclaration;
import koala.dynamicjava.tree.PlusExpression;
import koala.dynamicjava.tree.PostDecrement;
import koala.dynamicjava.tree.PostIncrement;
import koala.dynamicjava.tree.PreDecrement;
import koala.dynamicjava.tree.PreIncrement;
import koala.dynamicjava.tree.PrimitiveType;
import koala.dynamicjava.tree.QualifiedName;
import koala.dynamicjava.tree.ReferenceType;
import koala.dynamicjava.tree.RemainderAssignExpression;
import koala.dynamicjava.tree.RemainderExpression;
import koala.dynamicjava.tree.ReturnStatement;
import koala.dynamicjava.tree.ShiftLeftAssignExpression;
import koala.dynamicjava.tree.ShiftLeftExpression;
import koala.dynamicjava.tree.ShiftRightAssignExpression;
import koala.dynamicjava.tree.ShiftRightExpression;
import koala.dynamicjava.tree.SimpleAllocation;
import koala.dynamicjava.tree.SimpleAssignExpression;
import koala.dynamicjava.tree.StaticFieldAccess;
import koala.dynamicjava.tree.StaticMethodCall;
import koala.dynamicjava.tree.SubtractAssignExpression;
import koala.dynamicjava.tree.SubtractExpression;
import koala.dynamicjava.tree.SuperFieldAccess;
import koala.dynamicjava.tree.SuperMethodCall;
import koala.dynamicjava.tree.SwitchBlock;
import koala.dynamicjava.tree.SwitchStatement;
import koala.dynamicjava.tree.SynchronizedStatement;
import koala.dynamicjava.tree.ThisExpression;
import koala.dynamicjava.tree.ThrowStatement;
import koala.dynamicjava.tree.TreeUtilities;
import koala.dynamicjava.tree.TryStatement;
import koala.dynamicjava.tree.TypeExpression;
import koala.dynamicjava.tree.UnsignedShiftRightAssignExpression;
import koala.dynamicjava.tree.UnsignedShiftRightExpression;
import koala.dynamicjava.tree.VariableDeclaration;
import koala.dynamicjava.tree.WhileStatement;
import koala.dynamicjava.tree.visitor.VisitorObject;
import koala.dynamicjava.util.ListUtilities;
import koala.dynamicjava.util.ReflectionUtilities;
import koala.dynamicjava.util.TigerUtilities;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NameVisitor
extends VisitorObject<Node> {
    private Context context;
    private Context typeCheckerContext;
    private Integer name_counter;

    public NameVisitor(Context ctx) {
        this.context = ctx;
        this.name_counter = new Integer(0);
    }

    public NameVisitor(Context ctx, Context typeCtx) {
        this(ctx);
        this.typeCheckerContext = typeCtx;
    }

    protected static void rejectReferenceType(Node o, Node n) {
        if (o instanceof ReferenceType) {
            throw new ExecutionError("Type name used where expression is expected", n);
        }
    }

    @Override
    public Node visit(PackageDeclaration node) {
        this.context.setCurrentPackage(node.getName());
        return null;
    }

    @Override
    public Node visit(ImportDeclaration node) {
        if (node.isStatic()) {
            TigerUtilities.assertTigerEnabled("Static Import is not supported before Java 1.5");
            try {
                if (node.isStaticImportClass()) {
                    this.context.declareClassStaticImport(node.getName());
                }
                this.context.declareMemberStaticImport(node.getName());
            }
            catch (ClassNotFoundException e) {
                throw new CatchedExceptionError(e, (Node)node);
            }
        } else if (node.isPackage()) {
            this.context.declarePackageImport(node.getName());
        } else {
            try {
                this.context.declareClassImport(node.getName());
            }
            catch (ClassNotFoundException e) {
                throw new CatchedExceptionError(e, (Node)node);
            }
        }
        return null;
    }

    @Override
    public Node visit(WhileStatement node) {
        Node n = node.getCondition();
        Node o = n.acceptVisitor(this);
        if (o != null) {
            NameVisitor.rejectReferenceType(o, n);
            node.setCondition((Expression)o);
        }
        if ((o = (n = node.getBody()).acceptVisitor(this)) != null) {
            NameVisitor.rejectReferenceType(o, n);
            node.setBody(o);
        }
        return null;
    }

    @Override
    public Node visit(ForEachStatement node) {
        this.context.enterScope();
        this.name_counter = new Integer(this.name_counter + 1);
        String s1 = new StringBuffer().append("#_foreach_var_").append(this.name_counter).toString();
        this.name_counter = new Integer(this.name_counter + 1);
        String s2 = new StringBuffer().append("#_foreach_var_").append(this.name_counter).toString();
        this.context.define(s1, null);
        this.context.define(s2, null);
        node.addVar(s1);
        node.addVar(s2);
        FormalParameter param = node.getParameter();
        Expression coll = node.getCollection();
        Node body = node.getBody();
        Node o = param.acceptVisitor(this);
        if (o != null) {
            NameVisitor.rejectReferenceType(o, param);
            node.setParameter((FormalParameter)o);
        }
        if ((o = coll.acceptVisitor(this)) != null) {
            NameVisitor.rejectReferenceType(o, coll);
            node.setCollection((Expression)o);
        }
        if ((o = body.acceptVisitor(this)) != null) {
            NameVisitor.rejectReferenceType(o, body);
            node.setBody(o);
        }
        this.context.leaveScope();
        return null;
    }

    @Override
    public Node visit(ForStatement node) {
        Node o;
        List<Node> updt;
        Node o2;
        Node n;
        this.context.enterScope();
        List<Node> init = node.getInitialization();
        if (init != null) {
            this.visitList(init);
        }
        if ((n = node.getCondition()) != null && (o2 = n.acceptVisitor(this)) != null) {
            NameVisitor.rejectReferenceType(o2, n);
            node.setCondition((Expression)o2);
        }
        if ((updt = node.getUpdate()) != null) {
            this.visitList(updt);
        }
        if ((o = (n = node.getBody()).acceptVisitor(this)) != null) {
            NameVisitor.rejectReferenceType(o, n);
            node.setBody(o);
        }
        this.context.leaveScope();
        return null;
    }

    @Override
    public Node visit(DoStatement node) {
        Node n = node.getCondition();
        Node o = n.acceptVisitor(this);
        if (o != null) {
            NameVisitor.rejectReferenceType(o, n);
            node.setCondition((Expression)o);
        }
        if ((o = (n = node.getBody()).acceptVisitor(this)) != null) {
            NameVisitor.rejectReferenceType(o, n);
            node.setBody(o);
        }
        return null;
    }

    @Override
    public Node visit(SwitchStatement node) {
        Expression exp = node.getSelector();
        Node o = exp.acceptVisitor(this);
        if (o != null) {
            NameVisitor.rejectReferenceType(o, exp);
            node.setSelector((Expression)o);
        }
        Iterator<SwitchBlock> it = node.getBindings().iterator();
        while (it.hasNext()) {
            it.next().acceptVisitor(this);
        }
        return null;
    }

    @Override
    public Node visit(SwitchBlock node) {
        List<Node> l;
        Expression exp = node.getExpression();
        if (exp != null) {
            this.visitExpressionContainer(node);
        }
        if ((l = node.getStatements()) != null) {
            this.visitList(l);
        }
        return null;
    }

    @Override
    public Node visit(LabeledStatement node) {
        Node n = node.getStatement();
        Node o = n.acceptVisitor(this);
        if (o != null) {
            NameVisitor.rejectReferenceType(o, n);
            node.setStatement(o);
        }
        return null;
    }

    @Override
    public Node visit(ThrowStatement node) {
        this.visitExpressionContainer(node);
        return null;
    }

    @Override
    public Node visit(SynchronizedStatement node) {
        Node n = node.getLock();
        Node o = n.acceptVisitor(this);
        if (o != null) {
            NameVisitor.rejectReferenceType(o, n);
            node.setLock((Expression)o);
        }
        if ((o = (n = node.getBody()).acceptVisitor(this)) != null) {
            NameVisitor.rejectReferenceType(o, n);
            node.setBody(o);
        }
        return null;
    }

    @Override
    public Node visit(TryStatement node) {
        node.getTryBlock().acceptVisitor(this);
        Iterator<CatchStatement> it = node.getCatchStatements().iterator();
        while (it.hasNext()) {
            it.next().acceptVisitor(this);
        }
        Node n = node.getFinallyBlock();
        if (n != null) {
            n.acceptVisitor(this);
        }
        return null;
    }

    @Override
    public Node visit(CatchStatement node) {
        this.context.enterScope();
        node.getException().acceptVisitor(this);
        node.getBlock().acceptVisitor(this);
        this.context.leaveScope();
        return null;
    }

    @Override
    public Node visit(ReturnStatement node) {
        Expression e = node.getExpression();
        if (e != null) {
            this.visitExpressionContainer(node);
        }
        return null;
    }

    @Override
    public Node visit(IfThenStatement node) {
        Node n = node.getCondition();
        Node o = n.acceptVisitor(this);
        if (o != null) {
            NameVisitor.rejectReferenceType(o, n);
            node.setCondition((Expression)o);
        }
        if ((o = (n = node.getThenStatement()).acceptVisitor(this)) != null) {
            NameVisitor.rejectReferenceType(o, n);
            node.setThenStatement(o);
        }
        return null;
    }

    @Override
    public Node visit(IfThenElseStatement node) {
        Node n = node.getCondition();
        Node o = n.acceptVisitor(this);
        if (o != null) {
            NameVisitor.rejectReferenceType(o, n);
            node.setCondition((Expression)o);
        }
        if ((o = (n = node.getThenStatement()).acceptVisitor(this)) != null) {
            NameVisitor.rejectReferenceType(o, n);
            node.setThenStatement(o);
        }
        if ((o = (n = node.getElseStatement()).acceptVisitor(this)) != null) {
            NameVisitor.rejectReferenceType(o, n);
            node.setElseStatement(o);
        }
        return null;
    }

    @Override
    public Node visit(AssertStatement node) {
        Expression n = node.getCondition();
        Node o = n.acceptVisitor(this);
        if (o != null) {
            NameVisitor.rejectReferenceType(o, n);
            node.setCondition((Expression)o);
        }
        if ((n = node.getFailString()) != null && (o = n.acceptVisitor(this)) != null) {
            node.setFailString((Expression)o);
        }
        return null;
    }

    @Override
    public Node visit(VariableDeclaration node) {
        Node o;
        String s = node.getName();
        if (this.context.isDefinedVariable(s)) {
            node.setProperty("errorStrings", new String[]{s});
            throw new ExecutionError("variable.redefinition", node);
        }
        if (node.isFinal()) {
            this.context.defineConstant(s, null);
        } else {
            this.context.define(s, null);
        }
        Expression n = node.getInitializer();
        if (n != null && (o = n.acceptVisitor(this)) != null) {
            NameVisitor.rejectReferenceType(o, n);
            node.setInitializer((Expression)o);
        }
        return null;
    }

    @Override
    public Node visit(SimpleAssignExpression node) {
        Expression left;
        Expression right = node.getRightExpression();
        Node o = right.acceptVisitor(this);
        if (o != null) {
            NameVisitor.rejectReferenceType(o, right);
            node.setRightExpression((Expression)o);
        }
        if ((left = node.getLeftExpression()) instanceof QualifiedName) {
            List<IdentifierToken> ids = ((QualifiedName)left).getIdentifiers();
            String var = ids.get(0).image();
            if (ids.size() == 1 && !this.context.exists(var)) {
                this.context.define(var, null);
            }
        }
        if ((o = left.acceptVisitor(this)) != null) {
            NameVisitor.rejectReferenceType(o, left);
            node.setLeftExpression((Expression)o);
        }
        return null;
    }

    @Override
    public Node visit(BlockStatement node) {
        this.context.enterScope();
        this.visitList(node.getStatements());
        this.context.leaveScope();
        return null;
    }

    @Override
    public Node visit(ObjectFieldAccess node) {
        Node o = node.getExpression().acceptVisitor(this);
        if (o != null) {
            if (o instanceof ReferenceType) {
                return new StaticFieldAccess((ReferenceType)o, node.getFieldName(), node.getFilename(), node.getBeginLine(), node.getBeginColumn(), node.getEndLine(), node.getEndColumn());
            }
            node.setExpression((Expression)o);
        }
        return null;
    }

    @Override
    public Node visit(ObjectMethodCall node) {
        Node o;
        List<Expression> args = node.getArguments();
        if (args != null) {
            this.visitExprList(args);
        }
        Node defaultQualifier = this.context.getDefaultQualifier(node);
        Expression exp = node.getExpression();
        if (exp == null) {
            o = defaultQualifier;
        } else {
            o = exp.acceptVisitor(this);
            if (o == null) {
                return null;
            }
        }
        if (o == null || o == defaultQualifier) {
            try {
                AbstractTypeChecker tc = AbstractTypeChecker.makeTypeChecker(this.typeCheckerContext);
                Class[] params = new Class[args != null ? args.size() : 0];
                if (args != null) {
                    for (int i = 0; i < args.size(); ++i) {
                        String toParse = args.get(i).toString();
                        params[i] = (Class)args.get(i).acceptVisitor(tc);
                    }
                }
                boolean existsInCurrentScope = false;
                if (o == defaultQualifier) {
                    try {
                        ReflectionUtilities.lookupMethod((Class)o.acceptVisitor(tc), node.getMethodName(), params);
                        existsInCurrentScope = true;
                    }
                    catch (Exception nsme) {
                        // empty catch block
                    }
                }
                String representation = this.context.getQualifiedName(node.getMethodName(), params);
                if (!existsInCurrentScope) {
                    o = new ReferenceType(representation);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (o == null) {
            return new FunctionCall(node.getMethodName(), node.getArguments(), node.getFilename(), node.getBeginLine(), node.getBeginColumn(), node.getEndLine(), node.getEndColumn());
        }
        if (o instanceof ReferenceType) {
            return new StaticMethodCall((ReferenceType)o, node.getMethodName(), node.getArguments(), node.getFilename(), node.getBeginLine(), node.getBeginColumn(), node.getEndLine(), node.getEndColumn());
        }
        node.setExpression((Expression)o);
        return null;
    }

    @Override
    public Node visit(SuperMethodCall node) {
        List<Expression> args = node.getArguments();
        if (args != null) {
            this.visitExprList(args);
        }
        return null;
    }

    @Override
    public Node visit(ThisExpression node) {
        return (Expression)this.context.getDefaultQualifier(node, node.getClassName());
    }

    @Override
    public Node visit(QualifiedName node) {
        String s;
        List<IdentifierToken> ids = node.getIdentifiers();
        IdentifierToken t = ids.get(0);
        if (this.context.isDefined(t.image())) {
            Expression result = this.context.createName(node, t);
            Iterator<IdentifierToken> it = ids.iterator();
            it.next();
            while (it.hasNext()) {
                IdentifierToken t2 = it.next();
                result = new ObjectFieldAccess(result, t2.image(), node.getFilename(), t.beginLine(), t.beginColumn(), t2.endLine(), t2.endColumn());
            }
            return result;
        }
        try {
            if (this.context.isFieldImported(t.image())) {
                ids = this.context.getQualifiedName(t.image());
            }
        }
        catch (NoSuchFieldException e) {
            // empty catch block
        }
        LinkedList<IdentifierToken> l = ListUtilities.listCopy(ids);
        boolean b = false;
        while (l.size() > 0 && !(b = this.context.classExists(s = TreeUtilities.listToName(l)))) {
            l.remove(l.size() - 1);
        }
        if (!b) {
            node.setProperty("errorStrings", new String[]{t.image()});
            throw new ExecutionError("undefined.class", node);
        }
        IdentifierToken t2 = (IdentifierToken)l.get(l.size() - 1);
        ReferenceType rt = new ReferenceType(l, node.getFilename(), t.beginLine(), t.beginColumn(), t2.endLine(), t2.endColumn());
        if (l.size() != ids.size()) {
            ListIterator<IdentifierToken> it = ids.listIterator(l.size());
            t2 = it.next();
            FieldAccess result = new StaticFieldAccess(rt, t2.image(), node.getFilename(), t.beginLine(), t.beginColumn(), t2.endLine(), t2.endColumn());
            while (it.hasNext()) {
                t2 = it.next();
                result = new ObjectFieldAccess(result, t2.image(), node.getFilename(), t.beginLine(), t.beginColumn(), t2.endLine(), t2.endColumn());
            }
            return result;
        }
        return rt;
    }

    @Override
    public Node visit(SimpleAllocation node) {
        List<Expression> args = node.getArguments();
        if (args != null) {
            this.visitExprList(args);
        }
        return null;
    }

    @Override
    public Node visit(ArrayAllocation node) {
        this.visitExprList(node.getSizes());
        if (node.getInitialization() != null) {
            node.getInitialization().acceptVisitor(this);
        }
        return null;
    }

    @Override
    public Node visit(InnerAllocation node) {
        this.visitExpressionContainer(node);
        List<Expression> args = node.getArguments();
        if (args != null) {
            this.visitExprList(args);
        }
        return null;
    }

    @Override
    public Node visit(ArrayInitializer node) {
        this.visitExprList(node.getCells());
        return null;
    }

    @Override
    public Node visit(ArrayAccess node) {
        this.visitExpressionContainer(node);
        Expression n = node.getCellNumber();
        Node o = n.acceptVisitor(this);
        if (o != null) {
            NameVisitor.rejectReferenceType(o, n);
            node.setCellNumber((Expression)o);
        }
        return null;
    }

    @Override
    public Node visit(NotExpression node) {
        this.visitExpressionContainer(node);
        return null;
    }

    @Override
    public Node visit(ComplementExpression node) {
        this.visitExpressionContainer(node);
        return null;
    }

    @Override
    public Node visit(PlusExpression node) {
        this.visitExpressionContainer(node);
        return null;
    }

    @Override
    public Node visit(MinusExpression node) {
        this.visitExpressionContainer(node);
        return null;
    }

    @Override
    public Node visit(AddExpression node) {
        this.visitBinaryExpression(node);
        return null;
    }

    @Override
    public Node visit(AddAssignExpression node) {
        this.visitBinaryExpression(node);
        return null;
    }

    @Override
    public Node visit(SubtractExpression node) {
        this.visitBinaryExpression(node);
        return null;
    }

    @Override
    public Node visit(SubtractAssignExpression node) {
        this.visitBinaryExpression(node);
        return null;
    }

    @Override
    public Node visit(MultiplyExpression node) {
        this.visitBinaryExpression(node);
        return null;
    }

    @Override
    public Node visit(MultiplyAssignExpression node) {
        this.visitBinaryExpression(node);
        return null;
    }

    @Override
    public Node visit(DivideExpression node) {
        this.visitBinaryExpression(node);
        return null;
    }

    @Override
    public Node visit(DivideAssignExpression node) {
        this.visitBinaryExpression(node);
        return null;
    }

    @Override
    public Node visit(RemainderExpression node) {
        this.visitBinaryExpression(node);
        return null;
    }

    @Override
    public Node visit(RemainderAssignExpression node) {
        this.visitBinaryExpression(node);
        return null;
    }

    @Override
    public Node visit(EqualExpression node) {
        this.visitBinaryExpression(node);
        return null;
    }

    @Override
    public Node visit(NotEqualExpression node) {
        this.visitBinaryExpression(node);
        return null;
    }

    @Override
    public Node visit(LessExpression node) {
        this.visitBinaryExpression(node);
        return null;
    }

    @Override
    public Node visit(LessOrEqualExpression node) {
        this.visitBinaryExpression(node);
        return null;
    }

    @Override
    public Node visit(GreaterExpression node) {
        this.visitBinaryExpression(node);
        return null;
    }

    @Override
    public Node visit(GreaterOrEqualExpression node) {
        this.visitBinaryExpression(node);
        return null;
    }

    @Override
    public Node visit(BitAndExpression node) {
        this.visitBinaryExpression(node);
        return null;
    }

    @Override
    public Node visit(BitAndAssignExpression node) {
        this.visitBinaryExpression(node);
        return null;
    }

    @Override
    public Node visit(ExclusiveOrExpression node) {
        this.visitBinaryExpression(node);
        return null;
    }

    @Override
    public Node visit(ExclusiveOrAssignExpression node) {
        this.visitBinaryExpression(node);
        return null;
    }

    @Override
    public Node visit(BitOrExpression node) {
        this.visitBinaryExpression(node);
        return null;
    }

    @Override
    public Node visit(BitOrAssignExpression node) {
        this.visitBinaryExpression(node);
        return null;
    }

    @Override
    public Node visit(ShiftLeftExpression node) {
        this.visitBinaryExpression(node);
        return null;
    }

    @Override
    public Node visit(ShiftLeftAssignExpression node) {
        this.visitBinaryExpression(node);
        return null;
    }

    @Override
    public Node visit(ShiftRightExpression node) {
        this.visitBinaryExpression(node);
        return null;
    }

    @Override
    public Node visit(ShiftRightAssignExpression node) {
        this.visitBinaryExpression(node);
        return null;
    }

    @Override
    public Node visit(UnsignedShiftRightExpression node) {
        this.visitBinaryExpression(node);
        return null;
    }

    @Override
    public Node visit(UnsignedShiftRightAssignExpression node) {
        this.visitBinaryExpression(node);
        return null;
    }

    @Override
    public Node visit(AndExpression node) {
        this.visitBinaryExpression(node);
        return null;
    }

    @Override
    public Node visit(OrExpression node) {
        this.visitBinaryExpression(node);
        return null;
    }

    @Override
    public Node visit(InstanceOfExpression node) {
        this.visitExpressionContainer(node);
        return null;
    }

    @Override
    public Node visit(ConditionalExpression node) {
        Expression n = node.getConditionExpression();
        Node o = n.acceptVisitor(this);
        if (o != null) {
            NameVisitor.rejectReferenceType(o, n);
            node.setConditionExpression((Expression)o);
        }
        if ((o = (n = node.getIfTrueExpression()).acceptVisitor(this)) != null) {
            NameVisitor.rejectReferenceType(o, n);
            node.setIfTrueExpression((Expression)o);
        }
        if ((o = (n = node.getIfFalseExpression()).acceptVisitor(this)) != null) {
            NameVisitor.rejectReferenceType(o, n);
            node.setIfFalseExpression((Expression)o);
        }
        return null;
    }

    @Override
    public Node visit(PostIncrement node) {
        this.visitExpressionContainer(node);
        return null;
    }

    @Override
    public Node visit(PreIncrement node) {
        this.visitExpressionContainer(node);
        return null;
    }

    @Override
    public Node visit(PostDecrement node) {
        this.visitExpressionContainer(node);
        return null;
    }

    @Override
    public Node visit(PreDecrement node) {
        this.visitExpressionContainer(node);
        return null;
    }

    @Override
    public Node visit(CastExpression node) {
        this.visitExpressionContainer(node);
        return null;
    }

    @Override
    public Node visit(ClassAllocation node) {
        List<Expression> largs = node.getArguments();
        if (largs != null) {
            this.visitExprList(largs);
        }
        return null;
    }

    @Override
    public Node visit(InnerClassAllocation node) {
        this.visitExpressionContainer(node);
        List<Expression> largs = node.getArguments();
        if (largs != null) {
            this.visitExprList(largs);
        }
        return null;
    }

    @Override
    public Node visit(FormalParameter node) {
        if (node.isFinal()) {
            this.context.defineConstant(node.getName(), null);
        } else {
            this.context.define(node.getName(), null);
        }
        return null;
    }

    @Override
    public Node visit(ClassDeclaration node) {
        this.context.defineClass(node);
        return null;
    }

    @Override
    public Node visit(InterfaceDeclaration node) {
        this.context.defineClass(node);
        return null;
    }

    private void visitExpressionContainer(ExpressionContainer node) {
        Expression exp = node.getExpression();
        Node o = exp.acceptVisitor(this);
        if (o != null) {
            NameVisitor.rejectReferenceType(o, exp);
            node.setExpression((Expression)o);
        }
    }

    private void visitBinaryExpression(BinaryExpression node) {
        Node o = node.getLeftExpression().acceptVisitor(this);
        if (o != null) {
            NameVisitor.rejectReferenceType(o, node);
            node.setLeftExpression((Expression)o);
        }
        if ((o = node.getRightExpression().acceptVisitor(this)) != null) {
            NameVisitor.rejectReferenceType(o, node);
            node.setRightExpression((Expression)o);
        }
    }

    private void visitList(List<Node> l) {
        ListIterator<Node> it = l.listIterator();
        while (it.hasNext()) {
            Node n = it.next();
            Node o = n.acceptVisitor(this);
            if (o == null) continue;
            NameVisitor.rejectReferenceType(o, n);
            it.set(o);
        }
    }

    private void visitExprList(List<Expression> l) {
        ListIterator<Expression> it = l.listIterator();
        while (it.hasNext()) {
            Node n = it.next();
            Node o = n.acceptVisitor(this);
            if (o == null) continue;
            if (o instanceof ReferenceType) {
                throw new ExecutionError("malformed.expression", n);
            }
            it.set((Expression)o);
        }
    }

    @Override
    public /* synthetic */ Object visit(InstanceInitializer x0) {
        return super.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(ClassInitializer x0) {
        return super.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(VariableDeclaration x0) {
        return this.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(FieldDeclaration x0) {
        return super.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(FormalParameter x0) {
        return this.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(MethodDeclaration x0) {
        return super.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(ConstructorDeclaration x0) {
        return super.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(InterfaceDeclaration x0) {
        return this.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(ClassDeclaration x0) {
        return this.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(BlockStatement x0) {
        return this.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(BitOrAssignExpression x0) {
        return this.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(ExclusiveOrAssignExpression x0) {
        return this.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(BitAndAssignExpression x0) {
        return this.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(UnsignedShiftRightAssignExpression x0) {
        return this.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(ShiftRightAssignExpression x0) {
        return this.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(ShiftLeftAssignExpression x0) {
        return this.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(SubtractAssignExpression x0) {
        return this.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(AddAssignExpression x0) {
        return this.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(RemainderAssignExpression x0) {
        return this.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(DivideAssignExpression x0) {
        return this.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(MultiplyAssignExpression x0) {
        return this.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(SimpleAssignExpression x0) {
        return this.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(ConditionalExpression x0) {
        return this.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(OrExpression x0) {
        return this.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(AndExpression x0) {
        return this.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(BitOrExpression x0) {
        return this.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(ExclusiveOrExpression x0) {
        return this.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(BitAndExpression x0) {
        return this.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(NotEqualExpression x0) {
        return this.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(EqualExpression x0) {
        return this.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(InstanceOfExpression x0) {
        return this.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(GreaterOrEqualExpression x0) {
        return this.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(LessOrEqualExpression x0) {
        return this.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(GreaterExpression x0) {
        return this.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(LessExpression x0) {
        return this.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(UnsignedShiftRightExpression x0) {
        return this.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(ShiftRightExpression x0) {
        return this.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(ShiftLeftExpression x0) {
        return this.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(SubtractExpression x0) {
        return this.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(AddExpression x0) {
        return this.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(RemainderExpression x0) {
        return this.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(DivideExpression x0) {
        return this.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(MultiplyExpression x0) {
        return this.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(MinusExpression x0) {
        return this.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(PlusExpression x0) {
        return this.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(ComplementExpression x0) {
        return this.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(NotExpression x0) {
        return this.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(CastExpression x0) {
        return this.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(InnerClassAllocation x0) {
        return this.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(InnerAllocation x0) {
        return this.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(ClassAllocation x0) {
        return this.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(SimpleAllocation x0) {
        return this.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(ArrayAllocation x0) {
        return this.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(ArrayInitializer x0) {
        return this.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(PreDecrement x0) {
        return this.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(PreIncrement x0) {
        return this.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(PostDecrement x0) {
        return this.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(PostIncrement x0) {
        return this.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(TypeExpression x0) {
        return super.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(ArrayType x0) {
        return super.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(ReferenceType x0) {
        return super.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(PrimitiveType x0) {
        return super.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(SuperMethodCall x0) {
        return this.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(ConstructorInvocation x0) {
        return super.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(StaticMethodCall x0) {
        return super.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(FunctionCall x0) {
        return super.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(ObjectMethodCall x0) {
        return this.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(SuperFieldAccess x0) {
        return super.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(ArrayAccess x0) {
        return this.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(StaticFieldAccess x0) {
        return super.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(ObjectFieldAccess x0) {
        return this.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(QualifiedName x0) {
        return this.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(ThisExpression x0) {
        return this.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(Literal x0) {
        return super.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(AssertStatement x0) {
        return this.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(IfThenElseStatement x0) {
        return this.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(IfThenStatement x0) {
        return this.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(ContinueStatement x0) {
        return super.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(SynchronizedStatement x0) {
        return this.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(ReturnStatement x0) {
        return this.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(ThrowStatement x0) {
        return this.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(CatchStatement x0) {
        return this.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(TryStatement x0) {
        return this.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(BreakStatement x0) {
        return super.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(LabeledStatement x0) {
        return this.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(SwitchBlock x0) {
        return this.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(SwitchStatement x0) {
        return this.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(DoStatement x0) {
        return this.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(ForEachStatement x0) {
        return this.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(ForStatement x0) {
        return this.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(WhileStatement x0) {
        return this.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(EmptyStatement x0) {
        return super.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(ImportDeclaration x0) {
        return this.visit(x0);
    }

    @Override
    public /* synthetic */ Object visit(PackageDeclaration x0) {
        return this.visit(x0);
    }
}

