/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.util.swing;

import edu.rice.cs.drjava.ui.DrJavaErrorHandler;
import edu.rice.cs.drjava.ui.MainFrame;
import edu.rice.cs.util.StringOps;
import edu.rice.cs.util.UnexpectedException;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.SystemColor;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.Reader;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JTextArea;
import javax.swing.border.Border;

public class Utilities {
    public static volatile boolean TEST_MODE = false;

    public static void invokeLater(Runnable task) {
        if (EventQueue.isDispatchThread()) {
            task.run();
            return;
        }
        EventQueue.invokeLater(task);
    }

    public static void invokeAndWait(Runnable task) {
        if (EventQueue.isDispatchThread()) {
            task.run();
            return;
        }
        try {
            EventQueue.invokeAndWait(task);
        }
        catch (Exception e) {
            throw new UnexpectedException(e);
        }
    }

    public static void main(String[] args) {
        Utilities.clearEventQueue();
    }

    public static void clearEventQueue() {
        Utilities.invokeAndWait(new Runnable(){

            public void run() {
            }
        });
    }

    public static void show(final String msg) {
        Utilities.invokeAndWait(new Runnable(){

            public void run() {
                JOptionPane.showMessageDialog(null, msg);
            }
        });
    }

    public static void showTrace(final Throwable t) {
        Utilities.invokeAndWait(new Runnable(){

            public void run() {
                new DrJavaErrorHandler().handle(t);
            }
        });
    }

    public static void showDebug(String msg) {
        Utilities.showMessageBox(msg, "Debug Message");
    }

    public static void showMessageBox(final String msg, final String title) {
        Utilities.invokeAndWait(new Runnable(){

            public void run() {
                TextAreaMessageDialog.showDialog(null, title, msg);
            }
        });
    }

    public static void showStackTrace(final Throwable t) {
        Utilities.invokeAndWait(new Runnable(){

            public void run() {
                JOptionPane.showMessageDialog(null, StringOps.getStackTrace(t));
            }
        });
    }

    public static String getClipboardSelection(Component c) {
        Clipboard cb = c.getToolkit().getSystemClipboard();
        if (cb == null) {
            return null;
        }
        Transferable t = cb.getContents(null);
        if (t == null) {
            return null;
        }
        String s = null;
        try {
            int ch;
            Reader r = DataFlavor.stringFlavor.getReaderForText(t);
            StringBuffer sb = new StringBuffer();
            while ((ch = r.read()) != -1) {
                sb.append((char)ch);
            }
            s = sb.toString();
        }
        catch (UnsupportedFlavorException ufe) {
        }
        catch (IOException ioe) {
            // empty catch block
        }
        return s;
    }

    public static class TextAreaMessageDialog
    extends JDialog {
        public static void showDialog(Component comp, String title, String message) {
            if (TEST_MODE) {
                System.out.println(title + ": " + message);
            } else {
                Frame frame = JOptionPane.getFrameForComponent(comp);
                TextAreaMessageDialog dialog = new TextAreaMessageDialog(frame, comp, title, message);
                MainFrame.setPopupLoc(dialog, frame);
                dialog.setVisible(true);
            }
        }

        private TextAreaMessageDialog(Frame frame, Component comp, String title, String message) {
            super(frame, title, true);
            this.setDefaultCloseOperation(2);
            JButton okButton = new JButton("OK");
            okButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    TextAreaMessageDialog.this.dispose();
                }
            });
            this.getRootPane().setDefaultButton(okButton);
            JTextArea textArea = new JTextArea(message);
            textArea.setEditable(false);
            textArea.setLineWrap(true);
            textArea.setWrapStyleWord(false);
            textArea.setBackground(SystemColor.window);
            Border emptyBorder = BorderFactory.createEmptyBorder(10, 10, 10, 10);
            textArea.setBorder(emptyBorder);
            Container contentPane = this.getContentPane();
            contentPane.add((Component)textArea, "Center");
            contentPane.add((Component)okButton, "South");
            Dimension parentDim = comp != null ? comp.getSize() : this.getToolkit().getScreenSize();
            int xs = (int)parentDim.getWidth() / 4;
            int ys = (int)parentDim.getHeight() / 5;
            this.setSize(Math.max(xs, 350), Math.max(ys, 250));
            this.setLocationRelativeTo(comp);
        }
    }
}

