/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.util.swing;

import edu.rice.cs.util.swing.FileDisplayManager;
import java.io.File;

public class FileDisplay {
    private File _file;
    private String _rep;
    private boolean _repIsDifferent;
    private boolean _isNew;
    protected FileDisplayManager _fdm;

    FileDisplay(File f, FileDisplayManager fdm) {
        this(fdm);
        this._file = f;
        this._rep = this.formatRep(f);
    }

    FileDisplay(File parent, String child, FileDisplayManager fdm) {
        this(fdm);
        this._file = child == null || child.equals("") ? new File(parent, ".") : new File(parent, child);
        this._rep = this.formatRep(this._file);
    }

    private FileDisplay(FileDisplayManager fdm) {
        this._fdm = fdm;
    }

    public static FileDisplay newFile(File parent, FileDisplayManager fdm) {
        FileDisplay fd = new FileDisplay(parent, "", fdm);
        fd._isNew = true;
        fd._rep = FileDisplay.getDefaultNewFileRep();
        return fd;
    }

    public File getParentFile() {
        return this._file.getParentFile();
    }

    public File getFile() {
        return this._file;
    }

    public boolean isEditable() {
        return this._isNew || this._file.canWrite() && this._rep.equals(this._file.getName());
    }

    public boolean isNew() {
        return this._isNew;
    }

    public String getRepresentation() {
        return this._rep;
    }

    public final String toString() {
        return this._rep;
    }

    protected String formatRep(File file) {
        return this._fdm.getName(file);
    }

    protected static String getDefaultNewFileRep() {
        return "New Folder";
    }
}

