/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.util.jar;

import edu.rice.cs.util.UnexpectedException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

public class ManifestWriter {
    private List<String> _classPaths = new LinkedList<String>();
    private String _mainClass = null;
    public static final Manifest DEFAULT = new ManifestWriter().getManifest();

    public void addClassPath(String path) {
        this._classPaths.add(this._classPaths.size(), path);
    }

    public void setMainClass(String mainClass) {
        this._mainClass = mainClass;
    }

    protected InputStream getInputStream() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append(Attributes.Name.MANIFEST_VERSION.toString());
        sbuf.append(": 1.0" + System.getProperty("line.separator"));
        if (!this._classPaths.isEmpty()) {
            Iterator<String> iter = this._classPaths.iterator();
            sbuf.append(Attributes.Name.CLASS_PATH.toString());
            sbuf.append(":");
            while (iter.hasNext()) {
                sbuf.append(" ");
                sbuf.append(iter.next());
            }
            sbuf.append(System.getProperty("line.separator"));
        }
        if (this._mainClass != null) {
            sbuf.append(Attributes.Name.MAIN_CLASS.toString());
            sbuf.append(": ");
            sbuf.append(this._mainClass);
            sbuf.append(System.getProperty("line.separator"));
        }
        try {
            return new ByteArrayInputStream(sbuf.toString().getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new UnexpectedException(e);
        }
    }

    public Manifest getManifest() {
        try {
            Manifest m = new Manifest();
            m.read(this.getInputStream());
            return m;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

