/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.util.classloader;

import edu.rice.cs.plt.io.IOUtil;
import edu.rice.cs.util.FileOps;
import java.io.File;
import java.io.FileFilter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Iterator;
import java.util.LinkedHashSet;

public class ToolsJarClassLoader
extends URLClassLoader {
    public ToolsJarClassLoader(File toolsJar) {
        super(ToolsJarClassLoader.getToolsJarURLs(toolsJar));
    }

    public ToolsJarClassLoader() {
        this(FileOps.NONEXISTENT_FILE);
    }

    public static File[] getToolsJarFiles(File toolsJar) {
        File javaHome = IOUtil.attemptCanonicalFile(new File(System.getProperty("java.home")));
        LinkedHashSet<File> javaHomeParents = new LinkedHashSet<File>();
        javaHomeParents.add(IOUtil.attemptCanonicalFile(new File(javaHome, "..")));
        javaHomeParents.add(IOUtil.attemptCanonicalFile(new File(javaHome, "../..")));
        String jv = System.getProperty("java.version");
        if (!jv.startsWith("1.3") && !jv.startsWith("1.4")) {
            String winPrograms = System.getenv("ProgramFiles");
            if (winPrograms != null) {
                javaHomeParents.add(IOUtil.attemptCanonicalFile(new File(winPrograms, "Java")));
                javaHomeParents.add(IOUtil.attemptCanonicalFile(new File(winPrograms)));
            } else {
                javaHomeParents.add(IOUtil.attemptCanonicalFile(new File("/C:/Program Files/Java/")));
                javaHomeParents.add(IOUtil.attemptCanonicalFile(new File("/C:/Program Files/")));
            }
            String winSystem = System.getenv("SystemDrive");
            if (winSystem != null) {
                javaHomeParents.add(IOUtil.attemptCanonicalFile(new File(winSystem, "Java")));
                javaHomeParents.add(IOUtil.attemptCanonicalFile(new File(winSystem)));
            } else {
                javaHomeParents.add(IOUtil.attemptCanonicalFile(new File("/C:/Java/")));
                javaHomeParents.add(IOUtil.attemptCanonicalFile(new File("/C:/")));
            }
        }
        javaHomeParents.add(IOUtil.attemptCanonicalFile(new File("/usr/")));
        javaHomeParents.add(IOUtil.attemptCanonicalFile(new File("/usr/java/")));
        javaHomeParents.add(IOUtil.attemptCanonicalFile(new File("/usr/j2se/")));
        javaHomeParents.add(IOUtil.attemptCanonicalFile(new File("/usr/local/")));
        javaHomeParents.add(IOUtil.attemptCanonicalFile(new File("/usr/local/java/")));
        javaHomeParents.add(IOUtil.attemptCanonicalFile(new File("/usr/local/j2se/")));
        LinkedHashSet<File> javaHomes = new LinkedHashSet<File>();
        try {
            if (javaHome.isDirectory()) {
                javaHomes.add(javaHome);
            }
        }
        catch (SecurityException e) {
            // empty catch block
        }
        String version = System.getProperty("java.specification.version");
        final String prefix1 = "j2sdk" + version;
        final String prefix2 = "jdk" + version;
        FileFilter matchHomes = new FileFilter(){

            public boolean accept(File f) {
                return f.isDirectory() && (f.getName().startsWith(prefix1) || f.getName().startsWith(prefix2));
            }
        };
        Iterator i$ = javaHomeParents.iterator();
        while (i$.hasNext()) {
            File parent = (File)i$.next();
            try {
                File[] files = parent.listFiles(matchHomes);
                if (files == null) continue;
                File[] arr$ = files;
                int len$ = arr$.length;
                for (int i$2 = 0; i$2 < len$; ++i$2) {
                    File f = arr$[i$2];
                    javaHomes.add(f);
                }
            }
            catch (SecurityException e) {
            }
        }
        LinkedHashSet<File> result = new LinkedHashSet<File>();
        try {
            if (toolsJar.isFile()) {
                result.add(IOUtil.attemptCanonicalFile(toolsJar));
            }
        }
        catch (SecurityException e) {
            // empty catch block
        }
        Iterator i$3 = javaHomes.iterator();
        while (i$3.hasNext()) {
            File home = (File)i$3.next();
            try {
                File tools = new File(home, "lib/tools.jar");
                if (!tools.isFile()) continue;
                result.add(IOUtil.attemptCanonicalFile(tools));
            }
            catch (SecurityException e) {}
        }
        return result.toArray(new File[0]);
    }

    public static URL[] getToolsJarURLs() {
        return ToolsJarClassLoader.getToolsJarURLs(FileOps.NONEXISTENT_FILE);
    }

    public static URL[] getToolsJarURLs(File toolsJar) {
        File[] files = ToolsJarClassLoader.getToolsJarFiles(toolsJar);
        try {
            URL[] urls = new URL[files.length];
            for (int i = 0; i < files.length; ++i) {
                urls[i] = FileOps.toURL(files[i]);
            }
            return urls;
        }
        catch (MalformedURLException e) {
            return new URL[0];
        }
    }

    public static String getToolsJarClassPath() {
        return ToolsJarClassLoader.getToolsJarClassPath(FileOps.NONEXISTENT_FILE);
    }

    public static String getToolsJarClassPath(File toolsJar) {
        File[] files = ToolsJarClassLoader.getToolsJarFiles(toolsJar);
        StringBuffer classPath = new StringBuffer();
        String pathSep = System.getProperty("path.separator");
        for (int i = 0; i < files.length; ++i) {
            if (i > 0) {
                classPath.append(pathSep);
            }
            classPath.append(files[i].getAbsolutePath());
        }
        return classPath.toString();
    }

    public URL getResource(String name) {
        return this.findResource(name);
    }
}

