/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.util;

import edu.rice.cs.util.ExitingNotAllowedException;
import java.security.Permission;

public class PreventExitSecurityManager
extends SecurityManager {
    private static final Permission SET_MANAGER_PERM = new RuntimePermission("setSecurityManager");
    private final SecurityManager _parent;
    private boolean _exitAttempted = false;
    private boolean _timeToExit = false;
    private boolean _blockExit = false;
    private boolean _timeToDeactivate = false;

    private PreventExitSecurityManager(SecurityManager parent) {
        this._parent = parent;
    }

    public static PreventExitSecurityManager activate() {
        SecurityManager currentMgr = System.getSecurityManager();
        if (currentMgr instanceof PreventExitSecurityManager) {
            return (PreventExitSecurityManager)currentMgr;
        }
        PreventExitSecurityManager mgr = new PreventExitSecurityManager(System.getSecurityManager());
        System.setSecurityManager(mgr);
        return mgr;
    }

    public void deactivate() {
        this._timeToDeactivate = true;
        System.setSecurityManager(this._parent);
    }

    public void exitVM(int status) {
        if (!this._blockExit) {
            this._timeToExit = true;
        }
        System.exit(status);
    }

    public void setBlockExit(boolean b) {
        this._blockExit = b;
    }

    public boolean exitAttempted() {
        boolean old = this._exitAttempted;
        this._exitAttempted = false;
        return old;
    }

    public void checkPermission(Permission perm) {
        if (perm.equals(SET_MANAGER_PERM)) {
            if (!this._timeToDeactivate) {
                throw new SecurityException("Can not reset security manager!");
            }
        } else if (this._parent != null) {
            this._parent.checkPermission(perm);
        }
    }

    public void checkExit(int status) {
        if (!this._timeToExit) {
            this._exitAttempted = true;
            throw new ExitingNotAllowedException();
        }
    }
}

