/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.util;

import edu.rice.cs.util.FileOps;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassPathVector
extends ArrayList<URL> {
    public ClassPathVector() {
    }

    public ClassPathVector(int capacity) {
        super(capacity);
    }

    @Override
    public String toString() {
        StringBuffer cp = new StringBuffer();
        for (URL u : this) {
            cp.append(this.formatURL(u));
            cp.append(File.pathSeparator);
        }
        return cp.toString();
    }

    public void add(String entry) {
        try {
            this.add(new URL(entry));
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    public void add(File entry) {
        try {
            this.add(FileOps.toURL(entry));
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    public ArrayList<File> asFileVector() {
        ArrayList<File> v = new ArrayList<File>();
        for (URL url : this) {
            v.add(new File(url.getFile()));
        }
        return v;
    }

    private String formatURL(URL url) {
        return new File(url.getFile()).toString();
    }
}

