/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.plt.recur;

import edu.rice.cs.plt.collect.HashMultiset;
import edu.rice.cs.plt.collect.Multiset;
import edu.rice.cs.plt.lambda.Lambda3;
import edu.rice.cs.plt.lambda.Runnable3;
import edu.rice.cs.plt.lambda.Thunk;
import edu.rice.cs.plt.tuple.IdentityTriple;
import edu.rice.cs.plt.tuple.Triple;
import java.util.LinkedList;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RecursionStack3<T1, T2, T3> {
    private final Lambda3<? super T1, ? super T2, ? super T3, ? extends Triple<T1, T2, T3>> _tripleFactory;
    private final Multiset<Triple<T1, T2, T3>> _previous;
    private final LinkedList<Triple<T1, T2, T3>> _stack;

    public RecursionStack3() {
        this(IdentityTriple.factory());
    }

    public RecursionStack3(Lambda3<? super T1, ? super T2, ? super T3, ? extends Triple<T1, T2, T3>> tripleFactory) {
        this._tripleFactory = tripleFactory;
        this._previous = new HashMultiset<Triple<T1, T2, T3>>();
        this._stack = new LinkedList();
    }

    public boolean contains(T1 arg1, T2 arg2, T3 arg3) {
        return this._previous.contains(this._tripleFactory.value(arg1, arg2, arg3));
    }

    public boolean contains(T1 arg1, T2 arg2, T3 arg3, int threshold) {
        return this._previous.count(this._tripleFactory.value(arg1, arg2, arg3)) >= threshold;
    }

    public void push(T1 arg1, T2 arg2, T3 arg3) {
        Triple<T1, T2, T3> wrapped = this._tripleFactory.value(arg1, arg2, arg3);
        this._stack.addLast(wrapped);
        this._previous.add(wrapped);
    }

    public void pop(T1 arg1, T2 arg2, T3 arg3) {
        Triple<T1, T2, T3> wrapped = this._tripleFactory.value(arg1, arg2, arg3);
        if (this._stack.isEmpty() || !this._stack.getLast().equals(wrapped)) {
            throw new IllegalArgumentException("given args are not on top of the stack");
        }
        this._stack.removeLast();
        this._previous.remove(wrapped);
    }

    public int size() {
        return this._stack.size();
    }

    public boolean isEmpty() {
        return this._stack.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(Runnable r, T1 arg1, T2 arg2, T3 arg3) {
        if (!this.contains(arg1, arg2, arg3)) {
            this.push(arg1, arg2, arg3);
            try {
                r.run();
            }
            finally {
                this.pop(arg1, arg2, arg3);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(Runnable r, T1 arg1, T2 arg2, T3 arg3, int threshold) {
        if (!this.contains(arg1, arg2, arg3, threshold)) {
            this.push(arg1, arg2, arg3);
            try {
                r.run();
            }
            finally {
                this.pop(arg1, arg2, arg3);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(Runnable r, Runnable infiniteCase, T1 arg1, T2 arg2, T3 arg3) {
        Runnable toRun = this.contains(arg1, arg2, arg3) ? infiniteCase : r;
        this.push(arg1, arg2, arg3);
        try {
            toRun.run();
        }
        finally {
            this.pop(arg1, arg2, arg3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(Runnable r, Runnable infiniteCase, T1 arg1, T2 arg2, T3 arg3, int threshold) {
        Runnable toRun = this.contains(arg1, arg2, arg3, threshold) ? infiniteCase : r;
        this.push(arg1, arg2, arg3);
        try {
            toRun.run();
        }
        finally {
            this.pop(arg1, arg2, arg3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V1 extends T1, V2 extends T2, V3 extends T3> void run(Runnable3<? super V1, ? super V2, ? super V3> r, V1 arg1, V2 arg2, V3 arg3) {
        if (!this.contains(arg1, arg2, arg3)) {
            this.push(arg1, arg2, arg3);
            try {
                r.run(arg1, arg2, arg3);
            }
            finally {
                this.pop(arg1, arg2, arg3);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V1 extends T1, V2 extends T2, V3 extends T3> void run(Runnable3<? super V1, ? super V2, ? super V3> r, V1 arg1, V2 arg2, V3 arg3, int threshold) {
        if (!this.contains(arg1, arg2, arg3, threshold)) {
            this.push(arg1, arg2, arg3);
            try {
                r.run(arg1, arg2, arg3);
            }
            finally {
                this.pop(arg1, arg2, arg3);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V1 extends T1, V2 extends T2, V3 extends T3> void run(Runnable3<? super V1, ? super V2, ? super V3> r, Runnable3<? super V1, ? super V2, ? super V3> infiniteCase, V1 arg1, V2 arg2, V3 arg3) {
        Runnable3<V1, V2, V3> toRun = this.contains(arg1, arg2, arg3) ? infiniteCase : r;
        this.push(arg1, arg2, arg3);
        try {
            toRun.run(arg1, arg2, arg3);
        }
        finally {
            this.pop(arg1, arg2, arg3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V1 extends T1, V2 extends T2, V3 extends T3> void run(Runnable3<? super V1, ? super V2, ? super V3> r, Runnable3<? super V1, ? super V2, ? super V3> infiniteCase, V1 arg1, V2 arg2, V3 arg3, int threshold) {
        Runnable3<V1, V2, V3> toRun = this.contains(arg1, arg2, arg3, threshold) ? infiniteCase : r;
        this.push(arg1, arg2, arg3);
        try {
            toRun.run(arg1, arg2, arg3);
        }
        finally {
            this.pop(arg1, arg2, arg3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R> R apply(Thunk<? extends R> thunk, R infiniteCase, T1 arg1, T2 arg2, T3 arg3) {
        if (!this.contains(arg1, arg2, arg3)) {
            this.push(arg1, arg2, arg3);
            try {
                R r = thunk.value();
                return r;
            }
            finally {
                this.pop(arg1, arg2, arg3);
            }
        }
        return infiniteCase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R> R apply(Thunk<? extends R> thunk, R infiniteCase, T1 arg1, T2 arg2, T3 arg3, int threshold) {
        if (!this.contains(arg1, arg2, arg3, threshold)) {
            this.push(arg1, arg2, arg3);
            try {
                R r = thunk.value();
                return r;
            }
            finally {
                this.pop(arg1, arg2, arg3);
            }
        }
        return infiniteCase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R> R apply(Thunk<? extends R> thunk, Thunk<? extends R> infiniteCase, T1 arg1, T2 arg2, T3 arg3) {
        Thunk<R> toApply = this.contains(arg1, arg2, arg3) ? infiniteCase : thunk;
        this.push(arg1, arg2, arg3);
        try {
            R r = toApply.value();
            return r;
        }
        finally {
            this.pop(arg1, arg2, arg3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R> R apply(Thunk<? extends R> thunk, Thunk<? extends R> infiniteCase, T1 arg1, T2 arg2, T3 arg3, int threshold) {
        Thunk<R> toApply = this.contains(arg1, arg2, arg3, threshold) ? infiniteCase : thunk;
        this.push(arg1, arg2, arg3);
        try {
            R r = toApply.value();
            return r;
        }
        finally {
            this.pop(arg1, arg2, arg3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V1 extends T1, V2 extends T2, V3 extends T3, R> R apply(Lambda3<? super V1, ? super V2, ? super V3, ? extends R> lambda, R infiniteCase, V1 arg1, V2 arg2, V3 arg3) {
        if (!this.contains(arg1, arg2, arg3)) {
            this.push(arg1, arg2, arg3);
            try {
                R r = lambda.value(arg1, arg2, arg3);
                return r;
            }
            finally {
                this.pop(arg1, arg2, arg3);
            }
        }
        return infiniteCase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V1 extends T1, V2 extends T2, V3 extends T3, R> R apply(Lambda3<? super V1, ? super V2, ? super V3, ? extends R> lambda, R infiniteCase, V1 arg1, V2 arg2, V3 arg3, int threshold) {
        if (!this.contains(arg1, arg2, arg3, threshold)) {
            this.push(arg1, arg2, arg3);
            try {
                R r = lambda.value(arg1, arg2, arg3);
                return r;
            }
            finally {
                this.pop(arg1, arg2, arg3);
            }
        }
        return infiniteCase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V1 extends T1, V2 extends T2, V3 extends T3, R> R apply(Lambda3<? super V1, ? super V2, ? super V3, ? extends R> lambda, Lambda3<? super V1, ? super V2, ? super V3, ? extends R> infiniteCase, V1 arg1, V2 arg2, V3 arg3) {
        Lambda3<V1, V2, V3, R> toApply = this.contains(arg1, arg2, arg3) ? infiniteCase : lambda;
        this.push(arg1, arg2, arg3);
        try {
            R r = toApply.value(arg1, arg2, arg3);
            return r;
        }
        finally {
            this.pop(arg1, arg2, arg3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V1 extends T1, V2 extends T2, V3 extends T3, R> R apply(Lambda3<? super V1, ? super V2, ? super V3, ? extends R> lambda, Lambda3<? super V1, ? super V2, ? super V3, ? extends R> infiniteCase, V1 arg1, V2 arg2, V3 arg3, int threshold) {
        Lambda3<V1, V2, V3, R> toApply = this.contains(arg1, arg2, arg3, threshold) ? infiniteCase : lambda;
        this.push(arg1, arg2, arg3);
        try {
            R r = toApply.value(arg1, arg2, arg3);
            return r;
        }
        finally {
            this.pop(arg1, arg2, arg3);
        }
    }

    public static <T1, T2, T3> RecursionStack3<T1, T2, T3> make() {
        return new RecursionStack3<T1, T2, T3>();
    }

    public static <T1, T2, T3> RecursionStack3<T1, T2, T3> make(Lambda3<? super T1, ? super T2, ? super T3, ? extends Triple<T1, T2, T3>> tripleFactory) {
        return new RecursionStack3<T1, T2, T3>(tripleFactory);
    }
}

