/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.plt.recur;

import edu.rice.cs.plt.collect.HashMultiset;
import edu.rice.cs.plt.collect.Multiset;
import edu.rice.cs.plt.lambda.Lambda2;
import edu.rice.cs.plt.lambda.Runnable2;
import edu.rice.cs.plt.lambda.Thunk;
import edu.rice.cs.plt.tuple.IdentityPair;
import edu.rice.cs.plt.tuple.Pair;
import java.util.LinkedList;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RecursionStack2<T1, T2> {
    private final Lambda2<? super T1, ? super T2, ? extends Pair<T1, T2>> _pairFactory;
    private final Multiset<Pair<T1, T2>> _previous;
    private final LinkedList<Pair<T1, T2>> _stack;

    public RecursionStack2() {
        this(IdentityPair.factory());
    }

    public RecursionStack2(Lambda2<? super T1, ? super T2, ? extends Pair<T1, T2>> pairFactory) {
        this._pairFactory = pairFactory;
        this._previous = new HashMultiset<Pair<T1, T2>>();
        this._stack = new LinkedList();
    }

    public boolean contains(T1 arg1, T2 arg2) {
        return this._previous.contains(this._pairFactory.value(arg1, arg2));
    }

    public boolean contains(T1 arg1, T2 arg2, int threshold) {
        return this._previous.count(this._pairFactory.value(arg1, arg2)) >= threshold;
    }

    public void push(T1 arg1, T2 arg2) {
        Pair<T1, T2> wrapped = this._pairFactory.value(arg1, arg2);
        this._stack.addLast(wrapped);
        this._previous.add(wrapped);
    }

    public void pop(T1 arg1, T2 arg2) {
        Pair<T1, T2> wrapped = this._pairFactory.value(arg1, arg2);
        if (this._stack.isEmpty() || !this._stack.getLast().equals(wrapped)) {
            throw new IllegalArgumentException("given args are not on top of the stack");
        }
        this._stack.removeLast();
        this._previous.remove(wrapped);
    }

    public int size() {
        return this._stack.size();
    }

    public boolean isEmpty() {
        return this._stack.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(Runnable r, T1 arg1, T2 arg2) {
        if (!this.contains(arg1, arg2)) {
            this.push(arg1, arg2);
            try {
                r.run();
            }
            finally {
                this.pop(arg1, arg2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(Runnable r, T1 arg1, T2 arg2, int threshold) {
        if (!this.contains(arg1, arg2, threshold)) {
            this.push(arg1, arg2);
            try {
                r.run();
            }
            finally {
                this.pop(arg1, arg2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(Runnable r, Runnable infiniteCase, T1 arg1, T2 arg2) {
        Runnable toRun = this.contains(arg1, arg2) ? infiniteCase : r;
        this.push(arg1, arg2);
        try {
            toRun.run();
        }
        finally {
            this.pop(arg1, arg2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(Runnable r, Runnable infiniteCase, T1 arg1, T2 arg2, int threshold) {
        Runnable toRun = this.contains(arg1, arg2, threshold) ? infiniteCase : r;
        this.push(arg1, arg2);
        try {
            toRun.run();
        }
        finally {
            this.pop(arg1, arg2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V1 extends T1, V2 extends T2> void run(Runnable2<? super V1, ? super V2> r, V1 arg1, V2 arg2) {
        if (!this.contains(arg1, arg2)) {
            this.push(arg1, arg2);
            try {
                r.run(arg1, arg2);
            }
            finally {
                this.pop(arg1, arg2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V1 extends T1, V2 extends T2> void run(Runnable2<? super V1, ? super V2> r, V1 arg1, V2 arg2, int threshold) {
        if (!this.contains(arg1, arg2, threshold)) {
            this.push(arg1, arg2);
            try {
                r.run(arg1, arg2);
            }
            finally {
                this.pop(arg1, arg2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V1 extends T1, V2 extends T2> void run(Runnable2<? super V1, ? super V2> r, Runnable2<? super V1, ? super V2> infiniteCase, V1 arg1, V2 arg2) {
        Runnable2<V1, V2> toRun = this.contains(arg1, arg2) ? infiniteCase : r;
        this.push(arg1, arg2);
        try {
            toRun.run(arg1, arg2);
        }
        finally {
            this.pop(arg1, arg2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V1 extends T1, V2 extends T2> void run(Runnable2<? super V1, ? super V2> r, Runnable2<? super V1, ? super V2> infiniteCase, V1 arg1, V2 arg2, int threshold) {
        Runnable2<V1, V2> toRun = this.contains(arg1, arg2, threshold) ? infiniteCase : r;
        this.push(arg1, arg2);
        try {
            toRun.run(arg1, arg2);
        }
        finally {
            this.pop(arg1, arg2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R> R apply(Thunk<? extends R> thunk, R infiniteCase, T1 arg1, T2 arg2) {
        if (!this.contains(arg1, arg2)) {
            this.push(arg1, arg2);
            try {
                R r = thunk.value();
                return r;
            }
            finally {
                this.pop(arg1, arg2);
            }
        }
        return infiniteCase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R> R apply(Thunk<? extends R> thunk, R infiniteCase, T1 arg1, T2 arg2, int threshold) {
        if (!this.contains(arg1, arg2, threshold)) {
            this.push(arg1, arg2);
            try {
                R r = thunk.value();
                return r;
            }
            finally {
                this.pop(arg1, arg2);
            }
        }
        return infiniteCase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R> R apply(Thunk<? extends R> thunk, Thunk<? extends R> infiniteCase, T1 arg1, T2 arg2) {
        Thunk<R> toApply = this.contains(arg1, arg2) ? infiniteCase : thunk;
        this.push(arg1, arg2);
        try {
            R r = toApply.value();
            return r;
        }
        finally {
            this.pop(arg1, arg2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R> R apply(Thunk<? extends R> thunk, Thunk<? extends R> infiniteCase, T1 arg1, T2 arg2, int threshold) {
        Thunk<R> toApply = this.contains(arg1, arg2, threshold) ? infiniteCase : thunk;
        this.push(arg1, arg2);
        try {
            R r = toApply.value();
            return r;
        }
        finally {
            this.pop(arg1, arg2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V1 extends T1, V2 extends T2, R> R apply(Lambda2<? super V1, ? super V2, ? extends R> lambda, R infiniteCase, V1 arg1, V2 arg2) {
        if (!this.contains(arg1, arg2)) {
            this.push(arg1, arg2);
            try {
                R r = lambda.value(arg1, arg2);
                return r;
            }
            finally {
                this.pop(arg1, arg2);
            }
        }
        return infiniteCase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V1 extends T1, V2 extends T2, R> R apply(Lambda2<? super V1, ? super V2, ? extends R> lambda, R infiniteCase, V1 arg1, V2 arg2, int threshold) {
        if (!this.contains(arg1, arg2, threshold)) {
            this.push(arg1, arg2);
            try {
                R r = lambda.value(arg1, arg2);
                return r;
            }
            finally {
                this.pop(arg1, arg2);
            }
        }
        return infiniteCase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V1 extends T1, V2 extends T2, R> R apply(Lambda2<? super V1, ? super V2, ? extends R> lambda, Lambda2<? super V1, ? super V2, ? extends R> infiniteCase, V1 arg1, V2 arg2) {
        Lambda2<V1, V2, R> toApply = this.contains(arg1, arg2) ? infiniteCase : lambda;
        this.push(arg1, arg2);
        try {
            R r = toApply.value(arg1, arg2);
            return r;
        }
        finally {
            this.pop(arg1, arg2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V1 extends T1, V2 extends T2, R> R apply(Lambda2<? super V1, ? super V2, ? extends R> lambda, Lambda2<? super V1, ? super V2, ? extends R> infiniteCase, V1 arg1, V2 arg2, int threshold) {
        Lambda2<V1, V2, R> toApply = this.contains(arg1, arg2, threshold) ? infiniteCase : lambda;
        this.push(arg1, arg2);
        try {
            R r = toApply.value(arg1, arg2);
            return r;
        }
        finally {
            this.pop(arg1, arg2);
        }
    }

    public static <T1, T2> RecursionStack2<T1, T2> make() {
        return new RecursionStack2<T1, T2>();
    }

    public static <T1, T2> RecursionStack2<T1, T2> make(Lambda2<? super T1, ? super T2, ? extends Pair<T1, T2>> pairFactory) {
        return new RecursionStack2<T1, T2>(pairFactory);
    }
}

