/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.plt.io;

import com.rc.retroweaver.runtime.Autobox;
import com.rc.retroweaver.runtime.IterableMethods;
import com.rc.retroweaver.runtime.Iterable_;
import edu.rice.cs.plt.io.WrappedDirectInputStream;
import edu.rice.cs.plt.io.WrappedDirectReader;
import edu.rice.cs.plt.iter.AbstractIterable;
import edu.rice.cs.plt.iter.IterUtil;
import edu.rice.cs.plt.iter.SnapshotIterable;
import edu.rice.cs.plt.lambda.Lambda;
import edu.rice.cs.plt.lambda.Predicate;
import edu.rice.cs.plt.lambda.Thunk;
import edu.rice.cs.plt.lambda.WrappedException;
import edu.rice.cs.plt.recur.RecursionStack;
import edu.rice.cs.plt.tuple.Wrapper;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IOUtil {
    private static final Lambda<File, File> GET_ABSOLUTE_FILE = new Lambda<File, File>(){

        @Override
        public File value(File arg) {
            return arg.getAbsoluteFile();
        }

        @Override
        public Object value(Object x0) {
            return this.value((File)x0);
        }
    };
    private static final Lambda<File, File> ATTEMPT_ABSOLUTE_FILE = new Lambda<File, File>(){

        @Override
        public File value(File arg) {
            return IOUtil.attemptAbsoluteFile(arg);
        }

        @Override
        public Object value(Object x0) {
            return this.value((File)x0);
        }
    };
    private static final Lambda<File, File> GET_CANONICAL_FILE = new Lambda<File, File>(){

        @Override
        public File value(File arg) {
            try {
                return arg.getCanonicalFile();
            }
            catch (IOException e) {
                throw new WrappedException(e);
            }
        }

        @Override
        public Object value(Object x0) {
            return this.value((File)x0);
        }
    };
    private static final Lambda<File, File> ATTEMPT_CANONICAL_FILE = new Lambda<File, File>(){

        @Override
        public File value(File arg) {
            return IOUtil.attemptAbsoluteFile(arg);
        }

        @Override
        public Object value(Object x0) {
            return this.value((File)x0);
        }
    };
    private static final Lambda<File, File> CANONICAL_CASE = new Lambda<File, File>(){

        @Override
        public File value(File arg) {
            return IOUtil.canonicalCase(arg);
        }

        @Override
        public Object value(Object x0) {
            return this.value((File)x0);
        }
    };
    private static final Lambda<String, File> STRING_TO_FILE = new Lambda<String, File>(){

        @Override
        public File value(String arg) {
            return new File(arg);
        }

        @Override
        public Object value(Object x0) {
            return this.value((String)x0);
        }
    };
    public static final Predicate<File> IS_FILE = new Predicate<File>(){

        @Override
        public Boolean value(File f) {
            return Autobox.valueOf(f.isFile());
        }

        @Override
        public Boolean value(Object x0) {
            return this.value((File)x0);
        }

        @Override
        public Object value(Object x0) {
            return this.value((File)x0);
        }
    };
    public static final Predicate<File> IS_DIRECTORY = new Predicate<File>(){

        @Override
        public Boolean value(File f) {
            return Autobox.valueOf(f.isDirectory());
        }

        @Override
        public Boolean value(Object x0) {
            return this.value((File)x0);
        }

        @Override
        public Object value(Object x0) {
            return this.value((File)x0);
        }
    };
    public static final FileFilter ALWAYS_ACCEPT = IOUtil.predicateFileFilter(Predicate.TRUE);
    public static final FileFilter ALWAYS_REJECT = IOUtil.predicateFileFilter(Predicate.FALSE);
    public static final FileFilter ACCEPT_FILES = IOUtil.predicateFileFilter(IS_FILE);
    public static final FileFilter ACCEPT_DIRECTORIES = IOUtil.predicateFileFilter(IS_DIRECTORY);

    private IOUtil() {
    }

    public static File attemptAbsoluteFile(File f) {
        try {
            return f.getAbsoluteFile();
        }
        catch (SecurityException e) {
            return f;
        }
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    public static Iterable_ getAbsoluteFiles(Iterable_ files) {
        return IterUtil.mapSnapshot(files, GET_ABSOLUTE_FILE);
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    public static Iterable_ attemptAbsoluteFiles(Iterable_ files) {
        return IterUtil.mapSnapshot(files, ATTEMPT_ABSOLUTE_FILE);
    }

    public static File attemptCanonicalFile(File f) {
        try {
            return f.getCanonicalFile();
        }
        catch (IOException e) {
            return IOUtil.attemptAbsoluteFile(f);
        }
        catch (SecurityException e) {
            return IOUtil.attemptAbsoluteFile(f);
        }
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    public static Iterable_ getCanonicalFiles(Iterable_ files) throws IOException {
        try {
            return IterUtil.mapSnapshot(files, GET_CANONICAL_FILE);
        }
        catch (WrappedException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw e;
        }
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    public static Iterable_ attemptCanonicalFiles(Iterable_ files) {
        return IterUtil.mapSnapshot(files, ATTEMPT_CANONICAL_FILE);
    }

    public static boolean attemptCanRead(File f) {
        try {
            return f.canRead();
        }
        catch (SecurityException e) {
            return false;
        }
    }

    public static boolean attemptCanWrite(File f) {
        try {
            return f.canWrite();
        }
        catch (SecurityException e) {
            return false;
        }
    }

    public static boolean attemptExists(File f) {
        try {
            return f.exists();
        }
        catch (SecurityException e) {
            return false;
        }
    }

    public static boolean attemptIsDirectory(File f) {
        try {
            return f.isDirectory();
        }
        catch (SecurityException e) {
            return false;
        }
    }

    public static boolean attemptIsFile(File f) {
        try {
            return f.isFile();
        }
        catch (SecurityException e) {
            return false;
        }
    }

    public static boolean attemptIsHidden(File f) {
        try {
            return f.isHidden();
        }
        catch (SecurityException e) {
            return false;
        }
    }

    public static long attemptLastModified(File f) {
        try {
            return f.lastModified();
        }
        catch (SecurityException e) {
            return 0L;
        }
    }

    public static long attemptLength(File f) {
        try {
            return f.length();
        }
        catch (SecurityException e) {
            return 0L;
        }
    }

    public static boolean attemptCreateNewFile(File f) {
        try {
            return f.createNewFile();
        }
        catch (IOException e) {
            return false;
        }
        catch (SecurityException e) {
            return false;
        }
    }

    public static boolean attemptDelete(File f) {
        try {
            return f.delete();
        }
        catch (SecurityException e) {
            return false;
        }
    }

    public static void attemptDeleteOnExit(File f) {
        try {
            f.deleteOnExit();
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    public static File[] attemptListFiles(File f) {
        try {
            return f.listFiles();
        }
        catch (SecurityException e) {
            return null;
        }
    }

    public static File[] attemptListFiles(File f, FileFilter filter) {
        try {
            return f.listFiles(filter);
        }
        catch (SecurityException e) {
            return null;
        }
    }

    public static Iterable<File> attemptListFilesAsIterable(File f) {
        File[] result = IOUtil.attemptListFiles(f);
        if (result == null) {
            return IterUtil.empty();
        }
        return IterUtil.arrayIterable(result);
    }

    public static Iterable<File> attemptListFilesAsIterable(File f, FileFilter filter) {
        File[] result = IOUtil.attemptListFiles(f, filter);
        if (result == null) {
            return IterUtil.empty();
        }
        return IterUtil.arrayIterable(result);
    }

    public static boolean attemptMkdir(File f) {
        try {
            return f.mkdir();
        }
        catch (SecurityException e) {
            return false;
        }
    }

    public static boolean attemptMkdirs(File f) {
        try {
            return f.mkdirs();
        }
        catch (SecurityException e) {
            return false;
        }
    }

    public static boolean attemptRenameTo(File f, File dest) {
        try {
            return f.renameTo(dest);
        }
        catch (SecurityException e) {
            return false;
        }
    }

    public static boolean attemptMove(File f, File dest) {
        IOUtil.attemptDelete(dest);
        return IOUtil.attemptRenameTo(f, dest);
    }

    public static boolean attemptSetLastModified(File f, long time) {
        try {
            return f.setLastModified(time);
        }
        catch (SecurityException e) {
            return false;
        }
    }

    public static boolean attemptSetReadOnly(File f) {
        try {
            return f.setReadOnly();
        }
        catch (SecurityException e) {
            return false;
        }
    }

    public static File canonicalCase(File f) {
        File lowered = new File(f.getPath().toLowerCase());
        if (f.equals(lowered)) {
            return lowered;
        }
        return f;
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    public static Iterable_ canonicalCases(Iterable_ files) {
        return IterUtil.mapSnapshot(files, CANONICAL_CASE);
    }

    public static boolean isMember(File f, File ancestor) {
        for (File parent = f; parent != null; parent = parent.getParentFile()) {
            if (!parent.equals(ancestor)) continue;
            return true;
        }
        return false;
    }

    public static Iterable<File> fullPath(File f) {
        AbstractIterable result = IterUtil.singleton(f);
        for (File parent = f.getParentFile(); parent != null; parent = parent.getParentFile()) {
            result = IterUtil.compose(parent, result);
        }
        return result;
    }

    public static boolean deleteRecursively(File f) {
        return IOUtil.deleteRecursively(f, new RecursionStack<File>(Wrapper.factory()));
    }

    private static boolean deleteRecursively(File f, final RecursionStack<File> stack) {
        if (f.isDirectory()) {
            try {
                final File canonicalF = f.getCanonicalFile();
                Runnable deleteMembers = new Runnable(){

                    public void run() {
                        Iterator i$ = IterableMethods.iterator(IOUtil.attemptListFilesAsIterable((File)canonicalF));
                        while (i$.hasNext()) {
                            File child = (File)i$.next();
                            IOUtil.access$000(child, stack);
                        }
                    }
                };
                stack.run(deleteMembers, canonicalF);
            }
            catch (IOException e) {
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        return IOUtil.attemptDelete(f);
    }

    public static void deleteOnExitRecursively(File f) {
        IOUtil.deleteOnExitRecursively(f, new RecursionStack<File>(Wrapper.factory()));
    }

    private static void deleteOnExitRecursively(File f, final RecursionStack<File> stack) {
        IOUtil.attemptDeleteOnExit(f);
        if (f.isDirectory()) {
            try {
                final File canonicalF = f.getCanonicalFile();
                Runnable markMembers = new Runnable(){

                    public void run() {
                        Iterator i$ = IterableMethods.iterator(IOUtil.attemptListFilesAsIterable((File)canonicalF));
                        while (i$.hasNext()) {
                            File child = (File)i$.next();
                            IOUtil.access$100(child, stack);
                        }
                    }
                };
                stack.run(markMembers, canonicalF);
            }
            catch (IOException e) {
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
    }

    public static Iterable<File> listFilesRecursively(File f) {
        return IOUtil.listFilesRecursively((File)f, (FileFilter)ALWAYS_ACCEPT, (FileFilter)ALWAYS_ACCEPT);
    }

    public static Iterable<File> listFilesRecursively(File f, FileFilter filter) {
        return IOUtil.listFilesRecursively((File)f, (FileFilter)filter, (FileFilter)ALWAYS_ACCEPT);
    }

    public static Iterable<File> listFilesRecursively(File f, FileFilter filter, FileFilter recursionFilter) {
        return IOUtil.listFilesRecursively((File)f, (FileFilter)filter, (FileFilter)recursionFilter, new RecursionStack(Wrapper.factory()));
    }

    private static Iterable<File> listFilesRecursively(File f, final FileFilter filter, final FileFilter recursionFilter, final RecursionStack<File> stack) {
        AbstractIterable result;
        AbstractIterable abstractIterable = result = filter.accept(f) ? IterUtil.singleton(f) : IterUtil.empty();
        if (f.isDirectory() && recursionFilter.accept(f)) {
            try {
                final File canonicalF = f.getCanonicalFile();
                Thunk<Iterable<File>> getMembers = new Thunk<Iterable<File>>(){

                    @Override
                    public Iterable<File> value() {
                        AbstractIterable dirFiles = IterUtil.empty();
                        Iterator i$ = IterableMethods.iterator(IOUtil.attemptListFilesAsIterable((File)canonicalF));
                        while (i$.hasNext()) {
                            File child = (File)i$.next();
                            dirFiles = IterUtil.compose(dirFiles, IOUtil.access$200(child, filter, recursionFilter, stack));
                        }
                        return dirFiles;
                    }

                    @Override
                    public Object value() {
                        return this.value();
                    }
                };
                result = IterUtil.compose(result, (Iterable_)((Object)stack.apply(getMembers, IterUtil.empty(), canonicalF)));
            }
            catch (IOException e) {
            }
            catch (SecurityException e) {
                // empty catch block
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StringBuffer toStringBuffer(File file) throws IOException {
        FileReader reader = new FileReader(file);
        try {
            StringBuffer stringBuffer = IOUtil.toStringBuffer(reader);
            return stringBuffer;
        }
        finally {
            reader.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toString(File file) throws IOException {
        FileReader reader = new FileReader(file);
        try {
            String string = IOUtil.toString(reader);
            return string;
        }
        finally {
            reader.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File source, File dest) throws IOException {
        FileInputStream in = new FileInputStream(source);
        try {
            FileOutputStream out = new FileOutputStream(dest);
            try {
                IOUtil.copyInputStream(in, out);
            }
            finally {
                out.close();
            }
        }
        finally {
            in.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File source, File dest, byte[] buffer) throws IOException {
        FileInputStream in = new FileInputStream(source);
        try {
            FileOutputStream out = new FileOutputStream(dest);
            try {
                IOUtil.copyInputStream(in, out, buffer);
            }
            finally {
                out.close();
            }
        }
        finally {
            in.close();
        }
    }

    public static void writeStringToFile(File file, String text) throws IOException {
        IOUtil.writeStringToFile(file, text, false);
    }

    public static boolean attemptWriteStringToFile(File file, String text) {
        try {
            IOUtil.writeStringToFile(file, text);
            return true;
        }
        catch (IOException e) {
            return false;
        }
        catch (SecurityException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeStringToFile(File file, String text, boolean append) throws IOException {
        FileWriter writer = new FileWriter(file, append);
        try {
            writer.write(text);
        }
        finally {
            writer.close();
        }
    }

    public static boolean attemptWriteStringToFile(File file, String text, boolean append) {
        try {
            IOUtil.writeStringToFile(file, text, append);
            return true;
        }
        catch (IOException e) {
            return false;
        }
        catch (SecurityException e) {
            return false;
        }
    }

    public static File createAndMarkTempFile(String prefix, String suffix) throws IOException {
        return IOUtil.createAndMarkTempFile(prefix, suffix, null);
    }

    public static File createAndMarkTempFile(String prefix, String suffix, File location) throws IOException {
        File result = File.createTempFile(prefix, suffix, location);
        IOUtil.attemptDeleteOnExit(result);
        return result;
    }

    public static File createAndMarkTempDirectory(String prefix, String suffix) throws IOException {
        return IOUtil.createAndMarkTempDirectory(prefix, suffix, null);
    }

    public static File createAndMarkTempDirectory(String prefix, String suffix, File location) throws IOException {
        File result = File.createTempFile(prefix, suffix, location);
        boolean success = result.delete();
        boolean bl = success = success && result.mkdir();
        if (!success) {
            throw new IOException("Attempt to create directory failed");
        }
        IOUtil.attemptDeleteOnExit(result);
        return result;
    }

    public static Iterable<File> parsePath(String path) {
        StringTokenizer tokenizer = new StringTokenizer(path, File.pathSeparator);
        SnapshotIterable<String> filenames = IterUtil.snapshot(IterUtil.asIterator(tokenizer));
        return IterUtil.map(filenames, STRING_TO_FILE);
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    public static String pathToString(Iterable_ path) {
        return IterUtil.toString(path, "", File.pathSeparator, "");
    }

    public static int copyReader(Reader source, Writer dest) throws IOException {
        return WrappedDirectReader.makeDirect(source).readAll(dest);
    }

    public static int copyReader(Reader source, Writer dest, char[] buffer) throws IOException {
        return WrappedDirectReader.makeDirect(source).readAll(dest, buffer);
    }

    public static int writeFromReader(Reader source, Writer dest, int chars) throws IOException {
        return WrappedDirectReader.makeDirect(source).read(dest, chars);
    }

    public static int writeFromReader(Reader source, Writer dest, int chars, char[] buffer) throws IOException {
        return WrappedDirectReader.makeDirect(source).read(dest, chars, buffer);
    }

    public static int copyInputStream(InputStream source, OutputStream dest) throws IOException {
        return WrappedDirectInputStream.makeDirect(source).readAll(dest);
    }

    public static int copyInputStream(InputStream source, OutputStream dest, byte[] buffer) throws IOException {
        return WrappedDirectInputStream.makeDirect(source).readAll(dest, buffer);
    }

    public static int writeFromInputStream(InputStream source, OutputStream dest, int bytes) throws IOException {
        return WrappedDirectInputStream.makeDirect(source).read(dest, bytes);
    }

    public static int writeFromInputStream(InputStream source, OutputStream dest, int bytes, byte[] buffer) throws IOException {
        return WrappedDirectInputStream.makeDirect(source).read(dest, bytes, buffer);
    }

    protected static int doCopyReader(Reader r, Writer w, char[] buffer) throws IOException {
        if (buffer.length == 0) {
            throw new IllegalArgumentException();
        }
        int charsRead = r.read(buffer);
        if (charsRead == -1) {
            return -1;
        }
        int totalCharsRead = 0;
        do {
            if ((totalCharsRead += charsRead) < 0) {
                totalCharsRead = Integer.MAX_VALUE;
            }
            w.write(buffer, 0, charsRead);
        } while ((charsRead = r.read(buffer)) != -1);
        return totalCharsRead;
    }

    protected static int doCopyInputStream(InputStream in, OutputStream out, byte[] buffer) throws IOException {
        if (buffer.length == 0) {
            throw new IllegalArgumentException();
        }
        int charsRead = in.read(buffer);
        if (charsRead == -1) {
            return -1;
        }
        int totalCharsRead = 0;
        do {
            if ((totalCharsRead += charsRead) < 0) {
                totalCharsRead = Integer.MAX_VALUE;
            }
            out.write(buffer, 0, charsRead);
        } while ((charsRead = in.read(buffer)) != -1);
        return totalCharsRead;
    }

    protected static int doWriteFromReader(Reader r, Writer w, int chars, char[] buffer) throws IOException {
        if (buffer.length == 0 && chars > 0) {
            throw new IllegalArgumentException();
        }
        int charsRead = r.read(buffer, 0, chars < buffer.length ? chars : buffer.length);
        if (charsRead == -1) {
            return -1;
        }
        int totalCharsRead = 0;
        while (chars > 0 && charsRead > 0) {
            totalCharsRead += charsRead;
            w.write(buffer, 0, charsRead);
            if ((chars -= charsRead) <= 0) continue;
            charsRead = r.read(buffer, 0, chars < buffer.length ? chars : buffer.length);
        }
        return totalCharsRead;
    }

    protected static int doWriteFromInputStream(InputStream in, OutputStream out, int bytes, byte[] buffer) throws IOException {
        if (buffer.length == 0 && bytes > 0) {
            throw new IllegalArgumentException();
        }
        int bytesRead = in.read(buffer, 0, bytes < buffer.length ? bytes : buffer.length);
        if (bytesRead == -1) {
            return -1;
        }
        int totalBytesRead = 0;
        while (bytes > 0 && bytesRead > 0) {
            totalBytesRead += bytesRead;
            out.write(buffer, 0, bytesRead);
            if ((bytes -= bytesRead) <= 0) continue;
            bytesRead = in.read(buffer, 0, bytes < buffer.length ? bytes : buffer.length);
        }
        return totalBytesRead;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] toByteArray(InputStream stream) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            IOUtil.copyInputStream(stream, out);
            byte[] byArray = out.toByteArray();
            return byArray;
        }
        finally {
            out.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StringBuffer toStringBuffer(Reader r) throws IOException {
        StringWriter out = new StringWriter();
        try {
            IOUtil.copyReader(r, out);
            StringBuffer stringBuffer = out.getBuffer();
            return stringBuffer;
        }
        finally {
            out.close();
        }
    }

    public static String toString(Reader r) throws IOException {
        return IOUtil.toStringBuffer(r).toString();
    }

    public static FileFilter predicateFileFilter(final Predicate<? super File> p) {
        return new FileFilter(){

            public boolean accept(File f) {
                return p.value(f);
            }
        };
    }

    public static Predicate<File> fileFilterPredicate(final FileFilter filter) {
        return new Predicate<File>(){

            @Override
            public Boolean value(File f) {
                return Autobox.valueOf(filter.accept(f));
            }

            @Override
            public Boolean value(Object x0) {
                return this.value((File)x0);
            }

            @Override
            public Object value(Object x0) {
                return this.value((File)x0);
            }
        };
    }

    public static javax.swing.filechooser.FileFilter swingFileFilter(final FileFilter filter, final String description) {
        return new javax.swing.filechooser.FileFilter(){

            public boolean accept(File f) {
                return filter.accept(f);
            }

            public String getDescription() {
                return description;
            }
        };
    }

    public static FileFilter regexpFileFilter(String regexp) {
        return IOUtil.predicateFileFilter(IOUtil.regexpFilePredicate(regexp));
    }

    public static Predicate<File> regexpFilePredicate(final String regexp) {
        return new Predicate<File>(){

            @Override
            public Boolean value(File f) {
                return Autobox.valueOf(f.getName().matches(regexp));
            }

            @Override
            public Boolean value(Object x0) {
                return this.value((File)x0);
            }

            @Override
            public Object value(Object x0) {
                return this.value((File)x0);
            }
        };
    }

    public static FileFilter regexpCanonicalCaseFileFilter(String regexp) {
        return IOUtil.predicateFileFilter(IOUtil.regexpCanonicalCaseFilePredicate(regexp));
    }

    public static Predicate<File> regexpCanonicalCaseFilePredicate(final String regexp) {
        return new Predicate<File>(){

            @Override
            public Boolean value(File f) {
                return Autobox.valueOf(IOUtil.canonicalCase(f).getName().matches(regexp));
            }

            @Override
            public Boolean value(Object x0) {
                return this.value((File)x0);
            }

            @Override
            public Object value(Object x0) {
                return this.value((File)x0);
            }
        };
    }

    public static FileFilter extensionFileFilter(String extension) {
        return IOUtil.predicateFileFilter(IOUtil.extensionFilePredicate(extension));
    }

    public static Predicate<File> extensionFilePredicate(String extension) {
        extension = IOUtil.canonicalCase(new File(extension)).getName();
        final String suffix = new StringBuffer().append(".").append(extension).toString();
        return new Predicate<File>(){

            @Override
            public Boolean value(File f) {
                return Autobox.valueOf(IOUtil.canonicalCase(f).getName().endsWith(suffix));
            }

            @Override
            public Boolean value(Object x0) {
                return this.value((File)x0);
            }

            @Override
            public Object value(Object x0) {
                return this.value((File)x0);
            }
        };
    }

    static boolean access$000(File x0, RecursionStack x1) {
        return IOUtil.deleteRecursively(x0, x1);
    }

    static void access$100(File x0, RecursionStack x1) {
        IOUtil.deleteOnExitRecursively(x0, x1);
    }

    static Iterable_ access$200(File x0, FileFilter x1, FileFilter x2, RecursionStack x3) {
        return IOUtil.listFilesRecursively((File)x0, (FileFilter)x1, (FileFilter)x2, (RecursionStack)x3);
    }
}

