/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.plt.collect;

import com.rc.retroweaver.runtime.Iterable_;
import edu.rice.cs.plt.collect.ExternallySortedSet;
import edu.rice.cs.plt.iter.ComposedIterator;
import edu.rice.cs.plt.iter.EmptyIterator;
import edu.rice.cs.plt.iter.ImmutableIterable;
import edu.rice.cs.plt.iter.ImmutableIterator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExternallySortedMultiMap<K, V, C extends Comparable<? super C>> {
    private final Map<K, ExternallySortedSet<V, C>> _map;
    private int _size = 0;
    private final Iterator<V> _emptyIterator = new EmptyIterator<V>();

    public ExternallySortedMultiMap() {
        this._map = new HashMap<K, ExternallySortedSet<V, C>>();
    }

    public int size() {
        return this._size;
    }

    public boolean isEmpty() {
        return this._size == 0;
    }

    public boolean containsKey(K key) {
        return this._map.containsKey(key);
    }

    public boolean containsValue(V value) {
        for (ExternallySortedSet<V, C> set : this._map.values()) {
            if (!set.contains(value)) continue;
            return true;
        }
        return false;
    }

    public boolean contains(K key, V value) {
        ExternallySortedSet<V, C> set = this._map.get(key);
        return set != null && set.contains(value);
    }

    public Iterable<V> get(final K key) {
        return new Iterable<V>(){

            @Override
            public Iterator<V> iterator() {
                ExternallySortedSet set = (ExternallySortedSet)ExternallySortedMultiMap.access$000(ExternallySortedMultiMap.this).get(key);
                if (set == null) {
                    return ExternallySortedMultiMap.access$100(ExternallySortedMultiMap.this);
                }
                return new ImmutableIterator(set.iterator());
            }
        };
    }

    public boolean put(K key, V value, C orderBy) {
        ExternallySortedSet<Object, C> set = this._map.get(key);
        if (set == null) {
            set = new ExternallySortedSet();
            this._map.put(key, set);
        }
        if (set.add(value, orderBy)) {
            ++this._size;
            return true;
        }
        return false;
    }

    public boolean remove(K key, V value) {
        ExternallySortedSet<V, C> set = this._map.get(key);
        if (set == null) {
            return false;
        }
        if (set.remove(value)) {
            --this._size;
            if (set.isEmpty()) {
                this._map.remove(key);
            }
        } else {
            return false;
        }
        return true;
    }

    public boolean removeKey(K key) {
        ExternallySortedSet<V, C> set = this._map.get(key);
        if (set == null) {
            return false;
        }
        this._map.remove(key);
        this._size -= set.size();
        return true;
    }

    public boolean putAll(ExternallySortedMultiMap<? extends K, ? extends V, ? extends C> map) {
        boolean result = false;
        for (Map.Entry<K, ExternallySortedSet<V, C>> e : map._map.entrySet()) {
            ExternallySortedSet<Object, C> set = this._map.get(e.getKey());
            if (set == null) {
                set = new ExternallySortedSet();
                this._map.put(e.getKey(), set);
            }
            this._size -= set.size();
            K k = e.getKey();
            ExternallySortedSet<V, C> s = e.getValue();
            boolean newResult = set.addAll(s);
            result |= newResult;
            this._size += set.size();
        }
        return result;
    }

    public void clear() {
        this._map.clear();
        this._size = 0;
    }

    public Iterable<K> keys() {
        return new ImmutableIterable((Iterable_)((Object)this._map.keySet()));
    }

    public Iterable<V> values() {
        return new Iterable<V>(){

            @Override
            public Iterator<V> iterator() {
                ComposedIterator result = ExternallySortedMultiMap.access$100(ExternallySortedMultiMap.this);
                for (ExternallySortedSet set : ExternallySortedMultiMap.access$000(ExternallySortedMultiMap.this).values()) {
                    result = new ComposedIterator(set.iterator(), result);
                }
                return new ImmutableIterator(result);
            }
        };
    }

    static Map access$000(ExternallySortedMultiMap x0) {
        return x0._map;
    }

    static Iterator access$100(ExternallySortedMultiMap x0) {
        return x0._emptyIterator;
    }
}

