/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.plt.collect;

import edu.rice.cs.plt.collect.ConsVisitor;
import edu.rice.cs.plt.iter.AbstractIterable;
import edu.rice.cs.plt.iter.EmptyIterator;
import edu.rice.cs.plt.iter.ReadOnlyIterator;
import edu.rice.cs.plt.iter.SizedIterable;
import edu.rice.cs.plt.lambda.Lambda;
import edu.rice.cs.plt.lambda.Predicate;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ConsList<T>
extends AbstractIterable<T>
implements SizedIterable<T> {
    public abstract <Ret> Ret apply(ConsVisitor<? super T, ? extends Ret> var1);

    @Override
    public abstract Iterator<T> iterator();

    @Override
    public abstract int size();

    @Override
    public boolean isFixed() {
        return true;
    }

    public static <T> Empty<T> empty() {
        return Empty.make();
    }

    public static <T> Nonempty<T> cons(T first, ConsList<? extends T> rest) {
        return new Nonempty<T>(first, rest);
    }

    public static <T> Nonempty<T> singleton(T value) {
        return new Nonempty<T>(value, Empty.make());
    }

    public static boolean isEmpty(ConsList<?> list) {
        return list.apply(ConsVisitor.IS_EMPTY);
    }

    public static <T> ConsList<? extends T> reverse(ConsList<? extends T> list) {
        return list.apply(ConsVisitor.reverse());
    }

    public static <T> ConsList<? extends T> append(ConsList<? extends T> l1, ConsList<? extends T> l2) {
        return l1.apply(ConsVisitor.append(l2));
    }

    public static <T> ConsList<? extends T> filter(ConsList<? extends T> list, Predicate<? super T> pred) {
        return list.apply(ConsVisitor.filter(pred));
    }

    public static <S, T> ConsList<? extends T> map(ConsList<? extends S> list, Lambda<? super S, ? extends T> lambda) {
        return list.apply(ConsVisitor.map(lambda));
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Nonempty<T>
    extends ConsList<T> {
        private T _first;
        private ConsList<? extends T> _rest;

        public Nonempty(T first, ConsList<? extends T> rest) {
            this._first = first;
            this._rest = rest;
        }

        public T first() {
            return this._first;
        }

        public ConsList<? extends T> rest() {
            return this._rest;
        }

        @Override
        public <Ret> Ret apply(ConsVisitor<? super T, ? extends Ret> visitor) {
            return visitor.forNonempty(this);
        }

        @Override
        public Iterator<T> iterator() {
            return new ReadOnlyIterator<T>(){
                private ConsList<? extends T> _current;
                {
                    this._current = Nonempty.this;
                }

                @Override
                public boolean hasNext() {
                    return this._current.apply(ConsVisitor.IS_EMPTY) == false;
                }

                @Override
                public T next() {
                    return this._current.apply(new ConsVisitor<T, T>(){

                        @Override
                        public T forEmpty(Empty<? extends T> list) {
                            throw new NoSuchElementException();
                        }

                        @Override
                        public T forNonempty(Nonempty<? extends T> list) {
                            1.access$002(this, list.rest());
                            return list.first();
                        }
                    });
                }

                static ConsList access$002(1 x0, ConsList x1) {
                    x0._current = x1;
                    return x0._current;
                }
            };
        }

        @Override
        public int size() {
            return 1 + this._rest.size();
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Empty<T>
    extends ConsList<T> {
        private static final Empty<?> INSTANCE = new Empty();

        private Empty() {
        }

        public static <T> Empty<T> make() {
            return INSTANCE;
        }

        @Override
        public <Ret> Ret apply(ConsVisitor<? super T, ? extends Ret> visitor) {
            return visitor.forEmpty(this);
        }

        @Override
        public EmptyIterator<T> iterator() {
            return EmptyIterator.make();
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public Iterator iterator() {
            return this.iterator();
        }
    }
}

