/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.javalanglevels.tree;

import edu.rice.cs.javalanglevels.SourceInfo;
import edu.rice.cs.javalanglevels.tree.JExpression;
import edu.rice.cs.javalanglevels.tree.JExpressionIFVisitor;
import edu.rice.cs.javalanglevels.tree.JExpressionIFVisitor_void;
import edu.rice.cs.javalanglevels.tree.TabPrintWriter;
import edu.rice.cs.javalanglevels.tree.Word;
import java.io.StringWriter;
import java.io.Writer;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompoundWord
extends JExpression {
    private final Word[] _words;

    public CompoundWord(SourceInfo in_sourceInfo, Word[] in_words) {
        super(in_sourceInfo);
        if (in_words == null) {
            throw new IllegalArgumentException("Parameter 'words' to the CompoundWord constructor was null. This class may not have null field values.");
        }
        this._words = in_words;
    }

    public final Word[] getWords() {
        return this._words;
    }

    @Override
    public <RetType> RetType visit(JExpressionIFVisitor<RetType> visitor) {
        return visitor.forCompoundWord(this);
    }

    @Override
    public void visit(JExpressionIFVisitor_void visitor) {
        visitor.forCompoundWord(this);
    }

    public String toString() {
        StringWriter w = new StringWriter();
        this.output(w);
        return w.toString();
    }

    public void output(Writer writer) {
        this.outputHelp(new TabPrintWriter(writer, 2));
    }

    @Override
    public void outputHelp(TabPrintWriter writer) {
        writer.print("CompoundWord:");
        writer.indent();
        writer.startLine("");
        writer.print("sourceInfo = ");
        SourceInfo temp_sourceInfo = this.getSourceInfo();
        if (temp_sourceInfo == null) {
            writer.print("null");
        } else {
            writer.print(temp_sourceInfo);
        }
        writer.startLine("");
        writer.print("words = ");
        writer.print("{");
        writer.indent();
        for (int i = 0; i < this.getWords().length; ++i) {
            Word temp_words = this.getWords()[i];
            writer.startLine(new StringBuffer().append("#").append(i).append(": ").toString());
            if (temp_words == null) {
                writer.print("null");
                continue;
            }
            temp_words.outputHelp(writer);
        }
        writer.unindent();
        if (this.getWords().length > 0) {
            writer.startLine("");
        }
        writer.print("}");
        writer.unindent();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass() || obj.hashCode() != this.hashCode()) {
            return false;
        }
        CompoundWord casted = (CompoundWord)obj;
        if (this.getWords().length != casted.getWords().length) {
            return false;
        }
        for (int i = 0; i < this.getWords().length; ++i) {
            if (this.getWords()[i].equals(casted.getWords()[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    protected int generateHashCode() {
        int code = this.getClass().hashCode();
        code ^= 0;
        for (int i = 0; i < this.getWords().length; ++i) {
            code ^= this.getWords()[i].hashCode();
        }
        return code;
    }
}

