/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.javalanglevels;

import edu.rice.cs.javalanglevels.BodyData;
import edu.rice.cs.javalanglevels.BodyTypeChecker;
import edu.rice.cs.javalanglevels.ExpressionTypeChecker;
import edu.rice.cs.javalanglevels.InstanceData;
import edu.rice.cs.javalanglevels.LanguageLevelVisitor;
import edu.rice.cs.javalanglevels.MethodData;
import edu.rice.cs.javalanglevels.Pair;
import edu.rice.cs.javalanglevels.SymbolData;
import edu.rice.cs.javalanglevels.TypeData;
import edu.rice.cs.javalanglevels.VariableData;
import edu.rice.cs.javalanglevels.tree.BracedBody;
import edu.rice.cs.javalanglevels.tree.ComplexSuperConstructorInvocation;
import edu.rice.cs.javalanglevels.tree.ComplexThisConstructorInvocation;
import edu.rice.cs.javalanglevels.tree.Expression;
import edu.rice.cs.javalanglevels.tree.ExpressionStatement;
import edu.rice.cs.javalanglevels.tree.JExpression;
import edu.rice.cs.javalanglevels.tree.SimpleSuperConstructorInvocation;
import edu.rice.cs.javalanglevels.tree.SimpleThisConstructorInvocation;
import edu.rice.cs.javalanglevels.tree.ValueReturnStatement;
import edu.rice.cs.javalanglevels.tree.VoidReturnStatement;
import java.io.File;
import java.util.LinkedList;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstructorBodyTypeChecker
extends BodyTypeChecker {
    public ConstructorBodyTypeChecker(BodyData bodyData, File file, String packageName, LinkedList<String> importedFiles, LinkedList<String> importedPackages, LinkedList<VariableData> vars, LinkedList<Pair<SymbolData, JExpression>> thrown) {
        super(bodyData, file, packageName, importedFiles, importedPackages, vars, thrown);
    }

    @Override
    protected BodyTypeChecker createANewInstanceOfMe(BodyData bodyData, File file, String pakage, LinkedList<String> importedFiles, LinkedList<String> importedPackages, LinkedList<VariableData> vars, LinkedList<Pair<SymbolData, JExpression>> thrown) {
        return new ConstructorBodyTypeChecker(bodyData, file, pakage, importedFiles, importedPackages, vars, thrown);
    }

    public TypeData simpleThisConstructorInvocationAllowed(SimpleThisConstructorInvocation that) {
        String name = LanguageLevelVisitor.getUnqualifiedClassName(this._data.getSymbolData().getName());
        InstanceData[] args = this.getArgTypesForInvocation(that.getArguments());
        if (args == null) {
            return null;
        }
        MethodData cd = this._lookupMethod(name, this._data.getSymbolData(), args, that, new StringBuffer().append("No constructor found in class ").append(this._data.getSymbolData().getName()).append(" with signature: ").toString(), true, this._data.getSymbolData());
        if (cd == null) {
            return null;
        }
        LinkedList<VariableData> myFields = this._data.getSymbolData().getVars();
        for (int i = 0; i < myFields.size(); ++i) {
            if (!myFields.get(i).hasModifier("final")) continue;
            ((VariableData)this._vars.get(this._vars.indexOf(myFields.get(i)))).gotValue();
            this.thingsThatHaveBeenAssigned.addLast(this._vars.get(this._vars.indexOf(myFields.get(i))));
        }
        String[] thrown = cd.getThrown();
        for (int i = 0; i < thrown.length; ++i) {
            this._thrown.addLast(new Pair<SymbolData, SimpleThisConstructorInvocation>(this.getSymbolData(thrown[i], this._getData(), that), that));
        }
        return null;
    }

    public TypeData complexThisConstructorInvocationNotAllowed(ComplexThisConstructorInvocation that) {
        ConstructorBodyTypeChecker._addError("Constructor Invocations of this form are never allowed.  A constructor invocation can appear here, but it must either be a super constructor invocation or have the form this(...)", that);
        return null;
    }

    public TypeData simpleSuperConstructorInvocationAllowed(SimpleSuperConstructorInvocation that) {
        SymbolData superClass = this._data.getSymbolData().getSuperClass();
        if (superClass == null) {
            ConstructorBodyTypeChecker._addError(new StringBuffer().append("The class ").append(this._data.getSymbolData().getName()).append(" does not have a super class").toString(), that);
            return null;
        }
        if (superClass.getOuterData() != null && !superClass.hasModifier("static")) {
            ConstructorBodyTypeChecker._addError(new StringBuffer().append(superClass.getName()).append(" is a non-static inner class of ").append(superClass.getOuterData().getName()).append(".  Its constructor must be invoked from an instance of its outer class").toString(), that);
            return null;
        }
        String name = LanguageLevelVisitor.getUnqualifiedClassName(superClass.getName());
        InstanceData[] args = this.getArgTypesForInvocation(that.getArguments());
        if (args == null) {
            return null;
        }
        MethodData cd = this._lookupMethod(name, superClass, args, that, new StringBuffer().append("No constructor found in class ").append(superClass.getName()).append(" with signature: ").toString(), true, superClass);
        if (cd == null) {
            return null;
        }
        String[] thrown = cd.getThrown();
        for (int i = 0; i < thrown.length; ++i) {
            this._thrown.addLast(new Pair<SymbolData, SimpleSuperConstructorInvocation>(this.getSymbolData(thrown[i], this._getData(), that), that));
        }
        return null;
    }

    public TypeData complexSuperConstructorInvocationAllowed(ComplexSuperConstructorInvocation that) {
        ExpressionTypeChecker etc = new ExpressionTypeChecker(this._data, this._file, this._package, this._importedFiles, (LinkedList<String>)this._importedPackages, this._vars, this._thrown);
        TypeData enclosingResult = that.getEnclosing().visit(etc);
        this.thingsThatHaveBeenAssigned.addAll(etc.thingsThatHaveBeenAssigned);
        if (!this.assertFound(enclosingResult, that)) {
            return null;
        }
        SymbolData superClass = this._data.getSymbolData().getSuperClass();
        if (superClass == null) {
            ConstructorBodyTypeChecker._addError(new StringBuffer().append("A qualified super constructor invocation can only be used to invoke the constructor of your super class from the context of its outer class.  The class ").append(this._data.getSymbolData().getName()).append(" does not have a super class, so you cannot do this here").toString(), that);
            return null;
        }
        if (superClass.getOuterData() == null) {
            ConstructorBodyTypeChecker._addError(new StringBuffer().append("A qualified super constructor invocation can only be used to invoke the constructor of your super class from the context of its outer class.  The super class ").append(superClass.getName()).append(" does not have an outer class, so you cannot do this here").toString(), that);
            return null;
        }
        if (enclosingResult == null) {
            ConstructorBodyTypeChecker._addError("A qualified super constructor invocation can only be used to invoke the constructor of your super class from the context of its outer class.", that);
            return null;
        }
        if (superClass.getOuterData() != enclosingResult.getSymbolData()) {
            ConstructorBodyTypeChecker._addError(new StringBuffer().append("A qualified super constructor invocation can only be used to invoke the constructor of your super class from the context of its outer class.  The class or interface ").append(enclosingResult.getSymbolData().getName()).append(" is not the outer class of the super class ").append(superClass.getName()).toString(), that);
            return null;
        }
        if (!enclosingResult.isInstanceType()) {
            ConstructorBodyTypeChecker._addError("A qualified super constructor invocation can only be made from the context of an instance of the outer class of the super class.  You have specified a type name", that);
            return null;
        }
        if (superClass.hasModifier("static")) {
            ConstructorBodyTypeChecker._addError(new StringBuffer().append("A qualified super constructor invocation can only be used to invoke the constructor of a non-static super class from the context of its outer class.  The super class ").append(superClass.getName()).append(" is a static inner class").toString(), that);
            return null;
        }
        String name = LanguageLevelVisitor.getUnqualifiedClassName(superClass.getName());
        InstanceData[] args = this.getArgTypesForInvocation(that.getArguments());
        if (args == null) {
            return null;
        }
        MethodData cd = this._lookupMethod(name, superClass, args, that, new StringBuffer().append("No constructor found in class ").append(superClass.getName()).append(" with signature: ").toString(), true, superClass);
        if (cd == null) {
            return null;
        }
        String[] thrown = cd.getThrown();
        for (int i = 0; i < thrown.length; ++i) {
            this._thrown.addLast(new Pair<SymbolData, ComplexSuperConstructorInvocation>(this.getSymbolData(thrown[i], this._getData(), that), that));
        }
        return null;
    }

    private void implicitSuperConstructor(BracedBody that) {
        SymbolData superClass = this._data.getSymbolData().getSuperClass();
        if (superClass == null) {
            return;
        }
        if (superClass.getOuterData() != null && !superClass.hasModifier("static")) {
            ConstructorBodyTypeChecker._addError(new StringBuffer().append("There is an implicit call to the constructor of ").append(superClass.getName()).append(" here, but ").append(superClass.getName()).append(" is a non-static inner class of ").append(superClass.getOuterData().getName()).append(".  Thus, you must explicitly invoke its constructor from an instance of its outer class").toString(), that);
            return;
        }
        String name = LanguageLevelVisitor.getUnqualifiedClassName(superClass.getName());
        MethodData cd = this._lookupMethod(name, superClass, new InstanceData[0], that, new StringBuffer().append("You must invoke one of ").append(superClass.getName()).append("'s constructors here.  You can either explicitly invoke one of its exisitng constructors or add a constructor with signature: ").toString(), true, superClass);
        if (cd == null) {
            return;
        }
        String[] thrown = cd.getThrown();
        for (int i = 0; i < thrown.length; ++i) {
            this._thrown.addLast(new Pair<SymbolData, BracedBody>(this.getSymbolData(thrown[i], this._getData(), that), that));
        }
    }

    @Override
    public TypeData forVoidReturnStatementOnly(VoidReturnStatement that) {
        return this._bodyData.getSymbolData().getInstanceData();
    }

    @Override
    public TypeData forValueReturnStatementOnly(ValueReturnStatement that, TypeData value_result) {
        ConstructorBodyTypeChecker._addError("You cannot return a value from a class's constructor", that);
        return this._bodyData.getSymbolData().getInstanceData();
    }

    @Override
    public TypeData forBracedBody(BracedBody that) {
        int startIndex = 0;
        TypeData[] items_result = this.makeArrayOfRetType(that.getStatements().length);
        if (items_result.length > 0 && that.getStatements()[0] instanceof ExpressionStatement) {
            Expression firstExpression = ((ExpressionStatement)that.getStatements()[0]).getExpression();
            if (firstExpression instanceof SimpleThisConstructorInvocation) {
                items_result[0] = this.simpleThisConstructorInvocationAllowed((SimpleThisConstructorInvocation)firstExpression);
                ++startIndex;
            } else if (firstExpression instanceof ComplexThisConstructorInvocation) {
                items_result[0] = this.complexThisConstructorInvocationNotAllowed((ComplexThisConstructorInvocation)firstExpression);
                ++startIndex;
            } else if (firstExpression instanceof SimpleSuperConstructorInvocation) {
                items_result[0] = this.simpleSuperConstructorInvocationAllowed((SimpleSuperConstructorInvocation)firstExpression);
                ++startIndex;
            } else if (firstExpression instanceof ComplexSuperConstructorInvocation) {
                items_result[0] = this.complexSuperConstructorInvocationAllowed((ComplexSuperConstructorInvocation)firstExpression);
                ++startIndex;
            }
        }
        if (startIndex == 0) {
            this.implicitSuperConstructor(that);
        }
        for (int j = 0; j < this._thrown.size(); ++j) {
            if (!this.isUncaughtCheckedException((SymbolData)((Pair)this._thrown.get(j)).getFirst(), that)) continue;
            this.handleUncheckedException((SymbolData)((Pair)this._thrown.get(j)).getFirst(), (JExpression)((Pair)this._thrown.get(j)).getSecond());
        }
        for (int i = startIndex; i < that.getStatements().length; ++i) {
            items_result[i] = that.getStatements()[i].visit(this);
            for (int j = 0; j < this._thrown.size(); ++j) {
                if (!this.isUncaughtCheckedException((SymbolData)((Pair)this._thrown.get(j)).getFirst(), that)) continue;
                this.handleUncheckedException((SymbolData)((Pair)this._thrown.get(j)).getFirst(), (JExpression)((Pair)this._thrown.get(j)).getSecond());
            }
        }
        return this.forBracedBodyOnly(that, items_result);
    }

    @Override
    public /* synthetic */ Object forBracedBody(BracedBody x0) {
        return this.forBracedBody(x0);
    }

    @Override
    public /* synthetic */ Object forValueReturnStatementOnly(ValueReturnStatement x0, Object x1) {
        return this.forValueReturnStatementOnly(x0, (TypeData)x1);
    }

    @Override
    public /* synthetic */ Object forVoidReturnStatementOnly(VoidReturnStatement x0) {
        return this.forVoidReturnStatementOnly(x0);
    }

    static /* synthetic */ void access$000(ConstructorBodyTypeChecker x0, BracedBody x1) {
        x0.implicitSuperConstructor(x1);
    }
}

