/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.ui.predictive;

import edu.rice.cs.drjava.ui.predictive.PredictiveInputModel;
import edu.rice.cs.util.Lambda;
import edu.rice.cs.util.swing.Utilities;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PredictiveInputFrame<T extends Comparable<? super T>>
extends JFrame {
    private volatile PredictiveInputModel<T> _pim;
    private volatile int _buttonPressed;
    private final JButton _okButton = new JButton("OK");
    private final JTextField _textField = new JTextField();
    private final JLabel _tabCompletesLabel = new JLabel("Tab completes: ");
    private final JList _matchList;
    private final boolean _force;
    private final JLabel _sharedExtLabel = new JLabel("");
    private final PredictiveInputListener _listener = new PredictiveInputListener(null);
    private final InfoSupplier<? super T> _info;
    private final JLabel _infoLabel = new JLabel("");
    private final Frame _owner;
    private final CloseAction<T> _okAction;
    private final CloseAction<T> _cancelAction;
    private final List<PredictiveInputModel.MatchingStrategy<T>> _strategies;
    private final JComboBox _strategyBox;
    private volatile FrameState _lastState;
    private volatile PredictiveInputModel.MatchingStrategy<T> _currentStrategy;

    public PredictiveInputFrame(Frame owner, String title, boolean force, boolean ignoreCase, InfoSupplier<? super T> info, List<PredictiveInputModel.MatchingStrategy<T>> strategies, CloseAction<T> okAction, CloseAction<T> cancelAction, List<T> items) {
        super(title);
        this._strategies = strategies;
        this._strategyBox = new JComboBox<Object>(this._strategies.toArray());
        this._currentStrategy = this._strategies.get(0);
        this._pim = new PredictiveInputModel<T>(ignoreCase, this._currentStrategy, items);
        this._matchList = new JList<Object>(this._pim.getMatchingItems().toArray());
        this._force = force;
        this._info = info;
        this._lastState = null;
        this._owner = owner;
        this._okAction = okAction;
        this._cancelAction = cancelAction;
        this.init(this._info != null);
    }

    public PredictiveInputFrame(Frame owner, String title, boolean force, boolean ignoreCase, InfoSupplier<? super T> info, List<PredictiveInputModel.MatchingStrategy<T>> strategies, CloseAction<T> okAction, CloseAction<T> cancelAction, T ... items) {
        this(owner, title, force, ignoreCase, info, strategies, okAction, cancelAction, Arrays.asList(items));
    }

    public FrameState getFrameState() {
        return this._lastState;
    }

    public void setFrameState(FrameState ds) {
        this._lastState = ds;
        if (this._lastState != null) {
            this.setSize(this._lastState.getDimension());
            this.setLocation(this._lastState.getLocation());
            int index = this._lastState.getCurrentStrategyIndex();
            if (index >= 0 && index < this._strategies.size()) {
                this._currentStrategy = this._strategies.get(index);
                this._strategyBox.setSelectedIndex(index);
            }
            this.selectStrategy();
            this.validate();
        }
    }

    public void setFrameState(String s) {
        try {
            this._lastState = new FrameState(s);
        }
        catch (IllegalArgumentException e) {
            this._lastState = null;
        }
        if (this._lastState != null) {
            this.setSize(this._lastState.getDimension());
            this.setLocation(this._lastState.getLocation());
            int index = this._lastState.getCurrentStrategyIndex();
            if (index >= 0 && index < this._strategies.size()) {
                this._currentStrategy = this._strategies.get(index);
                this._strategyBox.setSelectedIndex(index);
            }
            this.selectStrategy();
            this.validate();
        } else {
            Dimension parentDim = this._owner != null ? this._owner.getSize() : this.getToolkit().getScreenSize();
            int xs = (int)parentDim.getWidth() / 3;
            int ys = (int)parentDim.getHeight() / 4;
            this.setSize(Math.max(xs, 400), Math.max(ys, 300));
            this.setLocationRelativeTo(this._owner);
            this._currentStrategy = this._strategies.get(0);
            this._strategyBox.setSelectedIndex(0);
            this.selectStrategy();
        }
    }

    public void setModel(boolean ignoreCase, PredictiveInputModel<T> pim) {
        this._pim = new PredictiveInputModel<T>(ignoreCase, pim);
        this.removeListener();
        this.updateTextField();
        this.updateExtensionLabel();
        this.updateList();
        this.addListener();
    }

    public void setItems(boolean ignoreCase, List<T> items) {
        this._pim = new PredictiveInputModel<T>(ignoreCase, this._currentStrategy, items);
        this.removeListener();
        this.updateTextField();
        this.updateExtensionLabel();
        this.updateList();
        this.addListener();
    }

    public void setCurrentItem(T item) {
        this._pim.setCurrentItem(item);
        this.removeListener();
        this.updateTextField();
        this.updateExtensionLabel();
        this.updateList();
        this.addListener();
    }

    public void setItems(boolean ignoreCase, T ... items) {
        this._pim = new PredictiveInputModel(ignoreCase, this._currentStrategy, items);
        this.removeListener();
        this.updateTextField();
        this.updateExtensionLabel();
        this.updateList();
        this.addListener();
    }

    public int getButtonPressed() {
        return this._buttonPressed;
    }

    public String getText() {
        if (this._force) {
            Comparable item = (Comparable)this._matchList.getSelectedValue();
            return item == null ? "" : this._currentStrategy.force(item, this._textField.getText());
        }
        return this._textField.getText();
    }

    public T getItem() {
        if (!this._force && this._pim.getMatchingItems().size() == 0) {
            return null;
        }
        Comparable item = (Comparable)this._matchList.getSelectedValue();
        return (T)item;
    }

    private void init(boolean info) {
        this._buttonPressed = 2;
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent winEvt) {
                PredictiveInputFrame.access$300(PredictiveInputFrame.this);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                PredictiveInputFrame.this.validate();
                PredictiveInputFrame.access$400(PredictiveInputFrame.this).ensureIndexIsVisible(PredictiveInputFrame.access$400(PredictiveInputFrame.this).getSelectedIndex());
            }
        });
        this._okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PredictiveInputFrame.access$500(PredictiveInputFrame.this);
            }
        });
        this.getRootPane().setDefaultButton(this._okButton);
        final JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PredictiveInputFrame.access$300(PredictiveInputFrame.this);
            }
        });
        this._strategyBox.setEditable(false);
        this._strategyBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PredictiveInputFrame.this.selectStrategy();
            }
        });
        this._strategyBox.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                if (e.getOppositeComponent() != PredictiveInputFrame.access$600(PredictiveInputFrame.this) && e.getOppositeComponent() != PredictiveInputFrame.access$700(PredictiveInputFrame.this) && e.getOppositeComponent() != cancelButton) {
                    PredictiveInputFrame.access$600(PredictiveInputFrame.this).requestFocus();
                }
            }
        });
        this._textField.setDragEnabled(false);
        this._textField.setFocusTraversalKeysEnabled(false);
        this.addListener();
        Keymap ourMap = JTextComponent.addKeymap("PredictiveInputFrame._textField", this._textField.getKeymap());
        ourMap.addActionForKeyStroke(KeyStroke.getKeyStroke(27, 0), new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                PredictiveInputFrame.access$300(PredictiveInputFrame.this);
            }
        });
        ourMap.addActionForKeyStroke(KeyStroke.getKeyStroke(10, 0), new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                PredictiveInputFrame.access$500(PredictiveInputFrame.this);
            }
        });
        ourMap.addActionForKeyStroke(KeyStroke.getKeyStroke(9, 0), new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                PredictiveInputFrame.access$800(PredictiveInputFrame.this);
                PredictiveInputFrame.access$900(PredictiveInputFrame.this).extendSharedMask();
                PredictiveInputFrame.access$1000(PredictiveInputFrame.this);
                PredictiveInputFrame.access$1100(PredictiveInputFrame.this);
                PredictiveInputFrame.access$1200(PredictiveInputFrame.this);
                PredictiveInputFrame.access$1300(PredictiveInputFrame.this);
            }
        });
        ourMap.addActionForKeyStroke(KeyStroke.getKeyStroke(38, 0), new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                if (PredictiveInputFrame.access$400(PredictiveInputFrame.this).getModel().getSize() > 0) {
                    PredictiveInputFrame.access$800(PredictiveInputFrame.this);
                    int i = PredictiveInputFrame.access$400(PredictiveInputFrame.this).getSelectedIndex();
                    if (i > 0) {
                        PredictiveInputFrame.access$400(PredictiveInputFrame.this).setSelectedIndex(i - 1);
                        PredictiveInputFrame.access$400(PredictiveInputFrame.this).ensureIndexIsVisible(i - 1);
                        PredictiveInputFrame.access$900(PredictiveInputFrame.this).setCurrentItem((Comparable)PredictiveInputFrame.access$900(PredictiveInputFrame.this).getMatchingItems().get(i - 1));
                        PredictiveInputFrame.access$1400(PredictiveInputFrame.this);
                    }
                    PredictiveInputFrame.access$1300(PredictiveInputFrame.this);
                }
            }
        });
        ourMap.addActionForKeyStroke(KeyStroke.getKeyStroke(40, 0), new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                if (PredictiveInputFrame.access$400(PredictiveInputFrame.this).getModel().getSize() > 0) {
                    PredictiveInputFrame.access$800(PredictiveInputFrame.this);
                    int i = PredictiveInputFrame.access$400(PredictiveInputFrame.this).getSelectedIndex();
                    if (i < PredictiveInputFrame.access$400(PredictiveInputFrame.this).getModel().getSize() - 1) {
                        PredictiveInputFrame.access$400(PredictiveInputFrame.this).setSelectedIndex(i + 1);
                        PredictiveInputFrame.access$400(PredictiveInputFrame.this).ensureIndexIsVisible(i + 1);
                        PredictiveInputFrame.access$900(PredictiveInputFrame.this).setCurrentItem((Comparable)PredictiveInputFrame.access$900(PredictiveInputFrame.this).getMatchingItems().get(i + 1));
                        PredictiveInputFrame.access$1400(PredictiveInputFrame.this);
                    }
                    PredictiveInputFrame.access$1300(PredictiveInputFrame.this);
                }
            }
        });
        ourMap.addActionForKeyStroke(KeyStroke.getKeyStroke(33, 0), new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                if (PredictiveInputFrame.access$400(PredictiveInputFrame.this).getModel().getSize() > 0) {
                    PredictiveInputFrame.access$800(PredictiveInputFrame.this);
                    int page = PredictiveInputFrame.access$400(PredictiveInputFrame.this).getLastVisibleIndex() - PredictiveInputFrame.access$400(PredictiveInputFrame.this).getFirstVisibleIndex() + 1;
                    int i = PredictiveInputFrame.access$400(PredictiveInputFrame.this).getSelectedIndex() - page;
                    if (i < 0) {
                        i = 0;
                    }
                    PredictiveInputFrame.access$400(PredictiveInputFrame.this).setSelectedIndex(i);
                    PredictiveInputFrame.access$400(PredictiveInputFrame.this).ensureIndexIsVisible(i);
                    PredictiveInputFrame.access$900(PredictiveInputFrame.this).setCurrentItem((Comparable)PredictiveInputFrame.access$900(PredictiveInputFrame.this).getMatchingItems().get(i));
                    PredictiveInputFrame.access$1400(PredictiveInputFrame.this);
                    PredictiveInputFrame.access$1300(PredictiveInputFrame.this);
                }
            }
        });
        ourMap.addActionForKeyStroke(KeyStroke.getKeyStroke(34, 0), new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                if (PredictiveInputFrame.access$400(PredictiveInputFrame.this).getModel().getSize() > 0) {
                    PredictiveInputFrame.access$800(PredictiveInputFrame.this);
                    int page = PredictiveInputFrame.access$400(PredictiveInputFrame.this).getLastVisibleIndex() - PredictiveInputFrame.access$400(PredictiveInputFrame.this).getFirstVisibleIndex() + 1;
                    int i = PredictiveInputFrame.access$400(PredictiveInputFrame.this).getSelectedIndex() + page;
                    if (i >= PredictiveInputFrame.access$400(PredictiveInputFrame.this).getModel().getSize()) {
                        i = PredictiveInputFrame.access$400(PredictiveInputFrame.this).getModel().getSize() - 1;
                    }
                    PredictiveInputFrame.access$400(PredictiveInputFrame.this).setSelectedIndex(i);
                    PredictiveInputFrame.access$400(PredictiveInputFrame.this).ensureIndexIsVisible(i);
                    PredictiveInputFrame.access$900(PredictiveInputFrame.this).setCurrentItem((Comparable)PredictiveInputFrame.access$900(PredictiveInputFrame.this).getMatchingItems().get(i));
                    PredictiveInputFrame.access$1400(PredictiveInputFrame.this);
                    PredictiveInputFrame.access$1300(PredictiveInputFrame.this);
                }
            }
        });
        this._textField.setKeymap(ourMap);
        this._textField.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                if (e.getOppositeComponent() != PredictiveInputFrame.access$1500(PredictiveInputFrame.this) && e.getOppositeComponent() != PredictiveInputFrame.access$700(PredictiveInputFrame.this) && e.getOppositeComponent() != cancelButton) {
                    PredictiveInputFrame.access$600(PredictiveInputFrame.this).requestFocus();
                }
            }
        });
        this._matchList.setSelectionMode(0);
        this._matchList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                PredictiveInputFrame.access$800(PredictiveInputFrame.this);
                int i = PredictiveInputFrame.access$400(PredictiveInputFrame.this).getSelectedIndex();
                if (i >= 0) {
                    PredictiveInputFrame.access$900(PredictiveInputFrame.this).setCurrentItem((Comparable)PredictiveInputFrame.access$900(PredictiveInputFrame.this).getMatchingItems().get(i));
                    PredictiveInputFrame.access$400(PredictiveInputFrame.this).ensureIndexIsVisible(i);
                    PredictiveInputFrame.access$1400(PredictiveInputFrame.this);
                }
                PredictiveInputFrame.access$1300(PredictiveInputFrame.this);
            }
        });
        Container contentPane = this.getContentPane();
        GridBagLayout layout = new GridBagLayout();
        contentPane.setLayout(layout);
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridwidth = 0;
        c.insets.top = 2;
        c.insets.left = 2;
        c.insets.bottom = 2;
        c.insets.right = 2;
        if (info) {
            c.fill = 0;
            contentPane.add((Component)this._infoLabel, c);
        }
        c.fill = 1;
        c.weighty = 1.0;
        contentPane.add((Component)new JScrollPane(this._matchList, 20, 30), c);
        c.anchor = 16;
        c.fill = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridwidth = 1;
        contentPane.add((Component)this._tabCompletesLabel, c);
        c.fill = 2;
        c.weightx = 1.0;
        c.gridwidth = 0;
        contentPane.add((Component)this._sharedExtLabel, c);
        contentPane.add((Component)this._textField, c);
        c.anchor = 15;
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        GridBagConstraints bc = new GridBagConstraints();
        bc.insets.left = 2;
        bc.insets.right = 2;
        buttonPanel.add((Component)new JLabel("Matching strategy:"), bc);
        buttonPanel.add((Component)this._strategyBox, bc);
        buttonPanel.add((Component)this._okButton, bc);
        buttonPanel.add((Component)cancelButton, bc);
        contentPane.add((Component)buttonPanel, c);
        Dimension parentDim = this._owner != null ? this._owner.getSize() : this.getToolkit().getScreenSize();
        int xs = (int)parentDim.getWidth() / 3;
        int ys = (int)parentDim.getHeight() / 4;
        this.setSize(Math.max(xs, 400), Math.max(ys, 300));
        this.setLocationRelativeTo(this._owner);
        this.removeListener();
        this.updateTextField();
        this.addListener();
        this.updateList();
    }

    public void setOwnerEnabled(boolean b) {
    }

    @Override
    public void setVisible(boolean b) {
        this.validate();
        super.setVisible(b);
        if (b) {
            this.setOwnerEnabled(false);
            this._textField.requestFocus();
        } else {
            this.setOwnerEnabled(true);
            this._owner.toFront();
        }
    }

    private void addListener() {
        this._textField.getDocument().addDocumentListener(this._listener);
        this._textField.addCaretListener(this._listener);
    }

    private void removeListener() {
        this._textField.getDocument().removeDocumentListener(this._listener);
        this._textField.removeCaretListener(this._listener);
    }

    private void updateTextField() {
        this._textField.setText(this._pim.getMask());
        this._textField.setCaretPosition(this._pim.getMask().length());
    }

    private void updateExtensionLabel() {
        this._sharedExtLabel.setText(new StringBuffer().append(this._pim.getSharedMaskExtension()).append(" ").toString());
        this._tabCompletesLabel.setVisible(this._pim.getSharedMaskExtension().length() > 0);
    }

    private void updateList() {
        this._matchList.setListData(this._pim.getMatchingItems().toArray());
        this._matchList.setSelectedValue(this._pim.getCurrentItem(), true);
        this.updateExtensionLabel();
        this.updateInfo();
        this._okButton.setEnabled(this._matchList.getModel().getSize() > 0);
    }

    private void updateInfo() {
        if (this._info == null) {
            return;
        }
        if (this._matchList.getModel().getSize() > 0) {
            Comparable item = (Comparable)this._matchList.getSelectedValue();
            this._infoLabel.setText(new StringBuffer().append("Path:   ").append(this._info.apply((T)item)).toString());
        } else {
            this._infoLabel.setText("No file selected");
        }
    }

    private void okButtonPressed() {
        if (this._matchList.getModel().getSize() > 0) {
            this._buttonPressed = 0;
            this._lastState = new FrameState(this);
            this.setVisible(false);
            this._okAction.apply(this);
        } else {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    private void cancelButtonPressed() {
        this._buttonPressed = 2;
        this._lastState = new FrameState(this);
        this.setVisible(false);
        this._cancelAction.apply(this);
    }

    public void selectStrategy() {
        this._currentStrategy = this._strategies.get(this._strategyBox.getSelectedIndex());
        this.removeListener();
        this._pim.setStrategy(this._currentStrategy);
        this.updateTextField();
        this.updateExtensionLabel();
        this.updateList();
        this.addListener();
        this._textField.requestFocus();
    }

    static PredictiveInputModel.MatchingStrategy access$000(PredictiveInputFrame x0) {
        return x0._currentStrategy;
    }

    static List access$100(PredictiveInputFrame x0) {
        return x0._strategies;
    }

    static void access$300(PredictiveInputFrame x0) {
        x0.cancelButtonPressed();
    }

    static JList access$400(PredictiveInputFrame x0) {
        return x0._matchList;
    }

    static void access$500(PredictiveInputFrame x0) {
        x0.okButtonPressed();
    }

    static JTextField access$600(PredictiveInputFrame x0) {
        return x0._textField;
    }

    static JButton access$700(PredictiveInputFrame x0) {
        return x0._okButton;
    }

    static void access$800(PredictiveInputFrame x0) {
        x0.removeListener();
    }

    static PredictiveInputModel access$900(PredictiveInputFrame x0) {
        return x0._pim;
    }

    static void access$1000(PredictiveInputFrame x0) {
        x0.updateTextField();
    }

    static void access$1100(PredictiveInputFrame x0) {
        x0.updateExtensionLabel();
    }

    static void access$1200(PredictiveInputFrame x0) {
        x0.updateList();
    }

    static void access$1300(PredictiveInputFrame x0) {
        x0.addListener();
    }

    static void access$1400(PredictiveInputFrame x0) {
        x0.updateInfo();
    }

    static JComboBox access$1500(PredictiveInputFrame x0) {
        return x0._strategyBox;
    }

    private class PredictiveInputListener
    implements CaretListener,
    DocumentListener {
        private PredictiveInputListener() {
        }

        public void insertUpdate(DocumentEvent e) {
            Utilities.invokeLater(new Runnable(){

                public void run() {
                    PredictiveInputFrame.access$800(PredictiveInputFrame.this);
                    PredictiveInputFrame.access$900(PredictiveInputFrame.this).setMask(PredictiveInputFrame.access$600(PredictiveInputFrame.this).getText());
                    PredictiveInputFrame.access$1100(PredictiveInputFrame.this);
                    PredictiveInputFrame.access$1200(PredictiveInputFrame.this);
                    PredictiveInputFrame.access$1300(PredictiveInputFrame.this);
                }
            });
        }

        public void removeUpdate(DocumentEvent e) {
            Utilities.invokeLater(new Runnable(){

                public void run() {
                    PredictiveInputFrame.access$800(PredictiveInputFrame.this);
                    PredictiveInputFrame.access$900(PredictiveInputFrame.this).setMask(PredictiveInputFrame.access$600(PredictiveInputFrame.this).getText());
                    PredictiveInputFrame.access$1100(PredictiveInputFrame.this);
                    PredictiveInputFrame.access$1200(PredictiveInputFrame.this);
                    PredictiveInputFrame.access$1300(PredictiveInputFrame.this);
                }
            });
        }

        public void changedUpdate(DocumentEvent e) {
            Utilities.invokeLater(new Runnable(){

                public void run() {
                    PredictiveInputFrame.access$800(PredictiveInputFrame.this);
                    PredictiveInputFrame.access$900(PredictiveInputFrame.this).setMask(PredictiveInputFrame.access$600(PredictiveInputFrame.this).getText());
                    PredictiveInputFrame.access$1100(PredictiveInputFrame.this);
                    PredictiveInputFrame.access$1200(PredictiveInputFrame.this);
                    PredictiveInputFrame.access$1300(PredictiveInputFrame.this);
                }
            });
        }

        public void caretUpdate(CaretEvent e) {
        }

        PredictiveInputListener(1 x1) {
            this();
        }
    }

    public static class FrameState {
        private volatile Dimension _dim;
        private volatile Point _loc;
        private volatile int _currentStrategyIndex;

        public FrameState(Dimension d, Point l, int currentStrategyIndex) {
            this._dim = d;
            this._loc = l;
            this._currentStrategyIndex = currentStrategyIndex;
        }

        public FrameState(String s) {
            StringTokenizer tok = new StringTokenizer(s);
            try {
                int x = Integer.valueOf(tok.nextToken());
                int y = Integer.valueOf(tok.nextToken());
                this._dim = new Dimension(x, y);
                x = Integer.valueOf(tok.nextToken());
                y = Integer.valueOf(tok.nextToken());
                this._loc = new Point(x, y);
                this._currentStrategyIndex = Integer.valueOf(tok.nextToken());
            }
            catch (NoSuchElementException nsee) {
                throw new IllegalArgumentException("Wrong FrameState string: " + nsee);
            }
            catch (NumberFormatException nfe) {
                throw new IllegalArgumentException("Wrong FrameState string: " + nfe);
            }
        }

        public FrameState(PredictiveInputFrame comp) {
            this._dim = comp.getSize();
            this._loc = comp.getLocation();
            this._currentStrategyIndex = PredictiveInputFrame.access$100(comp).indexOf(PredictiveInputFrame.access$000(comp));
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append((int)this._dim.getWidth());
            sb.append(' ');
            sb.append((int)this._dim.getHeight());
            sb.append(' ');
            sb.append(this._loc.x);
            sb.append(' ');
            sb.append(this._loc.y);
            sb.append(' ');
            sb.append(this._currentStrategyIndex);
            return sb.toString();
        }

        public Dimension getDimension() {
            return this._dim;
        }

        public Point getLocation() {
            return this._loc;
        }

        public int getCurrentStrategyIndex() {
            return this._currentStrategyIndex;
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface CloseAction<X extends Comparable<? super X>>
    extends Lambda<Object, PredictiveInputFrame<X>> {
        @Override
        public Object apply(PredictiveInputFrame<X> var1);
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface InfoSupplier<X>
    extends Lambda<String, X> {
        @Override
        public String apply(X var1);
    }
}

