/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.ui.config;

import edu.rice.cs.drjava.DrJava;
import edu.rice.cs.drjava.config.ColorOption;
import edu.rice.cs.drjava.config.OptionConstants;
import edu.rice.cs.drjava.config.OptionEvent;
import edu.rice.cs.drjava.config.OptionListener;
import edu.rice.cs.drjava.ui.config.OptionComponent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColorOptionComponent
extends OptionComponent<Color> {
    private JButton _button;
    private JTextField _colorField;
    private JPanel _panel;
    private Color _color;
    private boolean _isBackgroundColor;
    private boolean _isBoldText;

    public ColorOptionComponent(ColorOption opt, String text, Frame parent) {
        this(opt, text, parent, false);
    }

    public ColorOptionComponent(ColorOption opt, String text, Frame parent, boolean isBackgroundColor) {
        this(opt, text, parent, isBackgroundColor, false);
    }

    public ColorOptionComponent(ColorOption opt, String text, Frame parent, boolean isBackgroundColor, boolean isBoldText) {
        super(opt, text, parent);
        this._isBackgroundColor = isBackgroundColor;
        this._isBoldText = isBoldText;
        this._button = new JButton();
        this._button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ColorOptionComponent.this.chooseColor();
            }
        });
        this._button.setText("...");
        this._button.setMaximumSize(new Dimension(10, 10));
        this._button.setMinimumSize(new Dimension(10, 10));
        this._colorField = new JTextField();
        this._colorField.setEditable(false);
        this._colorField.setHorizontalAlignment(0);
        this._panel = new JPanel(new BorderLayout());
        this._panel.add((Component)this._colorField, "Center");
        this._panel.add((Component)this._button, "East");
        if (this._isBackgroundColor) {
            this._colorField.setForeground(DrJava.getConfig().getSetting(OptionConstants.DEFINITIONS_NORMAL_COLOR));
            DrJava.getConfig().addOptionListener(OptionConstants.DEFINITIONS_NORMAL_COLOR, new OptionListener<Color>(){

                @Override
                public void optionChanged(OptionEvent<Color> oe) {
                    ColorOptionComponent.access$000(ColorOptionComponent.this).setForeground((Color)oe.value);
                }
            });
        } else {
            this._colorField.setBackground(DrJava.getConfig().getSetting(OptionConstants.DEFINITIONS_BACKGROUND_COLOR));
            DrJava.getConfig().addOptionListener(OptionConstants.DEFINITIONS_BACKGROUND_COLOR, new OptionListener<Color>(){

                @Override
                public void optionChanged(OptionEvent<Color> oe) {
                    ColorOptionComponent.access$000(ColorOptionComponent.this).setBackground((Color)oe.value);
                }
            });
        }
        if (this._isBoldText) {
            this._colorField.setFont(this._colorField.getFont().deriveFont(1));
        }
        this._color = (Color)DrJava.getConfig().getSetting(this._option);
        this._updateField(this._color);
    }

    public ColorOptionComponent(ColorOption opt, String text, Frame parent, String description) {
        this(opt, text, parent, description, false);
    }

    public ColorOptionComponent(ColorOption opt, String text, Frame parent, String description, boolean isBackgroundColor) {
        this(opt, text, parent, isBackgroundColor);
        this.setDescription(description);
    }

    public ColorOptionComponent(ColorOption opt, String text, Frame parent, String description, boolean isBackgroundColor, boolean isBoldText) {
        this(opt, text, parent, isBackgroundColor, isBoldText);
        this.setDescription(description);
    }

    @Override
    public void setDescription(String description) {
        this._panel.setToolTipText(description);
        this._button.setToolTipText(description);
        this._colorField.setToolTipText(description);
        this._label.setToolTipText(description);
    }

    @Override
    public boolean updateConfig() {
        if (!this._color.equals(DrJava.getConfig().getSetting(this._option))) {
            DrJava.getConfig().setSetting(this._option, this._color);
        }
        return true;
    }

    @Override
    public void setValue(Color value) {
        this._color = value;
        this._updateField(value);
    }

    private void _updateField(Color c) {
        if (this._isBackgroundColor) {
            this._colorField.setBackground(c);
        } else {
            this._colorField.setForeground(c);
        }
        this._colorField.setText(new StringBuffer().append(this.getLabelText()).append(" (").append(this._option.format(c)).append(")").toString());
    }

    @Override
    public JComponent getComponent() {
        return this._panel;
    }

    public void chooseColor() {
        Color c = JColorChooser.showDialog(this._parent, new StringBuffer().append("Choose '").append(this.getLabelText()).append("'").toString(), this._color);
        if (c != null) {
            this._color = c;
            this.notifyChangeListeners();
            this._updateField(this._color);
        }
    }

    @Override
    public void setValue(Object x0) {
        this.setValue((Color)x0);
    }

    static JTextField access$000(ColorOptionComponent x0) {
        return x0._colorField;
    }
}

