/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.ui;

import edu.rice.cs.drjava.model.GlobalModel;
import edu.rice.cs.drjava.model.OpenDefinitionsDocument;
import edu.rice.cs.drjava.model.definitions.ClassNameNotFoundException;
import edu.rice.cs.drjava.ui.MainFrame;
import edu.rice.cs.util.FileOps;
import edu.rice.cs.util.StreamRedirectThread;
import edu.rice.cs.util.UnexpectedException;
import edu.rice.cs.util.jar.JarBuilder;
import edu.rice.cs.util.jar.ManifestWriter;
import edu.rice.cs.util.newjvm.ExecJVM;
import edu.rice.cs.util.swing.FileChooser;
import edu.rice.cs.util.swing.FileSelectorComponent;
import edu.rice.cs.util.swing.FileSelectorStringComponent;
import edu.rice.cs.util.swing.SwingWorker;
import edu.rice.cs.util.swing.Utilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class JarOptionsDialog
extends JFrame {
    public static final int JAR_CLASSES = 1;
    public static final int JAR_SOURCES = 2;
    public static final int MAKE_EXECUTABLE = 4;
    private JCheckBox _jarClasses;
    private JCheckBox _jarSources;
    private JCheckBox _makeExecutable;
    private FileSelectorComponent _jarFileSelector;
    private FileSelectorStringComponent _mainClassField;
    private JLabel _mainClassLabel;
    private JButton _okButton;
    private JButton _cancelButton;
    private MainFrame _mainFrame;
    private GlobalModel _model;
    private JLabel _cantJarClassesLabel;
    private File _rootFile;
    private ProcessingFrame _processingFrame;
    private FrameState _lastState = null;
    static final /* synthetic */ boolean $assertionsDisabled;
    private static final /* synthetic */ Class class$edu$rice$cs$drjava$ui$JarOptionsDialog;

    public FrameState getFrameState() {
        return this._lastState;
    }

    public void setFrameState(FrameState ds) {
        this._lastState = ds;
        if (this._lastState != null) {
            this.setLocation(this._lastState.getLocation());
            this.validate();
        }
    }

    public void setFrameState(String s) {
        try {
            this._lastState = new FrameState(s);
        }
        catch (IllegalArgumentException e) {
            this._lastState = null;
        }
        if (this._lastState != null) {
            this.setLocation(this._lastState.getLocation());
        } else {
            MainFrame.setPopupLoc(this, this._mainFrame);
        }
        this.validate();
    }

    public JarOptionsDialog(MainFrame mf) {
        super("Create Jar File from Project");
        this._mainFrame = mf;
        this._model = mf.getModel();
        this.initComponents();
    }

    private void _loadSettings() {
        int f = this._model.getCreateJarFlags();
        this._jarClasses.setSelected((f & 1) != 0);
        this._jarSources.setSelected((f & 2) != 0);
        this._makeExecutable.setSelected((f & 4) != 0);
        boolean outOfSync = true;
        if (this._model.getBuildDirectory() != null) {
            outOfSync = this._model.hasOutOfSyncDocuments();
        }
        if (this._model.getBuildDirectory() == null || outOfSync) {
            this._jarClasses.setSelected(false);
            this._jarClasses.setEnabled(false);
            String s = this._model.getBuildDirectory() == null && outOfSync ? "<html><center>A build directory must be specified in order to jar class files,<br>and the project needs to be compiled.</center></html>" : (this._model.getBuildDirectory() == null ? "<html>A build directory must be specified in order to jar class files.</html>" : "<html>The project needs to be compiled.</html>");
            this._cantJarClassesLabel.setText(s);
        } else {
            this._jarClasses.setEnabled(true);
            this._cantJarClassesLabel.setText(" ");
            this._rootFile = this._model.getBuildDirectory();
            try {
                this._rootFile = this._rootFile.getCanonicalFile();
            }
            catch (IOException e) {
                // empty catch block
            }
            File mc = this._model.getMainClass();
            if (mc == null) {
                this._mainClassField.setText("");
            } else {
                try {
                    OpenDefinitionsDocument mcDoc = this._model.getDocumentForFile(mc);
                    this._mainClassField.setText(mcDoc.getQualifiedClassName());
                }
                catch (IOException ioe) {
                    this._mainClassField.setText("");
                }
                catch (ClassNameNotFoundException e) {
                    this._mainClassField.setText("");
                }
            }
        }
        this._jarFileSelector.setFileField(this._model.getCreateJarFile());
        this._okButton.setEnabled(this._jarSources.isSelected() || this._jarClasses.isSelected());
        this._setEnableExecutable(this._jarClasses.isSelected());
    }

    private void initComponents() {
        JPanel main = this._makePanel();
        super.getContentPane().setLayout(new BorderLayout());
        super.getContentPane().add((Component)main, "North");
        AbstractAction okAction = new AbstractAction("OK"){

            public void actionPerformed(ActionEvent e) {
                JarOptionsDialog.access$000(JarOptionsDialog.this);
            }
        };
        this._okButton = new JButton(okAction);
        AbstractAction cancelAction = new AbstractAction("Cancel"){

            public void actionPerformed(ActionEvent e) {
                JarOptionsDialog.access$100(JarOptionsDialog.this);
            }
        };
        this._cancelButton = new JButton(cancelAction);
        JPanel bottom = new JPanel();
        bottom.setBorder(new EmptyBorder(5, 5, 5, 5));
        bottom.setLayout(new BoxLayout(bottom, 0));
        bottom.add(Box.createHorizontalGlue());
        bottom.add(this._okButton);
        bottom.add(this._cancelButton);
        bottom.add(Box.createHorizontalGlue());
        super.getContentPane().add((Component)bottom, "South");
        super.setResizable(false);
        this.pack();
        MainFrame.setPopupLoc(this, this._mainFrame);
    }

    private JPanel _makePanel() {
        JPanel panel = new JPanel();
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        panel.setLayout(gridbag);
        c.fill = 2;
        Insets labelInsets = new Insets(5, 10, 0, 10);
        c.weightx = 0.0;
        c.gridwidth = 1;
        c.insets = labelInsets;
        c.weightx = 1.0;
        c.gridwidth = 0;
        c.insets = labelInsets;
        c.fill = 2;
        JPanel jarClassesPanel = this._makeClassesPanel();
        gridbag.setConstraints(jarClassesPanel, c);
        panel.add(jarClassesPanel);
        this._cantJarClassesLabel = new JLabel("<html><center>A build directory must be specified in order to jar class files,<br>and the project needs to be compiled.</center></html>", 0);
        c.gridx = 0;
        c.anchor = 17;
        c.fill = 2;
        gridbag.setConstraints(jarClassesPanel, c);
        panel.add(this._cantJarClassesLabel);
        this._jarSources = new JCheckBox(new AbstractAction("Jar source files"){

            public void actionPerformed(ActionEvent e) {
                JarOptionsDialog.access$400(JarOptionsDialog.this).setEnabled(JarOptionsDialog.access$200(JarOptionsDialog.this).isSelected() || JarOptionsDialog.access$300(JarOptionsDialog.this).isSelected());
            }
        });
        c.weightx = 0.0;
        c.gridwidth = 1;
        c.insets = labelInsets;
        gridbag.setConstraints(this._jarSources, c);
        panel.add(this._jarSources);
        c.gridx = 0;
        c.gridwidth = 1;
        c.insets = labelInsets;
        JLabel label = new JLabel("Jar File");
        label.setToolTipText("The file that the jar should be written to.");
        gridbag.setConstraints(label, c);
        panel.add(label);
        c.weightx = 1.0;
        c.gridx = 0;
        c.gridwidth = 0;
        c.insets = labelInsets;
        JPanel jarFilePanel = this._makeJarFileSelector();
        gridbag.setConstraints(jarFilePanel, c);
        panel.add(jarFilePanel);
        return panel;
    }

    private JPanel _makeClassesPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        this._jarClasses = new JCheckBox(new AbstractAction("Jar classes"){

            public void actionPerformed(ActionEvent e) {
                JarOptionsDialog.access$500(JarOptionsDialog.this);
                JarOptionsDialog.access$400(JarOptionsDialog.this).setEnabled(JarOptionsDialog.access$200(JarOptionsDialog.this).isSelected() || JarOptionsDialog.access$300(JarOptionsDialog.this).isSelected());
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        panel.add((Component)this._jarClasses, gridBagConstraints);
        JPanel addclasses = new JPanel();
        addclasses.setLayout(new GridBagLayout());
        this._makeExecutable = new JCheckBox(new AbstractAction("Make executable"){

            public void actionPerformed(ActionEvent e) {
                JarOptionsDialog.access$600(JarOptionsDialog.this);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        addclasses.add((Component)this._makeExecutable, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 20, 0, 0);
        addclasses.add((Component)this._makeMainClassSelectorPanel(), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 25, 0, 0);
        panel.add((Component)addclasses, gridBagConstraints);
        return panel;
    }

    private JPanel _makeMainClassSelectorPanel() {
        FileChooser chooser = new FileChooser(this._rootFile);
        chooser.setDialogTitle("Select Main Class");
        chooser.setApproveButtonText("Select");
        javax.swing.filechooser.FileFilter filter = new javax.swing.filechooser.FileFilter(){

            public boolean accept(File f) {
                String name = f.getName();
                return !f.isDirectory() && name.endsWith(".class");
            }

            public String getDescription() {
                return "Class Files (*.class)";
            }
        };
        chooser.addChoosableFileFilter(filter);
        this._mainClassField = new FileSelectorStringComponent(this, chooser, 20, 12.0f){

            public File convertStringToFile(String s) {
                if ((s = s.trim().replace('.', File.separatorChar) + ".class").equals("")) {
                    return null;
                }
                return new File(JarOptionsDialog.access$700(JarOptionsDialog.this), s);
            }

            public String convertFileToString(File f) {
                if (f == null) {
                    return "";
                }
                try {
                    String s = FileOps.makeRelativeTo(f, JarOptionsDialog.access$700(JarOptionsDialog.this)).toString();
                    s = s.substring(0, s.lastIndexOf(".class"));
                    s = s.replace(File.separatorChar, '.').replace('$', '.');
                    int pos = 0;
                    boolean ok = true;
                    while ((pos = s.indexOf(46, pos)) >= 0) {
                        if (s.length() <= pos + 1 || Character.isDigit(s.charAt(pos + 1))) {
                            ok = false;
                            break;
                        }
                        ++pos;
                    }
                    if (ok) {
                        return s;
                    }
                    return "";
                }
                catch (Exception e) {
                    return "";
                }
            }
        };
        this._mainClassField.getTextField().getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                this.setEnabled();
            }

            public void removeUpdate(DocumentEvent e) {
                this.setEnabled();
            }

            public void changedUpdate(DocumentEvent e) {
                this.setEnabled();
            }

            private void setEnabled() {
                Utilities.invokeLater(new Runnable(){

                    public void run() {
                        JarOptionsDialog.access$400(JarOptionsDialog.this).setEnabled(true);
                    }
                });
            }
        });
        JPanel p = new JPanel();
        p.setLayout(new BorderLayout());
        this._mainClassLabel = new JLabel("Main class:  ");
        this._mainClassLabel.setLabelFor(this._mainClassField);
        p.add((Component)this._mainClassLabel, "West");
        p.add((Component)this._mainClassField, "Center");
        return p;
    }

    private JPanel _makeJarFileSelector() {
        JFileChooser fileChooser = new JFileChooser(this._model.getBuildDirectory());
        fileChooser.setDialogTitle("Select Jar Output File");
        fileChooser.setApproveButtonText("Select");
        fileChooser.setFileSelectionMode(0);
        fileChooser.setMultiSelectionEnabled(false);
        fileChooser.setDialogType(1);
        this._jarFileSelector = new FileSelectorComponent(this, fileChooser, 20, 12.0f, false);
        this._jarFileSelector.setFileFilter(new javax.swing.filechooser.FileFilter(){

            public boolean accept(File f) {
                return f.getName().endsWith(".jar") || f.isDirectory();
            }

            public String getDescription() {
                return "Java Archive Files (*.jar)";
            }
        });
        return this._jarFileSelector;
    }

    private void _setEnableExecutable(boolean b) {
        this._makeExecutable.setEnabled(b);
        this._toggleMainClass();
    }

    private void _toggleClassOptions() {
        this._setEnableExecutable(this._jarClasses.isSelected());
    }

    private void _toggleMainClass() {
        this._mainClassField.setEnabled(this._makeExecutable.isSelected() && this._jarClasses.isSelected());
        this._mainClassLabel.setEnabled(this._makeExecutable.isSelected() && this._jarClasses.isSelected());
    }

    private void _cancel() {
        this._lastState = new FrameState(this);
        this.setVisible(false);
    }

    private void _ok() {
        this._saveSettings();
        File jarOut = this._jarFileSelector.getFileFromField();
        if (jarOut == null) {
            JOptionPane.showMessageDialog(this, "You must specify an output file", "Error: No File Specified", 0);
            return;
        }
        if (jarOut.exists() && JOptionPane.showConfirmDialog(this, "Are you sure you want to overwrite the file '" + jarOut.getPath() + "'?", "Overwrite file?", 0) != 0) {
            return;
        }
        this.setEnabled(false);
        this._processingFrame = new ProcessingFrame(this, "Creating Jar File", "Processing, please wait.");
        this._processingFrame.setVisible(true);
        SwingWorker worker = new SwingWorker(){
            boolean _success = false;

            private boolean jarBuildDirectory(File dir, JarBuilder jarFile) throws IOException {
                FileFilter classFilter = new FileFilter(){

                    public boolean accept(File f) {
                        return f.isDirectory() || f.getName().endsWith(".class");
                    }
                };
                File[] files = dir.listFiles(classFilter);
                if (files != null) {
                    for (int i = 0; i < files.length; ++i) {
                        if (files[i].isDirectory()) {
                            jarFile.addDirectoryRecursive(files[i], files[i].getName(), classFilter);
                            continue;
                        }
                        jarFile.addFile(files[i], "", files[i].getName());
                    }
                }
                return true;
            }

            private boolean jarSources(GlobalModel model, JarBuilder jar) {
                List<OpenDefinitionsDocument> srcs = model.getProjectDocuments();
                Iterator<OpenDefinitionsDocument> iter = srcs.iterator();
                while (iter.hasNext()) {
                    OpenDefinitionsDocument doc = iter.next();
                    if (!doc.inProject() || doc.isAuxiliaryFile()) continue;
                    try {
                        jar.addFile(doc.getFile(), this.packageNameToPath(doc.getPackageName()), doc.getFileName());
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        throw new UnexpectedException(e);
                    }
                }
                return true;
            }

            private String packageNameToPath(String packageName) {
                return packageName.replaceAll("\\.", System.getProperty("file.separator").replaceAll("\\\\", "\\\\\\\\"));
            }

            public Object construct() {
                try {
                    File jarOut = JarOptionsDialog.access$800(JarOptionsDialog.this).getFileFromField();
                    if (!jarOut.exists()) {
                        jarOut.createNewFile();
                    }
                    if (JarOptionsDialog.access$300(JarOptionsDialog.this).isSelected() && JarOptionsDialog.access$200(JarOptionsDialog.this).isSelected()) {
                        JarBuilder mainJar = null;
                        if (JarOptionsDialog.access$900(JarOptionsDialog.this).isSelected()) {
                            ManifestWriter mw = new ManifestWriter();
                            mw.setMainClass(JarOptionsDialog.access$1000(JarOptionsDialog.this).getText());
                            mainJar = new JarBuilder(jarOut, mw.getManifest());
                        } else {
                            mainJar = new JarBuilder(jarOut);
                        }
                        this.jarBuildDirectory(JarOptionsDialog.access$1100(JarOptionsDialog.this).getBuildDirectory(), mainJar);
                        File sourceJarFile = File.createTempFile(JarOptionsDialog.access$1100(JarOptionsDialog.this).getBuildDirectory().getName(), ".jar");
                        JarBuilder sourceJar = new JarBuilder(sourceJarFile);
                        this.jarSources(JarOptionsDialog.access$1100(JarOptionsDialog.this), sourceJar);
                        sourceJar.close();
                        mainJar.addFile(sourceJarFile, "", "source.jar");
                        mainJar.close();
                        sourceJarFile.delete();
                    } else if (JarOptionsDialog.access$300(JarOptionsDialog.this).isSelected()) {
                        JarBuilder jb;
                        if (JarOptionsDialog.access$900(JarOptionsDialog.this).isSelected()) {
                            ManifestWriter mw = new ManifestWriter();
                            mw.setMainClass(JarOptionsDialog.access$1000(JarOptionsDialog.this).getText());
                            jb = new JarBuilder(jarOut, mw.getManifest());
                        } else {
                            jb = new JarBuilder(jarOut);
                        }
                        this.jarBuildDirectory(JarOptionsDialog.access$1100(JarOptionsDialog.this).getBuildDirectory(), jb);
                        jb.close();
                    } else {
                        JarBuilder jb = new JarBuilder(jarOut);
                        this.jarSources(JarOptionsDialog.access$1100(JarOptionsDialog.this), jb);
                        jb.close();
                    }
                    this._success = true;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return null;
            }

            public void finished() {
                JarOptionsDialog.access$1200(JarOptionsDialog.this).setVisible(false);
                JarOptionsDialog.access$1200(JarOptionsDialog.this).dispose();
                JarOptionsDialog.this.setEnabled(true);
                if (this._success) {
                    if (JarOptionsDialog.access$900(JarOptionsDialog.this).isSelected()) {
                        Object[] options = new Object[]{"OK", "Run"};
                        int res = JOptionPane.showOptionDialog(JarOptionsDialog.this, "Jar file successfully written to '" + JarOptionsDialog.access$800(JarOptionsDialog.this).getFileFromField().getName() + "'", "Jar Creation Successful", -1, 1, null, options, options[0]);
                        JarOptionsDialog.this.setVisible(false);
                        if (1 == res) {
                            SwingWorker jarRunner = new SwingWorker(){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                public Object construct() {
                                    try {
                                        Process jarFileProcess = ExecJVM.runJVM(JarOptionsDialog.access$1000(JarOptionsDialog.this).getText(), new String[0], new String[]{JarOptionsDialog.access$800(JarOptionsDialog.this).getFileFromField().getAbsolutePath()}, new String[0], JarOptionsDialog.access$800(JarOptionsDialog.this).getFileFromField().getParentFile());
                                        StreamRedirectThread errThread = new StreamRedirectThread("error reader", jarFileProcess.getErrorStream(), System.err);
                                        StreamRedirectThread outThread = new StreamRedirectThread("output reader", jarFileProcess.getInputStream(), System.out);
                                        errThread.start();
                                        outThread.start();
                                        boolean notDead = true;
                                        while (notDead) {
                                            try {
                                                errThread.join();
                                                outThread.join();
                                                notDead = false;
                                            }
                                            catch (InterruptedException exc) {}
                                        }
                                        jarFileProcess.waitFor();
                                        JOptionPane.showMessageDialog(JarOptionsDialog.this, "Execution of jar file terminated (exit value = " + jarFileProcess.exitValue() + ")", "Execution terminated.", 1);
                                    }
                                    catch (Exception e) {
                                        JOptionPane.showMessageDialog(JarOptionsDialog.this, "An error occured while running the jar file: \n" + e, "Error", 0);
                                    }
                                    finally {
                                        JarOptionsDialog.this.setVisible(false);
                                    }
                                    return null;
                                }
                            };
                            jarRunner.start();
                        }
                    } else {
                        JOptionPane.showMessageDialog(JarOptionsDialog.this, "Jar file successfully written to '" + JarOptionsDialog.access$800(JarOptionsDialog.this).getFileFromField().getName() + "'", "Jar Creation Successful", 1);
                        JarOptionsDialog.this.setVisible(false);
                    }
                } else {
                    JOptionPane.showMessageDialog(JarOptionsDialog.this, "An error occured while creating the jar file. This could be because the file that you are writing to or the file you are reading from could not be opened.", "Error: File Access", 0);
                    JarOptionsDialog.this.setVisible(false);
                }
            }
        };
        worker.start();
    }

    private boolean _saveSettings() {
        this._lastState = new FrameState(this);
        if (this._model.getCreateJarFile() == null || !this._model.getCreateJarFile().getName().equals(this._jarFileSelector.getFileFromField().getName())) {
            this._model.setCreateJarFile(this._jarFileSelector.getFileFromField());
        }
        int f = 0;
        if (this._jarClasses.isSelected()) {
            f |= 1;
        }
        if (this._jarSources.isSelected()) {
            f |= 2;
        }
        if (this._makeExecutable.isSelected()) {
            f |= 4;
        }
        if (f != this._model.getCreateJarFlags()) {
            this._model.setCreateJarFlags(f);
        }
        return true;
    }

    public void setVisible(boolean vis) {
        if (!$assertionsDisabled && !EventQueue.isDispatchThread()) {
            throw new AssertionError();
        }
        this.validate();
        if (vis) {
            this._mainFrame.hourglassOn();
            ProcessingFrame pf = new ProcessingFrame(this, "Checking class files", "Processing, please wait.");
            pf.setVisible(true);
            this._loadSettings();
            pf.setVisible(false);
            pf.dispose();
        } else {
            this._mainFrame.hourglassOff();
            this._mainFrame.toFront();
        }
        super.setVisible(vis);
    }

    static void access$000(JarOptionsDialog x0) {
        x0._ok();
    }

    static void access$100(JarOptionsDialog x0) {
        x0._cancel();
    }

    static JCheckBox access$200(JarOptionsDialog x0) {
        return x0._jarSources;
    }

    static JCheckBox access$300(JarOptionsDialog x0) {
        return x0._jarClasses;
    }

    static JButton access$400(JarOptionsDialog x0) {
        return x0._okButton;
    }

    static void access$500(JarOptionsDialog x0) {
        x0._toggleClassOptions();
    }

    static void access$600(JarOptionsDialog x0) {
        x0._toggleMainClass();
    }

    static File access$700(JarOptionsDialog x0) {
        return x0._rootFile;
    }

    static FileSelectorComponent access$800(JarOptionsDialog x0) {
        return x0._jarFileSelector;
    }

    static JCheckBox access$900(JarOptionsDialog x0) {
        return x0._makeExecutable;
    }

    static FileSelectorStringComponent access$1000(JarOptionsDialog x0) {
        return x0._mainClassField;
    }

    static GlobalModel access$1100(JarOptionsDialog x0) {
        return x0._model;
    }

    static ProcessingFrame access$1200(JarOptionsDialog x0) {
        return x0._processingFrame;
    }

    static {
        $assertionsDisabled = !(class$edu$rice$cs$drjava$ui$JarOptionsDialog == null ? (class$edu$rice$cs$drjava$ui$JarOptionsDialog = JarOptionsDialog.class$("edu.rice.cs.drjava.ui.JarOptionsDialog")) : class$edu$rice$cs$drjava$ui$JarOptionsDialog).desiredAssertionStatus();
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        Class<?> clazz;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(classNotFoundException.getMessage());
            try {
                noClassDefFoundError.initCause(classNotFoundException);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            throw noClassDefFoundError;
        }
        return clazz;
    }

    private static class ProcessingFrame
    extends JFrame {
        private Component _parent;

        public ProcessingFrame(Component parent, String title, String label) {
            super(title);
            this._parent = parent;
            this.setSize(350, 150);
            MainFrame.setPopupLoc(this, parent);
            JLabel waitLabel = new JLabel(label, 0);
            this.getRootPane().setLayout(new BorderLayout());
            this.getRootPane().add((Component)waitLabel, "Center");
        }

        public void setVisible(boolean vis) {
            MainFrame.setPopupLoc(this, this._parent);
            super.setVisible(vis);
        }
    }

    public static class FrameState {
        private Point _loc;

        public FrameState(Point l) {
            this._loc = l;
        }

        public FrameState(String s) {
            StringTokenizer tok = new StringTokenizer(s);
            try {
                int x = Integer.valueOf(tok.nextToken());
                int y = Integer.valueOf(tok.nextToken());
                this._loc = new Point(x, y);
            }
            catch (NoSuchElementException nsee) {
                throw new IllegalArgumentException("Wrong FrameState string: " + nsee);
            }
            catch (NumberFormatException nfe) {
                throw new IllegalArgumentException("Wrong FrameState string: " + nfe);
            }
        }

        public FrameState(JarOptionsDialog comp) {
            this._loc = comp.getLocation();
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append(this._loc.x);
            sb.append(' ');
            sb.append(this._loc.y);
            return sb.toString();
        }

        public Point getLocation() {
            return this._loc;
        }
    }
}

