/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.ui;

import edu.rice.cs.drjava.config.OptionConstants;
import edu.rice.cs.drjava.config.OptionEvent;
import edu.rice.cs.drjava.config.OptionListener;
import edu.rice.cs.drjava.model.DJDocument;
import edu.rice.cs.drjava.model.repl.InteractionsDJDocument;
import edu.rice.cs.drjava.model.repl.InteractionsEditorKit;
import edu.rice.cs.drjava.ui.AbstractDJPane;
import edu.rice.cs.drjava.ui.BackgroundColorListener;
import edu.rice.cs.drjava.ui.ForegroundColorListener;
import edu.rice.cs.drjava.ui.ReverseHighlighter;
import edu.rice.cs.util.OperationCanceledException;
import edu.rice.cs.util.UnexpectedException;
import edu.rice.cs.util.swing.HighlightManager;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.Transferable;
import java.awt.event.KeyEvent;
import java.util.List;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.KeyStroke;
import javax.swing.ProgressMonitor;
import javax.swing.text.EditorKit;
import javax.swing.text.Keymap;
import javax.swing.text.StyledEditorKit;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class InteractionsPane
extends AbstractDJPane
implements OptionConstants,
ClipboardOwner {
    protected Keymap _keymap;
    private boolean _antiAliasText = false;
    static StyledEditorKit EDITOR_KIT = new InteractionsEditorKit();
    protected Runnable _beep = new Runnable(){

        public void run() {
            Toolkit.getDefaultToolkit().beep();
        }
    };
    private InteractionsDJDocument _doc;
    private List<Integer> _listOfPrompt = new Vector<Integer>();

    public Runnable getBeep() {
        return this._beep;
    }

    public InteractionsPane(InteractionsDJDocument doc) {
        this("INTERACTIONS_KEYMAP", doc);
    }

    public InteractionsPane(String keymapName, InteractionsDJDocument doc) {
        super(doc);
        this._doc = doc;
        this._keymap = InteractionsPane.addKeymap(keymapName, this.getKeymap());
        this.setCaretPosition(doc.getLength());
        this.setHighlighter(new ReverseHighlighter());
        this._highlightManager = new HighlightManager(this);
        new ForegroundColorListener(this);
        new BackgroundColorListener(this);
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }

    @Override
    public void processKeyEvent(KeyEvent e) {
        super.processKeyEvent(e);
    }

    public void addActionForKeyStroke(KeyStroke stroke, Action action) {
        KeyStroke[] keys = this._keymap.getKeyStrokesForAction(action);
        if (keys != null) {
            for (int i = 0; i < keys.length; ++i) {
                this._keymap.removeKeyStrokeBinding(keys[i]);
            }
        }
        this._keymap.addActionForKeyStroke(stroke, action);
        this.setKeymap(this._keymap);
    }

    public void setBeep(Runnable beep) {
        this._beep = beep;
    }

    public void highlightError(int offset, int length) {
        this._highlightManager.addHighlight(offset, offset + length, ERROR_PAINTER);
    }

    @Override
    protected EditorKit createDefaultEditorKit() {
        return EDITOR_KIT;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
    }

    @Override
    public DJDocument getDJDocument() {
        return this._doc;
    }

    @Override
    protected void _updateMatchHighlight() {
        this.addToPromptList(this.getPromptPos());
        int to = this.getCaretPosition();
        int from = this.getDJDocument().balanceBackward();
        if (from > -1) {
            if (this._notCrossesPrompt(to, from = to - from)) {
                this._addHighlight(from, to);
            }
        } else {
            from = to;
            to = this.getDJDocument().balanceForward();
            if (to > -1 && this._notCrossesPrompt(to += from, from)) {
                this._addHighlight(from - 1, to);
            }
        }
    }

    List<Integer> getPromptList() {
        return this._listOfPrompt;
    }

    public void resetPrompts() {
        this._listOfPrompt.clear();
    }

    void addToPromptList(int pos) {
        if (!this._listOfPrompt.contains(new Integer(pos))) {
            this._listOfPrompt.add(new Integer(pos));
        }
    }

    private boolean _notCrossesPrompt(int to, int from) {
        boolean toReturn = true;
        for (Integer prompt : this._listOfPrompt) {
            toReturn &= to >= prompt && from >= prompt || to <= prompt && from <= prompt;
        }
        return toReturn;
    }

    @Override
    protected void indentLines(int selStart, int selEnd, int reason, ProgressMonitor pm) {
        try {
            this._doc.indentLines(selStart, selEnd, reason, pm);
            this.setCaretPosition(this._doc.getCurrentLocation());
        }
        catch (OperationCanceledException oce) {
            throw new UnexpectedException(oce);
        }
    }

    @Override
    protected boolean shouldIndent(int selStart, int selEnd) {
        return true;
    }

    public abstract int getPromptPos();

    static boolean access$002(InteractionsPane x0, boolean x1) {
        x0._antiAliasText = x1;
        return x0._antiAliasText;
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AntiAliasOptionListener
    implements OptionListener<Boolean> {
        private AntiAliasOptionListener() {
        }

        @Override
        public void optionChanged(OptionEvent<Boolean> oce) {
            InteractionsPane.access$002(InteractionsPane.this, (Boolean)oce.value);
            InteractionsPane.this.repaint();
        }
    }
}

