/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.ui;

import edu.rice.cs.drjava.DrJava;
import edu.rice.cs.drjava.config.ColorOption;
import edu.rice.cs.drjava.config.Option;
import edu.rice.cs.drjava.config.OptionConstants;
import edu.rice.cs.drjava.config.OptionEvent;
import edu.rice.cs.drjava.config.OptionListener;
import edu.rice.cs.drjava.model.DocumentRegion;
import edu.rice.cs.drjava.model.FileMovedException;
import edu.rice.cs.drjava.model.MovingDocumentRegion;
import edu.rice.cs.drjava.model.RegionManager;
import edu.rice.cs.drjava.model.RegionManagerListener;
import edu.rice.cs.drjava.model.SimpleDocumentRegion;
import edu.rice.cs.drjava.ui.DefinitionsPane;
import edu.rice.cs.drjava.ui.MainFrame;
import edu.rice.cs.drjava.ui.RegionsTreePanel;
import edu.rice.cs.drjava.ui.ReverseHighlighter;
import edu.rice.cs.plt.tuple.Pair;
import edu.rice.cs.util.UnexpectedException;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.LinkedList;
import javax.swing.AbstractAction;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.border.CompoundBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.MatteBorder;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FindResultsPanel
extends RegionsTreePanel<MovingDocumentRegion> {
    protected JButton _goToButton;
    protected JButton _bookmarkButton;
    protected JButton _removeButton;
    protected JComboBox _colorBox;
    protected RegionManager<MovingDocumentRegion> _regionManager;
    protected int _lastIndex;
    private LinkedList<Pair<Option<Color>, OptionListener<Color>>> _colorOptionListeners = new LinkedList();

    public FindResultsPanel(MainFrame frame, RegionManager<MovingDocumentRegion> rm, String title) {
        super(frame, title);
        this._regionManager = rm;
        this._regionManager.addListener(new RegionManagerListener<MovingDocumentRegion>(){

            @Override
            public void regionAdded(MovingDocumentRegion r, int index) {
                FindResultsPanel.this.addRegion(r);
            }

            @Override
            public void regionChanged(MovingDocumentRegion r, int index) {
                this.regionRemoved(r);
                this.regionAdded(r, index);
            }

            @Override
            public void regionRemoved(MovingDocumentRegion r) {
                FindResultsPanel.this.removeRegion(r);
            }

            @Override
            public void regionRemoved(DocumentRegion x0) {
                this.regionRemoved((MovingDocumentRegion)x0);
            }

            @Override
            public void regionChanged(DocumentRegion x0, int x1) {
                this.regionChanged((MovingDocumentRegion)x0, x1);
            }

            @Override
            public void regionAdded(DocumentRegion x0, int x1) {
                this.regionAdded((MovingDocumentRegion)x0, x1);
            }
        });
        for (int i = 0; i < OptionConstants.FIND_RESULTS_COLORS.length; ++i) {
            FindResultsColorOptionListener temp = new FindResultsColorOptionListener(i);
            Pair<ColorOption, FindResultsColorOptionListener> pair = new Pair<ColorOption, FindResultsColorOptionListener>(OptionConstants.FIND_RESULTS_COLORS[i], temp);
            this._colorOptionListeners.add(pair);
            DrJava.getConfig().addOptionListener(OptionConstants.FIND_RESULTS_COLORS[i], temp);
        }
    }

    @Override
    protected JComponent[] makeButtons() {
        AbstractAction goToAction = new AbstractAction("Go to"){

            public void actionPerformed(ActionEvent ae) {
                FindResultsPanel.this.goToRegion();
            }
        };
        this._goToButton = new JButton(goToAction);
        AbstractAction bookmarkAction = new AbstractAction("Bookmark"){

            public void actionPerformed(ActionEvent ae) {
                FindResultsPanel.access$000(FindResultsPanel.this);
            }
        };
        this._bookmarkButton = new JButton(bookmarkAction);
        AbstractAction removeAction = new AbstractAction("Remove"){

            public void actionPerformed(ActionEvent ae) {
                FindResultsPanel.access$100(FindResultsPanel.this);
            }
        };
        this._removeButton = new JButton(removeAction);
        final JPanel highlightPanel = new JPanel();
        final Color normalColor = highlightPanel.getBackground();
        highlightPanel.add(new JLabel("Highlight:"));
        this._colorBox = new JComboBox();
        for (int i = 0; i < OptionConstants.FIND_RESULTS_COLORS.length; ++i) {
            this._colorBox.addItem(DrJava.getConfig().getSetting(OptionConstants.FIND_RESULTS_COLORS[i]));
        }
        this._colorBox.addItem("None");
        this._colorBox.setRenderer(new ColorComboRenderer());
        this._colorBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (FindResultsPanel.this._lastIndex < OptionConstants.FIND_RESULTS_COLORS.length) {
                    int n = FindResultsPanel.this._lastIndex;
                    DefinitionsPane.FIND_RESULTS_PAINTERS_USAGE[n] = DefinitionsPane.FIND_RESULTS_PAINTERS_USAGE[n] - 1;
                }
                FindResultsPanel.this._lastIndex = FindResultsPanel.this._colorBox.getSelectedIndex();
                if (FindResultsPanel.this._lastIndex < OptionConstants.FIND_RESULTS_COLORS.length) {
                    int n = FindResultsPanel.this._lastIndex;
                    DefinitionsPane.FIND_RESULTS_PAINTERS_USAGE[n] = DefinitionsPane.FIND_RESULTS_PAINTERS_USAGE[n] + 1;
                    highlightPanel.setBackground(DrJava.getConfig().getSetting(OptionConstants.FIND_RESULTS_COLORS[FindResultsPanel.this._lastIndex]));
                } else {
                    highlightPanel.setBackground(normalColor);
                }
                FindResultsPanel.this._frame.refreshFindResultsHighlightPainter(FindResultsPanel.this, DefinitionsPane.FIND_RESULTS_PAINTERS[FindResultsPanel.this._lastIndex]);
            }
        });
        this._lastIndex = 0;
        while (this._lastIndex < OptionConstants.FIND_RESULTS_COLORS.length && DefinitionsPane.FIND_RESULTS_PAINTERS_USAGE[this._lastIndex] != 0) {
            ++this._lastIndex;
        }
        if (this._lastIndex < OptionConstants.FIND_RESULTS_COLORS.length) {
            int n = this._lastIndex;
            DefinitionsPane.FIND_RESULTS_PAINTERS_USAGE[n] = DefinitionsPane.FIND_RESULTS_PAINTERS_USAGE[n] + 1;
        }
        this._colorBox.setSelectedIndex(this._lastIndex);
        this._frame.refreshFindResultsHighlightPainter(this, DefinitionsPane.FIND_RESULTS_PAINTERS[this._lastIndex]);
        return new JComponent[]{this._goToButton, this._bookmarkButton, this._removeButton, highlightPanel, this._colorBox};
    }

    public ReverseHighlighter.DefaultUnderlineHighlightPainter getSelectedPainter() {
        return DefinitionsPane.FIND_RESULTS_PAINTERS[this._lastIndex];
    }

    private void _bookmark() {
        for (MovingDocumentRegion r : this.getSelectedRegions()) {
            DocumentRegion bookmark = this._model.getBookmarkManager().getRegionOverlapping(r.getDocument(), r.getStartOffset(), r.getEndOffset());
            if (bookmark != null) continue;
            try {
                SimpleDocumentRegion newR = new SimpleDocumentRegion(r.getDocument(), r.getDocument().getFile(), r.getStartOffset(), r.getEndOffset());
                this._model.getBookmarkManager().addRegion(newR);
            }
            catch (FileMovedException fme) {
                throw new UnexpectedException(fme);
            }
        }
    }

    @Override
    protected void performDefaultAction() {
        this.goToRegion();
    }

    private void _remove() {
        for (MovingDocumentRegion r : this.getSelectedRegions()) {
            this._regionManager.removeRegion(r);
        }
        if (this._regionManager.getRegions().size() == 0) {
            this._close();
        }
    }

    @Override
    protected void updateButtons() {
        ArrayList regs = this.getSelectedRegions();
        this._goToButton.setEnabled(regs.size() == 1);
        this._bookmarkButton.setEnabled(regs.size() > 0);
        this._removeButton.setEnabled(regs.size() > 0);
    }

    @Override
    protected AbstractAction[] makePopupMenuActions() {
        AbstractAction[] acts = new AbstractAction[]{new AbstractAction("Go to"){

            public void actionPerformed(ActionEvent e) {
                FindResultsPanel.this.goToRegion();
            }
        }, new AbstractAction("Bookmark"){

            public void actionPerformed(ActionEvent e) {
                FindResultsPanel.access$000(FindResultsPanel.this);
            }
        }, new AbstractAction("Remove"){

            public void actionPerformed(ActionEvent e) {
                FindResultsPanel.access$100(FindResultsPanel.this);
            }
        }};
        return acts;
    }

    @Override
    public void _close() {
        super._close();
        this.freeResources();
    }

    public void freeResources() {
        this._regionManager.clearRegions();
        this._model.disposeFindResultsManager(this._regionManager);
        for (Pair pair : this._colorOptionListeners) {
            DrJava.getConfig().removeOptionListener((Option)pair.first(), (OptionListener)pair.second());
        }
        if (this._lastIndex < OptionConstants.FIND_RESULTS_COLORS.length) {
            int n = this._lastIndex;
            DefinitionsPane.FIND_RESULTS_PAINTERS_USAGE[n] = DefinitionsPane.FIND_RESULTS_PAINTERS_USAGE[n] - 1;
        }
    }

    @Override
    protected RegionsTreePanel.RegionTreeUserObj<MovingDocumentRegion> makeRegionTreeUserObj(MovingDocumentRegion r) {
        return new FindResultsRegionTreeUserObj(r);
    }

    @Override
    protected RegionsTreePanel.RegionTreeUserObj makeRegionTreeUserObj(DocumentRegion x0) {
        return this.makeRegionTreeUserObj((MovingDocumentRegion)x0);
    }

    static void access$000(FindResultsPanel x0) {
        x0._bookmark();
    }

    static void access$100(FindResultsPanel x0) {
        x0._remove();
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FindResultsColorOptionListener
    implements OptionListener<Color> {
        private int _index;

        public FindResultsColorOptionListener(int i) {
            this._index = i;
        }

        @Override
        public void optionChanged(OptionEvent<Color> oce) {
            int pos = FindResultsPanel.this._colorBox.getSelectedIndex();
            FindResultsPanel.this._colorBox.removeItemAt(this._index);
            FindResultsPanel.this._colorBox.insertItemAt(oce.value, this._index);
            FindResultsPanel.this._colorBox.setSelectedIndex(pos);
            if (pos == this._index) {
                FindResultsPanel.this._frame.refreshFindResultsHighlightPainter(FindResultsPanel.this, DefinitionsPane.FIND_RESULTS_PAINTERS[this._index]);
            }
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class FindResultsRegionTreeUserObj
    extends RegionsTreePanel.RegionTreeUserObj<MovingDocumentRegion> {
        protected int _lineNumber;

        public FindResultsRegionTreeUserObj(MovingDocumentRegion r) {
            super(r);
            this._lineNumber = ((MovingDocumentRegion)this._region).getDocument().getLineOfOffset(((MovingDocumentRegion)this._region).getStartOffset()) + 1;
        }

        @Override
        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("<html>");
            sb.append(this.lineNumber());
            sb.append(": ");
            sb.append(((MovingDocumentRegion)this._region).getString());
            sb.append("</html>");
            return sb.toString();
        }
    }

    static class ColorComboRenderer
    extends JPanel
    implements ListCellRenderer {
        private Color m_c = Color.black;
        private DefaultListCellRenderer defaultRenderer = new DefaultListCellRenderer();
        private static final Dimension preferredSize = new Dimension(0, 20);

        public ColorComboRenderer() {
            this.setBorder(new CompoundBorder(new MatteBorder(2, 10, 2, 10, Color.white), new LineBorder(Color.black)));
        }

        public Component getListCellRendererComponent(JList list, Object value, int row, boolean sel, boolean hasFocus) {
            JComponent renderer;
            if (value instanceof Color) {
                this.m_c = (Color)value;
                renderer = this;
            } else {
                JLabel l = (JLabel)this.defaultRenderer.getListCellRendererComponent((JList<?>)list, value, row, sel, hasFocus);
                l.setHorizontalAlignment(0);
                renderer = l;
            }
            return renderer;
        }

        public void paint(Graphics g) {
            this.setBackground(this.m_c);
            super.paint(g);
        }
    }
}

