/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.ui;

import com.rc.retroweaver.runtime.Autobox;
import edu.rice.cs.drjava.DrJava;
import edu.rice.cs.drjava.config.OptionConstants;
import edu.rice.cs.drjava.model.ClipboardHistoryModel;
import edu.rice.cs.drjava.model.FileMovedException;
import edu.rice.cs.drjava.model.FindReplaceMachine;
import edu.rice.cs.drjava.model.FindResult;
import edu.rice.cs.drjava.model.MovingDocumentRegion;
import edu.rice.cs.drjava.model.OpenDefinitionsDocument;
import edu.rice.cs.drjava.model.RegionManager;
import edu.rice.cs.drjava.model.SingleDisplayModel;
import edu.rice.cs.drjava.ui.BackgroundColorListener;
import edu.rice.cs.drjava.ui.DefinitionsPane;
import edu.rice.cs.drjava.ui.FindResultsPanel;
import edu.rice.cs.drjava.ui.ForegroundColorListener;
import edu.rice.cs.drjava.ui.MainFrame;
import edu.rice.cs.drjava.ui.TabbedPanel;
import edu.rice.cs.util.Lambda;
import edu.rice.cs.util.StringOps;
import edu.rice.cs.util.UnexpectedException;
import edu.rice.cs.util.swing.BorderlessScrollPane;
import edu.rice.cs.util.swing.Utilities;
import edu.rice.cs.util.text.SwingDocument;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.TextAction;

class FindReplacePanel
extends TabbedPanel
implements ClipboardOwner {
    private JButton _findNextButton;
    private JButton _findPreviousButton;
    private JButton _findAllButton;
    private JButton _replaceButton;
    private JButton _replaceFindNextButton;
    private JButton _replaceFindPreviousButton;
    private JButton _replaceAllButton;
    private JTextPane _findField;
    private JTextPane _replaceField;
    private JLabel _findLabelBot;
    private JCheckBox _ignoreCommentsAndStrings;
    private JCheckBox _matchCase;
    private JCheckBox _searchAllDocuments;
    private JCheckBox _matchWholeWord;
    private FindReplaceMachine _machine;
    private SingleDisplayModel _model;
    private DefinitionsPane _defPane = null;
    private boolean _caretChanged;
    private CaretListener _caretListener = new CaretListener(){

        public void caretUpdate(CaretEvent e) {
            Utilities.invokeLater(new Runnable(){

                public void run() {
                    FindReplacePanel.access$000(FindReplacePanel.this).setEnabled(false);
                    FindReplacePanel.access$100(FindReplacePanel.this).setEnabled(false);
                    FindReplacePanel.access$200(FindReplacePanel.this).setEnabled(false);
                    FindReplacePanel.access$300(FindReplacePanel.this).positionChanged();
                    FindReplacePanel.access$402(FindReplacePanel.this, true);
                }
            });
        }
    };
    private Action _findNextAction = new AbstractAction("Find Next"){

        public void actionPerformed(ActionEvent e) {
            FindReplacePanel.this.findNext();
        }
    };
    private Action _findPreviousAction = new AbstractAction("Find Previous"){

        public void actionPerformed(ActionEvent e) {
            FindReplacePanel.this.findPrevious();
        }
    };
    private Action _findAllAction = new AbstractAction("Find All"){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent e) {
            if (FindReplacePanel.access$500(FindReplacePanel.this).getText().length() > 0) {
                String searchStr = FindReplacePanel.access$500(FindReplacePanel.this).getText();
                String title = searchStr;
                if (title.length() > 10) {
                    title = title.substring(0, 10) + "...";
                }
                title = "Find: " + title;
                RegionManager<MovingDocumentRegion> rm = FindReplacePanel.access$600(FindReplacePanel.this).createFindResultsManager();
                final FindResultsPanel panel = FindReplacePanel.this._frame.createFindResultsPanel(rm, title);
                FindReplacePanel.access$700(FindReplacePanel.this);
                FindReplacePanel.access$300(FindReplacePanel.this).setFindWord(searchStr);
                FindReplacePanel.access$300(FindReplacePanel.this).setReplaceWord(FindReplacePanel.access$800(FindReplacePanel.this).getText());
                FindReplacePanel.this._frame.clearStatusMessage();
                final OpenDefinitionsDocument startDoc = FindReplacePanel.access$900(FindReplacePanel.this).getOpenDefDocument();
                final LinkedList results = new LinkedList();
                FindReplacePanel.this._frame.hourglassOn();
                try {
                    final int count = FindReplacePanel.access$300(FindReplacePanel.this).processAll(new Lambda<Void, FindResult>(){

                        @Override
                        public Void apply(FindResult fr) {
                            results.add(fr);
                            return null;
                        }

                        @Override
                        public Object apply(Object x0) {
                            return this.apply((FindResult)x0);
                        }
                    });
                    LinkedList<OpenDefinitionsDocument> reverted = new LinkedList<OpenDefinitionsDocument>();
                    Iterator i$ = results.iterator();
                    while (i$.hasNext()) {
                        FindResult fr = (FindResult)i$.next();
                        if (reverted.contains(fr.getDocument())) continue;
                        long origts = fr.getDocument().getTimestamp();
                        if (!FindReplacePanel.access$600(FindReplacePanel.this).getActiveDocument().equals(fr.getDocument())) {
                            FindReplacePanel.access$600(FindReplacePanel.this).setActiveDocument(fr.getDocument());
                        } else {
                            FindReplacePanel.access$600(FindReplacePanel.this).refreshActiveDocument();
                        }
                        OpenDefinitionsDocument doc = FindReplacePanel.access$900(FindReplacePanel.this).getOpenDefDocument();
                        long newts = doc.getTimestamp();
                        if (newts != origts) {
                            reverted.add(doc);
                            continue;
                        }
                        StringBuffer sb = new StringBuffer();
                        try {
                            int i;
                            int endSel = fr.getFoundOffset();
                            int startSel = endSel - FindReplacePanel.access$300(FindReplacePanel.this).getFindWord().length();
                            Position startPos = doc.createPosition(startSel);
                            Position endPos = doc.createPosition(endSel);
                            int excerptEndSel = doc.getLineEndPos(endSel);
                            int excerptStartSel = doc.getLineStartPos(startSel);
                            int length = Math.min(120, excerptEndSel - excerptStartSel);
                            int startRed = startSel - excerptStartSel;
                            int endRed = endSel - excerptStartSel;
                            String s = doc.getText(excerptStartSel, length);
                            for (i = 0; i < s.length(); ++i) {
                                if (s.charAt(i) < ' ' || s.charAt(i) > '\u007f') {
                                    sb.append(' ');
                                    continue;
                                }
                                sb.append(s.charAt(i));
                            }
                            s = sb.toString();
                            for (i = 0; i < s.length() && Character.isWhitespace(s.charAt(i)); ++i) {
                                --startRed;
                                --endRed;
                            }
                            s = s.trim();
                            if (startRed < 0) {
                                startRed = 0;
                            }
                            if (startRed > s.length()) {
                                startRed = s.length();
                            }
                            if (endRed < startRed) {
                                endRed = startRed;
                            }
                            if (endRed > s.length()) {
                                endRed = s.length();
                            }
                            sb.setLength(0);
                            sb.append(StringOps.encodeHTML(s.substring(0, startRed)));
                            sb.append("<font color=#ff0000>");
                            sb.append(StringOps.encodeHTML(s.substring(startRed, endRed)));
                            sb.append("</font>");
                            sb.append(StringOps.encodeHTML(s.substring(endRed)));
                            rm.addRegion(new MovingDocumentRegion(doc, doc.getFile(), startPos, endPos, sb.toString()));
                        }
                        catch (FileMovedException fme) {
                            throw new UnexpectedException(fme);
                        }
                        catch (BadLocationException ble) {
                            throw new UnexpectedException(ble);
                        }
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            FindReplacePanel.access$600(FindReplacePanel.this).setActiveDocument(startDoc);
                            Toolkit.getDefaultToolkit().beep();
                            FindReplacePanel.this._frame.setStatusMessage("Found " + count + " occurrence" + (count == 1 ? "" : "s") + ".");
                            if (count > 0) {
                                FindReplacePanel.this._frame.showFindResultsPanel(panel);
                            } else {
                                panel.freeResources();
                            }
                        }
                    });
                }
                finally {
                    FindReplacePanel.this._frame.hourglassOff();
                }
            }
        }
    };
    private Action _doFindAction = new AbstractAction("Do Find"){

        public void actionPerformed(ActionEvent e) {
            FindReplacePanel.access$1000(FindReplacePanel.this);
        }
    };
    private Action _replaceAction = new AbstractAction("Replace"){

        public void actionPerformed(ActionEvent e) {
            FindReplacePanel.access$700(FindReplacePanel.this);
            FindReplacePanel.access$300(FindReplacePanel.this).setFindWord(FindReplacePanel.access$500(FindReplacePanel.this).getText());
            String replaceWord = FindReplacePanel.access$800(FindReplacePanel.this).getText();
            FindReplacePanel.access$300(FindReplacePanel.this).setReplaceWord(replaceWord);
            FindReplacePanel.this._frame.clearStatusMessage();
            boolean replaced = FindReplacePanel.access$300(FindReplacePanel.this).replaceCurrent();
            if (replaced) {
                FindReplacePanel.access$1100(FindReplacePanel.this, replaceWord.length());
            }
            FindReplacePanel.access$000(FindReplacePanel.this).setEnabled(false);
            FindReplacePanel.access$100(FindReplacePanel.this).setEnabled(false);
            FindReplacePanel.access$200(FindReplacePanel.this).setEnabled(false);
            FindReplacePanel.access$1200(FindReplacePanel.this).requestFocusInWindow();
        }
    };
    private Action _replaceFindNextAction = new AbstractAction("Replace/Find Next"){

        public void actionPerformed(ActionEvent e) {
            if (FindReplacePanel.this.getSearchBackwards()) {
                FindReplacePanel.access$300(FindReplacePanel.this).positionChanged();
                FindReplacePanel.this.findNext();
            }
            FindReplacePanel.access$700(FindReplacePanel.this);
            FindReplacePanel.access$300(FindReplacePanel.this).setFindWord(FindReplacePanel.access$500(FindReplacePanel.this).getText());
            String replaceWord = FindReplacePanel.access$800(FindReplacePanel.this).getText();
            FindReplacePanel.access$300(FindReplacePanel.this).setReplaceWord(replaceWord);
            FindReplacePanel.this._frame.clearStatusMessage();
            boolean replaced = FindReplacePanel.access$300(FindReplacePanel.this).replaceCurrent();
            if (replaced) {
                FindReplacePanel.access$1100(FindReplacePanel.this, replaceWord.length());
                FindReplacePanel.this.findNext();
                FindReplacePanel.access$1300(FindReplacePanel.this).requestFocusInWindow();
            } else {
                FindReplacePanel.access$000(FindReplacePanel.this).setEnabled(false);
                FindReplacePanel.access$100(FindReplacePanel.this).setEnabled(false);
                FindReplacePanel.access$200(FindReplacePanel.this).setEnabled(false);
                Toolkit.getDefaultToolkit().beep();
                FindReplacePanel.this._frame.setStatusMessage("Replace failed.");
            }
        }
    };
    private Action _replaceFindPreviousAction = new AbstractAction("Replace/Find Previous"){

        public void actionPerformed(ActionEvent e) {
            if (!FindReplacePanel.this.getSearchBackwards()) {
                FindReplacePanel.access$300(FindReplacePanel.this).positionChanged();
                FindReplacePanel.this.findPrevious();
            }
            FindReplacePanel.access$700(FindReplacePanel.this);
            FindReplacePanel.access$300(FindReplacePanel.this).setFindWord(FindReplacePanel.access$500(FindReplacePanel.this).getText());
            String replaceWord = FindReplacePanel.access$800(FindReplacePanel.this).getText();
            FindReplacePanel.access$300(FindReplacePanel.this).setReplaceWord(replaceWord);
            FindReplacePanel.this._frame.clearStatusMessage();
            boolean replaced = FindReplacePanel.access$300(FindReplacePanel.this).replaceCurrent();
            if (replaced) {
                FindReplacePanel.access$1100(FindReplacePanel.this, replaceWord.length());
                FindReplacePanel.this.findPrevious();
                FindReplacePanel.access$1400(FindReplacePanel.this).requestFocusInWindow();
            } else {
                FindReplacePanel.access$000(FindReplacePanel.this).setEnabled(false);
                FindReplacePanel.access$100(FindReplacePanel.this).setEnabled(false);
                FindReplacePanel.access$200(FindReplacePanel.this).setEnabled(false);
                Toolkit.getDefaultToolkit().beep();
                FindReplacePanel.this._frame.setStatusMessage("Replace failed.");
            }
        }
    };
    private Action _replaceAllAction = new AbstractAction("Replace All"){

        public void actionPerformed(ActionEvent e) {
            FindReplacePanel.access$700(FindReplacePanel.this);
            FindReplacePanel.access$300(FindReplacePanel.this).setFindWord(FindReplacePanel.access$500(FindReplacePanel.this).getText());
            FindReplacePanel.access$300(FindReplacePanel.this).setReplaceWord(FindReplacePanel.access$800(FindReplacePanel.this).getText());
            FindReplacePanel.this._frame.clearStatusMessage();
            int count = FindReplacePanel.access$300(FindReplacePanel.this).replaceAll();
            Toolkit.getDefaultToolkit().beep();
            FindReplacePanel.this._frame.setStatusMessage("Replaced " + count + " occurrence" + (count == 1 ? "" : "s") + ".");
            FindReplacePanel.access$000(FindReplacePanel.this).setEnabled(false);
            FindReplacePanel.access$100(FindReplacePanel.this).setEnabled(false);
            FindReplacePanel.access$200(FindReplacePanel.this).setEnabled(false);
        }
    };
    Action _standardNewlineAction = new TextAction("NewLine Action"){

        public void actionPerformed(ActionEvent e) {
            JTextComponent c = this.getTextComponent(e);
            String text = c.getText();
            int caretPos = c.getCaretPosition();
            String textBeforeCaret = text.substring(0, caretPos);
            String textAfterCaret = text.substring(caretPos);
            c.setText(textBeforeCaret.concat("\n").concat(textAfterCaret));
            c.setCaretPosition(caretPos + 1);
        }
    };
    Action cutAction = new DefaultEditorKit.CutAction(){

        public void actionPerformed(ActionEvent e) {
            JTextComponent tc;
            if (e.getSource() instanceof JTextComponent && (tc = (JTextComponent)e.getSource()).getSelectedText() != null) {
                super.actionPerformed(e);
                String s = Utilities.getClipboardSelection(FindReplacePanel.this);
                if (s != null && s.length() != 0) {
                    ClipboardHistoryModel.singleton().put(s);
                }
            }
        }
    };
    Action copyAction = new DefaultEditorKit.CopyAction(){

        public void actionPerformed(ActionEvent e) {
            JTextComponent tc;
            if (e.getSource() instanceof JTextComponent && (tc = (JTextComponent)e.getSource()).getSelectedText() != null) {
                super.actionPerformed(e);
                String s = Utilities.getClipboardSelection(FindReplacePanel.this);
                if (s != null && s.length() != 0) {
                    ClipboardHistoryModel.singleton().put(s);
                }
            }
        }
    };

    public FindReplacePanel(MainFrame frame, SingleDisplayModel model) {
        super(frame, "Find/Replace");
        this._model = model;
        this._machine = new FindReplaceMachine(this._model, this._model.getDocumentIterator());
        this._updateMachine();
        this._findNextButton = new JButton(this._findNextAction);
        this._findPreviousButton = new JButton(this._findPreviousAction);
        this._findAllButton = new JButton(this._findAllAction);
        this._replaceButton = new JButton(this._replaceAction);
        this._replaceFindNextButton = new JButton(this._replaceFindNextAction);
        this._replaceFindPreviousButton = new JButton(this._replaceFindPreviousAction);
        this._replaceAllButton = new JButton(this._replaceAllAction);
        this._replaceAction.setEnabled(false);
        this._replaceFindNextAction.setEnabled(false);
        this._replaceFindPreviousAction.setEnabled(false);
        this._findField = new JTextPane(new DefaultStyledDocument());
        this._replaceField = new JTextPane(new SwingDocument());
        int tabForward = 0;
        int tabBackward = 1;
        this._findField.setFocusTraversalKeys(tabForward, null);
        this._replaceField.setFocusTraversalKeys(tabForward, null);
        this._findField.setFocusTraversalKeys(tabBackward, null);
        this._replaceField.setFocusTraversalKeys(tabBackward, null);
        KeyStroke enter = KeyStroke.getKeyStroke(10, 0);
        KeyStroke ctrlEnter = KeyStroke.getKeyStroke(10, 2);
        KeyStroke ctrlTab = KeyStroke.getKeyStroke(9, 2);
        InputMap findIM = this._findField.getInputMap();
        InputMap replaceIM = this._replaceField.getInputMap();
        findIM.put(enter, "Do Find");
        findIM.put(ctrlEnter, "Insert Newline");
        findIM.put(ctrlTab, "Insert Tab");
        findIM.put(DrJava.getConfig().getSetting(OptionConstants.KEY_CUT), "Cut");
        findIM.put(DrJava.getConfig().getSetting(OptionConstants.KEY_COPY), "Copy");
        replaceIM.put(enter, "Insert Newline");
        replaceIM.put(ctrlEnter, "Insert Newline");
        replaceIM.put(ctrlTab, "Insert Tab");
        replaceIM.put(DrJava.getConfig().getSetting(OptionConstants.KEY_CUT), "Cut");
        replaceIM.put(DrJava.getConfig().getSetting(OptionConstants.KEY_COPY), "Copy");
        DefaultEditorKit.InsertTabAction insertTabAction = new DefaultEditorKit.InsertTabAction();
        ActionMap findAM = this._findField.getActionMap();
        ActionMap replaceAM = this._replaceField.getActionMap();
        findAM.put("Do Find", this._doFindAction);
        findAM.put("Insert Newline", this._standardNewlineAction);
        findAM.put("Insert Tab", insertTabAction);
        findAM.put("Cut", this.cutAction);
        findAM.put("Copy", this.copyAction);
        replaceAM.put("Insert Newline", this._standardNewlineAction);
        replaceAM.put("Insert Tab", insertTabAction);
        replaceAM.put("Cut", this.cutAction);
        replaceAM.put("Copy", this.copyAction);
        new ForegroundColorListener(this._findField);
        new BackgroundColorListener(this._findField);
        new ForegroundColorListener(this._replaceField);
        new BackgroundColorListener(this._replaceField);
        Font font = DrJava.getConfig().getSetting(OptionConstants.FONT_MAIN);
        this.setFieldFont(font);
        JLabel _replaceLabelTop = new JLabel("Replace", 4);
        JLabel _replaceLabelBot = new JLabel("With", 4);
        JPanel replaceLabelPanelTop = new JPanel(new BorderLayout(5, 5));
        JPanel replaceLabelPanelBot = new JPanel(new BorderLayout(5, 5));
        JPanel replaceLabelPanel = new JPanel(new GridLayout(2, 1));
        replaceLabelPanelTop.add((Component)_replaceLabelTop, "South");
        replaceLabelPanelBot.add((Component)_replaceLabelBot, "North");
        replaceLabelPanel.add(replaceLabelPanelTop);
        replaceLabelPanel.add(replaceLabelPanelBot);
        JLabel _findLabelTop = new JLabel("Find", 4);
        this._findLabelBot = new JLabel("Next", 4);
        JPanel findLabelPanelTop = new JPanel(new BorderLayout(5, 5));
        JPanel findLabelPanelBot = new JPanel(new BorderLayout(5, 5));
        JPanel findLabelPanel = new JPanel(new GridLayout(2, 1));
        findLabelPanelTop.add((Component)_findLabelTop, "South");
        findLabelPanelBot.add((Component)this._findLabelBot, "North");
        findLabelPanel.add(findLabelPanelTop);
        findLabelPanel.add(findLabelPanelBot);
        JPanel buttons = new JPanel();
        buttons.setLayout(new GridLayout(1, 0, 5, 0));
        buttons.add(this._findNextButton);
        buttons.add(this._findPreviousButton);
        buttons.add(this._findAllButton);
        buttons.add(this._replaceFindNextButton);
        buttons.add(this._replaceFindPreviousButton);
        buttons.add(this._replaceButton);
        buttons.add(this._replaceAllButton);
        boolean matchCaseSelected = DrJava.getConfig().getSetting(OptionConstants.FIND_MATCH_CASE);
        this._matchCase = new JCheckBox("Match Case", matchCaseSelected);
        this._machine.setMatchCase(matchCaseSelected);
        this._matchCase.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                boolean isSelected = e.getStateChange() == 1;
                FindReplacePanel.access$300(FindReplacePanel.this).setMatchCase(isSelected);
                DrJava.getConfig().setSetting(OptionConstants.FIND_MATCH_CASE, Autobox.valueOf(isSelected));
                FindReplacePanel.access$500(FindReplacePanel.this).requestFocusInWindow();
            }
        });
        boolean searchAllSelected = DrJava.getConfig().getSetting(OptionConstants.FIND_ALL_DOCUMENTS);
        this._searchAllDocuments = new JCheckBox("Search All Documents", searchAllSelected);
        this._machine.setSearchAllDocuments(searchAllSelected);
        this._searchAllDocuments.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                boolean isSelected = e.getStateChange() == 1;
                FindReplacePanel.access$300(FindReplacePanel.this).setSearchAllDocuments(isSelected);
                DrJava.getConfig().setSetting(OptionConstants.FIND_ALL_DOCUMENTS, Autobox.valueOf(isSelected));
                FindReplacePanel.access$500(FindReplacePanel.this).requestFocusInWindow();
            }
        });
        boolean matchWordSelected = DrJava.getConfig().getSetting(OptionConstants.FIND_WHOLE_WORD);
        this._matchWholeWord = new JCheckBox("Whole Word", matchWordSelected);
        if (matchWordSelected) {
            this._machine.setMatchWholeWord();
        } else {
            this._machine.setFindAnyOccurrence();
        }
        this._matchWholeWord.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                boolean isSelected;
                boolean bl = isSelected = e.getStateChange() == 1;
                if (isSelected) {
                    FindReplacePanel.access$300(FindReplacePanel.this).setMatchWholeWord();
                } else {
                    FindReplacePanel.access$300(FindReplacePanel.this).setFindAnyOccurrence();
                }
                DrJava.getConfig().setSetting(OptionConstants.FIND_WHOLE_WORD, Autobox.valueOf(isSelected));
                FindReplacePanel.access$500(FindReplacePanel.this).requestFocusInWindow();
            }
        });
        boolean ignoreCommentsSelected = DrJava.getConfig().getSetting(OptionConstants.FIND_NO_COMMENTS_STRINGS);
        this._ignoreCommentsAndStrings = new JCheckBox("No Comments/Strings", ignoreCommentsSelected);
        this._machine.setIgnoreCommentsAndStrings(ignoreCommentsSelected);
        this._ignoreCommentsAndStrings.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                boolean isSelected = e.getStateChange() == 1;
                FindReplacePanel.access$300(FindReplacePanel.this).setIgnoreCommentsAndStrings(isSelected);
                DrJava.getConfig().setSetting(OptionConstants.FIND_NO_COMMENTS_STRINGS, Autobox.valueOf(isSelected));
                FindReplacePanel.access$500(FindReplacePanel.this).requestFocusInWindow();
            }
        });
        this.removeAll();
        this._closePanel = new JPanel(new BorderLayout());
        this._closePanel.add((Component)this._closeButton, "North");
        JPanel _lowerCheckPanel = new JPanel(new FlowLayout(0, 0, 0));
        _lowerCheckPanel.add(this._matchWholeWord);
        _lowerCheckPanel.add(this._ignoreCommentsAndStrings);
        _lowerCheckPanel.setMaximumSize(new Dimension(200, 40));
        JPanel _matchCaseAndAllDocsPanel = new JPanel(new FlowLayout(0, 0, 0));
        this._matchCase.setPreferredSize(this._matchWholeWord.getPreferredSize());
        _matchCaseAndAllDocsPanel.add(this._matchCase);
        _matchCaseAndAllDocsPanel.add(this._searchAllDocuments);
        _matchCaseAndAllDocsPanel.setMaximumSize(new Dimension(200, 40));
        BorderlessScrollPane _findPane = new BorderlessScrollPane(this._findField);
        BorderlessScrollPane _replacePane = new BorderlessScrollPane(this._replaceField);
        _findPane.setHorizontalScrollBarPolicy(30);
        _replacePane.setHorizontalScrollBarPolicy(30);
        JPanel findPanel = new JPanel(new BorderLayout(5, 5));
        findPanel.add((Component)findLabelPanel, "West");
        findPanel.add((Component)_findPane, "Center");
        JPanel replacePanel = new JPanel(new BorderLayout(5, 5));
        replacePanel.add((Component)replaceLabelPanel, "West");
        replacePanel.add((Component)_replacePane, "Center");
        JPanel leftPanel = new JPanel(new GridLayout(1, 2, 5, 5));
        leftPanel.add(findPanel);
        leftPanel.add(replacePanel);
        GridBagLayout gbLayout = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        JPanel emptyPanel = new JPanel();
        JPanel optionsPanel = new JPanel(gbLayout);
        optionsPanel.setLayout(gbLayout);
        optionsPanel.add(_matchCaseAndAllDocsPanel);
        optionsPanel.add(_lowerCheckPanel);
        optionsPanel.add(emptyPanel);
        c.fill = 2;
        c.anchor = 11;
        c.gridwidth = 0;
        c.weightx = 1.0;
        gbLayout.setConstraints(_matchCaseAndAllDocsPanel, c);
        gbLayout.setConstraints(_lowerCheckPanel, c);
        c.fill = 1;
        c.anchor = 15;
        c.gridheight = 0;
        c.weighty = 1.0;
        gbLayout.setConstraints(emptyPanel, c);
        JPanel midPanel = new JPanel(new BorderLayout(5, 5));
        midPanel.add((Component)leftPanel, "Center");
        midPanel.add((Component)optionsPanel, "East");
        JPanel _rightPanel = new JPanel(new BorderLayout(5, 5));
        _rightPanel.add((Component)midPanel, "Center");
        _rightPanel.add((Component)this._closePanel, "East");
        JPanel newPanel = new JPanel();
        newPanel.setLayout(new BoxLayout(newPanel, 1));
        newPanel.add(_rightPanel);
        newPanel.add(Box.createVerticalStrut(5));
        newPanel.add(buttons);
        newPanel.add(Box.createVerticalStrut(5));
        this.add(newPanel);
        this._findField.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent e) {
                this._updateHelper();
            }

            public void insertUpdate(DocumentEvent e) {
                this._updateHelper();
            }

            public void removeUpdate(DocumentEvent e) {
                this._updateHelper();
            }

            private void _updateHelper() {
                Utilities.invokeLater(new Runnable(){

                    public void run() {
                        FindReplacePanel.this.updateFirstDocInSearch();
                        FindReplacePanel.access$000(FindReplacePanel.this).setEnabled(false);
                        FindReplacePanel.access$100(FindReplacePanel.this).setEnabled(false);
                        FindReplacePanel.access$200(FindReplacePanel.this).setEnabled(false);
                        FindReplacePanel.access$300(FindReplacePanel.this).positionChanged();
                        if (FindReplacePanel.access$500(FindReplacePanel.this).getText().equals("")) {
                            FindReplacePanel.access$1500(FindReplacePanel.this).setEnabled(false);
                        } else {
                            FindReplacePanel.access$1500(FindReplacePanel.this).setEnabled(true);
                        }
                        FindReplacePanel.this.updateUI();
                    }
                });
            }
        });
    }

    public boolean requestFocusInWindow() {
        super.requestFocusInWindow();
        this._findField.selectAll();
        return this._findField.requestFocusInWindow();
    }

    JTextPane getFindField() {
        return this._findField;
    }

    void findNext() {
        this._machine.setSearchBackwards(false);
        this._findLabelBot.setText("Next");
        this._doFind();
    }

    void findPrevious() {
        this._machine.setSearchBackwards(true);
        this._findLabelBot.setText("Prev");
        this._doFind();
    }

    void beginListeningTo(DefinitionsPane defPane) {
        if (this._defPane == null) {
            this._displayed = true;
            this._defPane = defPane;
            this._defPane.addCaretListener(this._caretListener);
            this._caretChanged = true;
            this._updateMachine();
            this._machine.setFindWord(this._findField.getText());
            this._machine.setReplaceWord(this._replaceField.getText());
            this._frame.clearStatusMessage();
            if (!this._machine.onMatch() || this._findField.getText().equals("")) {
                this._replaceAction.setEnabled(false);
                this._replaceFindNextAction.setEnabled(false);
                this._replaceFindPreviousAction.setEnabled(false);
            } else {
                this._replaceAction.setEnabled(true);
                this._replaceFindNextAction.setEnabled(true);
                this._replaceFindPreviousAction.setEnabled(true);
                this._machine.setLastFindWord();
            }
            if (this._findField.getText().equals("")) {
                this._replaceAllAction.setEnabled(false);
            } else {
                this._replaceAllAction.setEnabled(true);
            }
        } else {
            throw new UnexpectedException(new RuntimeException("FindReplacePanel should not be listening to anything"));
        }
        this._frame.clearStatusMessage();
    }

    public void stopListening() {
        if (this._defPane != null) {
            this._defPane.removeCaretListener(this._caretListener);
            this._defPane = null;
            this._displayed = false;
            this._frame.clearStatusMessage();
        }
    }

    private void _doFind() {
        if (this._findField.getText().length() > 0) {
            this._model.addToBrowserHistory();
            this._updateMachine();
            this._machine.setFindWord(this._findField.getText());
            this._machine.setReplaceWord(this._replaceField.getText());
            this._frame.clearStatusMessage();
            boolean searchAll = this._machine.getSearchAllDocuments();
            FindResult fr = this._machine.findNext();
            OpenDefinitionsDocument doc = fr.getDocument();
            OpenDefinitionsDocument matchDoc = this._model.getODDForDocument(doc);
            OpenDefinitionsDocument openDoc = this._defPane.getOpenDefDocument();
            int pos = fr.getFoundOffset();
            if (searchAll) {
                if (!matchDoc.equals(openDoc)) {
                    this._model.setActiveDocument(matchDoc);
                } else {
                    this._model.refreshActiveDocument();
                }
            }
            if (fr.getWrapped() && !searchAll) {
                Toolkit.getDefaultToolkit().beep();
                if (!this._machine.getSearchBackwards()) {
                    this._frame.setStatusMessage("Search wrapped to beginning.");
                } else {
                    this._frame.setStatusMessage("Search wrapped to end.");
                }
            }
            if (fr.getAllDocsWrapped() && searchAll) {
                Toolkit.getDefaultToolkit().beep();
                this._frame.setStatusMessage("Search wrapped around all documents.");
            }
            if (pos >= 0) {
                Caret c = this._defPane.getCaret();
                c.setDot(c.getDot());
                this._defPane.setCaretPosition(pos);
                this._caretChanged = true;
                this._updateMachine();
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        FindReplacePanel.access$1600(FindReplacePanel.this);
                        FindReplacePanel.access$000(FindReplacePanel.this).setEnabled(true);
                        FindReplacePanel.access$100(FindReplacePanel.this).setEnabled(true);
                        FindReplacePanel.access$200(FindReplacePanel.this).setEnabled(true);
                        FindReplacePanel.access$300(FindReplacePanel.this).setLastFindWord();
                    }
                });
            } else {
                Toolkit.getDefaultToolkit().beep();
                StringBuffer statusMessage = new StringBuffer("Search text \"");
                if (this._machine.getFindWord().length() <= 50) {
                    statusMessage.append(this._machine.getFindWord());
                } else {
                    statusMessage.append(this._machine.getFindWord().substring(0, 49) + "...");
                }
                statusMessage.append("\" not found.");
                this._frame.setStatusMessage(statusMessage.toString());
            }
        }
        if (!DrJava.getConfig().getSetting(OptionConstants.FIND_REPLACE_FOCUS_IN_DEFPANE).booleanValue()) {
            this._findField.requestFocusInWindow();
        }
    }

    protected void _close() {
        this._defPane.requestFocusInWindow();
        if (this._displayed) {
            this.stopListening();
        }
        super._close();
    }

    public void setSearchBackwards(boolean b) {
        this._machine.setSearchBackwards(b);
    }

    public boolean getSearchBackwards() {
        return this._machine.getSearchBackwards();
    }

    public void setFieldFont(Font f) {
        this._findField.setFont(f);
        this._replaceField.setFont(f);
    }

    public void updateFirstDocInSearch() {
        this._machine.setFirstDoc(this._model.getActiveDocument());
    }

    private void _updateMachine() {
        if (this._caretChanged) {
            OpenDefinitionsDocument doc = this._model.getActiveDocument();
            this._machine.setDocument(doc);
            if (this._machine.getFirstDoc() == null) {
                this._machine.setFirstDoc(doc);
            }
            this._machine.setPosition(this._defPane.getCaretPosition());
            this._caretChanged = false;
        }
    }

    private void _selectReplacedItem(int length) {
        int to = this._machine.getCurrentOffset();
        int from = this._machine.getSearchBackwards() ? to + length : to - length;
        this._selectFoundItem(from, to);
    }

    private void _selectFoundItem() {
        int position;
        int to = position = this._machine.getCurrentOffset();
        int from = !this._machine.getSearchBackwards() ? position - this._machine.getFindWord().length() : position + this._machine.getFindWord().length();
        this._selectFoundItem(from, to);
    }

    private void _selectFoundItem(int from, int to) {
        this._defPane.centerViewOnOffset(from);
        this._defPane.select(from, to);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                FindReplacePanel.access$900(FindReplacePanel.this).getCaret().setSelectionVisible(true);
            }
        });
    }

    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }

    public DefinitionsPane getDefPane() {
        return this._defPane;
    }

    public JButton getFindNextButton() {
        return this._findNextButton;
    }

    static Action access$000(FindReplacePanel x0) {
        return x0._replaceAction;
    }

    static Action access$100(FindReplacePanel x0) {
        return x0._replaceFindNextAction;
    }

    static Action access$200(FindReplacePanel x0) {
        return x0._replaceFindPreviousAction;
    }

    static FindReplaceMachine access$300(FindReplacePanel x0) {
        return x0._machine;
    }

    static boolean access$402(FindReplacePanel x0, boolean x1) {
        x0._caretChanged = x1;
        return x0._caretChanged;
    }

    static JTextPane access$500(FindReplacePanel x0) {
        return x0._findField;
    }

    static SingleDisplayModel access$600(FindReplacePanel x0) {
        return x0._model;
    }

    static void access$700(FindReplacePanel x0) {
        x0._updateMachine();
    }

    static JTextPane access$800(FindReplacePanel x0) {
        return x0._replaceField;
    }

    static DefinitionsPane access$900(FindReplacePanel x0) {
        return x0._defPane;
    }

    static void access$1000(FindReplacePanel x0) {
        x0._doFind();
    }

    static void access$1100(FindReplacePanel x0, int x1) {
        x0._selectReplacedItem(x1);
    }

    static JButton access$1200(FindReplacePanel x0) {
        return x0._replaceButton;
    }

    static JButton access$1300(FindReplacePanel x0) {
        return x0._replaceFindNextButton;
    }

    static JButton access$1400(FindReplacePanel x0) {
        return x0._replaceFindPreviousButton;
    }

    static Action access$1500(FindReplacePanel x0) {
        return x0._replaceAllAction;
    }

    static void access$1600(FindReplacePanel x0) {
        x0._selectFoundItem();
    }
}

