/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.ui;

import edu.rice.cs.drjava.DrJava;
import edu.rice.cs.drjava.Version;
import edu.rice.cs.drjava.platform.PlatformFactory;
import edu.rice.cs.drjava.ui.DrJavaErrorWindow;
import edu.rice.cs.drjava.ui.MainFrame;
import edu.rice.cs.util.StringOps;
import edu.rice.cs.util.UnexpectedException;
import edu.rice.cs.util.swing.BorderlessScrollPane;
import edu.rice.cs.util.swing.UneditableTableModel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.net.URL;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class AboutDialog
extends JDialog
implements ActionListener {
    private static ImageInfo CSLOGO = new ImageInfo("RiceCS.gif", new Color(4339077));
    private static ImageInfo SF = new ImageInfo("SourceForge.gif", Color.black);
    private static ImageInfo DRJAVA = new ImageInfo("DrJava.png", new Color(0xCCCCFF));
    private final JButton _okButton = new JButton("OK");
    private JButton _copyButton;
    private JTable _propertiesTable;
    private int _propertiesTabIndex;
    private final JTabbedPane _tabs = new JTabbedPane();
    public static final String COPYRIGHT = "Copyright \u00a9 2001-2006 JavaPLT group at Rice University\n(javaplt@rice.edu)\n\nSee http://www.drjava.org for more information on DrJava or to\nobtain the latest version of the program or its source code.\n\nDrJava is free software; you can redistribute it and/or modify\nit under the terms of the DrJava Open Source License.  A copy\nof the license should have been included in the documentation\nfor this software.";
    private static String LICENSE;
    private static boolean initLicense;
    public static final String DYADE_LICENSE = "DynamicJava - Copyright \u00a9 1999 Dyade\n\nPermission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the \"Software\"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:\n\nThe above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.\n\nTHE SOFTWARE IS PROVIDED \"AS IS\", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL DYADE BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.\n\nExcept as contained in this notice, the name of Dyade shall not be used in advertising or otherwise to promote the sale, use or other dealings in this Software without prior written authorization from Dyade.";
    public static final String INTRODUCTION = "DrJava is a pedagogic programming environment for Java, intended to help students focus more on program design than on the features of a complicated development environment. It provides an Interactions window based on a \"read-eval-print loop\", which allows programmers to develop, test, and debug Java programs in an interactive, incremental fashion.\n\nHome Page: http://www.drjava.org\nPaper: http://drjava.sf.net/papers/drjava-paper.shtml";
    private static final /* synthetic */ Class class$edu$rice$cs$drjava$ui$AboutDialog;

    public AboutDialog(JFrame owner) {
        super(owner, "About DrJava", true);
        this.buildGUI(this.getContentPane());
        this.getRootPane().setDefaultButton(this._okButton);
        this.setSize(550, 400);
    }

    public void setVisible(boolean vis) {
        this._tabs.remove(0);
        AboutDialog.addTab(this._tabs, "About", AboutDialog.createCopyrightTab(), 0);
        this._tabs.setSelectedIndex(0);
        if (vis) {
            MainFrame.setPopupLoc(this, this.getOwner());
        }
        super.setVisible(vis);
    }

    public void buildGUI(Container cp) {
        cp.setLayout(new BorderLayout());
        JLabel drjava = AboutDialog.createImageLabel(DRJAVA, 2);
        if (drjava != null) {
            drjava.setBorder(new CompoundBorder(new EmptyBorder(5, 5, 5, 5), drjava.getBorder()));
            drjava.setCursor(new Cursor(12));
            String url = "http://drjava.org/";
            drjava.setToolTipText("http://drjava.org/");
            drjava.addMouseListener(new MouseListener(){

                public void mousePressed(MouseEvent e) {
                }

                public void mouseReleased(MouseEvent e) {
                }

                public void mouseEntered(MouseEvent e) {
                }

                public void mouseExited(MouseEvent e) {
                }

                public void mouseClicked(MouseEvent e) {
                    try {
                        PlatformFactory.ONLY.openURL(new URL("http://drjava.org/"));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
            JPanel djPanel = new JPanel(new GridLayout(1, 1));
            djPanel.add(drjava);
            djPanel.setBorder(new CompoundBorder(new EmptyBorder(5, 5, 5, 5), new EtchedBorder()));
            cp.add((Component)djPanel, "North");
        }
        AboutDialog.addTab(this._tabs, "About", AboutDialog.createCopyrightTab());
        LICENSE = AboutDialog.getLicense();
        if (LICENSE != null) {
            AboutDialog.addTab(this._tabs, "DrJava License", AboutDialog.createTextScroller(LICENSE));
        }
        AboutDialog.addTab(this._tabs, "DynamicJava License", AboutDialog.createTextScroller(DYADE_LICENSE));
        AboutDialog.addTab(this._tabs, "System Properties", this.createSysPropTab());
        this._propertiesTabIndex = this._tabs.getTabCount() - 1;
        cp.add((Component)this.createBottomBar(), "South");
        cp.add((Component)this._tabs, "Center");
    }

    private JComponent createSysPropTab() {
        Properties props = System.getProperties();
        int size = props.size();
        Object[][] rowData = new String[size][2];
        Iterator<Map.Entry<Object, Object>> entries = props.entrySet().iterator();
        int rowNum = 0;
        while (entries.hasNext()) {
            Map.Entry<Object, Object> entry = entries.next();
            rowData[rowNum][0] = (String)entry.getKey();
            rowData[rowNum][1] = (String)entry.getValue();
            ++rowNum;
        }
        Arrays.sort(rowData, new Comparator<String[]>(){

            @Override
            public int compare(String[] o1, String[] o2) {
                return o1[0].compareTo(o2[0]);
            }

            @Override
            public int compare(Object x0, Object x1) {
                return this.compare((String[])x0, (String[])x1);
            }
        });
        Object[] nvStrings = new String[]{"Name", "Value"};
        UneditableTableModel model = new UneditableTableModel(rowData, nvStrings);
        this._propertiesTable = new JTable(model);
        BorderlessScrollPane scroller = new BorderlessScrollPane(this._propertiesTable);
        AboutDialog.wrapBorder(scroller, new EmptyBorder(5, 0, 0, 0));
        JPanel propTab = new JPanel(new BorderLayout());
        propTab.add((Component)new JLabel("Current system properties:"), "North");
        propTab.add((Component)scroller, "Center");
        return propTab;
    }

    private static void addTab(JTabbedPane tabs, String title, JComponent tab) {
        AboutDialog.wrapBorder(tab, new EmptyBorder(5, 6, 6, 5));
        tabs.addTab(title, tab);
    }

    private static void addTab(JTabbedPane tabs, String title, JComponent tab, int i) {
        AboutDialog.wrapBorder(tab, new EmptyBorder(5, 6, 6, 5));
        tabs.insertTab(title, null, tab, "", i);
    }

    public static JComponent createCopyrightTab() {
        JPanel panel = new JPanel(new BorderLayout());
        StringBuffer sb = new StringBuffer("DrJava Version : ");
        sb.append(Version.getBuildTimeString());
        sb.append("\n\nDrJava Configuration file: ");
        sb.append(DrJava.getPropertiesFile().getAbsolutePath());
        sb.append("\n\nUsed memory: about ");
        sb.append(StringOps.memSizeToString(Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()));
        sb.append("\nFree memory: about ");
        sb.append(StringOps.memSizeToString(Runtime.getRuntime().freeMemory()));
        sb.append("\nTotal memory: about ");
        sb.append(StringOps.memSizeToString(Runtime.getRuntime().totalMemory()));
        sb.append("\nTotal memory can expand to: about ");
        sb.append(StringOps.memSizeToString(Runtime.getRuntime().maxMemory()));
        sb.append("\n\n");
        sb.append(COPYRIGHT);
        JScrollPane copy = AboutDialog.createTextScroller(sb.toString());
        AboutDialog.wrapBorder(copy, new EmptyBorder(0, 0, 5, 0));
        LogoList logos = new LogoList(null);
        LogoList.access$100(logos, AboutDialog.createBorderedLabel(CSLOGO, new EmptyBorder(5, 5, 5, 5)), "http://compsci.rice.edu/");
        LogoList.access$100(logos, AboutDialog.createBorderedLabel(SF, null), "http://sourceforge.net/projects/drjava/");
        LogoList.access$200(logos);
        JPanel logoPanel = new JPanel();
        logoPanel.setLayout(new BoxLayout(logoPanel, 0));
        logoPanel.add(Box.createHorizontalGlue());
        Iterator it = logos.iterator();
        while (it.hasNext()) {
            JComponent l = (JComponent)it.next();
            logoPanel.add(l);
            l.setCursor(new Cursor(12));
            final String url = (String)l.getClientProperty("url");
            if (url != null) {
                l.setToolTipText(url);
                l.addMouseListener(new MouseListener(){

                    public void mousePressed(MouseEvent e) {
                    }

                    public void mouseReleased(MouseEvent e) {
                    }

                    public void mouseEntered(MouseEvent e) {
                    }

                    public void mouseExited(MouseEvent e) {
                    }

                    public void mouseClicked(MouseEvent e) {
                        try {
                            PlatformFactory.ONLY.openURL(new URL(url));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                });
            }
            logoPanel.add(Box.createHorizontalGlue());
        }
        panel.add((Component)logoPanel, "South");
        panel.add((Component)copy, "Center");
        return panel;
    }

    public static JPanel createBorderedLabel(ImageInfo info, EmptyBorder pad) {
        JLabel label = AboutDialog.createImageLabel(info, 0);
        if (label == null) {
            return null;
        }
        JPanel panel = new JPanel(new GridLayout(1, 1));
        panel.setOpaque(true);
        panel.setBackground(ImageInfo.access$300(info));
        panel.setBorder(pad);
        AboutDialog.wrapBorder(panel, new EtchedBorder());
        panel.add(label);
        return panel;
    }

    public static JLabel createImageLabel(ImageInfo info, int align) {
        ImageIcon icon = MainFrame.getIcon(ImageInfo.access$400(info));
        if (icon == null) {
            return null;
        }
        JLabel label = new JLabel(icon, align);
        label.setOpaque(true);
        label.setBackground(ImageInfo.access$300(info));
        return label;
    }

    public static JTextArea createTextArea(String text) {
        JTextArea textArea = new JTextArea(text);
        textArea.setEditable(false);
        textArea.setLineWrap(true);
        textArea.setWrapStyleWord(true);
        textArea.setCaretPosition(0);
        return textArea;
    }

    public static JScrollPane createTextScroller(String text) {
        return new BorderlessScrollPane(AboutDialog.createTextArea(text));
    }

    private JPanel createBottomBar() {
        JPanel panel = new JPanel(new BorderLayout());
        JPanel buttonPanel = new JPanel();
        this._copyButton = new JButton(new AbstractAction("Copy System Properties"){

            public void actionPerformed(ActionEvent e) {
                Clipboard cb = Toolkit.getDefaultToolkit().getSystemClipboard();
                StringSelection contents = new StringSelection(DrJavaErrorWindow.getSystemAndDrJavaInfo());
                cb.setContents(contents, null);
            }
        });
        this._tabs.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                AboutDialog.access$700(AboutDialog.this).setVisible(AboutDialog.access$500(AboutDialog.this).getSelectedIndex() == AboutDialog.access$600(AboutDialog.this));
            }
        });
        this._copyButton.setVisible(this._tabs.getSelectedIndex() == this._propertiesTabIndex);
        this._okButton.addActionListener(this);
        buttonPanel.add(this._copyButton);
        buttonPanel.add(this._okButton);
        panel.add((Component)buttonPanel, "East");
        AboutDialog.wrapBorder(panel, new EmptyBorder(5, 5, 5, 5));
        return panel;
    }

    public void actionPerformed(ActionEvent e) {
        this.setVisible(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getLicense() {
        block11: {
            if (initLicense) {
                return LICENSE;
            }
            try {
                InputStream is = (class$edu$rice$cs$drjava$ui$AboutDialog == null ? (class$edu$rice$cs$drjava$ui$AboutDialog = AboutDialog.class$("edu.rice.cs.drjava.ui.AboutDialog")) : class$edu$rice$cs$drjava$ui$AboutDialog).getResourceAsStream("/edu/rice/cs/LICENSE");
                if (is == null) break block11;
                BufferedReader r = new BufferedReader(new InputStreamReader(is));
                try {
                    StringBuffer sb = new StringBuffer();
                    String s = r.readLine();
                    while (s != null) {
                        int lastSig;
                        for (lastSig = s.length() - 1; lastSig >= 0 && Character.isWhitespace(s.charAt(lastSig)); --lastSig) {
                        }
                        if (lastSig < 0) {
                            sb.append("\n");
                        } else {
                            sb.append(s.substring(0, lastSig + 1));
                            sb.append('\n');
                        }
                        s = r.readLine();
                    }
                    LICENSE = sb.toString();
                    if ((LICENSE = LICENSE.trim()).length() == 0) {
                        LICENSE = null;
                    }
                }
                finally {
                    is.close();
                    r.close();
                }
            }
            catch (Exception e) {
                throw new UnexpectedException(e, StringOps.getStackTrace(e));
            }
        }
        initLicense = true;
        return LICENSE;
    }

    private static void wrapBorder(JComponent c, Border b) {
        c.setBorder(new CompoundBorder(b, c.getBorder()));
    }

    static JTabbedPane access$500(AboutDialog x0) {
        return x0._tabs;
    }

    static int access$600(AboutDialog x0) {
        return x0._propertiesTabIndex;
    }

    static JButton access$700(AboutDialog x0) {
        return x0._copyButton;
    }

    static {
        initLicense = false;
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        Class<?> clazz;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(classNotFoundException.getMessage());
            try {
                noClassDefFoundError.initCause(classNotFoundException);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            throw noClassDefFoundError;
        }
        return clazz;
    }

    public static class ImageInfo {
        private final String name;
        private final Color color;

        public ImageInfo(String name, Color color) {
            this.name = name;
            this.color = color;
        }

        static Color access$300(ImageInfo x0) {
            return x0.color;
        }

        static String access$400(ImageInfo x0) {
            return x0.name;
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LogoList
    extends LinkedList<JPanel>
    implements Serializable {
        private int width = Integer.MIN_VALUE;
        private int height = Integer.MIN_VALUE;

        private LogoList() {
        }

        private void addLogo(JPanel logo, String url) {
            if (logo != null) {
                Dimension d = logo.getMinimumSize();
                this.width = Math.max(this.width, d.width);
                this.height = Math.max(this.height, d.height);
                this.add(logo);
                if (url != null) {
                    logo.putClientProperty("url", url);
                }
            }
        }

        private void resizeLogos() {
            Iterator it = this.iterator();
            Dimension d = new Dimension(this.width, this.height);
            while (it.hasNext()) {
                JComponent i = (JComponent)it.next();
                i.setMinimumSize(d);
                i.setMaximumSize(d);
                i.setPreferredSize(d);
            }
        }

        LogoList(1 x0) {
            this();
        }

        static void access$100(LogoList x0, JPanel x1, String x2) {
            x0.addLogo(x1, x2);
        }

        static void access$200(LogoList x0) {
            x0.resizeLogos();
        }
    }
}

