/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.project;

import edu.rice.cs.drjava.Version;
import edu.rice.cs.drjava.model.DocumentRegion;
import edu.rice.cs.drjava.model.debug.DebugBreakpointData;
import edu.rice.cs.drjava.model.debug.DebugWatchData;
import edu.rice.cs.drjava.project.DocFile;
import edu.rice.cs.drjava.project.DocumentInfoGetter;
import edu.rice.cs.drjava.project.ProjectFileIR;
import edu.rice.cs.plt.io.IOUtil;
import edu.rice.cs.plt.tuple.Pair;
import edu.rice.cs.util.FileOps;
import edu.rice.cs.util.StringOps;
import edu.rice.cs.util.UnexpectedException;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectProfile
implements ProjectFileIR {
    private List<DocFile> _sourceFiles = new ArrayList<DocFile>();
    private List<DocFile> _auxFiles = new ArrayList<DocFile>();
    private List<String> _collapsedPaths = new ArrayList<String>();
    private File _buildDir = null;
    private File _workDir = null;
    private List<File> _classPathFiles = new ArrayList<File>();
    private File _mainClass = null;
    private File _projectRoot;
    private File _projectFile;
    private File _createJarFile = null;
    private int _createJarFlags = 0;
    private List<DocumentRegion> _bookmarks = new ArrayList<DocumentRegion>();
    private List<DebugBreakpointData> _breakpoints = new ArrayList<DebugBreakpointData>();
    private List<DebugWatchData> _watches = new ArrayList<DebugWatchData>();
    static final /* synthetic */ boolean $assertionsDisabled;
    private static final /* synthetic */ Class class$edu$rice$cs$drjava$project$ProjectProfile;

    public ProjectProfile(String fileName) throws IOException {
        this(new File(fileName));
    }

    public ProjectProfile(File f) throws IOException {
        this._projectFile = f;
        this._projectRoot = this._projectFile.getParentFile();
        if (!this._projectRoot.exists()) {
            throw new IOException(new StringBuffer().append("Parent directory of project root ").append(this._projectRoot).append(" does not exist").toString());
        }
    }

    @Override
    public DocFile[] getSourceFiles() {
        return this._sourceFiles.toArray(new DocFile[this._sourceFiles.size()]);
    }

    @Override
    public DocFile[] getAuxiliaryFiles() {
        return this._auxFiles.toArray(new DocFile[this._auxFiles.size()]);
    }

    @Override
    public File getProjectFile() {
        return this._projectFile;
    }

    @Override
    public File getBuildDirectory() {
        return this._buildDir;
    }

    @Override
    public File getWorkingDirectory() {
        return this._workDir;
    }

    @Override
    public String[] getCollapsedPaths() {
        return this._collapsedPaths.toArray(new String[this._collapsedPaths.size()]);
    }

    @Override
    public File[] getClassPaths() {
        return this._classPathFiles.toArray(new File[this._classPathFiles.size()]);
    }

    @Override
    public File getMainClass() {
        return this._mainClass;
    }

    @Override
    public File getProjectRoot() {
        return this._projectRoot;
    }

    @Override
    public File getCreateJarFile() {
        return this._createJarFile;
    }

    @Override
    public int getCreateJarFlags() {
        return this._createJarFlags;
    }

    @Override
    public DocumentRegion[] getBookmarks() {
        return this._bookmarks.toArray(new DocumentRegion[this._bookmarks.size()]);
    }

    @Override
    public DebugBreakpointData[] getBreakpoints() {
        return this._breakpoints.toArray(new DebugBreakpointData[this._breakpoints.size()]);
    }

    @Override
    public DebugWatchData[] getWatches() {
        return this._watches.toArray(new DebugWatchData[this._watches.size()]);
    }

    public void addSourceFile(DocFile df) {
        this._sourceFiles.add(df);
    }

    public void addSourceFile(DocumentInfoGetter getter) {
        if (!getter.isUntitled()) {
            try {
                this.addSourceFile(this.docFileFromGetter(getter));
            }
            catch (IOException e) {
                throw new UnexpectedException(e);
            }
        }
    }

    public void addAuxiliaryFile(DocFile df) {
        this._auxFiles.add(df);
    }

    public void addAuxiliaryFile(DocumentInfoGetter getter) {
        if (!getter.isUntitled()) {
            try {
                this.addAuxiliaryFile(this.docFileFromGetter(getter));
            }
            catch (IOException e) {
                throw new UnexpectedException(e);
            }
        }
    }

    public void addClassPathFile(File cp) {
        if (cp != null) {
            this._classPathFiles.add(cp);
        }
    }

    public void addCollapsedPath(String cp) {
        if (cp != null) {
            this._collapsedPaths.add(cp);
        }
    }

    @Override
    public void setBuildDirectory(File dir) {
        this._buildDir = dir;
    }

    @Override
    public void setWorkingDirectory(File dir) {
        this._workDir = FileOps.validate(dir);
    }

    @Override
    public void setMainClass(File main) {
        this._mainClass = main;
    }

    @Override
    public void setSourceFiles(List<DocFile> sf) {
        this._sourceFiles = new ArrayList<DocFile>(sf);
    }

    @Override
    public void setClassPaths(List<? extends File> cpf) {
        this._classPathFiles = new ArrayList<File>(cpf);
    }

    @Override
    public void setCollapsedPaths(List<String> cp) {
        this._collapsedPaths = new ArrayList<String>(cp);
    }

    @Override
    public void setAuxiliaryFiles(List<DocFile> af) {
        this._auxFiles = new ArrayList<DocFile>(af);
    }

    @Override
    public void setProjectRoot(File root) {
        this._projectRoot = root;
        if (!$assertionsDisabled && root.getParentFile() == null) {
            throw new AssertionError();
        }
    }

    @Override
    public void setCreateJarFile(File createJarFile) {
        this._createJarFile = createJarFile;
    }

    @Override
    public void setCreateJarFlags(int createJarFlags) {
        this._createJarFlags = createJarFlags;
    }

    @Override
    public void setBookmarks(List<? extends DocumentRegion> bms) {
        this._bookmarks = new ArrayList<DocumentRegion>(bms);
    }

    @Override
    public void setBreakpoints(List<? extends DebugBreakpointData> bps) {
        this._breakpoints = new ArrayList<DebugBreakpointData>(bps);
    }

    @Override
    public void setWatches(List<? extends DebugWatchData> ws) {
        this._watches = new ArrayList<DebugWatchData>(ws);
    }

    public void write() throws IOException {
        FileWriter fw = new FileWriter(this._projectFile);
        fw.write(new StringBuffer().append(";; DrJava project file, written by build ").append(Version.getBuildTimeString()).toString());
        fw.write(new StringBuffer().append("\n;; files in the source tree are relative to: ").append(this._projectRoot.getCanonicalPath()).toString());
        fw.write("\n;; other files with relative paths are rooted at (the parent of) this project file");
        if (this._projectRoot != null) {
            fw.write("\n(proj-root-and-base");
            fw.write(new StringBuffer().append("\n").append(this.encodeFileRelative(this._projectRoot, "  ", this._projectFile)).toString());
            fw.write(")");
        } else {
            fw.write("\n;; no project root; should never happen");
        }
        if (!this._sourceFiles.isEmpty()) {
            fw.write("\n(source-files");
            DocFile active = null;
            for (DocFile df : this._sourceFiles) {
                if (!df.isActive()) continue;
                active = df;
                fw.write(new StringBuffer().append("\n").append(this.encodeDocFileRelative(df, "  ")).toString());
                break;
            }
            for (DocFile df : this._sourceFiles) {
                if (df == active) continue;
                fw.write(new StringBuffer().append("\n").append(this.encodeDocFileRelative(df, "  ")).toString());
            }
            fw.write(")");
        } else {
            fw.write("\n;; no source files");
        }
        if (!this._auxFiles.isEmpty()) {
            fw.write("\n(auxiliary");
            for (DocFile df : this._auxFiles) {
                fw.write(new StringBuffer().append("\n").append(this.encodeDocFileAbsolute(df, "  ")).toString());
            }
            fw.write(")");
        } else {
            fw.write("\n;; no aux files");
        }
        if (!this._collapsedPaths.isEmpty()) {
            fw.write("\n(collapsed");
            for (String s : this._collapsedPaths) {
                fw.write(new StringBuffer().append("\n  (path ").append(StringOps.convertToLiteral(s)).append(")").toString());
            }
            fw.write(")");
        } else {
            fw.write("\n;; no collapsed branches");
        }
        if (!this._classPathFiles.isEmpty()) {
            fw.write("\n(classpaths");
            for (File f : this._classPathFiles) {
                fw.write(new StringBuffer().append("\n").append(this.encodeFileAbsolute(f, "  ")).toString());
            }
            fw.write(")");
        } else {
            fw.write("\n;; no classpaths files");
        }
        if (this._buildDir != null && this._buildDir.getPath() != "") {
            fw.write("\n(build-dir");
            fw.write(new StringBuffer().append("\n").append(this.encodeFileRelative(this._buildDir, "  ", this._projectFile)).toString());
            fw.write(")");
        } else {
            fw.write("\n;; no build directory");
        }
        if (this._workDir != null && this._workDir.getPath() != "") {
            fw.write("\n(work-dir");
            fw.write(new StringBuffer().append("\n").append(this.encodeFileRelative(this._workDir, "  ", this._projectFile)).toString());
            fw.write(")");
        } else {
            fw.write("\n;; no working directory");
        }
        if (this._mainClass != null) {
            fw.write("\n;; rooted at the (parent of the) project file");
            fw.write("\n(main-class");
            fw.write(new StringBuffer().append("\n").append(this.encodeFileRelative(this._mainClass, "  ", this._projectFile)).toString());
            fw.write(")");
        } else {
            fw.write("\n;; no main class");
        }
        if (!this._breakpoints.isEmpty()) {
            fw.write("\n(breakpoints");
            for (DebugBreakpointData bp : this._breakpoints) {
                fw.write(new StringBuffer().append("\n").append(this.encodeBreakpointRelative(bp, "  ")).toString());
            }
            fw.write(")");
        } else {
            fw.write("\n;; no breakpoints");
        }
        if (!this._watches.isEmpty()) {
            fw.write("\n(watches");
            for (DebugWatchData w : this._watches) {
                fw.write(new StringBuffer().append("\n").append(this.encodeWatch(w, "  ")).toString());
            }
            fw.write(")");
        } else {
            fw.write("\n;; no watches");
        }
        if (!this._bookmarks.isEmpty()) {
            fw.write("\n(bookmarks");
            for (DocumentRegion bm : this._bookmarks) {
                fw.write(new StringBuffer().append("\n").append(this.encodeBookmarkRelative(bm, "  ")).toString());
            }
            fw.write(")");
        } else {
            fw.write("\n;; no bookmarks");
        }
        fw.close();
    }

    private DocFile docFileFromGetter(DocumentInfoGetter g) throws IOException {
        return new DocFile(g.getFile().getCanonicalPath(), g.getSelection(), g.getScroll(), g.isActive(), g.getPackage());
    }

    private String encodeFileRelative(File f, String prefix, File base) throws IOException {
        String path = FileOps.makeRelativeTo(f, base).getPath();
        path = StringOps.replace(path, File.separator, "/");
        return new StringBuffer().append(prefix).append("(file (name ").append(StringOps.convertToLiteral(path)).append("))").toString();
    }

    private String encodeFileRelative(File f, String prefix) throws IOException {
        return this.encodeFileRelative(f, prefix, this._projectRoot);
    }

    private String encodeFileAbsolute(File f, String prefix) throws IOException {
        String path = f.getCanonicalPath();
        path = StringOps.replace(path, File.separator, "/");
        return new StringBuffer().append(prefix).append("(file (name ").append(StringOps.convertToLiteral(path)).append("))").toString();
    }

    private String encodeDocFile(DocFile df, String prefix, boolean relative) throws IOException {
        String pack;
        String ret = "";
        String path = relative ? FileOps.makeRelativeTo(df, this._projectRoot).getPath() : IOUtil.attemptCanonicalFile(df).getPath();
        path = StringOps.replace(path, File.separator, "/");
        ret = new StringBuffer().append(ret).append(prefix).append("(file (name ").append(StringOps.convertToLiteral(path)).append(")").toString();
        Pair<Integer, Integer> p1 = df.getSelection();
        Pair<Integer, Integer> p2 = df.getScroll();
        long modDate = df.lastModified();
        if (p1 != null || p2 != null) {
            ret = new StringBuffer().append(ret).append("\n").append(prefix).append("      ").toString();
        }
        if (p1 != null) {
            ret = new StringBuffer().append(ret).append("(select ").append(p1.first()).append(" ").append(p1.second()).append(")").toString();
        }
        if (p2 != null) {
            ret = new StringBuffer().append(ret).append("(scroll ").append(p2.first()).append(" ").append(p2.second()).append(")").toString();
        }
        if (modDate > 0L) {
            String s = new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss").format(new Date(modDate));
            ret = new StringBuffer().append(ret).append("(mod-date ").append(StringOps.convertToLiteral(s)).append(")").toString();
        }
        if ((pack = df.getPackage()) != null) {
            ret = new StringBuffer().append(ret).append("\n").append(prefix).append("      ").toString();
            ret = new StringBuffer().append(ret).append("(package ").append(StringOps.convertToLiteral(pack)).append(")").toString();
        }
        ret = new StringBuffer().append(ret).append(")").toString();
        return ret;
    }

    private String encodeDocFileRelative(DocFile df, String prefix) throws IOException {
        return this.encodeDocFile(df, prefix, true);
    }

    private String encodeDocFileAbsolute(DocFile df, String prefix) throws IOException {
        return this.encodeDocFile(df, prefix, false);
    }

    private String encodeBreakpointRelative(DebugBreakpointData bp, String prefix) throws IOException {
        String ret = "";
        String path = FileOps.makeRelativeTo(bp.getFile(), this._projectRoot).getPath();
        path = StringOps.replace(path, File.separator, "/");
        ret = new StringBuffer().append(ret).append(prefix).append("(breakpoint (name ").append(StringOps.convertToLiteral(path)).append(")").toString();
        int offset = bp.getOffset();
        int lineNumber = bp.getLineNumber();
        ret = new StringBuffer().append(ret).append("\n").append(prefix).append("      ").toString();
        ret = new StringBuffer().append(ret).append("(offset ").append(offset).append(")").toString();
        ret = new StringBuffer().append(ret).append("(line ").append(lineNumber).append(")").toString();
        if (bp.isEnabled()) {
            ret = new StringBuffer().append(ret).append("(enabled)").toString();
        }
        ret = new StringBuffer().append(ret).append(")").toString();
        return ret;
    }

    private String encodeWatch(DebugWatchData w, String prefix) throws IOException {
        String ret = "";
        ret = new StringBuffer().append(ret).append(prefix).append("(watch ").append(StringOps.convertToLiteral(w.getName())).append(")").toString();
        return ret;
    }

    private String encodeBookmarkRelative(DocumentRegion bp, String prefix) throws IOException {
        String ret = "";
        String path = FileOps.makeRelativeTo(bp.getDocument().getFile(), this._projectRoot).getPath();
        path = StringOps.replace(path, File.separator, "/");
        ret = new StringBuffer().append(ret).append(prefix).append("(bookmark (name ").append(StringOps.convertToLiteral(path)).append(")").toString();
        int startOffset = bp.getStartOffset();
        int endOffset = bp.getEndOffset();
        ret = new StringBuffer().append(ret).append("\n").append(prefix).append("      ").toString();
        ret = new StringBuffer().append(ret).append("(start ").append(startOffset).append(")").toString();
        ret = new StringBuffer().append(ret).append("(end ").append(endOffset).append(")").toString();
        ret = new StringBuffer().append(ret).append(")").toString();
        return ret;
    }

    static {
        $assertionsDisabled = !(class$edu$rice$cs$drjava$project$ProjectProfile == null ? (class$edu$rice$cs$drjava$project$ProjectProfile = ProjectProfile.class$("edu.rice.cs.drjava.project.ProjectProfile")) : class$edu$rice$cs$drjava$project$ProjectProfile).desiredAssertionStatus();
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        Class<?> clazz;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(classNotFoundException.getMessage());
            try {
                noClassDefFoundError.initCause(classNotFoundException);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            throw noClassDefFoundError;
        }
        return clazz;
    }
}

