/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.model.definitions.indent;

import edu.rice.cs.drjava.model.AbstractDJDocument;
import edu.rice.cs.drjava.model.definitions.indent.ActionStartPrevLinePlusMultiline;
import edu.rice.cs.drjava.model.definitions.indent.IndentRuleAction;
import edu.rice.cs.util.UnexpectedException;
import javax.swing.text.BadLocationException;

class ActionStartPrevLinePlusMultilinePreserve
extends IndentRuleAction {
    private String[] _suffices;
    private int _cursorLine;
    private int _cursorPos;
    private int _psrvLine;
    private int _psrvPos;

    public ActionStartPrevLinePlusMultilinePreserve(String[] suffices, int cursorLine, int cursorPos, int psrvLine, int psrvPos) {
        this._suffices = suffices;
        this._cursorLine = cursorLine;
        this._cursorPos = cursorPos;
        this._psrvLine = psrvLine;
        this._psrvPos = psrvPos;
    }

    public boolean indentLine(AbstractDJDocument doc, int reason) {
        try {
            String[] suffices = new String[this._suffices.length];
            for (int i = 0; i < this._suffices.length; ++i) {
                suffices[i] = this._suffices[i];
            }
            int here = doc.getCurrentLocation();
            int lineStart = doc.getLineStartPos(here);
            int lineEnd = doc.getLineEndPos(here);
            int lineLength = lineEnd - lineStart;
            String preserved = doc.getText(lineStart, lineLength);
            doc.remove(lineStart, lineLength);
            String prefix = suffices[this._psrvLine].substring(0, this._psrvPos);
            String suffix = suffices[this._psrvLine].substring(this._psrvPos);
            suffices[this._psrvLine] = prefix + preserved + suffix;
            ActionStartPrevLinePlusMultiline a = new ActionStartPrevLinePlusMultiline(suffices, this._cursorLine, this._cursorPos);
            return a.indentLine(doc, reason);
        }
        catch (BadLocationException e) {
            throw new UnexpectedException(e);
        }
    }
}

