/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.model.compiler;

import com.sun.tools.javac.main.JavaCompiler;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.DefaultFileManager;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Options;
import edu.rice.cs.drjava.model.compiler.CompilerError;
import edu.rice.cs.drjava.model.compiler.CompilerInterface;
import edu.rice.cs.drjava.model.compiler.CompilerOptions;
import java.io.File;
import java.util.LinkedList;
import java.util.Map;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticListener;
import javax.tools.JavaFileObject;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Javac160Compiler
implements CompilerInterface {
    public static final CompilerInterface ONLY = new Javac160Compiler();
    public static final String COMPILER_CLASS_NAME = "com.sun.tools.javac.main.JavaCompiler";
    private static final /* synthetic */ Class class$javax$tools$Diagnostic;
    private static final /* synthetic */ Class class$javax$tools$JavaFileManager;

    private Javac160Compiler() {
        if (!this._isValidVersion()) {
            throw new RuntimeException("Invalid version of Java 1.6 compiler.");
        }
    }

    private boolean _isValidVersion() {
        Class diagnostic = class$javax$tools$Diagnostic == null ? (class$javax$tools$Diagnostic = Javac160Compiler.class$("javax.tools.Diagnostic")) : class$javax$tools$Diagnostic;
        try {
            diagnostic.getMethod("getKind", new Class[0]);
            return true;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    @Override
    public boolean isAvailable() {
        return this._isValidVersion();
    }

    @Override
    public java.util.List<? extends CompilerError> compile(java.util.List<? extends File> files, java.util.List<? extends File> classPath, java.util.List<? extends File> sourcePath, File destination, java.util.List<? extends File> bootClassPath, String sourceVersion, boolean showWarnings) {
        Context context = this._createContext(classPath, sourcePath, destination, bootClassPath, sourceVersion, showWarnings);
        LinkedList<CompilerError> errors = new LinkedList<CompilerError>();
        new CompilerErrorListener(context, errors);
        JavaCompiler compiler = JavaCompiler.instance(context);
        DefaultFileManager fileManager = (DefaultFileManager)context.get(class$javax$tools$JavaFileManager == null ? (class$javax$tools$JavaFileManager = Javac160Compiler.class$("javax.tools.JavaFileManager")) : class$javax$tools$JavaFileManager);
        List<JavaFileObject> fileObjects = List.nil();
        for (File file : files) {
            fileObjects = fileObjects.prepend(fileManager.getRegularFile(file));
        }
        try {
            compiler.compile(fileObjects);
        }
        catch (Throwable t) {
            errors.addFirst(new CompilerError(new StringBuffer().append("Compile exception: ").append(t).toString(), false));
        }
        return errors;
    }

    @Override
    public String toString() {
        return "JDK 1.6";
    }

    @Override
    public String getName() {
        return this.toString();
    }

    private Context _createContext(java.util.List<? extends File> classPath, java.util.List<? extends File> sourcePath, File destination, java.util.List<? extends File> bootClassPath, String sourceVersion, boolean showWarnings) {
        Context context = new Context();
        Options options = Options.instance(context);
        for (Map.Entry<String, String> e : CompilerOptions.getOptions(showWarnings).entrySet()) {
            options.put(e.getKey(), e.getValue());
        }
        options.put("-g", "");
        if (classPath != null) {
            options.put("-classpath", Javac160Compiler._pathToString(classPath));
        }
        if (sourcePath != null) {
            options.put("-sourcepath", Javac160Compiler._pathToString(sourcePath));
        }
        if (destination != null) {
            options.put("-d", destination.getPath());
        }
        if (bootClassPath != null) {
            options.put("-bootclasspath", Javac160Compiler._pathToString(bootClassPath));
        }
        if (sourceVersion != null) {
            options.put("-source", sourceVersion);
        }
        if (!showWarnings) {
            options.put("-nowarn", "");
        }
        return context;
    }

    private static String _pathToString(java.util.List<? extends File> path) {
        StringBuffer result = new StringBuffer();
        boolean first = true;
        for (File file : path) {
            if (!first) {
                result.append(File.pathSeparatorChar);
            }
            first = false;
            result.append(file.getPath());
        }
        return result.toString();
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        Class<?> clazz;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(classNotFoundException.getMessage());
            try {
                noClassDefFoundError.initCause(classNotFoundException);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            throw noClassDefFoundError;
        }
        return clazz;
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CompilerErrorListener
    implements DiagnosticListener<JavaFileObject> {
        private java.util.List<? super CompilerError> _errors;
        private static final /* synthetic */ Class class$javax$tools$DiagnosticListener;

        public CompilerErrorListener(Context context, java.util.List<? super CompilerError> errors) {
            this._errors = errors;
            context.put(class$javax$tools$DiagnosticListener == null ? (class$javax$tools$DiagnosticListener = CompilerErrorListener.class$("javax.tools.DiagnosticListener")) : class$javax$tools$DiagnosticListener, this);
        }

        @Override
        public void report(Diagnostic<? extends JavaFileObject> d) {
            Diagnostic.Kind dt = d.getKind();
            boolean isWarning = false;
            switch (dt) {
                case OTHER: {
                    return;
                }
                case NOTE: {
                    return;
                }
                case MANDATORY_WARNING: {
                    isWarning = true;
                    break;
                }
                case WARNING: {
                    isWarning = true;
                    break;
                }
                case ERROR: {
                    isWarning = false;
                }
            }
            this._errors.add(new CompilerError(new File(d.getSource().toUri().getPath()), (int)d.getLineNumber() - 1, (int)d.getColumnNumber() - 1, d.getMessage(null), isWarning));
        }

        static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
            Class<?> clazz;
            try {
                clazz = Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(classNotFoundException.getMessage());
                try {
                    noClassDefFoundError.initCause(classNotFoundException);
                }
                catch (NoSuchMethodError noSuchMethodError) {
                    // empty catch block
                }
                throw noClassDefFoundError;
            }
            return clazz;
        }
    }
}

