/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.model.compiler;

import com.sun.tools.javac.main.JavaCompiler;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Options;
import com.sun.tools.javac.util.Position;
import edu.rice.cs.drjava.model.compiler.CompilerError;
import edu.rice.cs.drjava.model.compiler.CompilerInterface;
import edu.rice.cs.drjava.model.compiler.CompilerOptions;
import edu.rice.cs.util.UnexpectedException;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.LinkedList;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Javac150Compiler
implements CompilerInterface {
    private boolean _isJSR14v2_4;
    private boolean _isJSR14v2_5;
    public static final CompilerInterface ONLY = new Javac150Compiler();
    public static final String COMPILER_CLASS_NAME = "com.sun.tools.javac.main.JavaCompiler";
    private static final Writer NULL_WRITER = new Writer(){

        public void write(char[] cbuf, int off, int len) throws IOException {
        }

        public void flush() throws IOException {
        }

        public void close() throws IOException {
        }
    };
    private static final PrintWriter NULL_PRINT_WRITER = new PrintWriter(NULL_WRITER);
    private static final /* synthetic */ Class class$com$sun$tools$javac$util$Context;
    private static final /* synthetic */ Class class$com$sun$tools$javac$util$Log;
    private static final /* synthetic */ Class class$com$sun$tools$javac$util$List;
    private static final /* synthetic */ Class class$com$sun$tools$javac$main$JavaCompiler;

    protected Javac150Compiler() {
        if (!this._isValidVersion()) {
            throw new RuntimeException("Invalid version of Java compiler.");
        }
        this._isJSR14v2_5 = false;
        this._isJSR14v2_4 = this._isJSR14v2_4();
    }

    protected boolean _isValidVersion() {
        Class log = class$com$sun$tools$javac$util$Log == null ? (class$com$sun$tools$javac$util$Log = Javac150Compiler.class$("com.sun.tools.javac.util.Log")) : class$com$sun$tools$javac$util$Log;
        Class[] validArgs1 = new Class[]{class$com$sun$tools$javac$util$Context == null ? (class$com$sun$tools$javac$util$Context = Javac150Compiler.class$("com.sun.tools.javac.util.Context")) : class$com$sun$tools$javac$util$Context};
        try {
            log.getMethod("instance", validArgs1);
            try {
                log.getMethod("hasDiagnosticListener", new Class[0]);
                return false;
            }
            catch (NoSuchMethodException e) {
                return true;
            }
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    @Override
    public java.util.List<? extends CompilerError> compile(java.util.List<? extends File> files, java.util.List<? extends File> classPath, java.util.List<? extends File> sourcePath, File destination, java.util.List<? extends File> bootClassPath, String sourceVersion, boolean showWarnings) {
        Context context = this._createContext(classPath, sourcePath, destination, bootClassPath, sourceVersion, showWarnings);
        OurLog log = new OurLog(context);
        JavaCompiler compiler = this._makeCompiler(context);
        List<String> filesToCompile = this._emptyStringList();
        for (File file : files) {
            filesToCompile = filesToCompile.prepend(file.getAbsolutePath());
        }
        try {
            compiler.compile(filesToCompile);
        }
        catch (Throwable t) {
            LinkedList<CompilerError> linkedList = log.getErrors();
            linkedList.addFirst(new CompilerError(new StringBuffer().append("Compile exception: ").append(t).toString(), false));
            return linkedList;
        }
        return log.getErrors();
    }

    @Override
    public boolean isAvailable() {
        try {
            Class.forName(COMPILER_CLASS_NAME);
            try {
                Class.forName("java.lang.Enum");
            }
            catch (Exception e) {
                Class.forName("com.sun.tools.javac.main.Main$14");
                this._isJSR14v2_5 = true;
            }
            return this._isValidVersion();
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public String getName() {
        if (this._isJSR14v2_5) {
            return "JSR-14 v2.5";
        }
        if (this._isJSR14v2_4) {
            return "JSR-14 v2.4";
        }
        return "JSR-14 v2.0/2.2";
    }

    @Override
    public String toString() {
        return this.getName();
    }

    protected Context _createContext(java.util.List<? extends File> classPath, java.util.List<? extends File> sourcePath, File destination, java.util.List<? extends File> bootClassPath, String sourceVersion, boolean showWarnings) {
        Context context = new Context();
        Options options = Options.instance(context);
        options.putAll(CompilerOptions.getOptions(showWarnings));
        options.put("-g", "");
        if (classPath != null) {
            options.put("-classpath", Javac150Compiler._pathToString(classPath));
        }
        if (sourcePath != null) {
            options.put("-sourcepath", Javac150Compiler._pathToString(sourcePath));
        }
        if (destination != null) {
            options.put("-d", destination.getPath());
        }
        if (bootClassPath != null) {
            options.put("-bootclasspath", Javac150Compiler._pathToString(bootClassPath));
        }
        if (sourceVersion != null) {
            options.put("-source", sourceVersion);
        }
        if (!showWarnings) {
            options.put("-nowarn", "");
        }
        return context;
    }

    protected static String _pathToString(java.util.List<? extends File> path) {
        StringBuffer result = new StringBuffer();
        boolean first = true;
        for (File file : path) {
            if (!first) {
                result.append(File.pathSeparatorChar);
            }
            first = false;
            result.append(file.getPath());
        }
        return result.toString();
    }

    protected JavaCompiler _makeCompiler(Context context) {
        Class javaCompilerClass = class$com$sun$tools$javac$main$JavaCompiler == null ? (class$com$sun$tools$javac$main$JavaCompiler = Javac150Compiler.class$(COMPILER_CLASS_NAME)) : class$com$sun$tools$javac$main$JavaCompiler;
        Class[] validArgs1 = new Class[]{class$com$sun$tools$javac$util$Context == null ? (class$com$sun$tools$javac$util$Context = Javac150Compiler.class$("com.sun.tools.javac.util.Context")) : class$com$sun$tools$javac$util$Context};
        if (this._isJSR14v2_4) {
            try {
                Method m = javaCompilerClass.getMethod("instance", validArgs1);
                return (JavaCompiler)m.invoke(null, context);
            }
            catch (NoSuchMethodException e) {
                throw new UnexpectedException(e);
            }
            catch (IllegalAccessException e) {
                throw new UnexpectedException(e);
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
                throw new UnexpectedException(e);
            }
        }
        try {
            Method m = javaCompilerClass.getMethod("make", validArgs1);
            return (JavaCompiler)m.invoke(null, context);
        }
        catch (NoSuchMethodException e) {
            throw new UnexpectedException(e);
        }
        catch (IllegalAccessException e) {
            throw new UnexpectedException(e);
        }
        catch (InvocationTargetException e) {
            throw new UnexpectedException(e);
        }
    }

    private boolean _isJSR14v2_4() {
        try {
            Class.forName("com.sun.tools.javac.main.Main$14");
            return true;
        }
        catch (Exception e) {
            try {
                Class.forName("com.sun.tools.javac.main.Main+1");
                return true;
            }
            catch (Exception e2) {
                return false;
            }
        }
    }

    private List<String> _emptyStringList() {
        try {
            Method nil = (class$com$sun$tools$javac$util$List == null ? (class$com$sun$tools$javac$util$List = Javac150Compiler.class$("com.sun.tools.javac.util.List")) : class$com$sun$tools$javac$util$List).getMethod("nil", new Class[0]);
            List result = (List)nil.invoke(null, new Object[0]);
            return result;
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("Exception occured when invoking com.sun.tools.javac.util.List.nil()", e);
        }
        catch (Exception e) {
            try {
                List result = (List)(class$com$sun$tools$javac$util$List == null ? (class$com$sun$tools$javac$util$List = Javac150Compiler.class$("com.sun.tools.javac.util.List")) : class$com$sun$tools$javac$util$List).newInstance();
                return result;
            }
            catch (Exception e2) {
                throw new RuntimeException("Unable to create an instance of com.sun.tools.javac.util.List", e);
            }
        }
    }

    static PrintWriter access$000() {
        return NULL_PRINT_WRITER;
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        Class<?> clazz;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(classNotFoundException.getMessage());
            try {
                noClassDefFoundError.initCause(classNotFoundException);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            throw noClassDefFoundError;
        }
        return clazz;
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class OurLog
    extends Log {
        private LinkedList<CompilerError> _errors = new LinkedList();
        private String _sourceName = "";

        public OurLog(Context context) {
            super(context, Javac150Compiler.access$000(), Javac150Compiler.access$000(), Javac150Compiler.access$000());
        }

        public void warning(int pos, String key, Object ... args) {
            super.warning(pos, key, args);
            String msg = OurLog.getText((String)new StringBuffer().append("compiler.warn.").append(key).toString(), (Object[])args);
            this._errors.addLast(new CompilerError(new File(this.currentSource().toString()), Position.line((int)pos) - 1, Position.column((int)pos) - 1, msg, true));
        }

        public void mandatoryWarning(int pos, String key, Object ... args) {
            super.mandatoryWarning(pos, key, args);
            String msg = OurLog.getText((String)new StringBuffer().append("compiler.warn.").append(key).toString(), (Object[])args);
            this._errors.addLast(new CompilerError(new File(this.currentSource().toString()), Position.line((int)pos) - 1, Position.column((int)pos) - 1, msg, true));
        }

        @Override
        public void error(int pos, String key, Object ... args) {
            super.error(pos, key, args);
            String msg = OurLog.getText((String)new StringBuffer().append("compiler.err.").append(key).toString(), (Object[])args);
            this._errors.addLast(new CompilerError(new File(this.currentSource().toString()), Position.line((int)pos) - 1, Position.column((int)pos) - 1, msg, false));
        }

        public void note(String key, Object ... args) {
            super.note(key, args);
        }

        public void mandatoryNote(String key, Object ... args) {
            super.mandatoryNote(key, args);
        }

        public LinkedList<CompilerError> getErrors() {
            return this._errors;
        }
    }
}

