/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.model.compiler;

import com.sun.tools.javac.v8.JavaCompiler;
import com.sun.tools.javac.v8.util.Context;
import com.sun.tools.javac.v8.util.List;
import com.sun.tools.javac.v8.util.Log;
import com.sun.tools.javac.v8.util.Options;
import com.sun.tools.javac.v8.util.Position;
import edu.rice.cs.drjava.model.compiler.CompilerError;
import edu.rice.cs.drjava.model.compiler.CompilerInterface;
import edu.rice.cs.drjava.model.compiler.CompilerOptions;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;

public class Javac141Compiler
implements CompilerInterface {
    public static final CompilerInterface ONLY = new Javac141Compiler();
    public static final String COMPILER_CLASS_NAME = "com.sun.tools.javac.v8.JavaCompiler";
    private static final Writer NULL_WRITER = new Writer(){

        public void write(char[] cbuf, int off, int len) throws IOException {
        }

        public void flush() throws IOException {
        }

        public void close() throws IOException {
        }
    };
    private static final PrintWriter NULL_PRINT_WRITER = new PrintWriter(NULL_WRITER);

    protected Javac141Compiler() {
        if (!this._isValidVersion()) {
            throw new RuntimeException("Invalid version of Java compiler.");
        }
    }

    public java.util.List compile(java.util.List files, java.util.List classPath, java.util.List sourcePath, File destination, java.util.List bootClassPath, String sourceVersion, boolean showWarnings) {
        Context context = this._createContext(classPath, sourcePath, destination, bootClassPath, sourceVersion, showWarnings);
        OurLog log = new OurLog(context);
        JavaCompiler compiler = JavaCompiler.make((Context)context);
        List filesToCompile = new List();
        Iterator filesI = files.iterator();
        while (filesI.hasNext()) {
            File f = (File)filesI.next();
            filesToCompile = filesToCompile.prepend((Object)f.getAbsolutePath());
        }
        try {
            compiler.compile(filesToCompile);
        }
        catch (Throwable t) {
            LinkedList errors = log.getErrors();
            errors.addFirst(new CompilerError("Compile exception: " + t, false));
            return errors;
        }
        return log.getErrors();
    }

    public boolean isAvailable() {
        try {
            Class.forName(COMPILER_CLASS_NAME);
            return this._isValidVersion();
        }
        catch (Exception e) {
            return false;
        }
    }

    public String getName() {
        return "javac 1.4.x";
    }

    public String toString() {
        return this.getName();
    }

    protected boolean _isValidVersion() {
        Class log = Log.class;
        Class[] validArgs1 = new Class[]{Context.class};
        try {
            log.getMethod("instance", validArgs1);
            return true;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    protected Context _createContext(java.util.List classPath, java.util.List sourcePath, File destination, java.util.List bootClassPath, String sourceVersion, boolean showWarnings) {
        Context context = new Context();
        Options options = Options.instance((Context)context);
        Iterator<Map.Entry<String, String>> optsI = CompilerOptions.getOptions(showWarnings).entrySet().iterator();
        while (optsI.hasNext()) {
            Map.Entry<String, String> entry = optsI.next();
            options.put((Object)entry.getKey(), (Object)entry.getValue());
        }
        options.put((Object)"-g", (Object)"");
        if (classPath != null) {
            options.put((Object)"-classpath", (Object)Javac141Compiler._pathToString(classPath));
        }
        if (sourcePath != null) {
            options.put((Object)"-sourcepath", (Object)Javac141Compiler._pathToString(sourcePath));
        }
        if (destination != null) {
            options.put((Object)"-d", (Object)destination.getPath());
        }
        if (bootClassPath != null) {
            options.put((Object)"-bootclasspath", (Object)Javac141Compiler._pathToString(bootClassPath));
        }
        if (sourceVersion != null) {
            options.put((Object)"-source", (Object)sourceVersion);
        }
        if (!showWarnings) {
            options.put((Object)"-nowarn", (Object)"");
        }
        return context;
    }

    protected static String _pathToString(java.util.List path) {
        StringBuffer result = new StringBuffer();
        Iterator pathI = path.iterator();
        boolean first = true;
        while (pathI.hasNext()) {
            File f = (File)pathI.next();
            if (!first) {
                result.append(File.pathSeparatorChar);
            }
            first = false;
            result.append(f.getPath());
        }
        return result.toString();
    }

    private static class OurLog
    extends Log {
        private LinkedList _errors = new LinkedList();
        private String _sourceName = "";

        public OurLog(Context context) {
            super(context, NULL_PRINT_WRITER, NULL_PRINT_WRITER, NULL_PRINT_WRITER);
        }

        public void warning(int pos, String key, String arg0, String arg1, String arg2, String arg3) {
            super.warning(pos, key, arg0, arg1, arg2, arg3);
            String msg = OurLog.getText((String)("compiler.warn." + key), (String)arg0, (String)arg1, (String)arg2, (String)arg3, null, null, null);
            this._errors.addLast(new CompilerError(new File(this.currentSource().toString()), Position.line((int)pos) - 1, Position.column((int)pos) - 1, msg, true));
        }

        public void error(int pos, String key, String arg0, String arg1, String arg2, String arg3, String arg4, String arg5, String arg6) {
            super.error(pos, key, arg0, arg1, arg2, arg3, arg4, arg5, arg6);
            String msg = OurLog.getText((String)("compiler.err." + key), (String)arg0, (String)arg1, (String)arg2, (String)arg3, (String)arg4, (String)arg5, (String)arg6);
            this._errors.addLast(new CompilerError(new File(this.currentSource().toString()), Position.line((int)pos) - 1, Position.column((int)pos) - 1, msg, false));
        }

        public LinkedList getErrors() {
            return this._errors;
        }
    }
}

