/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.model.compiler;

import edu.rice.cs.drjava.model.GlobalModel;
import edu.rice.cs.drjava.model.OpenDefinitionsDocument;
import edu.rice.cs.drjava.model.compiler.CompilerError;
import edu.rice.cs.drjava.model.compiler.CompilerErrorModel;
import edu.rice.cs.drjava.model.compiler.CompilerEventNotifier;
import edu.rice.cs.drjava.model.compiler.CompilerInterface;
import edu.rice.cs.drjava.model.compiler.CompilerListener;
import edu.rice.cs.drjava.model.compiler.CompilerModel;
import edu.rice.cs.drjava.model.compiler.CompilerRegistry;
import edu.rice.cs.javalanglevels.JExprParseException;
import edu.rice.cs.javalanglevels.LanguageLevelConverter;
import edu.rice.cs.javalanglevels.Pair;
import edu.rice.cs.javalanglevels.SourceInfo;
import edu.rice.cs.javalanglevels.parser.JExprParser;
import edu.rice.cs.javalanglevels.tree.JExpressionIF;
import edu.rice.cs.plt.io.IOUtil;
import edu.rice.cs.util.UnexpectedException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultCompilerModel
implements CompilerModel {
    private final CompilerEventNotifier _notifier = new CompilerEventNotifier();
    private final GlobalModel _model;
    private CompilerErrorModel _compilerErrorModel;
    private File _workDir;
    private Object _compilerLock = new Object();

    public DefaultCompilerModel(GlobalModel m) {
        this._model = m;
        this._compilerErrorModel = new CompilerErrorModel(new CompilerError[0], this._model);
        this._workDir = this._model.getWorkingDirectory();
    }

    @Override
    public Object getCompilerLock() {
        return this._compilerLock;
    }

    @Override
    public void addListener(CompilerListener listener) {
        this._notifier.addListener(listener);
    }

    @Override
    public void removeListener(CompilerListener listener) {
        this._notifier.removeListener(listener);
    }

    @Override
    public void removeAllListeners() {
        this._notifier.removeAllListeners();
    }

    @Override
    public void compileAll() throws IOException {
        if (this._prepareForCompile()) {
            this._doCompile(this._model.getOpenDefinitionsDocuments());
        }
    }

    @Override
    public void compileProject() throws IOException {
        if (!this._model.isProjectActive()) {
            throw new UnexpectedException("compileProject invoked when DrJava is not in project mode");
        }
        if (this._prepareForCompile()) {
            this._doCompile(this._model.getProjectDocuments());
        }
    }

    @Override
    public void compile(List<OpenDefinitionsDocument> defDocs) throws IOException {
        if (this._prepareForCompile()) {
            this._doCompile(defDocs);
        }
    }

    @Override
    public void compile(OpenDefinitionsDocument doc) throws IOException {
        if (this._prepareForCompile()) {
            this._doCompile(Arrays.asList(doc));
        }
    }

    private boolean _prepareForCompile() {
        if (this._model.hasModifiedDocuments()) {
            this._notifier.saveBeforeCompile();
        }
        return !this._model.hasModifiedDocuments();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _doCompile(List<OpenDefinitionsDocument> docs) throws IOException {
        ArrayList<File> filesToCompile = new ArrayList<File>();
        ArrayList<File> excludedFiles = new ArrayList<File>();
        for (OpenDefinitionsDocument doc : docs) {
            if (doc.isSourceFile()) {
                File f = doc.getFile();
                if (f != null) {
                    filesToCompile.add(f);
                }
                doc.setCachedClassFile(null);
                continue;
            }
            excludedFiles.add(doc.getFile());
        }
        File buildDir = this._model.getBuildDirectory();
        if (buildDir != null && !buildDir.exists() && !buildDir.mkdirs()) {
            throw new IOException(new StringBuffer().append("Could not create build directory: ").append(buildDir).toString());
        }
        File workDir = this._model.getWorkingDirectory();
        if (workDir != null && !workDir.exists() && !workDir.mkdirs()) {
            throw new IOException(new StringBuffer().append("Could not create working directory: ").append(workDir).toString());
        }
        this._notifier.compileStarted();
        try {
            this._compileFiles(filesToCompile, buildDir);
        }
        catch (Throwable t) {
            CompilerError err = new CompilerError(t.toString(), false);
            this._distributeErrors(Arrays.asList(err));
        }
        finally {
            this._notifier.compileEnded(workDir, excludedFiles);
        }
    }

    private LinkedList<CompilerError> _parseExceptions2CompilerErrors(LinkedList<JExprParseException> pes) {
        LinkedList<CompilerError> errors = new LinkedList<CompilerError>();
        for (JExprParseException pe : pes) {
            errors.addLast(new CompilerError(pe.getFile(), pe.currentToken.beginLine - 1, pe.currentToken.beginColumn - 1, pe.getMessage(), false));
        }
        return errors;
    }

    private LinkedList<CompilerError> _visitorErrors2CompilerErrors(LinkedList<Pair<String, JExpressionIF>> visitorErrors) {
        LinkedList<CompilerError> errors = new LinkedList<CompilerError>();
        for (Pair pair : visitorErrors) {
            String message = (String)pair.getFirst();
            JExpressionIF jexpr = (JExpressionIF)pair.getSecond();
            SourceInfo si = jexpr == null ? JExprParser.NO_SOURCE_INFO : ((JExpressionIF)pair.getSecond()).getSourceInfo();
            errors.addLast(new CompilerError(si.getFile(), si.getStartLine() - 1, si.getStartColumn() - 1, message, false));
        }
        return errors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _compileFiles(List<? extends File> files, File buildDir) throws IOException {
        if (!files.isEmpty()) {
            if (buildDir != null) {
                buildDir = IOUtil.attemptCanonicalFile(buildDir);
            }
            ArrayList<File> classPath = this._model.getClassPath().asFileVector();
            LinkedList<File> bootClassPath = null;
            if (System.getProperty("drjava.bootclasspath") != null) {
                bootClassPath = new LinkedList<File>();
                StringTokenizer st = new StringTokenizer(System.getProperty("drjava.bootclasspath"), File.pathSeparator);
                while (st.hasMoreTokens()) {
                    bootClassPath.add(new File(st.nextToken()));
                }
            }
            LinkedList<CompilerError> errors = new LinkedList<CompilerError>();
            List<? extends File> preprocessedFiles = this._compileLanguageLevelsFiles(files, errors);
            if (errors.isEmpty()) {
                CompilerInterface compiler = CompilerRegistry.ONLY.getActiveCompiler();
                Object object = this._compilerLock;
                synchronized (object) {
                    if (preprocessedFiles == null) {
                        errors.addAll(compiler.compile(files, classPath, null, buildDir, bootClassPath, null, true));
                    } else {
                        errors.addAll(compiler.compile(preprocessedFiles, classPath, null, buildDir, bootClassPath, null, false));
                    }
                }
            }
            this._distributeErrors(errors);
        } else {
            this._distributeErrors(Collections.EMPTY_LIST);
        }
    }

    private List<? extends File> _compileLanguageLevelsFiles(List<? extends File> files, List<? super CompilerError> errors) {
        LanguageLevelConverter llc = new LanguageLevelConverter(this.getActiveCompiler().getName());
        Pair<LinkedList<JExprParseException>, LinkedList<Pair<String, JExpressionIF>>> llErrors = llc.convert(files.toArray(new File[0]));
        HashSet<File> javaFileSet = new HashSet<File>();
        boolean containsLanguageLevels = false;
        for (File file : files) {
            File canonicalFile = IOUtil.attemptCanonicalFile(file);
            String fileName = canonicalFile.getPath();
            int lastIndex = fileName.lastIndexOf(".dj");
            if (lastIndex != -1) {
                containsLanguageLevels = true;
                javaFileSet.add(new File(new StringBuffer().append(fileName.substring(0, lastIndex)).append(".java").toString()));
                continue;
            }
            javaFileSet.add(canonicalFile);
        }
        files = new LinkedList<File>(javaFileSet);
        errors.addAll(this._parseExceptions2CompilerErrors(llErrors.getFirst()));
        errors.addAll(this._visitorErrors2CompilerErrors(llErrors.getSecond()));
        if (containsLanguageLevels) {
            return files;
        }
        return null;
    }

    private void _distributeErrors(List<? extends CompilerError> errors) throws IOException {
        this._compilerErrorModel = new CompilerErrorModel(errors.toArray(new CompilerError[0]), this._model);
        this._model.setNumCompErrors(this._compilerErrorModel.getNumCompErrors());
    }

    @Override
    public CompilerErrorModel getCompilerErrorModel() {
        return this._compilerErrorModel;
    }

    @Override
    public int getNumErrors() {
        return this.getCompilerErrorModel().getNumErrors();
    }

    public int getNumCompErrors() {
        return this.getCompilerErrorModel().getNumCompErrors();
    }

    public int getNumWarnings() {
        return this.getCompilerErrorModel().getNumWarnings();
    }

    @Override
    public void resetCompilerErrors() {
        this._compilerErrorModel = new CompilerErrorModel(new CompilerError[0], this._model);
    }

    @Override
    public CompilerInterface[] getAvailableCompilers() {
        return CompilerRegistry.ONLY.getAvailableCompilers();
    }

    @Override
    public CompilerInterface getActiveCompiler() {
        return CompilerRegistry.ONLY.getActiveCompiler();
    }

    @Override
    public void setActiveCompiler(CompilerInterface compiler) {
        CompilerRegistry.ONLY.setActiveCompiler(compiler);
    }
}

