/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.model.compiler;

import edu.rice.cs.drjava.model.compiler.CompilerError;
import edu.rice.cs.drjava.model.compiler.CompilerInterface;
import edu.rice.cs.drjava.model.compiler.CompilerRegistry;
import edu.rice.cs.util.Log;
import edu.rice.cs.util.classloader.StickyClassLoader;
import java.io.File;
import java.util.List;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompilerProxy
implements CompilerInterface {
    public static final String VERSION = System.getProperty("java.specification.version");
    private static final Log _log = new Log("CompilerTest.txt", false);
    private CompilerInterface _realCompiler = null;
    private final String _className;
    private final ClassLoader _newLoader;
    private static final String[] _useOldLoader = new String[]{"edu.rice.cs.drjava.model.Configuration", "edu.rice.cs.drjava.model.compiler.CompilerInterface", "edu.rice.cs.drjava.model.compiler.CompilerError"};

    public CompilerProxy(String className, ClassLoader newLoader) {
        this._className = className;
        this._newLoader = newLoader;
        this._recreateCompiler();
    }

    private void _recreateCompiler() {
        _log.log(new StringBuffer().append(this).append("._recreateCompiler() called").toString());
        StickyClassLoader loader = new StickyClassLoader(this._newLoader, this.getClass().getClassLoader(), _useOldLoader);
        try {
            Class<?> c = loader.loadClass(this._className);
            _log.log(new StringBuffer().append("Class ").append(c).append(" loaded").toString());
            this._realCompiler = CompilerRegistry.createCompiler(c);
            _log.log(new StringBuffer().append("_realCompiler set to ").append(this._realCompiler).toString());
            String compilerClass = this._realCompiler.getClass().getName();
            _log.log(new StringBuffer().append("Compiler created with name ").append(compilerClass).toString());
        }
        catch (Throwable t) {
            _log.log(new StringBuffer().append(this).append("._recreateCompiler() threw exception ").append(t).toString());
        }
    }

    @Override
    public List<? extends CompilerError> compile(List<? extends File> files, List<? extends File> classPath, List<? extends File> sourcePath, File destination, List<? extends File> bootClassPath, String sourceVersion, boolean showWarnings) {
        this._recreateCompiler();
        _log.log(new StringBuffer().append("realCompiler is ").append(this._realCompiler.getClass()).toString());
        return this._realCompiler.compile(files, classPath, sourcePath, destination, bootClassPath, sourceVersion, showWarnings);
    }

    @Override
    public boolean isAvailable() {
        _log.log(new StringBuffer().append("CompilerProxy.isAvailable() called for ").append(this.getClass()).append(" _realCompiler = ").append(this._realCompiler).toString());
        if (this._realCompiler == null) {
            return false;
        }
        return this._realCompiler.isAvailable();
    }

    @Override
    public String getName() {
        if (!this.isAvailable()) {
            return "(unavailable)";
        }
        return this._realCompiler.getName();
    }

    @Override
    public String toString() {
        return this.getName();
    }
}

