/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.model.cache;

import edu.rice.cs.drjava.model.FileMovedException;
import edu.rice.cs.drjava.model.OpenDefinitionsDocument;
import edu.rice.cs.drjava.model.cache.DCacheAdapter;
import edu.rice.cs.drjava.model.cache.DDReconstructor;
import edu.rice.cs.drjava.model.definitions.DefinitionsDocument;
import edu.rice.cs.util.OrderedHashSet;
import edu.rice.cs.util.UnexpectedException;
import edu.rice.cs.util.swing.Utilities;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.text.BadLocationException;

public class DocumentCache {
    private static final int INIT_CACHE_SIZE = 32;
    private int CACHE_SIZE;
    private OrderedHashSet<DocManager> _residentQueue;
    private Object _cacheLock = new Object();
    private static final int IN_QUEUE = 0;
    private static final int UNTITLED = 1;
    private static final int NOT_IN_QUEUE = 2;
    private static final int UNMANAGED = 3;
    private LinkedList<RegistrationListener> _regListeners = new LinkedList();

    public DocumentCache(int size) {
        this.CACHE_SIZE = size;
        this._residentQueue = new OrderedHashSet();
    }

    public DocumentCache() {
        this(32);
    }

    public DCacheAdapter register(OpenDefinitionsDocument odd, DDReconstructor rec) {
        DocManager mgr = new DocManager(rec, odd.toString(), odd.isUntitled());
        this.notifyRegistrationListeners(odd, mgr);
        return mgr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCacheSize(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Cannot set the cache size to zero or less.");
        }
        DocManager[] removed = null;
        Object object = this._cacheLock;
        synchronized (object) {
            this.CACHE_SIZE = size;
            int diff = this._residentQueue.size() - this.CACHE_SIZE;
            if (diff > 0) {
                removed = new DocManager[diff];
                for (int i = 0; i < diff; ++i) {
                    removed[i] = this._residentQueue.remove(0);
                }
            }
            if (diff > 0) {
                this.kickOut(removed);
            }
        }
    }

    private void kickOut(DocManager[] removed) {
        DocManager[] arr$ = removed;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            DocManager dm = arr$[i$];
            dm.kickOut();
        }
    }

    public int getCacheSize() {
        return this.CACHE_SIZE;
    }

    public int getNumInCache() {
        return this._residentQueue.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRegistrationListener(RegistrationListener list) {
        LinkedList<RegistrationListener> linkedList = this._regListeners;
        synchronized (linkedList) {
            this._regListeners.add(list);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRegistrationListener(RegistrationListener list) {
        LinkedList<RegistrationListener> linkedList = this._regListeners;
        synchronized (linkedList) {
            this._regListeners.remove(list);
        }
    }

    public void clearRegistrationListeners() {
        this._regListeners.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyRegistrationListeners(final OpenDefinitionsDocument odd, final DocManager man) {
        LinkedList<RegistrationListener> linkedList = this._regListeners;
        synchronized (linkedList) {
            if (this._regListeners.isEmpty()) {
                return;
            }
            Utilities.invokeAndWait(new Runnable(){

                public void run() {
                    Iterator i$ = DocumentCache.access$300(DocumentCache.this).iterator();
                    while (i$.hasNext()) {
                        RegistrationListener list = (RegistrationListener)i$.next();
                        list.registered(odd, man);
                    }
                }
            });
        }
    }

    static Object access$000(DocumentCache x0) {
        return x0._cacheLock;
    }

    static OrderedHashSet access$100(DocumentCache x0) {
        return x0._residentQueue;
    }

    static int access$200(DocumentCache x0) {
        return x0.CACHE_SIZE;
    }

    static LinkedList access$300(DocumentCache x0) {
        return x0._regListeners;
    }

    public static interface RegistrationListener {
        public void registered(OpenDefinitionsDocument var1, DCacheAdapter var2);
    }

    private class DocManager
    implements DCacheAdapter {
        private final DDReconstructor _rec;
        private volatile int _stat;
        private volatile DefinitionsDocument _doc;
        private volatile String _fileName;
        static final /* synthetic */ boolean $assertionsDisabled;
        private static final /* synthetic */ Class class$edu$rice$cs$drjava$model$cache$DocumentCache;

        public DocManager(DDReconstructor rec, String fn, boolean isUntitled) {
            this._rec = rec;
            this._stat = isUntitled ? 1 : 2;
            this._doc = null;
            this._fileName = fn;
        }

        public DDReconstructor getReconstructor() {
            return this._rec;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public DefinitionsDocument getDocument() throws IOException, FileMovedException {
            if (this._doc != null) {
                return this._doc;
            }
            Object object = DocumentCache.access$000(DocumentCache.this);
            synchronized (object) {
                if (this._doc != null) {
                    return this._doc;
                }
                try {
                    this._doc = this._rec.make();
                    if (!$assertionsDisabled && this._doc == null) {
                        throw new AssertionError();
                    }
                }
                catch (BadLocationException e) {
                    throw new UnexpectedException(e);
                }
                if (this._stat == 2) {
                    this.add();
                }
                return this._doc;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isReady() {
            Object object = DocumentCache.access$000(DocumentCache.this);
            synchronized (object) {
                return this._doc != null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            Object object = DocumentCache.access$000(DocumentCache.this);
            synchronized (object) {
                DocumentCache.access$100(DocumentCache.this).remove(this);
                this.closingKickOut();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void documentModified() {
            Object object = DocumentCache.access$000(DocumentCache.this);
            synchronized (object) {
                DocumentCache.access$100(DocumentCache.this).remove(this);
                this._stat = 3;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void documentReset() {
            Object object = DocumentCache.access$000(DocumentCache.this);
            synchronized (object) {
                if (this._stat == 3) {
                    this.add();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void documentSaved(String fileName) {
            Object object = DocumentCache.access$000(DocumentCache.this);
            synchronized (object) {
                if (this.isUnmanagedOrUntitled()) {
                    this._fileName = fileName;
                    this.add();
                }
            }
        }

        private void add() {
            if (!DocumentCache.access$100(DocumentCache.this).contains(this)) {
                DocumentCache.access$100(DocumentCache.this).add(this);
                this._stat = 0;
            }
            if (DocumentCache.access$100(DocumentCache.this).size() > DocumentCache.access$200(DocumentCache.this)) {
                ((DocManager)DocumentCache.access$100(DocumentCache.this).get(0)).remove();
            }
        }

        private void remove() {
            boolean removed = DocumentCache.access$100(DocumentCache.this).remove(this);
            this.kickOut();
        }

        private boolean isUnmanagedOrUntitled() {
            return (this._stat & 1) != 0;
        }

        void kickOut() {
            this.kickOut(false);
        }

        void closingKickOut() {
            this.kickOut(true);
        }

        private void kickOut(boolean isClosing) {
            if (!isClosing) {
                this._rec.saveDocInfo(this._doc);
            }
            if (this._doc != null) {
                this._doc.close();
                this._doc = null;
            }
            this._stat = 2;
        }

        public String toString() {
            return this._fileName;
        }

        static {
            $assertionsDisabled = !(class$edu$rice$cs$drjava$model$cache$DocumentCache == null ? (class$edu$rice$cs$drjava$model$cache$DocumentCache = DocManager.class$("edu.rice.cs.drjava.model.cache.DocumentCache")) : class$edu$rice$cs$drjava$model$cache$DocumentCache).desiredAssertionStatus();
        }

        static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
            Class<?> clazz;
            try {
                clazz = Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(classNotFoundException.getMessage());
                try {
                    noClassDefFoundError.initCause(classNotFoundException);
                }
                catch (NoSuchMethodError noSuchMethodError) {
                    // empty catch block
                }
                throw noClassDefFoundError;
            }
            return clazz;
        }
    }
}

