/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.model;

import com.rc.retroweaver.runtime.Autobox;
import edu.rice.cs.drjava.DrJava;
import edu.rice.cs.drjava.config.OptionConstants;
import edu.rice.cs.drjava.config.OptionEvent;
import edu.rice.cs.drjava.config.OptionListener;
import edu.rice.cs.drjava.model.DJDocument;
import edu.rice.cs.drjava.model.definitions.indent.Indenter;
import edu.rice.cs.drjava.model.definitions.reducedmodel.BraceReduction;
import edu.rice.cs.drjava.model.definitions.reducedmodel.HighlightStatus;
import edu.rice.cs.drjava.model.definitions.reducedmodel.IndentInfo;
import edu.rice.cs.drjava.model.definitions.reducedmodel.ReducedModelControl;
import edu.rice.cs.drjava.model.definitions.reducedmodel.ReducedModelState;
import edu.rice.cs.util.OperationCanceledException;
import edu.rice.cs.util.UnexpectedException;
import edu.rice.cs.util.text.SwingDocument;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.ProgressMonitor;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Position;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDJDocument
extends SwingDocument
implements DJDocument,
OptionConstants {
    protected static final HashSet<String> _normEndings = AbstractDJDocument._makeNormEndings();
    protected static final HashSet<String> _keywords = AbstractDJDocument._makeKeywords();
    protected static final HashSet<String> _primTypes = AbstractDJDocument._makePrimTypes();
    protected volatile int _indent = 2;
    public final BraceReduction _reduced = new ReducedModelControl();
    protected volatile int _currentLocation = 0;
    private final Hashtable<String, Object> _helperCache = new Hashtable();
    private final Vector<String> _helperCacheHistory = new Vector();
    protected volatile boolean _cacheInUse;
    private static final int MAX_CACHE_SIZE = 10000;
    public static final int DOCSTART = 0;
    public static final int ERROR_INDEX = -1;
    private volatile Indenter _indenter;
    private volatile OptionListener<Integer> _listener1;
    private volatile OptionListener<Boolean> _listener2;

    protected AbstractDJDocument() {
    }

    protected AbstractDJDocument(Indenter indent) {
        this._indenter = indent;
    }

    protected abstract Indenter makeNewIndenter(int var1);

    private Indenter getIndenter() {
        if (this._indenter == null) {
            int ind = DrJava.getConfig().getSetting(INDENT_LEVEL);
            this._indenter = this.makeNewIndenter(ind);
            this._initNewIndenter();
        }
        return this._indenter;
    }

    @Override
    public int getIndent() {
        return this._indent;
    }

    @Override
    public void setIndent(int indent) {
        DrJava.getConfig().setSetting(INDENT_LEVEL, Autobox.valueOf(indent));
        this._indent = indent;
    }

    protected void _removeIndenter() {
        DrJava.getConfig().removeOptionListener(INDENT_LEVEL, this._listener1);
        DrJava.getConfig().removeOptionListener(AUTO_CLOSE_COMMENTS, this._listener2);
    }

    private void _initNewIndenter() {
        final Indenter indenter = this._indenter;
        this._listener1 = new OptionListener<Integer>(){

            @Override
            public void optionChanged(OptionEvent<Integer> oce) {
                indenter.buildTree((Integer)oce.value);
            }
        };
        this._listener2 = new OptionListener<Boolean>(){

            @Override
            public void optionChanged(OptionEvent<Boolean> oce) {
                indenter.buildTree(DrJava.getConfig().getSetting(OptionConstants.INDENT_LEVEL));
            }
        };
        DrJava.getConfig().addOptionListener(INDENT_LEVEL, this._listener1);
        DrJava.getConfig().addOptionListener(AUTO_CLOSE_COMMENTS, this._listener2);
    }

    protected static HashSet<String> _makeNormEndings() {
        HashSet<String> normEndings = new HashSet<String>();
        normEndings.add(";");
        normEndings.add("{");
        normEndings.add("}");
        normEndings.add("(");
        return normEndings;
    }

    protected static HashSet<String> _makeKeywords() {
        String[] words = new String[]{"import", "native", "package", "goto", "const", "if", "else", "switch", "while", "for", "do", "true", "false", "null", "this", "super", "new", "instanceof", "return", "static", "synchronized", "transient", "volatile", "final", "strictfp", "throw", "try", "catch", "finally", "throws", "extends", "implements", "interface", "class", "break", "continue", "public", "protected", "private", "abstract", "case", "default", "assert", "enum"};
        HashSet<String> keywords = new HashSet<String>();
        for (int i = 0; i < words.length; ++i) {
            keywords.add(words[i]);
        }
        return keywords;
    }

    protected static HashSet<String> _makePrimTypes() {
        String[] words = new String[]{"boolean", "char", "byte", "short", "int", "long", "float", "double", "void"};
        HashSet<String> prims = new HashSet<String>();
        for (String w : words) {
            prims.add(w);
        }
        return prims;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Vector<HighlightStatus> getHighlightStatus(int start, int end) {
        Vector<HighlightStatus> v;
        if (start == end) {
            return new Vector<HighlightStatus>(0);
        }
        this.acquireReadLock();
        try {
            BraceReduction braceReduction = this._reduced;
            synchronized (braceReduction) {
                this.setCurrentLocation(start);
                v = this._reduced.getHighlightStatus(start, end - start);
                for (int i = 0; i < v.size(); ++i) {
                    HighlightStatus stat = v.get(i);
                    if (stat.getState() != 0) continue;
                    i = this._highlightKeywords(v, i);
                }
            }
        }
        finally {
            this.releaseReadLock();
        }
        return v;
    }

    private int _highlightKeywords(Vector<HighlightStatus> v, int i) {
        String text;
        String delimiters = " \t\n\r{}()[].+-/*;:=!@#$%^&*~<>?,\"`'<>|";
        HighlightStatus original = v.get(i);
        try {
            text = this.getText(original.getLocation(), original.getLength());
        }
        catch (BadLocationException e) {
            throw new UnexpectedException(e);
        }
        StringTokenizer tokenizer = new StringTokenizer(text, " \t\n\r{}()[].+-/*;:=!@#$%^&*~<>?,\"`'<>|", true);
        int start = original.getLocation();
        int length = 0;
        v.remove(i);
        int index = i;
        int state = 0;
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            boolean process = false;
            if (this._isType(token)) {
                state = 6;
                process = true;
            } else if (_keywords.contains(token)) {
                state = 4;
                process = true;
            } else if (this._isNum(token)) {
                state = 5;
                process = true;
            }
            if (process) {
                if (length != 0) {
                    HighlightStatus newStat = new HighlightStatus(start, length, original.getState());
                    v.add(index, newStat);
                    ++index;
                    start += length;
                    length = 0;
                }
                int keywordLength = token.length();
                v.add(index, new HighlightStatus(start, keywordLength, state));
                ++index;
                start += keywordLength;
                continue;
            }
            length += token.length();
        }
        if (length != 0) {
            HighlightStatus newStat = new HighlightStatus(start, length, original.getState());
            v.add(index, newStat);
            ++index;
            length = 0;
        }
        return index - 1;
    }

    private boolean _isNum(String x) {
        try {
            Double.parseDouble(x);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private boolean _isType(String x) {
        if (_primTypes.contains(x)) {
            return true;
        }
        try {
            return Character.isUpperCase(x.charAt(0));
        }
        catch (IndexOutOfBoundsException e) {
            return false;
        }
    }

    private boolean _hasOnlySpaces(String text) {
        return text.trim().length() == 0;
    }

    protected abstract void _styleChanged();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearCache() {
        Hashtable<String, Object> hashtable = this._helperCache;
        synchronized (hashtable) {
            if (this._cacheInUse) {
                this._clearCache();
            }
        }
    }

    private void _clearCache() {
        this._helperCache.clear();
        this._helperCacheHistory.clear();
        this._cacheInUse = false;
    }

    private void _addCharToReducedModel(char curChar) {
        this.clearCache();
        this._reduced.insertChar(curChar);
    }

    @Override
    public int getCurrentLocation() {
        return this._currentLocation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCurrentLocation(int loc) {
        this.acquireReadLock();
        try {
            BraceReduction braceReduction = this._reduced;
            synchronized (braceReduction) {
                int dist = loc - this._currentLocation;
                this._currentLocation = loc;
                this._reduced.move(dist);
            }
        }
        finally {
            this.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void move(int dist) {
        this.acquireReadLock();
        try {
            BraceReduction braceReduction = this._reduced;
            synchronized (braceReduction) {
                int newLoc;
                this._currentLocation = newLoc = this._currentLocation + dist;
                this._reduced.move(dist);
            }
        }
        finally {
            this.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int balanceBackward() {
        this.acquireReadLock();
        try {
            BraceReduction braceReduction = this._reduced;
            synchronized (braceReduction) {
                int n = this._reduced.balanceBackward();
                return n;
            }
        }
        finally {
            this.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int balanceForward() {
        this.acquireReadLock();
        try {
            BraceReduction braceReduction = this._reduced;
            synchronized (braceReduction) {
                int n = this._reduced.balanceForward();
                return n;
            }
        }
        finally {
            this.releaseReadLock();
        }
    }

    public BraceReduction getReduced() {
        return this._reduced;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IndentInfo getIndentInformation() {
        IndentInfo info;
        String key = new StringBuffer().append("getIndentInformation:").append(this._currentLocation).toString();
        IndentInfo cached = (IndentInfo)this._checkCache(key);
        if (cached != null) {
            return cached;
        }
        this.acquireReadLock();
        try {
            BraceReduction braceReduction = this._reduced;
            synchronized (braceReduction) {
                info = this._reduced.getIndentInformation();
            }
            this._storeInCache(key, info);
        }
        finally {
            this.releaseReadLock();
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReducedModelState stateAtRelLocation(int dist) {
        this.acquireReadLock();
        try {
            BraceReduction braceReduction = this._reduced;
            synchronized (braceReduction) {
                ReducedModelState reducedModelState = this._reduced.moveWalkerGetState(dist);
                return reducedModelState;
            }
        }
        finally {
            this.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReducedModelState getStateAtCurrent() {
        this.acquireReadLock();
        try {
            BraceReduction braceReduction = this._reduced;
            synchronized (braceReduction) {
                ReducedModelState reducedModelState = this._reduced.getStateAtCurrent();
                return reducedModelState;
            }
        }
        finally {
            this.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resetReducedModelLocation() {
        this.acquireReadLock();
        try {
            BraceReduction braceReduction = this._reduced;
            synchronized (braceReduction) {
                this._reduced.resetLocation();
            }
        }
        finally {
            this.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int findPrevEnclosingBrace(int pos, char opening, char closing) throws BadLocationException {
        StringBuffer keyBuf = new StringBuffer("findPrevEnclosingBrace:").append(opening).append(':').append(closing).append(':').append(pos);
        String key = keyBuf.toString();
        Integer cached = (Integer)this._checkCache(key);
        if (cached != null) {
            return cached;
        }
        if (pos >= this.getLength() || pos == 0) {
            return -1;
        }
        char[] delims = new char[]{opening, closing};
        int reducedPos = pos;
        int braceBalance = 0;
        this.acquireReadLock();
        try {
            int i;
            String text = this.getText(0, pos);
            BraceReduction braceReduction = this._reduced;
            synchronized (braceReduction) {
                int origLocation = this._currentLocation;
                this._reduced.move(pos - origLocation);
                for (i = pos - 1; i >= 0; --i) {
                    if (!AbstractDJDocument.match(text.charAt(i), delims)) continue;
                    this._reduced.move(i - reducedPos);
                    reducedPos = i;
                    ReducedModelState state = this._reduced.getStateAtCurrent();
                    if (!state.equals(ReducedModelState.FREE) || AbstractDJDocument._isStartOfComment(text, i) || i > 0 && AbstractDJDocument._isStartOfComment(text, i - 1)) continue;
                    if (text.charAt(i) == closing) {
                        ++braceBalance;
                        continue;
                    }
                    if (braceBalance == 0) break;
                    --braceBalance;
                }
                this._reduced.move(origLocation - reducedPos);
            }
            if (i == -1) {
                reducedPos = -1;
            }
            this._storeInCache(key, Autobox.valueOf(reducedPos));
        }
        finally {
            this.releaseReadLock();
        }
        return reducedPos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int findNextEnclosingBrace(int pos, char opening, char closing) throws BadLocationException {
        StringBuffer keyBuf = new StringBuffer("findNextEnclosingBrace:").append(opening).append(':').append(closing).append(':').append(pos);
        String key = keyBuf.toString();
        Integer cached = (Integer)this._checkCache(key);
        if (cached != null) {
            return cached;
        }
        if (pos >= this.getLength() - 1) {
            return -1;
        }
        char[] delims = new char[]{opening, closing};
        int reducedPos = pos;
        int braceBalance = 0;
        this.acquireReadLock();
        String text = this.getText();
        try {
            int i;
            BraceReduction braceReduction = this._reduced;
            synchronized (braceReduction) {
                int origLocation = this._currentLocation;
                this._reduced.move(pos - origLocation);
                for (i = pos + 1; i < text.length(); ++i) {
                    if (!AbstractDJDocument.match(text.charAt(i), delims)) continue;
                    this._reduced.move(i - reducedPos);
                    reducedPos = i;
                    ReducedModelState state = this._reduced.getStateAtCurrent();
                    if (!state.equals(ReducedModelState.FREE) || AbstractDJDocument._isStartOfComment(text, i) || i > 0 && AbstractDJDocument._isStartOfComment(text, i - 1)) continue;
                    if (text.charAt(i) == opening) {
                        ++braceBalance;
                        continue;
                    }
                    if (braceBalance == 0) break;
                    --braceBalance;
                }
                this._reduced.move(origLocation - reducedPos);
            }
            if (i == text.length()) {
                reducedPos = -1;
            }
            this._storeInCache(key, Autobox.valueOf(reducedPos));
        }
        finally {
            this.releaseReadLock();
        }
        return reducedPos;
    }

    @Override
    public int findPrevDelimiter(int pos, char[] delims) throws BadLocationException {
        return this.findPrevDelimiter(pos, delims, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int findPrevDelimiter(int pos, char[] delims, boolean skipParenPhrases) throws BadLocationException {
        StringBuffer keyBuf = new StringBuffer("findPrevDelimiter:").append(pos);
        for (char ch : delims) {
            keyBuf.append(':').append(ch);
        }
        keyBuf.append(':').append(skipParenPhrases);
        String key = keyBuf.toString();
        Integer cached = (Integer)this._checkCache(key);
        if (cached != null) {
            return cached;
        }
        int reducedPos = pos;
        this.acquireReadLock();
        try {
            int i;
            String text = this.getText(0, pos);
            BraceReduction braceReduction = this._reduced;
            synchronized (braceReduction) {
                int origLocation = this._currentLocation;
                this._reduced.move(pos - origLocation);
                for (i = pos - 1; i >= 0; --i) {
                    if (!AbstractDJDocument.match(text.charAt(i), delims)) continue;
                    this._reduced.move(i - reducedPos);
                    reducedPos = i;
                    ReducedModelState state = this._reduced.getStateAtCurrent();
                    if (state.equals(ReducedModelState.FREE) && !AbstractDJDocument._isStartOfComment(text, i) && (i <= 0 || !AbstractDJDocument._isStartOfComment(text, i - 1)) && (!skipParenPhrases || !this.posInParenPhrase())) break;
                }
                this._reduced.move(origLocation - reducedPos);
            }
            if (i == -1) {
                reducedPos = -1;
            }
            this._storeInCache(key, Autobox.valueOf(reducedPos));
        }
        finally {
            this.releaseReadLock();
        }
        return reducedPos;
    }

    private static boolean match(char c, char[] delims) {
        for (char d : delims) {
            if (c != d) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean findCharInStmtBeforePos(char findChar, int position) {
        boolean found;
        if (position == -1) {
            String mesg = "Argument endChar to QuestionExistsCharInStmt must be a char that exists on the current line.";
            throw new UnexpectedException(new IllegalArgumentException(mesg));
        }
        char[] findCharDelims = new char[]{findChar, ';', '{', '}'};
        this.acquireReadLock();
        try {
            int prevFindChar = this.findPrevDelimiter(position, findCharDelims, false);
            if (prevFindChar == -1 || prevFindChar < 0) {
                boolean bl = false;
                return bl;
            }
            String foundString = this.getText(prevFindChar, 1);
            char foundChar = foundString.charAt(0);
            found = foundChar == findChar;
        }
        catch (Throwable t) {
            throw new UnexpectedException(t);
        }
        finally {
            this.releaseReadLock();
        }
        return found;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int findPrevCharPos(int pos, char[] whitespace) throws BadLocationException {
        StringBuffer keyBuf = new StringBuffer("findPrevCharPos:").append(pos);
        for (char ch : whitespace) {
            keyBuf.append(':').append(ch);
        }
        String key = keyBuf.toString();
        Integer cached = (Integer)this._checkCache(key);
        if (cached != null) {
            return cached;
        }
        int reducedPos = pos;
        int i = pos - 1;
        this.acquireReadLock();
        try {
            String text = this.getText(0, pos);
            BraceReduction braceReduction = this._reduced;
            synchronized (braceReduction) {
                int origLocation = this._currentLocation;
                this._reduced.move(pos - origLocation);
                while (i >= 0) {
                    if (AbstractDJDocument.match(text.charAt(i), whitespace)) {
                        --i;
                        continue;
                    }
                    this._reduced.move(i - reducedPos);
                    reducedPos = i;
                    if (this._reduced.getStateAtCurrent().equals(ReducedModelState.INSIDE_LINE_COMMENT) || this._reduced.getStateAtCurrent().equals(ReducedModelState.INSIDE_BLOCK_COMMENT)) {
                        --i;
                        continue;
                    }
                    if (!AbstractDJDocument._isReversteStartOfComment(text, i)) break;
                    i -= 2;
                }
                this._reduced.move(origLocation - reducedPos);
            }
            int result = reducedPos;
            if (i < 0) {
                result = -1;
            }
            this._storeInCache(key, Autobox.valueOf(result));
            int n = result;
            return n;
        }
        finally {
            this.releaseReadLock();
        }
    }

    protected Object _checkCache(String key) {
        Object result = this._helperCache.get(key);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _storeInCache(String key, Object result) {
        Hashtable<String, Object> hashtable = this._helperCache;
        synchronized (hashtable) {
            Object prev;
            this._cacheInUse = true;
            if (this._helperCache.size() >= 10000) {
                if (this._helperCacheHistory.size() > 0) {
                    this._helperCache.remove(this._helperCacheHistory.get(0));
                    this._helperCacheHistory.remove(0);
                } else {
                    throw new RuntimeException("Cache larger than cache history!");
                }
            }
            if ((prev = this._helperCache.put(key, result)) == null) {
                this._helperCacheHistory.add(key);
            }
        }
    }

    @Override
    public void indentLines(int selStart, int selEnd) {
        try {
            this.indentLines(selStart, selEnd, 0, null);
        }
        catch (OperationCanceledException oce) {
            throw new UnexpectedException(oce);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void indentLines(int selStart, int selEnd, int reason, ProgressMonitor pm) throws OperationCanceledException {
        this.acquireWriteLock();
        try {
            BraceReduction braceReduction = this._reduced;
            synchronized (braceReduction) {
                if (selStart == selEnd) {
                    Position oldCurrentPosition = this.createUnwrappedPosition(this._currentLocation);
                    if (this._indentLine(reason)) {
                        this.setCurrentLocation(oldCurrentPosition.getOffset());
                        if (this.onlyWhiteSpaceBeforeCurrent()) {
                            int space = this.getWhiteSpace();
                            this.move(space);
                        }
                    }
                } else {
                    this._indentBlock(selStart, selEnd, reason, pm);
                }
            }
        }
        catch (Throwable t) {
            throw new UnexpectedException(t);
        }
        finally {
            this.releaseWriteLock();
        }
        this.endLastCompoundEdit();
    }

    private void _indentBlock(int start, int end, int reason, ProgressMonitor pm) throws OperationCanceledException, BadLocationException {
        Position endPos = this.createUnwrappedPosition(end);
        for (int walker = start; walker < endPos.getOffset(); walker += this._reduced.getDistToNextNewline() + 1) {
            this.setCurrentLocation(walker);
            Position walkerPos = this.createUnwrappedPosition(walker);
            this._indentLine(reason);
            this.setCurrentLocation(walkerPos.getOffset());
            walker = walkerPos.getOffset();
            if (pm == null) continue;
            pm.setProgress(walker);
            if (!pm.isCanceled()) continue;
            throw new OperationCanceledException();
        }
    }

    public boolean _indentLine(int reason) {
        return this.getIndenter().indent(this, reason);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getIntelligentBeginLinePos(int currPos) throws BadLocationException {
        int firstRealChar;
        int i;
        String prefix;
        int firstChar;
        this.acquireReadLock();
        try {
            firstChar = this.getLineStartPos(currPos);
            prefix = this.getText(firstChar, currPos - firstChar);
        }
        finally {
            this.releaseReadLock();
        }
        int len = prefix.length();
        for (i = 0; i < len && Character.isWhitespace(prefix.charAt(i)); ++i) {
        }
        if (i < len && (firstRealChar = firstChar + i) < currPos) {
            return firstRealChar;
        }
        return firstChar;
    }

    @Override
    public String getIndentOfCurrStmt(int pos) throws BadLocationException {
        char[] delims = new char[]{';', '{', '}'};
        char[] whitespace = new char[]{' ', '\t', '\n', ','};
        return this.getIndentOfCurrStmt(pos, delims, whitespace);
    }

    @Override
    public String getIndentOfCurrStmt(int pos, char[] delims) throws BadLocationException {
        char[] whitespace = new char[]{' ', '\t', '\n', ','};
        return this.getIndentOfCurrStmt(pos, delims, whitespace);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getIndentOfCurrStmt(int pos, char[] delims, char[] whitespace) throws BadLocationException {
        String lineText;
        StringBuffer keyBuf = new StringBuffer("getIndentOfCurrStmt:").append(pos);
        for (char ch : delims) {
            keyBuf.append(':').append(ch);
        }
        String key = keyBuf.toString();
        String cached = (String)this._checkCache(key);
        if (cached != null) {
            return cached;
        }
        this.acquireReadLock();
        try {
            BraceReduction ch = this._reduced;
            synchronized (ch) {
                int nextNonWSChar;
                int lineStart = this.getLineStartPos(pos);
                boolean reachedStart = false;
                int prevDelim = lineStart;
                boolean ignoreParens = this.posInParenPhrase(prevDelim);
                while ((prevDelim = this.findPrevDelimiter(prevDelim, delims, ignoreParens)) <= 0 || prevDelim >= this.getLength() || this.getText(prevDelim, 1).charAt(0) != '{') {
                    if (prevDelim == -1) {
                        reachedStart = true;
                        break;
                    }
                    ignoreParens = this.posInParenPhrase(prevDelim);
                    if (ignoreParens) continue;
                }
                if ((nextNonWSChar = reachedStart ? this.getFirstNonWSCharPos(0) : this.getFirstNonWSCharPos(prevDelim + 1, whitespace, false)) == -1) {
                    nextNonWSChar = this.getLength();
                }
                int lineStartStmt = this.getLineStartPos(nextNonWSChar);
                int lineFirstNonWS = this.getLineFirstCharPos(lineStartStmt);
                lineText = this.getText(lineStartStmt, lineFirstNonWS - lineStartStmt);
                this._storeInCache(key, lineText);
            }
        }
        catch (Throwable t) {
            throw new UnexpectedException(t);
        }
        finally {
            this.releaseReadLock();
        }
        return lineText;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int findCharOnLine(int pos, char findChar) {
        int matchIndex;
        String key = new StringBuffer().append("findCharOnLine:").append(pos).append(":").append(findChar).toString();
        Integer cached = (Integer)this._checkCache(key);
        if (cached != null) {
            return cached;
        }
        this.acquireReadLock();
        try {
            int i;
            BraceReduction braceReduction = this._reduced;
            synchronized (braceReduction) {
                int here = this._currentLocation;
                int lineStart = this.getLineStartPos(pos);
                int lineEnd = this.getLineEndPos(pos);
                String lineText = this.getText(lineStart, lineEnd - lineStart);
                i = lineText.indexOf(findChar, 0);
                matchIndex = i + lineStart;
                while (i != -1) {
                    this._reduced.move(matchIndex - here);
                    if (this._reduced.getStateAtCurrent().equals(ReducedModelState.FREE)) {
                        this._reduced.move(here - matchIndex);
                        break;
                    }
                    this._reduced.move(here - matchIndex);
                    i = lineText.indexOf(findChar, i + 1);
                }
            }
            if (i == -1) {
                matchIndex = -1;
            }
            this._storeInCache(key, Autobox.valueOf(matchIndex));
        }
        catch (Throwable t) {
            throw new UnexpectedException(t);
        }
        finally {
            this.releaseReadLock();
        }
        return matchIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getLineStartPos(int pos) {
        int dist;
        if (pos < 0 || pos > this.getLength()) {
            return -1;
        }
        String key = new StringBuffer().append("getLineStartPos:").append(pos).toString();
        Integer cached = (Integer)this._checkCache(key);
        if (cached != null) {
            return cached;
        }
        this.acquireReadLock();
        try {
            BraceReduction braceReduction = this._reduced;
            synchronized (braceReduction) {
                int location = this._currentLocation;
                this._reduced.move(pos - location);
                dist = this._reduced.getDistToPreviousNewline(0);
                this._reduced.move(location - pos);
            }
            if (dist == -1) {
                this._storeInCache(key, Autobox.valueOf(0));
                int n = 0;
                return n;
            }
            this._storeInCache(key, Autobox.valueOf(pos - dist));
        }
        finally {
            this.releaseReadLock();
        }
        return pos - dist;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getLineEndPos(int pos) {
        int dist;
        if (pos < 0 || pos > this.getLength()) {
            return -1;
        }
        String key = new StringBuffer().append("getLineEndPos:").append(pos).toString();
        Integer cached = (Integer)this._checkCache(key);
        if (cached != null) {
            return cached;
        }
        this.acquireReadLock();
        try {
            BraceReduction braceReduction = this._reduced;
            synchronized (braceReduction) {
                int location = this._currentLocation;
                this._reduced.move(pos - location);
                dist = this._reduced.getDistToNextNewline();
                this._reduced.move(location - pos);
            }
            this._storeInCache(key, Autobox.valueOf(pos + dist));
        }
        finally {
            this.releaseReadLock();
        }
        return pos + dist;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getLineFirstCharPos(int pos) throws BadLocationException {
        String key = new StringBuffer().append("getLineFirstCharPos:").append(pos).toString();
        Integer cached = (Integer)this._checkCache(key);
        if (cached != null) {
            return cached;
        }
        this.acquireReadLock();
        try {
            int startLinePos = this.getLineStartPos(pos);
            int endLinePos = this.getLineEndPos(pos);
            String text = this.getText(startLinePos, endLinePos - startLinePos);
            for (int walker = 0; walker < text.length(); ++walker) {
                if (text.charAt(walker) == ' ' || text.charAt(walker) == '\t') {
                    continue;
                }
                this._storeInCache(key, Autobox.valueOf(startLinePos + walker));
                int n = startLinePos + walker;
                return n;
            }
            this._storeInCache(key, Autobox.valueOf(endLinePos));
            int n = endLinePos;
            return n;
        }
        finally {
            this.releaseReadLock();
        }
    }

    @Override
    public int getFirstNonWSCharPos(int pos) throws BadLocationException {
        char[] whitespace = new char[]{' ', '\t', '\n'};
        return this.getFirstNonWSCharPos(pos, whitespace, false);
    }

    @Override
    public int getFirstNonWSCharPos(int pos, boolean acceptComments) throws BadLocationException {
        char[] whitespace = new char[]{' ', '\t', '\n'};
        return this.getFirstNonWSCharPos(pos, whitespace, acceptComments);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getFirstNonWSCharPos(int pos, char[] whitespace, boolean acceptComments) throws BadLocationException {
        StringBuffer keyBuf = new StringBuffer("getFirstNonWSCharPos:").append(pos);
        for (char ch : whitespace) {
            keyBuf.append(':').append(ch);
        }
        String key = keyBuf.toString();
        Integer cached = (Integer)this._checkCache(key);
        if (cached != null) {
            return cached;
        }
        int result = -1;
        this.acquireReadLock();
        try {
            int i = pos;
            int endPos = this.getLength();
            String text = this.getText(pos, endPos - pos);
            int origLocation = this._currentLocation;
            BraceReduction braceReduction = this._reduced;
            synchronized (braceReduction) {
                this._reduced.move(pos - origLocation);
                int reducedPos = pos;
                while (i < endPos) {
                    if (AbstractDJDocument.match(text.charAt(i - pos), whitespace)) {
                        ++i;
                        continue;
                    }
                    this._reduced.move(i - reducedPos);
                    reducedPos = i;
                    if (!acceptComments && (this._reduced.getStateAtCurrent().equals(ReducedModelState.INSIDE_LINE_COMMENT) || this._reduced.getStateAtCurrent().equals(ReducedModelState.INSIDE_BLOCK_COMMENT))) {
                        ++i;
                        continue;
                    }
                    if (acceptComments || !AbstractDJDocument._isStartOfComment(text, i - pos)) break;
                    i += 2;
                }
                this._reduced.move(origLocation - reducedPos);
                result = reducedPos;
                if (i == endPos) {
                    result = -1;
                }
            }
            this._storeInCache(key, Autobox.valueOf(result));
        }
        finally {
            this.releaseReadLock();
        }
        return result;
    }

    @Override
    public int findPrevNonWSCharPos(int pos) throws BadLocationException {
        char[] whitespace = new char[]{' ', '\t', '\n'};
        return this.findPrevCharPos(pos, whitespace);
    }

    protected static boolean _isStartOfComment(String text, int pos) {
        char currChar = text.charAt(pos);
        if (currChar == '/') {
            try {
                char afterCurrChar = text.charAt(pos + 1);
                if (afterCurrChar == '/' || afterCurrChar == '*') {
                    return true;
                }
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                // empty catch block
            }
        }
        return false;
    }

    protected static boolean _isReversteStartOfComment(String text, int pos) {
        char currChar = text.charAt(pos);
        if (currChar == '/' || currChar == '*') {
            try {
                char beforeCurrChar = text.charAt(pos - 1);
                if (beforeCurrChar == '/') {
                    return true;
                }
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                // empty catch block
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean posInParenPhrase(int pos) {
        boolean inParenPhrase;
        String key = new StringBuffer().append("posInParenPhrase:").append(pos).toString();
        Boolean cached = (Boolean)this._checkCache(key);
        if (cached != null) {
            return cached;
        }
        this.acquireReadLock();
        try {
            BraceReduction braceReduction = this._reduced;
            synchronized (braceReduction) {
                int here = this._currentLocation;
                this._reduced.move(pos - here);
                inParenPhrase = this.posInParenPhrase();
                this._reduced.move(here - pos);
            }
            this._storeInCache(key, Autobox.valueOf(inParenPhrase));
        }
        finally {
            this.releaseReadLock();
        }
        return inParenPhrase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean posInParenPhrase() {
        IndentInfo info;
        this.acquireReadLock();
        try {
            BraceReduction braceReduction = this._reduced;
            synchronized (braceReduction) {
                info = this._reduced.getIndentInformation();
            }
        }
        finally {
            this.releaseReadLock();
        }
        return info.braceTypeCurrent.equals("(");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean posNotInBlock(int pos) {
        boolean notInParenPhrase;
        String key = new StringBuffer().append("posNotInBlock:").append(pos).toString();
        Boolean cached = (Boolean)this._checkCache(key);
        if (cached != null) {
            return cached;
        }
        BraceReduction braceReduction = this._reduced;
        synchronized (braceReduction) {
            int here = this._currentLocation;
            this._reduced.move(pos - here);
            IndentInfo info = this._reduced.getIndentInformation();
            notInParenPhrase = info.braceTypeCurrent.equals("");
            this._reduced.move(here - pos);
        }
        this._storeInCache(key, Autobox.valueOf(notInParenPhrase));
        return notInParenPhrase;
    }

    @Override
    public int getWhiteSpace() {
        try {
            return this.getWhiteSpaceBetween(0, this.getLength() - this._currentLocation);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
            return -1;
        }
    }

    private int getWhiteSpaceBetween(int relStart, int relEnd) throws BadLocationException {
        int i;
        String text = this.getText(this._currentLocation - relStart, Math.abs(relStart - relEnd));
        int length = text.length();
        for (i = 0; i < length && text.charAt(i) == ' '; ++i) {
        }
        return i;
    }

    private boolean onlyWhiteSpaceBeforeCurrent() throws BadLocationException {
        int index;
        String text = this.getText(0, this._currentLocation);
        text = text.substring(text.lastIndexOf("\n") + 1);
        int lastChar = 32;
        for (index = text.length() - 1; lastChar == 32 && index >= 0; --index) {
            lastChar = text.charAt(index);
        }
        return index < 0;
    }

    @Override
    public void setTab(String tab, int pos) {
        try {
            int startPos = this.getLineStartPos(pos);
            int firstNonWSPos = this.getLineFirstCharPos(pos);
            int len = firstNonWSPos - startPos;
            boolean onlySpaces = this._hasOnlySpaces(tab);
            if (!onlySpaces || len != tab.length()) {
                if (onlySpaces) {
                    int diff = tab.length() - len;
                    if (diff > 0) {
                        this.insertString(firstNonWSPos, tab.substring(0, diff), null);
                    } else {
                        this.remove(firstNonWSPos + diff, -diff);
                    }
                } else {
                    this.remove(startPos, len);
                    this.insertString(startPos, tab, null);
                }
            }
        }
        catch (BadLocationException e) {
            throw new UnexpectedException(e);
        }
    }

    @Override
    protected void insertUpdate(AbstractDocument.DefaultDocumentEvent chng, AttributeSet attr) {
        this.clearCache();
        super.insertUpdate(chng, attr);
        try {
            int offset = chng.getOffset();
            int length = chng.getLength();
            String str = this.getText(offset, length);
            InsertCommand doCommand = new InsertCommand(offset, str);
            RemoveCommand undoCommand = new RemoveCommand(offset, length);
            this.addUndoRedo(chng, undoCommand, doCommand);
            doCommand.run();
        }
        catch (BadLocationException ble) {
            throw new UnexpectedException(ble);
        }
    }

    @Override
    protected void removeUpdate(AbstractDocument.DefaultDocumentEvent chng) {
        this.clearCache();
        try {
            int offset = chng.getOffset();
            int length = chng.getLength();
            String removedText = this.getText(offset, length);
            super.removeUpdate(chng);
            RemoveCommand doCommand = new RemoveCommand(offset, length);
            InsertCommand undoCommand = new InsertCommand(offset, removedText);
            this.addUndoRedo(chng, undoCommand, doCommand);
            doCommand.run();
        }
        catch (BadLocationException e) {
            throw new UnexpectedException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insertString(int offset, String str, AttributeSet a) throws BadLocationException {
        this.acquireWriteLock();
        try {
            BraceReduction braceReduction = this._reduced;
            synchronized (braceReduction) {
                this.clearCache();
                super.insertString(offset, str, a);
            }
        }
        finally {
            this.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(int offset, int len) throws BadLocationException {
        this.acquireWriteLock();
        try {
            BraceReduction braceReduction = this._reduced;
            synchronized (braceReduction) {
                this.clearCache();
                super.remove(offset, len);
            }
        }
        finally {
            this.releaseWriteLock();
        }
    }

    @Override
    public String getText() {
        this.acquireReadLock();
        try {
            String string = this.getText(0, this.getLength());
            return string;
        }
        catch (BadLocationException e) {
            throw new UnexpectedException(e);
        }
        finally {
            this.releaseReadLock();
        }
    }

    public byte[] getBytes() {
        return this.getText().getBytes();
    }

    @Override
    public void clear() {
        this.acquireWriteLock();
        try {
            this.remove(0, this.getLength());
        }
        catch (BadLocationException e) {
            throw new UnexpectedException(e);
        }
        finally {
            this.releaseWriteLock();
        }
    }

    protected abstract int startCompoundEdit();

    protected abstract void endCompoundEdit(int var1);

    protected abstract void endLastCompoundEdit();

    protected abstract void addUndoRedo(AbstractDocument.DefaultDocumentEvent var1, Runnable var2, Runnable var3);

    static void access$000(AbstractDJDocument x0, char x1) {
        x0._addCharToReducedModel(x1);
    }

    protected class RemoveCommand
    implements Runnable {
        private final int _offset;
        private final int _length;

        public RemoveCommand(int offset, int length) {
            this._offset = offset;
            this._length = length;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            AbstractDJDocument.this.acquireReadLock();
            try {
                BraceReduction braceReduction = AbstractDJDocument.this._reduced;
                synchronized (braceReduction) {
                    AbstractDJDocument.this.setCurrentLocation(this._offset);
                    AbstractDJDocument.this._reduced.delete(this._length);
                    AbstractDJDocument.this._styleChanged();
                }
            }
            finally {
                AbstractDJDocument.this.releaseReadLock();
            }
        }
    }

    protected class InsertCommand
    implements Runnable {
        private final int _offset;
        private final String _text;

        public InsertCommand(int offset, String text) {
            this._offset = offset;
            this._text = text;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            AbstractDJDocument.this.acquireReadLock();
            try {
                BraceReduction braceReduction = AbstractDJDocument.this._reduced;
                synchronized (braceReduction) {
                    AbstractDJDocument.this._reduced.move(this._offset - AbstractDJDocument.this._currentLocation);
                    int len = this._text.length();
                    for (int i = 0; i < len; ++i) {
                        char curChar = this._text.charAt(i);
                        AbstractDJDocument.access$000(AbstractDJDocument.this, curChar);
                    }
                    AbstractDJDocument.this._currentLocation = this._offset + len;
                    AbstractDJDocument.this._styleChanged();
                }
            }
            finally {
                AbstractDJDocument.this.releaseReadLock();
            }
        }
    }
}

