function varargout = Phone(varargin)
% PHONE M-file for Phone.fig
%      PHONE, by itself, creates a new PHONE or raises the existing
%      singleton*.
%
%      H = PHONE returns the handle to a new PHONE or the handle to
%      the existing singleton*.
%
%      PHONE('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in PHONE.M with the given input arguments.
%
%      PHONE('Property','Value',...) creates a new PHONE or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before Phone_OpeningFcn gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to Phone_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help Phone

% Last Modified by GUIDE v2.5 23-Nov-2012 10:12:54

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @Phone_OpeningFcn, ...
                   'gui_OutputFcn',  @Phone_OutputFcn, ...
                   'gui_LayoutFcn',  [] , ...
                   'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


% --- Executes just before Phone is made visible.
function Phone_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to Phone (see VARARGIN)

% Choose default command line output for Phone
handles.output = hObject;
set(handles.LCD,'String','')
set(handles.CoinToggle,'BackgroundColor','r')
set(handles.PayReminder,'Visible','on')
handles.number = [];
handles.paid = 0;
handles.ListOfContacts = {'911'};
set(handles.Contacts,'String',handles.ListOfContacts)
set(handles.PB0,'Interruptible','off')
set(handles.PB1,'Interruptible','off')
set(handles.PB2,'Interruptible','off')
set(handles.PB3,'Interruptible','off')
set(handles.PB4,'Interruptible','off')
set(handles.PB5,'Interruptible','off')
set(handles.PB6,'Interruptible','off')
set(handles.PB7,'Interruptible','off')
set(handles.PB8,'Interruptible','off')
set(handles.PB9,'Interruptible','off')
set(handles.CoinToggle,'Interruptible','off')
set(handles.axes1,'Interruptible','off','Visible','on')

A = imread('Tower','jpg');
handles.picture = imshow(A);
set(handles.picture,'Visible','off')



% Update handles structure
guidata(hObject, handles);

% UIWAIT makes Phone wait for user response (see UIRESUME)
% uiwait(handles.figure1);


% --- Outputs from this function are returned to the command line.
function varargout = Phone_OutputFcn(hObject, eventdata, handles) 
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
varargout{1} = handles.output;


% --- Executes on button press in PB1.
function PB1_Callback(hObject, eventdata, handles)
ProcessButton(hObject,handles,'1');
% --- Executes on button press in PB2.
function PB2_Callback(hObject, eventdata, handles)
ProcessButton(hObject,handles,'2');
% --- Executes on button press in PB3.
function PB3_Callback(hObject, eventdata, handles)
ProcessButton(hObject,handles,'3');
% --- Executes on button press in PB4.
function PB4_Callback(hObject, eventdata, handles)
ProcessButton(hObject,handles,'4');
% --- Executes on button press in PB5.
function PB5_Callback(hObject, eventdata, handles)
ProcessButton(hObject,handles,'5');
% --- Executes on button press in PB6.
function PB6_Callback(hObject, eventdata, handles)
ProcessButton(hObject,handles,'6');
% --- Executes on button press in PB7.
function PB7_Callback(hObject, eventdata, handles)
ProcessButton(hObject,handles,'7');
% --- Executes on button press in PB8.
function PB8_Callback(hObject, eventdata, handles)
ProcessButton(hObject,handles,'8');
% --- Executes on button press in PB9.
function PB9_Callback(hObject, eventdata, handles)
ProcessButton(hObject,handles,'9');
% --- Executes on button press in PB0.
function PB0_Callback(hObject, eventdata, handles)
ProcessButton(hObject,handles,'0');

% --- Executes on button press in PBasterik.
function PBasterik_Callback(hObject, eventdata, handles)
% No operation performed
% --- Executes on button press in PBpound.
function PBpound_Callback(hObject, eventdata, handles)
% No operation performed.


function LCD_Callback(hObject, eventdata, handles)
% hObject    handle to LCD (see GCBO)

function LCD_CreateFcn(hObject, eventdata, handles)

if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in HangUpButton.
function HangUpButton_Callback(hObject, eventdata, handles)
% hObject    handle to HangUpButton (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

set(handles.LCD,'String','')
set(handles.CoinToggle,'Value',0,'BackgroundColor','r')
handles.paid = 0;
set(handles.axes1,'Visible','off')
set(handles.picture,'Visible','off')
guidata(hObject,handles)



% --- Executes on button press in CoinToggle.
function CoinToggle_Callback(hObject, eventdata, handles)
% hObject    handle to CoinToggle (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of CoinToggle

[y,Fs] = wavread('coin-01');
sound(y,Fs)

set(hObject,'BackgroundColor','g')
handles.paid = 1;
set(handles.PayReminder,'Visible','off')
s = get(handles.LCD,'String');
if length(s)==7 && ~strcmp(s(1),'1')
    set(handles.picture,'Visible','on')
end
guidata(hObject,handles)

if Over(s)
    MakeCall(hObject,handles,s)
end



% --- Executes on selection change in Contacts.
function Contacts_Callback(hObject, eventdata, handles)
% hObject    handle to Contacts (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = cellstr(get(hObject,'String')) returns Contacts contents as cell array
%        contents{get(hObject,'Value')} returns selected item from Contacts

ListOfNumbers = get(handles.Contacts,'String');
% Get hold of the index of the selected item...
IndexOfSelected = get(handles.Contacts,'Value');
% Get the number (as a string):
s = ListOfNumbers{IndexOfSelected};
if length(s)==7 && ~strcmp(s(1),'1')
    % Display local  image...
    set(handles.picture,'Visible','on')
end

set(handles.LCD,'String',s);
guidata(hObject,handles)

if handles.paid
   MakeCall(hObject,handles,s);
else
   set(handles.PayReminder,'Visible','on')
   [y,Fs] = wavread('noCoin');
   sound(y,Fs)
end
guidata(hObject, handles)



% --- Executes during object creation, after setting all properties.
function Contacts_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Contacts (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


function alfa = Over(s)
% s is a string of digit characters.
% Returns "1" if s = '911' or has length 7 and does not begin with '1' 
% or has length 11  and begins with '1'
alfa = 0;
if length(s)==3
   alfa = strcmp(s,'911');
elseif length(s)==7 
   alfa = ~strcmp('1',s(1));
elseif  length(s)==11 
   alfa = strcmp('1',s(1));
end

function playTone(k)
% k is a digit character. Plays the tone associated with that button.
% Get the two frequencies...
if strcmp(k,'1')
    omega_row = 697; omega_col = 1209;
elseif strcmp(k,'2')
    omega_row = 697; omega_col = 1336;
elseif strcmp(k,'3')
    omega_row = 697; omega_col = 1477;
elseif strcmp(k,'4')
    omega_row = 770; omega_col = 1209;
elseif strcmp(k,'5')
    omega_row = 770; omega_col = 1336;
elseif strcmp(k,'6')
    omega_row = 770; omega_col = 1477;
elseif strcmp(k,'7')
    omega_row = 852; omega_col = 1209;
elseif strcmp(k,'8')
    omega_row = 852; omega_col = 1336;
elseif strcmp(k,'9')
    omega_row = 852; omega_col = 1477;
elseif strcmp(k,'0')
    omega_row = 941; omega_col = 1336;
end
% Assemble the waveform and play...
DurationInSeconds = .15;
Fs = 32768;
tVals = 0:(1/Fs):DurationInSeconds;
y = .5*sin(2*pi*omega_row*tVals) + .5*sin(2*pi*omega_col*tVals);
sound(y,Fs);
pause(DurationInSeconds)

function ProcessButton(hObject,handles,k)
% Processes a button push. (Nothing happens if the number is complete.)

% Get the incomplete phone number string...
s = get(handles.LCD,'String');
if ~Over(s)  
   % Append the new digit..
   s = [s k];
   % Update the LCD display and save...
   set(handles.LCD,'String',s)
   guidata(hObject,handles)
   % Play the tone..
   playTone(k);
end
  
if Over(s) 
   % Button-pushing is complete....
   if length(s)==7 && ~strcmp(s(1),'1')
        % Local call so display image...
        set(handles.picture,'Visible','on')
   end
   if handles.paid
      % Call has been paid for...
      MakeCall(hObject,handles,s)
   else
      set(handles.PayReminder,'Visible','on')
      [y,Fs] = wavread('noCoin');
      sound(y,Fs)
   end
end



function MakeCall(hObject,handles,s)
% Processes the telephone number encoded in s, a  string of digits.

% Play back the numbers...
for k=1:length(s)
    playTone(s(k))
end

% Play the ringtone...

RingTone = 5.*wavread('RingTone11025.wav');
sound(RingTone,11025);

% Swallow the coin...
handles.paid  = 0;
set(handles.PayReminder,'Visible','on')
set(handles.CoinToggle,'BackgroundColor','r')


% Update the pop-up log of numbers..
C = get(handles.Contacts,'String');
m = length(C);
C{m+1} = s;
set(handles.Contacts,'String',C);

% Hide the local image...
set(handles.axes1,'Visible','off')
set(handles.picture,'Visible','off')
guidata(hObject,handles)


% --- Executes on button press in pushbutton14.
function pushbutton14_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton14 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --- Executes on button press in PayButton.
function PayButton_Callback(hObject, eventdata, handles)
% hObject    handle to PayButton (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
