function [T, inliers] = ransac_affine(frames1, frames2, matches, ...
                                      threshold, rounds)
% Compute an affine transformation T using RANSAC
% = Inputs =
%   frames1   : feature coordinate frames in the first image
%   frames2   : feature coordinate frames in the second image
%   matches   : matches produced from your match routines
%   threshold : inlier threshold
%   rounds    : number of rounds to run RANSAC
%
% = Outputs =
%   T       : the computed affine transformation (a 3x3 matrix)
%   inliers : indices of the inlier matches
