function [detected, T] = detect_object(template, search)
% This is the main function that will be called for object detection.
% This should call the rest of the helper functions that you will write
% 
% = Inputs =
%    template: the image that you want to find in the search image
%    search:   the image to be searched for the template image
%
% = Outputs =
%    detected: should be set to 1 if the object is detected, 0 otherwise
%    T:        3x3 affine transformation mapping template -> search, if the
%              template image is indeed detected


% Currently, this function just returns the identity transformation.  You
% will replace this silly output with your code.  We've started you off by
% converting the input images to grayscale, if they are color
if size(template, 3) > 1
    template = rgb2gray(template);
end

if size(search, 3) > 1
    search = rgb2gray(search);
end

detected = 1;
T = [ 1 0 0 ; 0 1 0 ; 0 0 1 ];
