function list = listDeleteAtStart(list)
% Delete the first element in a linked list

first = list(1);

% Check if the list is empty
if first == 0
    return; % Nothing to delete
end

% Find the index of the second element (which will be the new first
% element)
second = list(first+3);

% If this element is not null, change this element's backwards pointer to
% point to null
if second ~= 0
    list(second) = 0; 
end

% Change the header to point to this element and update the count
list(1) = second;
list(3) = list(3) - 1;

% If the second element is null, we just deleted the last element in the
% list, so update the header so that the last pointer is null
if second == 0
    list(2) = 0;
end
