function [ labeled, num_components ] = CC(bimage, algo)
% Compute an image 'labeled' where every pixel is labeled with the
% connected component it is in, and return the number of components

[num_rows, num_cols] = size(bimage);
labeled = zeros(num_rows, num_cols);
num_components = 0;
label = 1;

done = 0;

[nz_rows, nz_cols] = find(bimage);
num_nz_elements = length(nz_rows);

while done == 0
    % Search for an unlabeled 1
    root = 0;
    
    [nz_rows, nz_cols] = find(labeled < bimage);
    num_nz_elements = length(nz_rows);

    if num_nz_elements == 0
        done = 1;
        break;
    end
    
    root = 1;

    % Found an unlabeled 1
    root_row = nz_rows(root);
    root_col = nz_cols(root);

    if algo == 'DFS'
        labeled = CC_DFS_student(bimage, root_row, root_col, label, labeled);
    elseif algo == 'BFS'
        labeled = CC_BFS_student(bimage, root_row, root_col, label, labeled);
    end
        
    num_components = num_components + 1;
    label = label + 1;
end

