function stickMan = stickManWaves()
% returns a cloud of 2D points representing a stick man waving their left
% arm, while standing on one leg
% in form
%     r1 r2 ... rn
%     c1 c2 ... cn

maxPt = 3000;
stickMan = zeros(2,maxPt);

% head
maxHeadPt = floor(maxPt * 3/5);
for i = 1:maxHeadPt
    dist = 35*rand(1);
    theta = 360*rand(1);
    stickMan(:,i) = (makeRotation(theta) * [0; dist]) + [100;0];
end

% torso / leg
maxLegPt = maxHeadPt + floor(maxPt * 2/15);
for j = (maxHeadPt + 1):maxLegPt
    r = 75 * rand(1);
    c = 20 * rand(1) - 10;
    stickMan(:,j) = [r;c];
end

% arm
maxArmPt = maxLegPt + floor(maxPt * 2/15);
for k = (maxLegPt + 1):maxArmPt
    rmv = 15 * rand(1) - 10;
    cmv = 15 * rand(1) - 10;
    stickMan(:,k) = [60 + rmv; (k - (maxLegPt+1))*(55/(maxArmPt-(maxLegPt+1))) + cmv];
end

% hand
for l = (maxArmPt + 1):maxPt
   rmv = 15 * rand(1) - 10;
   cmv = 15 * rand(1) - 10;
   stickMan(:,l) = [(l - (maxLegPt+1))*(15/(maxArmPt-(maxLegPt+1))) + 55 + rmv; 50 + cmv];
end

end
