function [] = plotPoints(varargin)
% plots up to two point sets of the form
%    r1 r2 ... rn
%    c1 c2 ... cn
%
% Examples:
%     plotPoints(a)
%     plotPoints(a,b)

if (nargin == 1)
    a = varargin{1};
    minr = min(a(1,:));
    maxr = max(a(1,:));
    minc = min(a(2,:));
    maxc = max(a(2,:));
    
    figure();
    hold on;
    axis([minc maxc minr maxr]);
    axis square;
    [m,n] = size(a);
    for i = 1:n
        plot(a(2,i),a(1,i),'b.');
    end
    hold off;
    
else
    a = varargin{1};
    b = varargin{2};
    
    minr = min(min(a(1,:)), min(b(1,:)));
    maxr = max(max(a(1,:)), max(b(1,:)));
    minc = min(min(a(2,:)), min(b(2,:)));
    maxc = max(max(a(2,:)), max(b(2,:)));
    
    figure();
    hold on;
    axis([minc maxc minr maxr]);
    axis square;
    [ma,na] = size(a);
    [mb,nb] = size(b);
    for i = 1:na
        plot(a(2,i),a(1,i),'r.');
    end
    for i = 1:nb
        plot(b(2,i),b(1,i),'b.');
    end
    hold off;    
end


end