using System;
using System.Xml;
using System.Reflection;
using System.Net;
using System.IO;
using System.Text;

namespace Cornell.Cs100r.Robotics.DssLogoApiToPennbot
{
	/// <summary>
	/// Summary description for RociPin.
	/// </summary>
	public class RociPin
	{
        public delegate void LoggerFn(string s);

		protected string host;
		protected string task;
		protected string service;
		protected string pin;

		public RociPin(string location)
		{
			string[] t = location.Split('.');
			switch(t.Length)
			{
				case 4:	// hostname.task.service.port
					host = t[0];
					task = t[1];
					service = t[2];
					pin = t[3];
					break;
				case 3: // task.service.port
					host = "localhost";
					task = t[0];
					service = t[1];
					pin = t[3];
					break;
				default:
					throw new ArgumentException("Unable to parse location into a ROCI Pin Descriptor", "location");
					
			}
		}

        public string getUri()
        {
            return String.Format("http://{0}:2010/{1}/{2}/{3}/XML", host, task, service, pin);
        }

		public void SendData(object o)
		{
			this.SendData(o, o.GetType().FullName,null);
		}

		public void SendData(object o, string sendType, LoggerFn log)
		{

			XmlDocument doc = ROCISerializer.Serialize(o, sendType);
            string reqUri = this.getUri();

            if (log != null) log("about to build a HttpWebRequest with URI " + reqUri);
			HttpWebRequest req = (HttpWebRequest) WebRequest.Create(reqUri);

			req.ContentType = "text/xml";
			req.Method = "POST";
			req.Expect = "";
			req.Accept = "*/*";

            req.KeepAlive = false;
            req.Pipelined = false;
            req.SendChunked = false;
            req.ReadWriteTimeout = 5000;
			/*
			MemoryStream tmp = new MemoryStream();
			XmlTextWriter tmpWriter = new XmlTextWriter(
			doc.WriteTo(tmpWriter);
*/
			
			int l = doc.InnerXml.Length;

			req.ContentLength = l+2;
	

			/*
			XmlTextWriter writer = new XmlTextWriter(req.GetRequestStream(), System.Text.Encoding.UTF8);
			int m = doc.InnerText.Length;
			doc.WriteTo(writer);
			writer.Close();
			*/

            if (log != null) log("about to GetRequestStream");
			Stream tmp = req.GetRequestStream();
			ASCIIEncoding encoding = new ASCIIEncoding();
			byte[] data = encoding.GetBytes(doc.InnerXml);
            if (log != null) log("about to write data to stream");
			tmp.Write(data, 0, data.Length);
			tmp.Write(encoding.GetBytes("\r\n"), 0, 2);
			tmp.Close();

			try 
			{
				//if(req.HaveResponse) 
				{
					HttpWebResponse resp = (HttpWebResponse) req.GetResponse();

                    if (log != null) log("about to GetResponseStream");
					Stream respStream = resp.GetResponseStream();
                    resp.Close();
					//byte[] rv = new byte[resp.ContentLength];
					//string rString = encoding.GetString(rv, 0, (int) resp.ContentLength);
					//Console.WriteLine(rString);
                    //if (log != null) log("rString = '" + rString + "'");
                }
                //else { if (log != null) log("no response returned"); }

			} 
			catch (Exception e) 
			{
				Console.WriteLine("Caught Exception");
			}

            


		}
	}
}
