using System;
using System.Xml;
using System.Reflection;

namespace Cornell.Cs100r.Robotics.DssLogoApiToPennbot
{
	/// <summary>
	/// Summary description for ROCISerializer.
	/// </summary>
	public class ROCISerializer
	{
		public ROCISerializer()
		{
		}

		public static XmlDocument Serialize(object o) 
		{
			return Serialize(o, o.GetType().FullName);
		}

		public static XmlDocument Serialize(object o, string sendType)
		{
			XmlDocument x = new XmlDocument();

			x.AppendChild(x.CreateProcessingInstruction("xml", "version=\"1.0\" encoding=\"utf-8\""));
			
			XmlAttribute tAttribute = x.CreateAttribute("type");
			tAttribute.Value = sendType;
			
			x.AppendChild(x.CreateElement("PinData"));
			x.DocumentElement.Attributes.Append(tAttribute);

			XmlElement timeElement = x.CreateElement("Time");
			timeElement.InnerText = DateTime.Now.ToString();
			x.DocumentElement.AppendChild(timeElement);

			FieldInfo[] fields = o.GetType().GetFields();
			foreach(FieldInfo cur in fields) 
			{
				if(cur.DeclaringType != o.GetType())
					continue;

				XmlElement curN = x.CreateElement(cur.Name);
				XmlAttribute curAt = x.CreateAttribute("type");

				curN.InnerText = cur.GetValue(o).ToString();
				curAt.Value = cur.FieldType.ToString();

				curN.Attributes.Append(curAt);
				x.DocumentElement.AppendChild(curN);
			}

			return x;
		}
	}
}
