//------------------------------------------------------------------------------
// LogoApiToPennbot.cs
//
//     This code was generated by the DssNewService tool.
//
//------------------------------------------------------------------------------
using Microsoft.Ccr.Core;
using Microsoft.Dss.Core;
using Microsoft.Dss.Core.Attributes;
using Microsoft.Dss.ServiceModel.Dssp;
using Microsoft.Dss.ServiceModel.DsspServiceBase;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Security.Permissions;
using xml = System.Xml;
using Cornell.Cs100r.Robotics.LogoApi.Proxy;
using System.Configuration;
using System.Net.Configuration;
using System.Xml;


namespace Cornell.Cs100r.Robotics.DssLogoApiToPennbot
{
    
    [DisplayName("LogoApiToPennbot")]
    [Description("The LogoApiToPennbot Service")]
    [Contract(Contract.Namespace)]
    [AlternateContract(Cornell.Cs100r.Robotics.LogoApi.Proxy.Contract.Namespace)]
    //[PermissionSet(SecurityAction.PermitOnly, Name="Execution")]
    public class LogoApiToPennbotService : DsspServiceBase
    {
        public const ushort MAX_SPEED = 1000;

        [InitialStatePartner(Optional = false, ServiceUri = "CS100R-initial-state.xml")]
        private StateType _state;

        [ServicePort("/logoapitopennbot", AllowMultipleInstances=false)]
        private LogoApiToPennbotOperations _mainPort = new LogoApiToPennbotOperations();

        // For the PointHead handler
        private double currentBearing;

        /// <summary>
        /// Default Service Constructor
        /// </summary>
        public LogoApiToPennbotService(DsspServiceCreationPort creationPort) : 
                base(creationPort)
        {
			CreateSuccess();
        }
        /// <summary>
        /// Service Start
        /// </summary>
        protected override void Start()
        {
            if (_state == null)
            {
                _state = new StateType();
                /*_state.IPAddress = "fuckyou";
                this.SaveState(_state);*/
            }

            _state.CurSpeed = 500;

            /* From http://www.cookcomputing.com/blog/archives/000556.html
               For some reason the .NET HTTP components don't like ROCI.  --cgd */
            Configuration config = ConfigurationManager.OpenExeConfiguration(ConfigurationUserLevel.None);
            SettingsSection section = (SettingsSection)config.GetSection("system.net/settings");
            section.HttpWebRequest.UseUnsafeHeaderParsing = true;
            config.Save();

            // Listen on the main port for requests and call the appropriate handler.
            ActivateDsspOperationHandlers();

            // Publish the service to the local Node Directory
            DirectoryInsert();

			// display HTTP service Uri
			LogInfo(LogGroups.Console, "Service uri: " + ServiceInfo.Service);

            currentBearing = 0.0;
        }
        /// <summary>
        /// Get Handler
        /// </summary>
        /// <param name="get"></param>
        /// <returns></returns>
        [ServiceHandler(ServiceHandlerBehavior.Concurrent)]
        public virtual IEnumerator<ITask> GetHandler(Get get)
        {
            get.ResponsePort.Post(_state);
            yield break;
        }
        /// <summary>
        /// Replace Handler
        /// </summary>
        /// <param name="replace"></param>
        /// <returns></returns>
        [ServiceHandler(ServiceHandlerBehavior.Exclusive)]
        public virtual IEnumerator<ITask> ReplaceHandler(Replace replace)
        {
            _state = replace.Body;
            replace.ResponsePort.Post(DefaultReplaceResponseType.Instance);
            yield break;
        }

        [ServiceHandler(ServiceHandlerBehavior.Concurrent)]
        public virtual IEnumerator<ITask> GrabFrameHandler(GetImageCommand gi)
        {

            LogInfo("Received GetImage command");

            try
            {
                //GetImage r = new GetStepsResponse();

                LogInfo(LogGroups.Console, "Making RociPin");
                RociPin p = new RociPin(_state.IPAddress + ".DShowPreview.DShow.VideoOutputPin");

                XmlTextReader rdr = new XmlTextReader(p.getUri());

                LogInfo(LogGroups.Console, string.Format("Loading document from {0}", p.getUri()));
                XmlDocument doc = new XmlDocument();
                doc.Load(rdr);

                LogInfo(LogGroups.Console, "Looking for Pixels");
                XmlNodeList nlist = doc.GetElementsByTagName("Pixels");
                if (nlist.Count == 0) throw new Exception();
                XmlNode elem = nlist.Item(0);
                
                LogInfo(LogGroups.Console, "Trying to parse element innertext");
                LogInfo(LogGroups.Console, "url = " + elem.FirstChild.Attributes.GetNamedItem("href").InnerText);

                LogInfo(LogGroups.Console, "attempting to retrieve image ...");
                
                System.Net.WebRequest request = System.Net.WebRequest.Create(elem.FirstChild.Attributes.GetNamedItem("href").InnerText);
                System.Net.WebResponse response = request.GetResponse();
                System.IO.Stream responseStream = response.GetResponseStream();

                System.Drawing.Bitmap msbmp = new System.Drawing.Bitmap(responseStream);

                MyBitmap bmp = new MyBitmap();
                bmp.data = new System.IO.MemoryStream();
                msbmp.RotateFlip(System.Drawing.RotateFlipType.RotateNoneFlipY);

                msbmp.Save(bmp.data, System.Drawing.Imaging.ImageFormat.Bmp);                
                bmp.data.Position = 0;

                //r.steps = ulong.Parse(elem.InnerText);

                LogInfo(LogGroups.Console, "About to post back...");
                gi.ResponsePort.Post(bmp);

            }
            catch (Exception e)
            {
                LogError(LogGroups.Console, "Exception in GetSteps, returning Fault");
                LogError(LogGroups.Console, "Information: " + e.Message + e.StackTrace);

                Fault f = new Fault();
                gi.ResponsePort.Post(f);
            }

            LogInfo(LogGroups.Console, "Done.");

            yield break;
        }



        // FIXME TODO THESE NEED ERROR HANDLING!
        [ServiceHandler(ServiceHandlerBehavior.Concurrent)]
        public virtual IEnumerator<ITask> TurnHandler(TurnCommand t)
        {
            TurnPin tp = new TurnPin((float)t.Body.Degrees, Math.Min(MAX_SPEED, _state.CurSpeed));
            RociPin p = new RociPin(_state.IPAddress + ".CS100RSetup.Driver.TurnInputPin");
            LogInfo("Turning; degrees=" + t.Body.Degrees);
            p.SendData(tp, "CS100R.DriveControllerPins.StraightPin", LogInfo);
            LogInfo("Posted to ROCI");
            t.ResponsePort.Post(new Success());
            yield break;
        }

        [ServiceHandler(ServiceHandlerBehavior.Concurrent)]
        public virtual IEnumerator<ITask> DriveHandler(DriveCommand d)
        {
            StraightPin sp = new StraightPin((float)d.Body.Distance, Math.Min(MAX_SPEED,_state.CurSpeed));
            RociPin p = new RociPin(_state.IPAddress + ".CS100RSetup.Driver.StraightInputPin");
            LogInfo("Driving straight; distance=" + d.Body.Distance);
            p.SendData(sp, "CS100R.DriveControllerPins.StraightPin", LogInfo);
            LogInfo("Posted to ROCI");
            d.ResponsePort.Post(new Success());
            yield break;
        }

        [ServiceHandler(ServiceHandlerBehavior.Concurrent)]
        public virtual IEnumerator<ITask> RawAiboHandler(AiboCommand a)
        {
            Fault f = new Fault();
            f.Message = "Aibo-specific functionality not supported on Pennbot";
            a.ResponsePort.Post(f);

            yield break;
        }

        [ServiceHandler(ServiceHandlerBehavior.Concurrent)]
        public virtual IEnumerator<ITask> SpeakHandler(SpeakCommand s)
        {
            // TODO FIXME!
            Fault f = new Fault();
            f.Message = "Not yet supported on Pennbot";
            s.ResponsePort.Post(f);

            yield break;
        }

        [ServiceHandler(ServiceHandlerBehavior.Concurrent)]
        public virtual IEnumerator<ITask> IsDoneHandler(IsDoneCommand d)
        {
            LogInfo("Making RociPin");
            RociPin p = new RociPin(_state.IPAddress + ".CS100RSetup.Robot.RightMotorStatusPin");

            XmlTextReader rdr = new XmlTextReader(p.getUri());

            LogInfo(string.Format("Loading document from {0}", p.getUri()));
            XmlDocument doc = new XmlDocument();
            doc.Load(rdr);

            LogInfo("Looking for Position");
            XmlNodeList nlist = doc.GetElementsByTagName("Position");
            if (nlist.Count == 0) throw new Exception();
            XmlNode elem = nlist.Item(0);
            LogInfo("Trying to parse element innertext");
            ulong position = ulong.Parse(elem.InnerText);

            LogInfo("About to post back...");


            IsDoneResponse resp = new IsDoneResponse();
            resp.isDone = (position == 0);
            d.ResponsePort.Post(resp);

            yield break;
        }

        [ServiceHandler(ServiceHandlerBehavior.Concurrent)]
        public virtual IEnumerator<ITask> PointHeadHandler(PointHeadCommand p)
        {
            // This is a kludge for A3.
            LogInfo(string.Format("Received PointHead command: (x,y,z) = ({0},{1},{2})", p.Body.X,p.Body.Y ,p.Body.Z));
            double newDegrees = p.Body.X / 2;

            double turnDeg = newDegrees - currentBearing;
            currentBearing += turnDeg;

            LogInfo(string.Format("newDegrees = {0}, currentBearing = {1}, turnDeg = {2}", newDegrees,currentBearing,turnDeg));

            TurnCommand t = new TurnCommand();
            t.Body.Degrees = turnDeg;

            _mainPort.Post(t);

            yield return Arbiter.Choice(t.ResponsePort,
                delegate(Fault f) { p.ResponsePort.Post(f); },
                delegate(Success s) { p.ResponsePort.Post(s); });
        }

        [ServiceHandler(ServiceHandlerBehavior.Concurrent)]
        public virtual IEnumerator<ITask> SetSpeedHandler(SetSpeedCommand c)
        {
            LogInfo(string.Format("Received SetSpeed command: speed = {0}", c.Body.Speed));
            ushort newSpeed = Math.Min(MAX_SPEED, (ushort)c.Body.Speed);
            LogInfo(string.Format("Setting speed to {0}", newSpeed));
            _state.CurSpeed = newSpeed;

            c.ResponsePort.Post(new Success());
            yield break;
        }

        [ServiceHandler(ServiceHandlerBehavior.Concurrent)]
        public virtual IEnumerator<ITask> GetStepsHandler(GetStepsCommand c)
        {
            LogInfo("Received GetSteps command");

            try
            {
                GetStepsResponse r = new GetStepsResponse();

                LogInfo("Making RociPin");
                RociPin p = new RociPin(_state.IPAddress + ".CS100RSetup.Driver.MotorStatusOut");

                XmlTextReader rdr = new XmlTextReader(p.getUri());

                LogInfo(string.Format("Loading document from {0}",p.getUri()));
                XmlDocument doc = new XmlDocument();
                doc.Load(rdr);

                LogInfo("Looking for lsteps");
                XmlNodeList nlist = doc.GetElementsByTagName("lsteps");
                if (nlist.Count == 0) throw new Exception();
                XmlNode elem = nlist.Item(0);
                LogInfo("Trying to parse element innertext");
                r.steps = ulong.Parse(elem.InnerText);

                LogInfo("About to post back...");
                c.ResponsePort.Post(r);
            }
            catch (Exception e)
            {
                LogError("Exception in GetSteps, returning Fault");
                Fault f = new Fault();
                c.ResponsePort.Post(f);
                
            }
            yield break;
        }
    }
}
