//------------------------------------------------------------------------------
// LogoApiToAibo.cs
//
//     This code was generated by the DssNewService tool.
//
//------------------------------------------------------------------------------
using Microsoft.Ccr.Core;
using Microsoft.Dss.Core;
using Microsoft.Dss.Core.Attributes;
using Microsoft.Dss.ServiceModel.Dssp;
using Microsoft.Dss.ServiceModel.DsspServiceBase;
using System;
using System.Collections.Generic;
using System.Security.Permissions;
using xml = System.Xml;

using Cornell.Cs100r.Robotics.LogoApi.Proxy;
using aibo = Cornell.Cs100r.Robotics.DssAibo.Proxy;

namespace Cornell.Cs100r.Robotics.DssLogoApiToAibo
{
    
    [Contract(Contract.Namespace)]
    [AlternateContract(Cornell.Cs100r.Robotics.LogoApi.Proxy.Contract.Namespace)]
    [PermissionSet(SecurityAction.PermitOnly, Name="Execution")]
    public class LogoApiToAibo : DsspServiceBase
    {
        private StateType _state = new StateType();

        [ServicePort("/LogoApiToAibo", AllowMultipleInstances=true)]
        private LogoApiToAiboOperations _mainPort = new LogoApiToAiboOperations();

        [Partner("Aibo",Contract=aibo.Contract.Namespace,CreationPolicy=PartnerCreationPolicy.UseExisting)]
        private aibo.AiboOperations _aiboPort = new aibo.AiboOperations();

        public LogoApiToAibo(DsspServiceCreationPort creationPort) : 
                base(creationPort)
        {
			CreateSuccess();
        }
        protected override void Start()
        {

            // Listen on the main port for requests and call the appropriate handler.
            ActivateDsspOperationHandlers();

            // Publish the service to the local Node Directory
            DirectoryInsert();

			// display HTTP service Uri
			LogInfo(LogGroups.Activation, "Service uri: " + base.FindServiceAliasFromScheme(Uri.UriSchemeHttp));
        }
        /// <summary>
        /// Get Handler
        /// </summary>
        /// <param name="get"></param>
        /// <returns></returns>
        [ServiceHandler(ServiceHandlerBehavior.Concurrent)]
        public virtual IEnumerator<ITask> GetHandler(Get get)
        {
            get.ResponsePort.Post(_state);
            yield break;
        }
        /// <summary>
        /// Replace Handler
        /// </summary>
        /// <param name="replace"></param>
        /// <returns></returns>
        [ServiceHandler(ServiceHandlerBehavior.Exclusive)]
        public virtual IEnumerator<ITask> ReplaceHandler(Replace replace)
        {
            _state = replace.Body;
            replace.ResponsePort.Post(DefaultReplaceResponseType.Instance);
            yield break;
        }

        [ServiceHandler(ServiceHandlerBehavior.Concurrent)]
        public virtual IEnumerator<ITask> GrabFrameHandler(GetImageCommand gi)
        {
            aibo.GrabFrame gf = new aibo.GrabFrame(new aibo.GrabFrameRequest());
            _aiboPort.Post(gf);
            yield return Arbiter.Choice(gf.ResponsePort,
                delegate(Fault f)
                {
                    gi.ResponsePort.Post(f);
                },
                delegate(MyBitmap bmp)
                {
                    gi.ResponsePort.Post(bmp);
                });
        }

        private aibo.WalkRequest makeWalkRequest(double x, double y, double a, double duration)
        {
            aibo.WalkRequest w = new aibo.WalkRequest();
            w.x = x;
            w.y = y;
            w.a = a;
            w.duration = duration;
            return w;
        }

        /* FIXME: BEWARE!!! MAGIC CONSTANTS BELOW!!!
         * 
         * Shake: Are you the guy that keeps telling me to beware?  
         *        'Cause I'll tell you where to be.  Out of my sight!
         * 
         * --cgd */

        [ServiceHandler(ServiceHandlerBehavior.Exclusive)]
        public virtual IEnumerator<ITask> TurnHandler(TurnCommand t)
        {
            double turnRate = 0.15;
            if (t.Body.Degrees > 0) turnRate = -turnRate;

            double turnTime = Math.Abs(t.Body.Degrees) / 6;

            aibo.Walk w = new aibo.Walk(makeWalkRequest(0, 0, turnRate, turnTime));

            _aiboPort.Post(w);
            updateFinishedTime(turnTime);

            yield return Arbiter.Choice(w.ResponsePort,
                delegate(Fault f) { t.ResponsePort.Post(f); },
                delegate(Success s) { t.ResponsePort.Post(s); });
        }

        [ServiceHandler(ServiceHandlerBehavior.Exclusive)]
        public virtual IEnumerator<ITask> DriveHandler(DriveCommand d)
        {
            double walkRate = 7.5;
            if (d.Body.Distance < 0) walkRate = -walkRate;

            double walkTime = Math.Abs(d.Body.Distance) * 30;

            aibo.Walk w = new aibo.Walk(makeWalkRequest(0, walkRate, 0, walkTime));

            _aiboPort.Post(w);
            updateFinishedTime(walkTime);

            yield return Arbiter.Choice(w.ResponsePort,
                delegate(Fault f) { d.ResponsePort.Post(f); },
                delegate(Success s) { d.ResponsePort.Post(s); });

        }

        protected virtual void updateFinishedTime(double aiboTicks)
        {
            DateTime d = DateTime.Now;
            d.AddSeconds(aiboTicks / 30);
            _state.MoveFinishesAt = d;
        }

        [ServiceHandler(ServiceHandlerBehavior.Concurrent)]
        public virtual IEnumerator<ITask> RawAiboHandler(AiboCommand a)
        {
            aibo.RawCommand r = new aibo.RawCommand(new aibo.RawCommandRequest());
            r.Body.command = a.Body.Command;

            _aiboPort.Post(r);

            yield return Arbiter.Choice(r.ResponsePort,
                delegate(Fault f) { a.ResponsePort.Post(f); },
                delegate(Success s) { a.ResponsePort.Post(s); });
        }

        [ServiceHandler(ServiceHandlerBehavior.Concurrent)]
        public virtual IEnumerator<ITask> PointHeadHandler(PointHeadCommand p)
        {
            aibo.PointHead ap = new aibo.PointHead();
            ap.Body.x = p.Body.X;
            ap.Body.y = p.Body.Y;
            ap.Body.z = p.Body.Z;

            _aiboPort.Post(ap);
            yield return Arbiter.Choice(ap.ResponsePort,
                delegate(Fault f) { p.ResponsePort.Post(f); },
                delegate(Success s) { p.ResponsePort.Post(s); });
        }


        [ServiceHandler(ServiceHandlerBehavior.Concurrent)]
        public virtual IEnumerator<ITask> SpeakHandler(SpeakCommand s)
        {
            Fault f = new Fault();
            f.Message="Speak command not supported by Aibo";
            s.ResponsePort.Post(f);
            yield break;
        }

        [ServiceHandler(ServiceHandlerBehavior.Exclusive)]
        public virtual IEnumerator<ITask> IsDoneHandler(IsDoneCommand d)
        {
            IsDoneResponse resp = new IsDoneResponse();
            if (_state.MoveFinishesAt == null || _state.MoveFinishesAt > DateTime.Now)
            {
                resp.isDone = false;
            }
            else
            {
                resp.isDone = true;
            }

            d.ResponsePort.Post(resp);

            yield break;
        }

        [ServiceHandler(ServiceHandlerBehavior.Concurrent)]
        public virtual IEnumerator<ITask> SetSpeedHandler(SetSpeedCommand c)
        {
            Fault f = new Fault();
            f.Message = "SetSpeed command not supported on Aibo";
            c.ResponsePort.Post(f);

            yield break;
        }

        [ServiceHandler(ServiceHandlerBehavior.Concurrent)]
        public virtual IEnumerator<ITask> GetStepsHandler(GetStepsCommand c)
        {
            Fault f = new Fault();
            f.Message = "GetSteps command not supported on Aibo";
            c.ResponsePort.Post(f);

            yield break;
        }
    }
}
