using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

using Microsoft.Ccr.Core;
using System.Reflection;
using System.Collections;
using Microsoft.Dss.ServiceModel.Dssp;
using Cornell.Cs100r.Robotics.LogoApi.Proxy;

namespace Cornell.Cs100r.Robotics.DssLogoApiTester
{
    public partial class LogoApiTesterGUI : Form
    {
        LogoApiTesterGUIOperations eventSendPort;
        
        public LogoApiTesterGUI(LogoApiTesterGUIOperations sendPort)
        {
            this.eventSendPort = sendPort;
            InitializeComponent();
        }

        private void LogoApiTesterGUI_Load(object sender, EventArgs e)
        {
            
            Array rbTypeValues = Enum.GetValues(typeof(RobotTypes));
            foreach(object i in rbTypeValues)
                lstRobotTypes.Items.Add(i);
            eventSendPort.Post(new LoadEvent(this));
        }

        private void btnConnect_Click(object sender, EventArgs e)
        {
            if (lstRobotTypes.SelectedIndices.Count == 1)
            {
                RobotTypes rb = (RobotTypes)lstRobotTypes.SelectedItem;
                if (txtIP.Text.Length > 0)
                {
                    ConnectEvent ce = new ConnectEvent(this, txtIP.Text, rb);
                    eventSendPort.Post(ce);
                }
            }
        }

        public void updateStatusText(string s)
        {
            toolStripStatusLabel1.Text = s;
        }

        private void btnDrive_Click(object sender, EventArgs e)
        {
            DriveCommandData dc = new DriveCommandData();
            dc.Distance = float.Parse(txtDistance.Text);
            eventSendPort.Post(new LogoApiEvent(this, dc));
        }

        private void btnTurn_Click(object sender, EventArgs e)
        {
            TurnCommandData tc = new TurnCommandData();
            tc.Degrees = float.Parse(txtDegrees.Text);
            eventSendPort.Post(new LogoApiEvent(this, tc));
        }
    }

    public class LogoApiTesterGUIOperation
    {
        private LogoApiTesterGUI _gui;

        public LogoApiTesterGUI GUI { get { return _gui; } }

        public LogoApiTesterGUIOperation(LogoApiTesterGUI gui)
        {
            _gui = gui;
        }
    }

    public class LoadEvent : LogoApiTesterGUIOperation
    {
        public LoadEvent(LogoApiTesterGUI gui)
            : base(gui)
        {
        }
    }

    public class ConnectEvent : LogoApiTesterGUIOperation
    {
        string address;
        RobotTypes robotType;

        public ConnectEvent(LogoApiTesterGUI gui, string address, RobotTypes robotType)
            : base(gui)
        {
            this.address = address;
            this.robotType = robotType;
        }

        public string Address { get { return address; } }

        public RobotTypes RobotType { get { return robotType; } }
    }

    public class LogoApiEvent : LogoApiTesterGUIOperation
    {
        LogoApiCommand cmd;

        public LogoApiEvent(LogoApiTesterGUI gui, LogoApiCommand cmd)
            : base(gui)
        {
            this.cmd = cmd;
        }

        public LogoApiCommand Command { get { return cmd; } }
    }

    public class LogoApiTesterGUIOperations : PortSet<LoadEvent, ConnectEvent, LogoApiEvent> { }


}
