//------------------------------------------------------------------------------
// LogoApiTester.cs
//
//     This code was generated by the DssNewService tool.
//
//------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using attributes = Microsoft.Dss.Core.Attributes;
using ccr = Microsoft.Ccr.Core;
using Microsoft.Ccr.Core;
using dsslogoapitester = Cornell.Cs100r.Robotics.DssLogoApiTester;
using permissions = System.Security.Permissions;
using svcbase = Microsoft.Dss.ServiceModel.DsspServiceBase;
using dssp = Microsoft.Dss.ServiceModel.Dssp;
using Microsoft.Dss.ServiceModel.Dssp;

using Cornell.Cs100r.Robotics.LogoApi.Proxy;
using Microsoft.Ccr.Adaptors.WinForms;
using System.Reflection;
using aibo = Cornell.Cs100r.Robotics.DssAibo.Proxy;

namespace Cornell.Cs100r.Robotics.DssLogoApiTester
{

    [attributes.Contract(Contract.Namespace)]
    [permissions.PermissionSet(permissions.SecurityAction.PermitOnly, Name = "FullTrust")]
    public partial class LogoApiTester : svcbase.DsspServiceBase
    {
        private StateType _state = new StateType();
        [attributes.ServicePort("/LogoApiTester", AllowMultipleInstances=true)]
        private LogoApiTesterOperations _mainPort = new LogoApiTesterOperations();

        [attributes.Partner("Aibo", Contract = aibo.Contract.Namespace,
            CreationPolicy = attributes.PartnerCreationPolicy.UseExistingOrCreate)]
        aibo.AiboOperations _aiboPort = new aibo.AiboOperations();

        LogoApiTesterGUI _GUI;
        LogoApiTesterGUIOperations _guiPort = new LogoApiTesterGUIOperations();
        LogoApiOperations _robotPort = new LogoApiOperations();

        CastAndPost poster;

        public LogoApiTester(dssp.DsspServiceCreationPort creationPort)
            :
                base(creationPort)
        {
            CreateSuccess();
        }
        protected override void Start()
        {
            poster = new CastAndPost(this.LogInfo, this.LogError);
            // Listen on the main port for requests and call the appropriate handler.

            Activate(
                ccr.Arbiter.Interleave(
                    new ccr.TeardownReceiverGroup(
                        ccr.Arbiter.Receive<dssp.DsspDefaultDrop>(false, _mainPort, DefaultDropHandler)
                    ),
                    new ccr.ExclusiveReceiverGroup
                    (
                        ccr.Arbiter.ReceiveWithIterator<Replace>(true, _mainPort, ReplaceHandler),
                        ccr.Arbiter.ReceiveWithIterator<Subscribe>(true, _mainPort, SubscribeHandler),
                        ccr.Arbiter.ReceiveWithIterator<ConnectEvent>(true, _guiPort, ConnectHandler)
                    ),
                    new ccr.ConcurrentReceiverGroup
                    (
                        ccr.Arbiter.ReceiveWithIterator<Get>(true, _mainPort, GetHandler),
                        ccr.Arbiter.Receive<dssp.DsspDefaultLookup>(true, _mainPort, DefaultLookupHandler),
                        ccr.Arbiter.Receive<LoadEvent>(true, _guiPort, LoadHandler),
                        ccr.Arbiter.Receive<LogoApiEvent>(true, _guiPort, LogoApiHandler),
                        ccr.Arbiter.Receive<DriveCommand>(true, _robotPort, DriveHandler)
                        //ccr.Arbiter.Receive<LogoApiCommand>(true, _robotPort, CmdHandler)
                    ))
            );


            // Insert ourselves into the directory so that others can find us
            DirectoryInsert();

            // Display browser accesible Service URI
            LogInfo("Service uri: " + ServiceInfo.Service);

            WinFormsServicePort.Post(new RunForm(CreateForm));
        }

        /* Winforms interaction */
        System.Windows.Forms.Form CreateForm()
        {
            LogInfo("CreateForm() called");
            return new LogoApiTesterGUI(_guiPort);
        }
        PortSet<EmptyValue, Exception> MarshalInvoke(System.Windows.Forms.MethodInvoker mi)
        {
            FormInvoke formInvoke = new FormInvoke(mi);
            WinFormsServicePort.Post(formInvoke);
            return formInvoke.ResultPort;
        }
        Choice Invoke(System.Windows.Forms.MethodInvoker mi)
        {
            FormInvoke formInvoke = new FormInvoke(mi);

            WinFormsServicePort.Post(formInvoke);

            return Arbiter.Choice(
                formInvoke.ResultPort,
                delegate(EmptyValue v) { },
                delegate(Exception e)
                {
                    LogError(e);
                }
            );
        }

        private IEnumerator<ccr.ITask> GetHandler(Get get)
        {
            get.ResponsePort.Post(_state);
            yield break;
        }
        private IEnumerator<ccr.ITask> ReplaceHandler(Replace replace)
        {
            _state = replace.Body;
            replace.ResponsePort.Post(dssp.DefaultReplaceResponseType.Instance);
            yield break;
        }
        private IEnumerator<ccr.ITask> SubscribeHandler(Subscribe subscribe)
        {
            yield break;
        }

        void LoadHandler(LoadEvent le)
        {
            _GUI = le.GUI;

            LogInfo("Loaded form");
        }

        IEnumerator<ccr.ITask> ConnectHandler(ConnectEvent ce)
        {
            if (ce.GUI == _GUI)
            {
                PortSet<Fault,Success> rsp = null;
                switch (ce.RobotType)
                {
                    case RobotTypes.Aibo:
                        aibo.ConnectRequest cr = new aibo.ConnectRequest();
                        cr.hostname = ce.Address;
                        aibo.Connect con = new aibo.Connect(cr);

                        _aiboPort.Post(con);

                        rsp = con.ResponsePort;
                        break;
                    case RobotTypes.PennBot:
                        rsp = null;
                        break;
                }

                yield return Invoke(delegate() { _GUI.updateStatusText("Connecting..."); });

                yield return Arbiter.Choice(rsp,
                            delegate(Fault fault)
                            {
                                LogError("Robot service returned an error in connecting to " +
                                    ce.Address + ": " + fault.Message);
                                Invoke(delegate()
                                {
                                    string str = "Could not connect: " + fault.Message;
                                    _GUI.updateStatusText(str);
                                    System.Windows.Forms.MessageBox.Show(str, "Could not connect");
                                });
                            },
                            delegate(Success response)
                            {
                                LogInfo("Connected!");
                                Invoke(delegate() { _GUI.updateStatusText("Connected!"); });
                                return;
                            });
            }
            yield break;
        }

        void LogoApiHandler(LogoApiEvent le)
        {
            if (le.GUI == _GUI)
            {
                poster.doCastAndPost(le.Command, _robotPort);
                //_robotPort.Post(le.Command);
                Type t = le.Command.GetType();
                LogInfo("Received a LogoApiEvent (enclosed type " + t.FullName + "); re-posting");
            }
        }

        void DriveHandler(DriveCommand dc)
        {
            LogInfo("Received a drive command with distance " + dc.Body.Distance);
        }

        void CmdHandler(LogoApiCommand lac)
        {
            LogInfo("Received a LogoApiCommand of actual type " + lac.GetType().FullName);
        }

    }
}
