using System;
using System.Collections.Generic;
using System.Text;

using Microsoft.Ccr.Core;
using System.Reflection;
using System.CodeDom.Compiler;
using Cornell.Cs100r.Robotics.LogoApi;
using svcbase = Microsoft.Dss.ServiceModel.DsspServiceBase;
using Cornell.Cs100r.Robotics.LogoApi.Proxy;

/* This follows a technique shown on http://www.khmerang.com/index.php?p=53
   This is a huge kludge and I coded it mostly to see if it would actually work.
   Shockingly, it does.  --cgd */

namespace Cornell.Cs100r.Robotics.DssLogoApiTester
{
    public partial class LogoApiTester : svcbase.DsspServiceBase
    {
        private class CastAndPost
        {
            CompilerResults cr;

            public delegate void LoggerFn(string s);

            LoggerFn LogInfo;
            LoggerFn LogError;

            /* We construct a CastAndPost in the Start() function of LogoApiTester.cs
               Thus we do this reflection & compilation at startup time */
            public CastAndPost(LoggerFn infoFn, LoggerFn errorFn)
            {
                LogInfo = infoFn;
                LogError = errorFn;
                Microsoft.CSharp.CSharpCodeProvider c =
                    new Microsoft.CSharp.CSharpCodeProvider();
                ICodeCompiler cc = c.CreateCompiler();
                /* Load the assemblies we need so we can get their path
                   and include them in the compilation */
                Assembly ccrCore = Assembly.Load("Ccr.Core");
                Assembly logoApi = Assembly.Load("LogoApiCommon");

                CompilerParameters cp =
                    new CompilerParameters(new string[] { ccrCore.Location,
                        logoApi.Location });

                Type[] types = logoApi.GetTypes();

                /* Build a little class that checks against all types in the LogoApiCommon
                   assembly that are derived from the LogoApiCommand type */
                string src =
                    @"using System;
                using Cornell.Cs100r.Robotics.LogoApi;
                using Microsoft.Ccr.Core;
                    public class CastPostWorker {
                        public static void castpost(LogoApiCommand o, LogoApiOperations port) {";

                Type baseType = logoApi.GetType("Cornell.Cs100r.Robotics.LogoApi.LogoApiCommand");
                foreach (Type t in types)
                {
                    if (t.BaseType.FullName == baseType.FullName)
                        src += string.Format("if (o is {0}) port.Post(({0})o);", t.FullName);
                }


                src += "}}";

                /* Compile our little class */
                cr = cc.CompileAssemblyFromSource(cp, src);

                if (cr.Errors.Count != 0)
                {
                    foreach (CompilerError error in cr.Errors)
                    {
                        LogError("COMPILER ERROR: " + error.ToString());
                    }
                }
                else
                {
                    LogInfo("Compiled CastPostWorker successfully");
                }
            }

            public void doCastAndPost(LogoApiCommand o, LogoApiOperations port)
            {
                Assembly a = cr.CompiledAssembly;
                Type castPostWorkerType = a.GetType("CastPostWorker");
                MethodInfo mi = castPostWorkerType.GetMethod("castpost");
                mi.Invoke(null, new object[] { o, port });
            }
        }
    }
}
