//------------------------------------------------------------------------------
// LogoApiHTTPReceive.cs
//
//     This code was generated by the DssNewService tool.
//
//------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using attributes = Microsoft.Dss.Core.Attributes;
using Microsoft.Ccr.Core;
using dsslogoapihttpreceive = Cornell.Cs100r.Robotics.DssLogoApiHTTPReceive;
using permissions = System.Security.Permissions;
using svcbase = Microsoft.Dss.ServiceModel.DsspServiceBase;
using dssp = Microsoft.Dss.ServiceModel.Dssp;

using Microsoft.Dss.ServiceModel.Dssp;
using Microsoft.Dss.Core.DsspHttp;
using Microsoft.Dss.Core.DsspHttpUtilities;
using System.Collections.Specialized;
using Cornell.Cs100r.Robotics.LogoApi.Proxy;
using mime = System.Net.Mime;
using System.Net;
using System.IO;

namespace Cornell.Cs100r.Robotics.DssLogoApiHTTPReceive
{

    [attributes.Contract(Contract.Namespace)]
    [permissions.PermissionSet(permissions.SecurityAction.PermitOnly, Name = "Execution")]
    public class LogoApiHTTPReceive : svcbase.DsspServiceBase
    {
        private StateType _state = new StateType();
        [attributes.ServicePort("/LogoApiHTTPReceive", AllowMultipleInstances = false)]
        private LogoApiHTTPReceiveOperations _mainPort = new LogoApiHTTPReceiveOperations();

        [attributes.Partner("output",Contract=Cornell.Cs100r.Robotics.LogoApi.Proxy.Contract.Namespace,
            CreationPolicy=attributes.PartnerCreationPolicy.UseExisting)]
        private LogoApiOperations _outputPort = new LogoApiOperations();

        private DsspHttpUtilitiesPort _httpUtilsPort;

        public LogoApiHTTPReceive(dssp.DsspServiceCreationPort creationPort)
            :
                base(creationPort)
        {
            CreateSuccess();
        }
        protected override void Start()
        {
            _httpUtilsPort = DsspHttpUtilitiesService.Create(this.Environment);

            // Listen on the main port for requests and call the appropriate handler.

            Activate(
                Arbiter.Interleave(
                    new TeardownReceiverGroup(
                        Arbiter.Receive<dssp.DsspDefaultDrop>(false, _mainPort, DefaultDropHandler)
                    ),
                    new ExclusiveReceiverGroup
                    (
                        Arbiter.ReceiveWithIterator<Replace>(true, _mainPort, ReplaceHandler),
                        Arbiter.ReceiveWithIterator<Subscribe>(true, _mainPort, SubscribeHandler),
                        Arbiter.ReceiveWithIterator<HttpPost>(true, _mainPort, HttpPostHandler),
                        Arbiter.ReceiveWithIterator<HttpGet>(true, _mainPort, HttpGetHandler)
                    ),
                    new ConcurrentReceiverGroup
                    (
                        Arbiter.ReceiveWithIterator<Get>(true, _mainPort, GetHandler),
                        Arbiter.Receive<dssp.DsspDefaultLookup>(true, _mainPort, DefaultLookupHandler)
                    ))
            );


            // Insert ourselves into the directory so that others can find us
            DirectoryInsert();

            // Display browser accesible Service URI
            LogInfo("Service uri: " + ServiceInfo.Service);
        }
        private IEnumerator<ITask> GetHandler(Get get)
        {
            get.ResponsePort.Post(_state);
            yield break;
        }
        private IEnumerator<ITask> ReplaceHandler(Replace replace)
        {
            _state = replace.Body;
            replace.ResponsePort.Post(dssp.DefaultReplaceResponseType.Instance);
            yield break;
        }
        private IEnumerator<ITask> SubscribeHandler(Subscribe subscribe)
        {
            yield break;
        }

        private bool paramsPresent(NameValueCollection pms, params string[] keys)
        {
            foreach (string s in keys)
            {
                if (pms[s] == null)
                {
                    LogError("ERROR: Parameter '" + s + "' is required; not present in POST");
                    return false;
                }
            }
            return true;
        }

        private IEnumerator<ITask> HttpGetHandler(HttpGet hg)
        {
            HttpListenerRequest request = hg.Body.Context.Request;
            string path = request.Url.AbsolutePath;

            if (path.StartsWith("/logoapihttpreceive/getimage"))
            {
                doGetImage(hg.Body.Context);
            }

            yield break;
        }

        private IEnumerator<ITask> HttpPostHandler(HttpPost req)
        {
            LogInfo("Received a HTTP POST; attempting to read params");

            ReadFormData readForm = new ReadFormData(req.Body.Context);
            _httpUtilsPort.Post(readForm);

            HttpListenerContext context = req.Body.Context;

            yield return (Arbiter.Choice(readForm.ResultPort,
                delegate(NameValueCollection parameters)
                {
                    PortSet<Fault, Success> rspPort = null;

                    if (parameters["function"] != null)
                    {
                        string function = parameters["function"];
                        LogInfo("Received logoapi command " + function);
                        /* FIXME: These things really should be defined in string constants */
                        switch (function)
                        {
                            case "turn":
                                if (!paramsPresent(parameters, "degrees"))
                                    break;

                                TurnCommand turn = new TurnCommand(new TurnCommandData());
                                turn.Body.Degrees = double.Parse(parameters["degrees"]);
                                _outputPort.Post(turn);
                                rspPort = turn.ResponsePort;
                                break;

                            case "drive":
                                if (!paramsPresent(parameters, "distance"))
                                    break;

                                DriveCommand drive = new DriveCommand(new DriveCommandData());
                                drive.Body.Distance = double.Parse(parameters["distance"]);
                                _outputPort.Post(drive);
                                rspPort = drive.ResponsePort;
                                break;

                            case "aibocommand":
                                if (!paramsPresent(parameters, "command"))
                                    break;

                                AiboCommand aibo = new AiboCommand(new AiboCommandData());
                                aibo.Body.Command = parameters["command"];
                                _outputPort.Post(aibo);
                                rspPort = aibo.ResponsePort;
                                break;

                            case "speak":
                                if (!paramsPresent(parameters, "phrase"))
                                    break;

                                SpeakCommand speak = new SpeakCommand(new SpeakCommandData());
                                speak.Body.Phrase = parameters["phrase"];
                                _outputPort.Post(speak);
                                rspPort = speak.ResponsePort;
                                break;

                            case "pointhead":
                                if (!paramsPresent(parameters, "x") || !paramsPresent(parameters, "y")
                                    || !paramsPresent(parameters, "z"))
                                    break;

                                PointHeadCommand point = new PointHeadCommand();
                                point.Body.X = double.Parse(parameters["x"]);
                                point.Body.Y = double.Parse(parameters["y"]);
                                point.Body.Z = double.Parse(parameters["z"]);
                                _outputPort.Post(point);
                                rspPort = point.ResponsePort;
                                break;
                            case "setspeed":
                                if (!paramsPresent(parameters, "speed"))
                                    break;

                                SetSpeedCommand spd = new SetSpeedCommand();
                                spd.Body.Speed = ushort.Parse(parameters["speed"]);
                                _outputPort.Post(spd);
                                rspPort = spd.ResponsePort;
                                break;
                            case "getsteps":
                                doGetSteps(context);
                                break;
                            case "is_done":
                                doIsDone(context);
                                break;

                            case "getimage":
                                doGetImage(context);
                                break;
                        }

                        if (rspPort != null)
                        {
                            Activate(Arbiter.Choice(rspPort,
                                delegate(Fault f) { returnLogoApiError(context); },
                                delegate(Success s) { returnLogoApiOk(context); }));
                        }
                    }
                    else
                    {
                        LogError("Invalid LogoApi message received: no 'command' parameter!");
                        returnLogoApiError(context);
                    }

                },
                delegate(Exception e)
                {
                    LogError(e.Message);
                }));
        }

        private void doIsDone(HttpListenerContext context)
        {
            IsDoneCommand d = new IsDoneCommand();
            _outputPort.Post(d);

            Activate(Arbiter.Choice(d.ResponsePort,
                delegate(Fault f) { returnLogoApiError(context); },
                delegate(IsDoneResponse r)
                {
                    string resp = r.isDone ? "1" : "0";
                    SendPlainText(context, resp);
                }));
        }

        private void doGetSteps(HttpListenerContext context)
        {
            GetStepsCommand s = new GetStepsCommand();
            _outputPort.Post(s);

            Activate(Arbiter.Choice(s.ResponsePort,
                delegate(Fault f) { returnLogoApiError(context); },
                delegate(GetStepsResponse r)
                {
                    LogInfo(string.Format("sending back steps reply: {0}", r.steps.ToString()));
                    SendPlainText(context, r.steps.ToString());
                }));
        }

        private void doGetImage(HttpListenerContext context)
        {
            GetImageCommand g = new GetImageCommand(new GetImageCommandData());
            _outputPort.Post(g);

            Activate(Arbiter.Choice(g.ResponsePort,
                delegate(Fault f) { returnLogoApiError(context); },
                delegate(MyBitmap b)
                {
                    SendJpeg(context,
                        streamifyBitmap(new System.Drawing.Bitmap(b.data), System.Drawing.Imaging.ImageFormat.Jpeg));
                }));

        }

        private void returnLogoApiError(HttpListenerContext context)
        {
            SendPlainText(context, "ERR\n");
        }

        private void returnLogoApiOk(HttpListenerContext context)
        {
            LogInfo("Returning OK to POST request");
            SendPlainText(context, "OK\n");
        }

        private Stream streamifyBitmap(System.Drawing.Bitmap bmp, System.Drawing.Imaging.ImageFormat fmt)
        {
            MemoryStream memory = new MemoryStream();
            bmp.Save(memory, fmt);
            memory.Position = 0;
            return memory;
        }

        private Stream streamifyString(string s)
        {
            System.Text.ASCIIEncoding a = new System.Text.ASCIIEncoding();
            byte[] bytes = a.GetBytes(s);
            MemoryStream stream = new MemoryStream(bytes);
            stream.Position = 0;
            return stream;
        }

        private void SendPlainText(HttpListenerContext context, string s)
        {
            Stream stream = streamifyString(s);
            WriteResponseFromStream write = new WriteResponseFromStream(context, stream, mime.MediaTypeNames.Text.Plain);
            
            _httpUtilsPort.Post(write);

            Activate(Arbiter.Choice(write.ResultPort,
                delegate(Stream res)
                {
                    stream.Close();
                },
                delegate(Exception e)
                {
                    stream.Close();
                    LogError(e);
                }));
        }

        /* Taken from SickLRF.cs in the _Sensor/_SickLRF sample service --cgd */
        private void SendJpeg(HttpListenerContext context, Stream stream)
        {
            WriteResponseFromStream write = new WriteResponseFromStream(context, stream, mime.MediaTypeNames.Image.Jpeg);

            _httpUtilsPort.Post(write);

            Activate(
                Arbiter.Choice(
                    write.ResultPort,
                    delegate(Stream res)
                    {
                        stream.Close();
                    },
                    delegate(Exception e)
                    {
                        stream.Close();
                        LogError(e);
                    }
                )
            );
        }
    }
}
