using System;
using System.Collections.Generic;
using System.Text;

using Microsoft.Ccr.Core;

using Microsoft.Dss.ServiceModel.Dssp;
using Microsoft.Dss.Core.Attributes;

using System.Runtime.Serialization;

namespace Cornell.Cs100r.Robotics.LogoApi
{

    public sealed class Contract
    {
        public const string Namespace = "http://schemas.cs100r.cs.cornell.edu/2006/05/logoapi.html";
    }

    [ServicePort]
    class LogoApiOperations
        : PortSet<TurnCommand, DriveCommand, GetImageCommand,
                  AiboCommand, SpeakCommand, IsDoneCommand,
                  PointHeadCommand, SetSpeedCommand, GetStepsCommand> { }


    // An enum with the types of robots we support
    [DataContract]
    public enum RobotTypes
    {
        Aibo,
        PennBot
    }

    // And an attribute to specify "This command can't be applied to this type of robot"
    // TODO FIXME These things really could be named better.
    [AttributeUsage(AttributeTargets.Class)]
    public class CommandUnavailableAttribute : System.Attribute
    {
        
        public CommandUnavailableAttribute(RobotTypes unavailableForWhat) 
        {
            this.unavailableForWhat = unavailableForWhat;
        }

        private RobotTypes unavailableForWhat;

        public RobotTypes Robot { get { return unavailableForWhat; } }

    }

    [DataContract]
    public class LogoApiCommand { }

    [DataContract]
    public class TurnCommandData : LogoApiCommand
    {
        double degrees;

        public TurnCommandData() { }

        public TurnCommandData(double degrees)
        {
            this.degrees = degrees;
        }

        [DataMember]
        public double Degrees 
        {
            get { return degrees; }
            set { degrees = value; }
        }
    }

    class TurnCommand : Submit<TurnCommandData, PortSet<Fault,Success>> { }

    [DataContract]
    public class DriveCommandData : LogoApiCommand
    {
        double distance;

        public DriveCommandData() { }

        public DriveCommandData(double distance)
        {
            this.distance = distance;
        }

        [DataMember]
        public double Distance {
            get { return distance; }
            set { distance = value; }
        }
    }

    class DriveCommand : Submit<DriveCommandData, PortSet<Fault,Success>> { }

    [DataContract]
    public class GetImageCommandData : LogoApiCommand
    {
        public GetImageCommandData() { }
    }

    class GetImageCommand : Submit<GetImageCommandData, PortSet<Fault, MyBitmap>> { }

    [DataContract]
    public class MyBitmap
    {
        /* This is pretty much the most asinine thing ever. */
        [DataMember]
        public System.IO.MemoryStream data;
    }



    [CommandUnavailable(RobotTypes.PennBot)]
    [DataContract]
    public class AiboCommandData : LogoApiCommand
    {
        string command;

        public AiboCommandData() { }

        public AiboCommandData(string command)
        {
            this.command = command;
        }

        [DataMember]
        public string Command { 
            get { return command; }
            set { command = value; }
        }
    }

    class AiboCommand : Submit<AiboCommandData, PortSet<Fault,Success>> { }

    [CommandUnavailable(RobotTypes.Aibo)]
    [DataContract]
    public class SpeakCommandData : LogoApiCommand
    {
        string phrase;

        public SpeakCommandData() { }

        public SpeakCommandData(string phrase)
        {
            this.phrase = phrase;
        }

        [DataMember]
        public string Phrase {
            get { return phrase; }
            set { phrase = value; }
        }
    }

    class SpeakCommand : Submit<SpeakCommandData, PortSet<Fault,Success>> { }

    [DataContract]
    public class IsDoneCommandData : LogoApiCommand
    {
        public IsDoneCommandData() { }
    }

    class IsDoneCommand : Submit<IsDoneCommandData, PortSet<Fault, IsDoneResponse>> { }

    [DataContract]
    public class IsDoneResponse
    {
        /* This is pretty asinine too. */
        [DataMember]
        public bool isDone;
    }

    class PointHeadCommand : Submit<PointHeadCommandData, PortSet<Fault, Success>> { }

    [DataContract]
    public class PointHeadCommandData
    {
        double x,y,z;

        [DataMember]
        public double X { get { return x; } set { x = value; } }
        [DataMember]
        public double Y { get { return y; } set { y = value; } }
        [DataMember]
        public double Z { get { return z; } set { z = value; } }

    }

    class SetSpeedCommand : Submit<SetSpeedCommandData, PortSet<Fault,Success>> {}

    [DataContract]
    public class SetSpeedCommandData
    {
        double speed;

        [DataMember]
        public double Speed { get { return speed; } set { speed = value; } }
    }

    class GetStepsCommand : Submit<GetStepsCommandData, PortSet<Fault, GetStepsResponse>> { }

    [DataContract]
    public class GetStepsCommandData : LogoApiCommand
    {
        public GetStepsCommandData() { }
    }

    [DataContract]
    public class GetStepsResponse
    {
        /* This is also extremely asinine. */
        [DataMember]
        public UInt64 steps;
    }

    [DataContract]
    public class Success
    {
        static readonly Success instance = new Success();
        static Success() { }
        public Success() { }

        [DataMember]
        public static Success Instance { get { return instance; } }
    }

    [DataContract]
    public class Fault
    {
        string msg;

        public Fault() { }

        public Fault(string Message)
        {
            msg = Message;
        }

        [DataMember]
        public string Message
        {
            get { return msg; }
            set { msg = value; }
        }
    }
}
