//------------------------------------------------------------------------------
// Aibo.cs
//
//     This code was generated by the DssNewService tool.
//
//------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using attributes = Microsoft.Dss.Core.Attributes;
using ccr = Microsoft.Ccr.Core;
using dssaibo = Cornell.Cs100r.Robotics.DssAibo;
using permissions = System.Security.Permissions;
using svcbase = Microsoft.Dss.ServiceModel.DsspServiceBase;
using Microsoft.Dss.ServiceModel.Dssp;

using Microsoft.Ccr.Core;

using System.IO;
using System.Net;
using System.Text;
using System.Net.Sockets;
using System.Collections.Generic;

using Cornell.Cs100r.Robotics.LogoApi.Proxy;

using cam = Cornell.Cs100r.Robotics.DssAiboCamera.Proxy;


namespace Cornell.Cs100r.Robotics.DssAibo
{
    
    [attributes.Contract(Contract.Namespace)]
    [permissions.PermissionSet(permissions.SecurityAction.PermitOnly, Name="FullTrust")]
    public class Aibo : svcbase.DsspServiceBase
    {
        public static readonly int AIBO_INTERP_PORT = 1001;


        //private const string _initialState = "InitialState";

        [attributes.InitialStatePartner(Optional = false, ServiceUri = "CS100R-initial-state.xml")]
        private StateType _state;

        [attributes.ServicePort("/Aibo", AllowMultipleInstances=true)]
        private AiboOperations _mainPort = new AiboOperations();

        [attributes.Partner("AiboCamera",Contract=cam.Contract.Namespace,CreationPolicy=attributes.PartnerCreationPolicy.UseExistingOrCreate)]
        private cam.AiboCameraOperations _camPort = new cam.AiboCameraOperations();

        public Aibo(DsspServiceCreationPort creationPort) : 
                base(creationPort)
        {
			CreateSuccess();
        }
        protected override void Start()
        {

            if (_state == null)
            {
                _state = new StateType();
            }

            // Listen on the main port for requests and call the appropriate handler.

            Activate(
                Arbiter.Interleave(
                    new TeardownReceiverGroup(
                        Arbiter.Receive<DsspDefaultDrop>(false, _mainPort, DefaultDropHandler)
                    ),
                    new ExclusiveReceiverGroup
                    (
                        Arbiter.ReceiveWithIterator<Replace>(true, _mainPort, ReplaceHandler),
                        Arbiter.ReceiveWithIterator<Subscribe>(true, _mainPort, SubscribeHandler),
                        Arbiter.Receive<Connect>(true, _mainPort, ConnectHandler)
                    ),
                    new ConcurrentReceiverGroup
                    (
                        Arbiter.ReceiveWithIterator<Get>(true, _mainPort, GetHandler),
                        Arbiter.Receive<DsspDefaultLookup>(true, _mainPort, DefaultLookupHandler),
                        Arbiter.Receive<Walk>(true, _mainPort, WalkHandler),
                        Arbiter.Receive<PointHead>(true, _mainPort, PointHeadHandler),
                        Arbiter.Receive<SetLED>(true, _mainPort, SetLEDHandler),
                        Arbiter.Receive<DoBasicStance>(true, _mainPort, DoBasicStanceHandler),
                        Arbiter.Receive<WavPlay>(true, _mainPort, WavPlayHandler),
                        Arbiter.Receive<DoMotion>(true, _mainPort, DoMotionHandler),
                        Arbiter.Receive<RawCommand>(true, _mainPort, RawCommandHandler),
                        Arbiter.ReceiveWithIterator<GrabFrame>(true, _mainPort, GrabFrameHandler)
                    ))
            );


            // Insert ourselves into the directory so that others can find us
            DirectoryInsert();

            // Display browser accesible Service URI
            LogInfo("Service uri: " + ServiceInfo.Service);

            connectMe();
        }

        private void connectMe()
        {
            connectMe(null);
        }

        private void connectMe(string hostname)
        {
            // The actual hostname to connect to:
            // in case the parameter is null, we pull from the state  -cgd
            string h = hostname ?? _state.IPAddress;

            Connect c = new Connect();
            c.Body = new ConnectRequest();
            c.Body.hostname = h;
            _mainPort.Post(c);
        }

        /* Handlers */
        private IEnumerator<ccr.ITask> GetHandler(Get get)
        {
            get.ResponsePort.Post(_state);
            yield break;
        }
        private IEnumerator<ccr.ITask> ReplaceHandler(Replace replace)
        {
            _state = replace.Body;
            replace.ResponsePort.Post(DefaultReplaceResponseType.Instance);
            yield break;
        }
        private IEnumerator<ccr.ITask> SubscribeHandler(Subscribe subscribe)
        {
            yield break;
        }


        IEnumerator<ITask> GrabFrameHandler(GrabFrame gf)
        {
            if (_state.IPAddress == null)
            {
                Fault f = new Fault();
                f.Message = "Not connected!";
                gf.ResponsePort.Post(f);
                yield break;
            }
            cam.GrabFrame cgf = new cam.GrabFrame(new cam.GrabFrameRequest());

            cgf.Body.address = _state.IPAddress;
            _camPort.Post(cgf);

            yield return Arbiter.Choice(cgf.ResponsePort,
                delegate(Fault f) { gf.ResponsePort.Post(f); },
                delegate(MyBitmap bmp) { gf.ResponsePort.Post(bmp); });
        }

        void ConnectHandler(Connect connect)
        {
            string hostname = connect.Body.hostname;
            /* IP address or hostname of Aibo, and the interpreter port number (hardcoded) --cgd */
            try
            {
                _state.aiboclient = new TcpClient(hostname, AIBO_INTERP_PORT);
            }
            catch (SocketException e)
            {
                LogError("SocketException while connecting to " + hostname + ": " + e.Message);
                Fault f = new Fault();
                f.Message = e.Message;
                connect.ResponsePort.Post(f);
                return;
            }
            if (!_state.aiboclient.Connected)
            {
                LogError("Could not connect to host " + hostname);
                Fault f = new Fault();
                f.Message = "Could not connect";
                connect.ResponsePort.Post(f);
            }
            else
            {
                LogInfo("Connected to aibo at " + hostname);
                _state.IPAddress = hostname;
                connect.ResponsePort.Post(new Success());
            }
        }

        void WalkHandler(Walk walk)
        {
            if (_state.aiboclient.Connected)
            {
                /* For some reason the AIBO expects a \r instead of a \n;
                 * at least, this is what MATLAB sends --cgd */

                string cmd = String.Format("matlab_walk({0},{1},{2},{3});\r",
                             walk.Body.x, walk.Body.y, walk.Body.a, walk.Body.duration);
                SendAiboCmd(cmd);
                walk.ResponsePort.Post(new Success());
            }
            else
            {
                walk.ResponsePort.Post(new Fault());
            }
        }

        void PointHeadHandler(PointHead pointhead) 
        {
            if (_state.aiboclient.Connected)
            {
                string cmd = String.Format("PointHead({0},{1},{2})\r",
                             pointhead.Body.x, pointhead.Body.y, pointhead.Body.z);
                SendAiboCmd(cmd);
                pointhead.ResponsePort.Post(new Success());
            }
            else
            {
                pointhead.ResponsePort.Post(new Fault());
            }
        }

        void SetLEDHandler(SetLED setled)
        {
            if (_state.aiboclient.Connected)
            {
                string cmd = String.Format("SetLedNamed(\"{0}\",{1});\r",
                             setled.Body.led.ToString(), setled.Body.value);
                SendAiboCmd(cmd);
                setled.ResponsePort.Post(new Success());
            }
            else
            {
                setled.ResponsePort.Post(new Fault());
            }
        }

        void DoBasicStanceHandler(DoBasicStance dbs)
        {
            if (_state.aiboclient.Connected)
            {
                SendAiboCmd("Motion::doBasicStance();\r");
                dbs.ResponsePort.Post(new Success());
            }
            else
            {
                dbs.ResponsePort.Post(new Fault());
            }
        }

        void WavPlayHandler(WavPlay wp)
        {
            if (_state.aiboclient.Connected)
            {
                string cmd = String.Format("OPENR::WavPlay({0});\r", wp.Body.filename);
                SendAiboCmd(cmd);
                wp.ResponsePort.Post(new Success());
            }
            else
            {
                wp.ResponsePort.Post(new Fault());
            }
        }

        void DoMotionHandler(DoMotion dm)
        {
            if (_state.aiboclient.Connected)
            {
                string cmd = String.Format("Motion::doMotion({0});\r", dm.Body.filename);
                SendAiboCmd(cmd);
                dm.ResponsePort.Post(new Success());
            }
            else
            {
                dm.ResponsePort.Post(new Fault());
            }
        }

        void RawCommandHandler(RawCommand rc)
        {
            if (_state.aiboclient.Connected)
            {
                SendAiboCmd(rc.Body.command);
                rc.ResponsePort.Post(new Success());
            }
            else
            {
                rc.ResponsePort.Post(new Fault());
            }
        }

        void SendAiboCmds(string[] cmdarray)
        {
            /* NOTE: I am not convinced that this is threadsafe.  The documentation
             * on TcpClient and NetworkStream make no reference to thread safety.
             * If we start running into weird problems when handling lots of messages,
             * the easiest fix is to serialize access by making an internal port on the
             * Aibo service and to have this function send the formatted commands to
             * that port, and then install an Exclusive handler that sends them
             * over the pipe. */
            UInt32 nCmds = (uint)cmdarray.Length;
            if (nCmds == 0) return;

            UInt32 totalLen = 4; // start at 4 because we have to send a UInt32 with # of commands

            foreach (string s in cmdarray)
            {
                totalLen += (uint)s.Length + 4; // length of command plus a length UInt32
            }

            byte[] bytes;
            NetworkStream stream = _state.aiboclient.GetStream();

            /* We actually must send these integers in little-endian order,
             * and NOT network byte order.  Who knows why. --cgd */

            // Send the total length of the entire command list
            bytes = BitConverter.GetBytes(totalLen);
            stream.Write(bytes, 0, bytes.Length);

            // Send the number of commands
            bytes = BitConverter.GetBytes(nCmds);
            stream.Write(bytes, 0, bytes.Length);

            // Send each command, prefixed with a length
            ASCIIEncoding asen = new ASCIIEncoding();
            foreach (string s in cmdarray)
            {
                // Send a length
                UInt32 len = (uint)s.Length;
                bytes = BitConverter.GetBytes(len);
                stream.Write(bytes, 0, bytes.Length);

                // Send the command
                bytes = asen.GetBytes(s);
                stream.Write(bytes, 0, bytes.Length);
                LogInfo("Sent command: \"" + s + "\"");
            }
        }

        void SendAiboCmds(ICollection<string> cmds)
        {
            string[] cmdarray = new string[cmds.Count];
            cmds.CopyTo(cmdarray, 0);

            SendAiboCmds(cmdarray);
        }

        void SendAiboCmd(string cmd)
        {
            string[] cmdarray = new string[1];
            cmdarray[0] = cmd;
            SendAiboCmds(cmdarray);
        }

    }
}

